/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting;

import com.owc.gui.charting.ConfigurationChangeResponse;
import com.owc.gui.charting.listener.MasterOfDesasterListener;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.Tools;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MasterOfDesaster {
    private List<ConfigurationChangeResponse> configChangeResponseList = new LinkedList<ConfigurationChangeResponse>();
    private List<WeakReference<MasterOfDesasterListener>> listeners = new LinkedList<WeakReference<MasterOfDesasterListener>>();
    private boolean calculating = false;
    private static final URL OKAY_ICON_URL = Tools.getResource((String)"icons/16/ok.png");
    private static final URL CALCULATING_ICON_URL = Tools.getResource((String)"icons/16/calculator.png");
    private static final String CALCULATE_LABEL = I18N.getGUILabel((String)"plotter.master_of_desaster.calculating.label", (Object[])new Object[0]);
    private static final String NO_PROBLEMS_LABEL = I18N.getGUILabel((String)"plotter.master_of_desaster.no_problems_detected.label", (Object[])new Object[0]);

    public void clearAll() {
        this.configChangeResponseList.clear();
        this.fireChanged();
    }

    private void removeEmptyResponses() {
        LinkedList<ConfigurationChangeResponse> copy = new LinkedList<ConfigurationChangeResponse>(this.configChangeResponseList);
        for (ConfigurationChangeResponse change : copy) {
            if (!change.isEmpty()) continue;
            this.configChangeResponseList.remove(change);
        }
    }

    public void clearWarnings() {
        for (ConfigurationChangeResponse change : this.configChangeResponseList) {
            change.clearWarnings();
        }
        this.removeEmptyResponses();
        this.fireChanged();
    }

    public void clearErrors() {
        for (ConfigurationChangeResponse change : this.configChangeResponseList) {
            change.clearErrors();
        }
        this.removeEmptyResponses();
        this.fireChanged();
    }

    public void removeConfigurationChangeResponse(ConfigurationChangeResponse response) {
        this.configChangeResponseList.remove(response);
        this.fireChanged();
    }

    public void registerConfigurationChangeResponse(ConfigurationChangeResponse error) {
        if (this.calculating) {
            this.calculating = false;
        }
        this.configChangeResponseList.add(error);
        this.fireChanged();
    }

    public List<ConfigurationChangeResponse> getConfigurationChangeResponses() {
        return this.configChangeResponseList;
    }

    private void fireChanged() {
        LinkedList<WeakReference<MasterOfDesasterListener>> listeners = new LinkedList<WeakReference<MasterOfDesasterListener>>();
        listeners.addAll(this.listeners);
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            MasterOfDesasterListener listener = (MasterOfDesasterListener)((WeakReference)it.next()).get();
            if (listener == null) {
                it.remove();
                continue;
            }
            listener.masterOfDesasterChanged(this);
        }
    }

    public void addListener(MasterOfDesasterListener l) {
        this.listeners.add(new WeakReference<MasterOfDesasterListener>(l));
    }

    public void removeListener(MasterOfDesasterListener l) {
        Iterator<WeakReference<MasterOfDesasterListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            MasterOfDesasterListener listener = (MasterOfDesasterListener)it.next().get();
            if (listener != null && listener != l) continue;
            it.remove();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ConfigurationChangeResponse response : this.configChangeResponseList) {
            if (response == null) continue;
            builder.append(response.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public String toHtmlString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        if (this.calculating) {
            builder.append("<div style=\"color:#0066CC;\">");
            builder.append("<img valign=\"middle\" style=\"vertical-align:middle;\" src=\"" + CALCULATING_ICON_URL + "\"/>&nbsp;");
            builder.append(CALCULATE_LABEL);
            builder.append("</div>");
            return builder.toString();
        }
        if (this.configChangeResponseList.size() > 0) {
            for (ConfigurationChangeResponse response : this.configChangeResponseList) {
                if (response == null) continue;
                builder.append(response.toHtmlString());
            }
        } else {
            builder.append("<div style=\"color:#000000;\">");
            builder.append("<img valign=\"middle\" style=\"vertical-align:middle;\" src=\"" + OKAY_ICON_URL + "\"/>&nbsp;");
            builder.append(NO_PROBLEMS_LABEL);
            builder.append("</div>");
        }
        builder.append("</html>");
        return builder.toString();
    }

    public void setCalculating(boolean calculating) {
        this.calculating = calculating;
        this.fireChanged();
    }
}

