/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting;

import com.owc.gui.charting.PlotConfigurationQuickFix;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.ParameterService;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PlotConfigurationError {
    private static ResourceBundle messages = I18N.getGUIBundle();
    private static final MessageFormat formatter = new MessageFormat("");
    private static final String NAME_KEY = "name";
    private static final String MESSAGE_KEY = "message";
    private static final String EXPLANATION_KEY = "explanation";
    private List<PlotConfigurationQuickFix> possiblesFixes = new LinkedList<PlotConfigurationQuickFix>();
    private String errorId;
    private Object[] messageParameters;

    public PlotConfigurationError(String errorId, Object ... messageParameters) {
        this.errorId = errorId;
        this.messageParameters = messageParameters;
    }

    public PlotConfigurationError(String errorId, PlotConfigurationQuickFix quickFix, Object ... messageParameters) {
        this.errorId = errorId;
        this.messageParameters = messageParameters;
        this.possiblesFixes.add(quickFix);
    }

    public PlotConfigurationError(String errorId, PlotConfigurationChangeEvent changeForQuickFix, Object ... messageParameters) {
        this.errorId = errorId;
        this.messageParameters = messageParameters;
        this.possiblesFixes.add(new PlotConfigurationQuickFix(changeForQuickFix));
    }

    public void addQuickFix(PlotConfigurationQuickFix quickFix) {
        this.possiblesFixes.add(quickFix);
    }

    public List<PlotConfigurationQuickFix> getQuickFixes() {
        return this.possiblesFixes;
    }

    public String getErrorName() {
        String deflt = "Unnamed plotter error.";
        if (Boolean.valueOf(ParameterService.getParameterValue((String)"rapidminer.general.debugmode")).booleanValue()) {
            deflt = deflt + " (" + this.errorId + ")";
        }
        return PlotConfigurationError.getResourceString(this.errorId, NAME_KEY, deflt);
    }

    public String getErrorMessage() {
        return PlotConfigurationError.getErrorMessage(this.errorId, this.messageParameters);
    }

    public Object[] getMessageParameters() {
        return this.messageParameters;
    }

    public String getErrorId() {
        return this.errorId;
    }

    public String getErrorDescription() {
        return PlotConfigurationError.getResourceString(this.errorId, EXPLANATION_KEY, "");
    }

    public static String getResourceString(String id, String key, String deflt) {
        if (messages == null) {
            return deflt;
        }
        try {
            return messages.getString("gui.plotter.error." + id + "." + key);
        }
        catch (MissingResourceException e) {
            return deflt;
        }
    }

    public static String getErrorMessage(String identifier, Object[] arguments) {
        String message = PlotConfigurationError.getResourceString(identifier, MESSAGE_KEY, "No message.");
        try {
            formatter.applyPattern(message);
            String formatted = formatter.format(arguments);
            return formatted;
        }
        catch (Throwable t) {
            return message;
        }
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof PlotConfigurationError;
    }
}

