/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.StaticDebug;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.ValueGrouping;
import com.owc.gui.charting.listener.ValueGroupingListener;
import com.owc.gui.charting.listener.events.ValueGroupingChangeEvent;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.owc.gui.charting.utility.NumericalValueRange;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.datatable.DataTable;
import java.text.DateFormat;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractValueGrouping
implements ValueGrouping {
    private static final long serialVersionUID = 4921166025867331194L;
    private boolean categorical;
    private DataTableColumn dataTableColumn;
    private List<ValueGroupingListener> listeners = new LinkedList<ValueGroupingListener>();
    private DateFormat dateFormat;

    public AbstractValueGrouping(DataTableColumn dataTableColumn, boolean isCategorical, DateFormat dateFormat) {
        this.categorical = isCategorical;
        this.dataTableColumn = dataTableColumn;
        this.dateFormat = dateFormat;
    }

    @Override
    public boolean isCategorical() {
        return this.categorical || this.getDomainType() == DataTableColumn.ValueType.NOMINAL;
    }

    public void setCategorical(boolean categorical) {
        if (categorical != this.categorical) {
            this.categorical = categorical;
            this.fireGroupingChanged(new ValueGroupingChangeEvent((ValueGrouping)this, categorical));
        }
    }

    @Override
    public void addListener(ValueGroupingListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(ValueGroupingListener l) {
        this.listeners.remove(l);
    }

    protected void fireGroupingChanged(ValueGroupingChangeEvent e) {
        for (ValueGroupingListener l : this.listeners) {
            l.valueGroupingChanged(e);
        }
    }

    @Override
    public abstract ValueGrouping clone();

    public DataTableColumn getDataTableColumn() {
        return this.dataTableColumn;
    }

    public void setDataTableColumn(DataTableColumn dataTableColumn) {
        if (dataTableColumn != this.dataTableColumn) {
            this.dataTableColumn = dataTableColumn;
        }
    }

    protected void forceDataTableColumn(DataTableColumn dataTableColumn) {
        this.dataTableColumn = dataTableColumn;
    }

    @Override
    public DataTableColumn.ValueType getDomainType() {
        if (this.categorical) {
            return DataTableColumn.ValueType.NOMINAL;
        }
        return this.dataTableColumn.getValueType();
    }

    @Override
    public final List<ValueRange> getGroupingModel(DataTable data, double upperBound, double lowerBound) {
        StaticDebug.debug("Create grouping with upper bound: " + upperBound);
        StaticDebug.debug("and lower bound: " + lowerBound);
        return this.createGroupingModel(data, upperBound, lowerBound);
    }

    protected abstract List<ValueRange> createGroupingModel(DataTable var1, double var2, double var4);

    @Override
    public abstract boolean equals(Object var1);

    protected void applyAdaptiveVisualRounding(List<ValueRange> valueGroups, boolean valuesAreDates) {
        if (valuesAreDates) {
            DateFormat dateFormat = this.getDateFormat();
            for (ValueRange range : valueGroups) {
                NumericalValueRange numericalValueRange = (NumericalValueRange)range;
                numericalValueRange.setDateFormat(dateFormat);
            }
        } else {
            NumericalValueRange previous = null;
            NumericalValueRange current = null;
            NumericalValueRange next = null;
            for (ValueRange valueGroup : valueGroups) {
                int precisionUpper;
                int precisionLower;
                next = (NumericalValueRange)valueGroup;
                if (previous != null) {
                    precisionLower = Math.min(DataStructureUtils.getOptimalPrecision(current.getLowerBound(), current.getUpperBound()), DataStructureUtils.getOptimalPrecision(previous.getLowerBound(), current.getLowerBound()));
                    precisionUpper = Math.min(DataStructureUtils.getOptimalPrecision(current.getLowerBound(), current.getUpperBound()), DataStructureUtils.getOptimalPrecision(current.getUpperBound(), next.getUpperBound()));
                    if (precisionUpper >= Integer.MAX_VALUE) {
                        precisionUpper = precisionLower;
                    }
                    current.setVisualPrecision(precisionLower, precisionUpper);
                } else if (current != null) {
                    precisionLower = DataStructureUtils.getOptimalPrecision(current.getLowerBound(), current.getUpperBound());
                    precisionUpper = Math.min(DataStructureUtils.getOptimalPrecision(current.getLowerBound(), current.getUpperBound()), DataStructureUtils.getOptimalPrecision(current.getUpperBound(), next.getUpperBound()));
                    if (precisionUpper >= Integer.MAX_VALUE) {
                        precisionUpper = precisionLower;
                    }
                    current.setVisualPrecision(precisionLower, precisionUpper);
                }
                previous = current;
                current = next;
            }
            if (previous != null) {
                int precisionLower = Math.min(DataStructureUtils.getOptimalPrecision(current.getLowerBound(), current.getUpperBound()), DataStructureUtils.getOptimalPrecision(previous.getLowerBound(), current.getLowerBound()));
                int precisionUpper = DataStructureUtils.getOptimalPrecision(current.getLowerBound(), current.getUpperBound());
                if (precisionUpper >= Integer.MAX_VALUE) {
                    precisionUpper = precisionLower;
                }
                current.setVisualPrecision(precisionLower, precisionUpper);
            } else if (current != null) {
                int precision = DataStructureUtils.getOptimalPrecision(current.getLowerBound(), current.getUpperBound());
                current.setVisualPrecision(precision, precision);
            }
        }
    }

    @Override
    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setDateFormat(DateFormat dateFormat) {
        if (dateFormat != this.dateFormat) {
            this.dateFormat = dateFormat;
            this.fireGroupingChanged(new ValueGroupingChangeEvent((ValueGrouping)this, dateFormat));
        }
    }
}

