/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.configuration.AxisParallelLineConfiguration;
import com.owc.gui.charting.configuration.AxisParallelLinesConfigurationListener;
import com.owc.gui.charting.configuration.LineFormat;
import com.owc.gui.charting.configuration.event.AxisParallelLinesConfigurationChangeEvent;
import com.owc.gui.charting.event.AxisParallelLineConfigurationChangeEvent;
import com.owc.gui.charting.listener.AxisParallelLineConfigurationListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AxisParallelLinesConfiguration
implements AxisParallelLineConfigurationListener,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6450792821858616514L;
    private List<AxisParallelLineConfiguration> lineConfigurations = new LinkedList<AxisParallelLineConfiguration>();
    private transient List<WeakReference<AxisParallelLinesConfigurationListener>> listeners = new LinkedList<WeakReference<AxisParallelLinesConfigurationListener>>();

    public void addLine(double value, boolean labelVisible, LineFormat.LineStyle style, float width) {
        AxisParallelLineConfiguration line = new AxisParallelLineConfiguration(value, labelVisible);
        line.getFormat().setStyle(style);
        line.getFormat().setWidth(width);
        this.addLine(line);
    }

    public void addLine(AxisParallelLineConfiguration line) {
        if (this.lineConfigurations.contains(line)) {
            return;
        }
        this.lineConfigurations.add(line);
        line.addAxisParallelLineConfigurationListener(this);
        line.getFormat().addLineFormatListener(line);
        this.fireLineAdded(line);
    }

    public void removeLine(AxisParallelLineConfiguration line) {
        this.lineConfigurations.remove(line);
        line.removeAxisParallelLineConfigurationListener(this);
        line.getFormat().removeLineFormatListener(line);
        this.fireLineRemoved(line);
    }

    public List<AxisParallelLineConfiguration> getLines() {
        return this.lineConfigurations;
    }

    private void fireLineAdded(AxisParallelLineConfiguration line) {
        this.fireAxisParallelLinesChanged(new AxisParallelLinesConfigurationChangeEvent(this, AxisParallelLinesConfigurationChangeEvent.AxisParallelLineConfigurationsChangeType.LINE_ADDED, line));
    }

    private void fireLineRemoved(AxisParallelLineConfiguration line) {
        this.fireAxisParallelLinesChanged(new AxisParallelLinesConfigurationChangeEvent(this, AxisParallelLinesConfigurationChangeEvent.AxisParallelLineConfigurationsChangeType.LINE_REMOVED, line));
    }

    private void fireAxisParallelLineChanged(AxisParallelLineConfigurationChangeEvent e) {
        this.fireAxisParallelLinesChanged(new AxisParallelLinesConfigurationChangeEvent(this, e));
    }

    private void fireAxisParallelLinesChanged(AxisParallelLinesConfigurationChangeEvent e) {
        Iterator<WeakReference<AxisParallelLinesConfigurationListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            AxisParallelLinesConfigurationListener l = (AxisParallelLinesConfigurationListener)it.next().get();
            if (l != null) {
                l.axisParallelLineConfigurationsChanged(e);
                continue;
            }
            it.remove();
        }
    }

    public void addAxisParallelLinesConfigurationListener(AxisParallelLinesConfigurationListener l) {
        for (WeakReference<AxisParallelLinesConfigurationListener> listenerRef : this.listeners) {
            if (!l.equals(listenerRef.get())) continue;
            return;
        }
        this.listeners.add(new WeakReference<AxisParallelLinesConfigurationListener>(l));
    }

    public void removeAxisParallelLinesConfigurationListener(AxisParallelLinesConfigurationListener l) {
        Iterator<WeakReference<AxisParallelLinesConfigurationListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            AxisParallelLinesConfigurationListener listener = (AxisParallelLinesConfigurationListener)it.next().get();
            if (l != null) {
                if (listener == null || !listener.equals(l)) continue;
                it.remove();
                continue;
            }
            it.remove();
        }
    }

    @Override
    public void axisParallelLineConfigurationChanged(AxisParallelLineConfigurationChangeEvent e) {
        this.fireAxisParallelLineChanged(e);
    }

    public AxisParallelLinesConfiguration clone() {
        AxisParallelLinesConfiguration clone = new AxisParallelLinesConfiguration();
        for (AxisParallelLineConfiguration line : this.lineConfigurations) {
            clone.addLine(line.clone());
        }
        return clone;
    }
}

