/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.StaticDebug;
import com.owc.gui.charting.configuration.AbstractDimensionConfig;
import com.owc.gui.charting.configuration.AbstractValueGrouping;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.ValueGrouping;
import com.owc.gui.charting.listener.ValueGroupingListener;
import com.owc.gui.charting.listener.ValueRangeListener;
import com.owc.gui.charting.listener.events.DimensionConfigChangeEvent;
import com.owc.gui.charting.listener.events.ValueGroupingChangeEvent;
import com.owc.gui.charting.listener.events.ValueRangeChangeEvent;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.owc.gui.charting.utility.NumericalValueRange;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.datatable.DataTable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;

public class DefaultDimensionConfig
extends AbstractDimensionConfig
implements ValueGroupingListener,
ValueRangeListener {
    private static final long serialVersionUID = -8722816650580052287L;
    private DataTableColumn dataTableColumn;
    private ValueGrouping valueGrouping;
    private NumericalValueRange userDefinedRange = null;
    private String dimensionAxisLabel = "";
    private boolean logarithmicDimensionAxis = false;
    private boolean autoNaming = true;
    private boolean useUserDefinedLowerBound;
    private boolean useUserDefinedUpperBound;
    private String userDefinedDateFormatString = "dd.MM.yyyy HH:mm";
    private boolean useUserDefinedDateFormatString = false;
    private final int Id;

    public DefaultDimensionConfig(PlotConfiguration plotConfiguration, DataTableColumn dataTableColumn, DimensionConfig.PlotDimension dimension) {
        this(dataTableColumn, dimension, plotConfiguration.getNextId());
    }

    private DefaultDimensionConfig(DataTableColumn dataTableColumn, DimensionConfig.PlotDimension dimension, int id) {
        super(dimension);
        this.Id = id;
        this.dataTableColumn = dataTableColumn;
        this.setUserDefinedRange(new NumericalValueRange(0.0, 1.0, -1, true, true));
        this.setAutoLabelIfEnabled();
    }

    @Override
    public void setGrouping(ValueGrouping valueGrouping) {
        if (!this.isGrouping() || valueGrouping != null && valueGrouping.getGroupingType() != this.getGrouping().getGroupingType() || valueGrouping != this.valueGrouping) {
            this.fireDimensionConfigChanged(new DimensionConfigChangeEvent((DimensionConfig)this, this.getDimension(), DimensionConfigChangeEvent.DimensionConfigChangeType.ABOUT_TO_CHANGE_GROUPING));
            if (this.valueGrouping != null) {
                this.valueGrouping.removeListener(this);
            }
            this.valueGrouping = valueGrouping;
            if (valueGrouping != null) {
                if (this.isLogarithmic() && valueGrouping.isCategorical()) {
                    this.setLogarithmic(false);
                }
                valueGrouping.addListener(this);
            }
            this.fireDimensionConfigChanged(new DimensionConfigChangeEvent((DimensionConfig)this, this.getDimension(), new ValueGroupingChangeEvent(valueGrouping)));
        }
    }

    @Override
    public ValueGrouping getGrouping() {
        return this.valueGrouping;
    }

    @Override
    public ValueRange getUserDefinedRangeClone(DataTable dataTable) {
        int columnIdx = DataTableColumn.getColumnIndex(dataTable, this.dataTableColumn);
        NumericalValueRange clone = this.userDefinedRange.clone();
        clone.setColumnIdx(columnIdx);
        return clone;
    }

    @Override
    public boolean isAutoRangeRequired() {
        if (this.isNominal()) {
            if (this.isUsingUserDefinedLowerBound()) {
                this.setUseUserDefinedLowerBound(false);
            }
            if (this.isUsingUserDefinedUpperBound()) {
                this.setUseUserDefinedUpperBound(false);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setLowerBound(Double lowerBound) {
        this.userDefinedRange.setLowerBound(lowerBound);
    }

    @Override
    public void setUpperBound(Double upperBound) {
        this.userDefinedRange.setUpperBound(upperBound);
    }

    @Override
    public void setUserDefinedRange(NumericalValueRange range) {
        if (range == null) {
            throw new RuntimeException("NULL value range is not allowed");
        }
        if (this.userDefinedRange != range) {
            if (this.userDefinedRange != null) {
                this.userDefinedRange.removeValueRangeListener(this);
            }
            this.userDefinedRange = range;
            range.addValueRangeListener(this);
            this.fireDimensionConfigChanged(new DimensionConfigChangeEvent((DimensionConfig)this, this.getDimension(), new ValueRangeChangeEvent(this.userDefinedRange, ValueRangeChangeEvent.ValueRangeChangeType.RESET)));
        }
    }

    @Override
    public boolean isGrouping() {
        return this.valueGrouping != null;
    }

    @Override
    public DataTableColumn getDataTableColumn() {
        return this.dataTableColumn;
    }

    @Override
    public void setDataTableColumn(DataTableColumn column) {
        if (this.dataTableColumn != column || !this.dataTableColumn.equals(column)) {
            this.setFireEvents(false);
            if (this.getGrouping() instanceof AbstractValueGrouping) {
                AbstractValueGrouping grouping = (AbstractValueGrouping)this.getGrouping();
                grouping.setDataTableColumn(column);
            }
            this.dataTableColumn = column;
            this.setAutoLabelIfEnabled();
            if (column.getValueType() == DataTableColumn.ValueType.DATE_TIME) {
                this.setUseUserDefinedLowerBound(false);
                this.setUseUserDefinedUpperBound(false);
            }
            this.setFireEvents(true);
            this.fireDimensionConfigChanged(new DimensionConfigChangeEvent((DimensionConfig)this, this.getDimension(), column));
        }
    }

    @Override
    public boolean isValid() {
        return this.getErrors().isEmpty();
    }

    @Override
    public List<PlotConfigurationError> getErrors() {
        LinkedList<PlotConfigurationError> errorList = new LinkedList<PlotConfigurationError>();
        if (this.getDataTableColumn().getName() == null || this.getDataTableColumn().getName().isEmpty()) {
            PlotConfigurationError error = new PlotConfigurationError("undefined_dimension", DimensionConfig.PlotDimension.DOMAIN.getName());
            errorList.add(error);
            return errorList;
        }
        DataTableColumn.ValueType valueType = this.getValueType();
        if (!this.getSupportedValueTypes().contains((Object)valueType)) {
            PlotConfigurationError error = new PlotConfigurationError("illegal_dimension_type", new Object[]{this.getDimension().getName(), valueType});
            errorList.add(error);
            return errorList;
        }
        if (this.isUsingUserDefinedLowerBound() && this.isUsingUserDefinedUpperBound() && DataStructureUtils.greaterOrAlmostEqual(this.getUserDefinedLowerBound(), this.getUserDefinedUpperBound(), 1.0E-6)) {
            PlotConfigurationError error = new PlotConfigurationError("min_filter_greater_max_filter", this.getDimension().getName());
            errorList.add(error);
            return errorList;
        }
        return errorList;
    }

    @Override
    public List<PlotConfigurationError> getWarnings() {
        LinkedList<PlotConfigurationError> warnings = new LinkedList<PlotConfigurationError>();
        if (this.isLogarithmic() && !this.isNumerical() && !this.isNominal()) {
            warnings.add(new PlotConfigurationError("logarithmic_ignored_when_not_numerical", this.getDimension().getName()));
        }
        if (this.useUserDefinedDateFormatString) {
            try {
                new SimpleDateFormat(this.userDefinedDateFormatString);
            }
            catch (IllegalArgumentException e) {
                warnings.add(new PlotConfigurationError("illegal_date_format_string", this.getDimension().getName()));
            }
        }
        return warnings;
    }

    @Override
    public boolean isNominal() {
        if (this.isGrouping()) {
            return this.getGrouping().isCategorical();
        }
        return this.getDataTableColumn().isNominal();
    }

    @Override
    public void setLogarithmic(boolean logarithmic) {
        if (logarithmic != this.logarithmicDimensionAxis) {
            this.logarithmicDimensionAxis = logarithmic;
            this.fireDimensionConfigChanged(new DimensionConfigChangeEvent(this, this.getDimension(), logarithmic, DimensionConfigChangeEvent.DimensionConfigChangeType.SCALING));
        }
    }

    @Override
    public boolean isLogarithmic() {
        return this.logarithmicDimensionAxis;
    }

    private void setAutoLabelIfEnabled() {
        if (this.isAutoNaming()) {
            if (this.dataTableColumn != null) {
                this.setLabel(this.dataTableColumn.getName());
            } else {
                this.setLabel(null);
            }
        }
    }

    @Override
    public boolean isAutoNaming() {
        return this.autoNaming;
    }

    @Override
    public void setAutoNaming(boolean autoNaming) {
        if (autoNaming != this.autoNaming) {
            this.autoNaming = autoNaming;
            this.setAutoLabelIfEnabled();
            this.fireDimensionConfigChanged(new DimensionConfigChangeEvent(this, this.getDimension(), autoNaming, DimensionConfigChangeEvent.DimensionConfigChangeType.AUTO_NAMING));
        }
    }

    @Override
    public String getLabel() {
        return this.dimensionAxisLabel;
    }

    @Override
    public void setLabel(String label) {
        if (label == null || !label.equals(this.dimensionAxisLabel)) {
            this.dimensionAxisLabel = label;
            this.fireDimensionConfigChanged(new DimensionConfigChangeEvent((DimensionConfig)this, this.getDimension(), label));
        }
    }

    @Override
    public boolean isNumerical() {
        if (this.isGrouping()) {
            return this.valueGrouping.getDomainType() == DataTableColumn.ValueType.NUMERICAL;
        }
        return this.dataTableColumn.isNumerical();
    }

    public DefaultDimensionConfig clone() {
        DefaultDimensionConfig clone = new DefaultDimensionConfig(this.getDataTableColumn().clone(), this.getDimension(), this.Id);
        ValueGrouping grouping = this.getGrouping();
        if (grouping != null) {
            clone.setGrouping(grouping.clone());
        }
        clone.autoNaming = this.autoNaming;
        clone.dimensionAxisLabel = this.dimensionAxisLabel;
        clone.logarithmicDimensionAxis = this.logarithmicDimensionAxis;
        clone.useUserDefinedLowerBound = this.useUserDefinedLowerBound;
        clone.useUserDefinedUpperBound = this.useUserDefinedUpperBound;
        clone.useUserDefinedDateFormatString = this.useUserDefinedDateFormatString;
        clone.userDefinedDateFormatString = this.userDefinedDateFormatString;
        clone.setUserDefinedRange(this.userDefinedRange.clone());
        return clone;
    }

    @Override
    public DataTableColumn.ValueType getValueType() {
        if (this.isGrouping()) {
            return this.getGrouping().getDomainType();
        }
        return this.getDataTableColumn().getValueType();
    }

    @Override
    public void valueGroupingChanged(ValueGroupingChangeEvent change) {
        StaticDebug.debug((Object)((Object)this.getDimension()) + ": Grouping has changed");
        if (change.getType() == ValueGroupingChangeEvent.ValueGroupingChangeType.CATEGORICAL) {
            // empty if block
        }
        this.fireDimensionConfigChanged(new DimensionConfigChangeEvent((DimensionConfig)this, this.getDimension(), change));
    }

    @Override
    public void valueRangeChanged(ValueRangeChangeEvent change) {
        this.fireDimensionConfigChanged(new DimensionConfigChangeEvent((DimensionConfig)this, this.getDimension(), change));
    }

    @Override
    public boolean isDate() {
        if (this.isGrouping()) {
            return this.valueGrouping.getDomainType() == DataTableColumn.ValueType.DATE_TIME;
        }
        return this.dataTableColumn.isDate();
    }

    @Override
    public Double getUserDefinedUpperBound() {
        return this.userDefinedRange.getUpperBound();
    }

    @Override
    public Double getUserDefinedLowerBound() {
        return this.userDefinedRange.getLowerBound();
    }

    @Override
    public Vector<ValueGrouping.GroupingType> getValidGroupingTypes() {
        ValueGrouping.GroupingType[] values = ValueGrouping.GroupingType.values();
        Vector<ValueGrouping.GroupingType> validGroupings = new Vector<ValueGrouping.GroupingType>();
        for (int i = 0; i < values.length; ++i) {
            ValueGrouping.GroupingType type = values[i];
            if (this.dataTableColumn.isNominal()) {
                switch (type) {
                    case EQUAL_DATA_FRACTION: 
                    case EQUIDISTANT_FIXED_BIN_COUNT: {
                        break;
                    }
                    default: {
                        validGroupings.add(type);
                        break;
                    }
                }
                continue;
            }
            validGroupings.add(type);
        }
        return validGroupings;
    }

    @Override
    public Set<DataTableColumn.ValueType> getSupportedValueTypes() {
        DimensionConfig.PlotDimension dimension = this.getDimension();
        HashSet<DataTableColumn.ValueType> valueTypes = new HashSet<DataTableColumn.ValueType>();
        switch (dimension) {
            case SHAPE: {
                valueTypes.add(DataTableColumn.ValueType.NOMINAL);
                break;
            }
            case COLOR: 
            case DOMAIN: 
            case SIZE: {
                valueTypes.add(DataTableColumn.ValueType.NOMINAL);
                valueTypes.add(DataTableColumn.ValueType.NUMERICAL);
                valueTypes.add(DataTableColumn.ValueType.DATE_TIME);
                break;
            }
        }
        return valueTypes;
    }

    @Override
    public boolean isUsingUserDefinedLowerBound() {
        return this.useUserDefinedLowerBound;
    }

    @Override
    public boolean isUsingUserDefinedUpperBound() {
        return this.useUserDefinedUpperBound;
    }

    @Override
    public void setUseUserDefinedUpperBound(boolean useUpperBound) {
        this.useUserDefinedUpperBound = useUpperBound;
        this.valueRangeChanged(new ValueRangeChangeEvent((ValueRange)this.userDefinedRange, ValueRangeChangeEvent.ValueRangeChangeType.USE_UPPER_BOUND, useUpperBound));
    }

    @Override
    public void setUseUserDefinedLowerBound(boolean useLowerBound) {
        this.useUserDefinedLowerBound = useLowerBound;
        this.valueRangeChanged(new ValueRangeChangeEvent((ValueRange)this.userDefinedRange, ValueRangeChangeEvent.ValueRangeChangeType.USE_LOWER_BOUND, useLowerBound));
    }

    @Override
    public void colorSchemeChanged() {
        this.fireDimensionConfigChanged(new DimensionConfigChangeEvent((DimensionConfig)this, this.getDimension(), DimensionConfigChangeEvent.DimensionConfigChangeType.COLOR_SCHEME));
    }

    public String toString() {
        return "DefaultDimensionConfig for " + this.getDimension().getName() + " (" + (this.isGrouping() ? "grouping" : "not grouping") + ")";
    }

    @Override
    public DateFormat getDateFormat() {
        DateFormat dateFormat;
        if (this.useUserDefinedDateFormatString) {
            try {
                dateFormat = new SimpleDateFormat(this.userDefinedDateFormatString);
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            }
            catch (IllegalArgumentException e) {
                dateFormat = (DateFormat)DateFormat.getDateTimeInstance().clone();
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            }
        } else {
            dateFormat = (DateFormat)DateFormat.getDateTimeInstance().clone();
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        return dateFormat;
    }

    @Override
    public void setUserDefinedDateFormatString(String formatString) {
        if (formatString != null ? !formatString.equals(this.userDefinedDateFormatString) : this.userDefinedDateFormatString != null) {
            this.userDefinedDateFormatString = formatString;
            if (this.valueGrouping != null) {
                this.valueGrouping.setDateFormat(this.getDateFormat());
            }
            this.fireDimensionConfigChanged(new DimensionConfigChangeEvent(this, this.getDateFormat()));
        }
    }

    @Override
    public String getUserDefinedDateFormatString() {
        return this.userDefinedDateFormatString;
    }

    @Override
    public boolean isUsingUserDefinedDateFormat() {
        return this.useUserDefinedDateFormatString;
    }

    @Override
    public void setUseUserDefinedDateFormat(boolean yes) {
        if (yes != this.useUserDefinedDateFormatString) {
            this.useUserDefinedDateFormatString = yes;
            if (this.valueGrouping != null) {
                this.valueGrouping.setDateFormat(this.getDateFormat());
            }
            this.fireDimensionConfigChanged(new DimensionConfigChangeEvent(this, this.getDateFormat()));
        }
    }

    @Override
    public int getId() {
        return this.Id;
    }
}

