/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.configuration.AbstractValueGrouping;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.ValueGrouping;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.owc.gui.charting.utility.SingleValueValueRange;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.datatable.DataTable;
import java.text.DateFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DistinctValueGrouping
extends AbstractValueGrouping {
    private static final long serialVersionUID = -5991303102885958304L;
    private final ValueGrouping.GroupingType type = ValueGrouping.GroupingType.DISTINCT_VALUES;

    public DistinctValueGrouping(DataTableColumn dataTableColumn, boolean isCategorical, DateFormat dateFormat) {
        super(dataTableColumn, isCategorical, dateFormat);
    }

    public DistinctValueGrouping(DistinctValueGrouping other) {
        super(other.getDataTableColumn(), other.isCategorical(), other.getDateFormat());
    }

    @Override
    protected List<ValueRange> createGroupingModel(DataTable dataTable, double upperBound, double lowerBound) {
        LinkedList<Double> sortedValues = new LinkedList<Double>();
        int columnIdx = DataTableColumn.getColumnIndex(dataTable, this.getDataTableColumn());
        sortedValues.addAll(DataStructureUtils.getDistinctDataTableValues(dataTable, columnIdx));
        Collections.sort(sortedValues);
        LinkedList<ValueRange> groupingModel = new LinkedList<ValueRange>();
        for (Double value : sortedValues) {
            if (!(value >= lowerBound) || !(value <= upperBound)) continue;
            groupingModel.add(new SingleValueValueRange((double)value, dataTable, columnIdx));
        }
        if (!this.getDataTableColumn().isNominal()) {
            this.applyAdaptiveVisualRounding(groupingModel, this.getDataTableColumn().isDate());
        }
        return groupingModel;
    }

    @Override
    protected void applyAdaptiveVisualRounding(List<ValueRange> valueGroups, boolean valuesAreDates) {
        DateFormat dateFormat = this.getDateFormat();
        if (valuesAreDates) {
            for (ValueRange valueGroup : valueGroups) {
                SingleValueValueRange r = (SingleValueValueRange)valueGroup;
                r.setDateFormat(dateFormat);
            }
        } else {
            SingleValueValueRange previous = null;
            SingleValueValueRange current = null;
            SingleValueValueRange next = null;
            for (ValueRange valueGroup : valueGroups) {
                next = (SingleValueValueRange)valueGroup;
                if (previous != null) {
                    int precisionLower = DataStructureUtils.getOptimalPrecision(previous.getValue(), current.getValue());
                    int precisionUpper = DataStructureUtils.getOptimalPrecision(current.getValue(), next.getValue());
                    int precision = Math.min(precisionLower, precisionUpper);
                    current.setVisualPrecision(precision);
                } else if (current != null) {
                    int precisionUpper;
                    int precision = precisionUpper = DataStructureUtils.getOptimalPrecision(current.getValue(), next.getValue());
                    current.setVisualPrecision(precision);
                }
                previous = current;
                current = next;
            }
            if (previous != null) {
                int precisionLower;
                int precision = precisionLower = DataStructureUtils.getOptimalPrecision(previous.getValue(), current.getValue());
                next.setVisualPrecision(precision);
            }
        }
    }

    @Override
    public ValueGrouping.GroupingType getGroupingType() {
        return this.type;
    }

    @Override
    public ValueGrouping clone() {
        return new DistinctValueGrouping(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DistinctValueGrouping)) {
            return false;
        }
        DistinctValueGrouping tempObj = (DistinctValueGrouping)obj;
        return tempObj.isCategorical() == this.isCategorical();
    }

    @Override
    public boolean definesUpperLowerBounds() {
        return false;
    }
}

