/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.ChartConfigurationException;
import com.owc.gui.charting.configuration.AbstractValueGrouping;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.ValueGrouping;
import com.owc.gui.charting.listener.events.ValueGroupingChangeEvent;
import com.owc.gui.charting.utility.NumericalValueRange;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import java.text.DateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class EqualDataFractionGrouping
extends AbstractValueGrouping {
    private static final long serialVersionUID = 7460378059234537678L;
    private int binCount;
    private final ValueGrouping.GroupingType type = ValueGrouping.GroupingType.EQUAL_DATA_FRACTION;
    private Integer distinctValueCount = Integer.MAX_VALUE;

    public EqualDataFractionGrouping(DataTableColumn dataTableColumn, int binCount, boolean categorical, DateFormat dateFormat) throws ChartConfigurationException {
        super(dataTableColumn, categorical, dateFormat);
        if (dataTableColumn.isNominal()) {
            throw new ChartConfigurationException("grouping.illegal_column_type", new Object[]{this.getGroupingType().getName(), dataTableColumn.getName(), dataTableColumn.getValueType(), "numerical or date."});
        }
        this.binCount = binCount;
    }

    protected EqualDataFractionGrouping(EqualDataFractionGrouping other) {
        super(other.getDataTableColumn(), other.isCategorical(), other.getDateFormat());
        this.forceDataTableColumn(other.getDataTableColumn());
        this.binCount = other.binCount;
    }

    public int getBinCount() {
        return this.binCount;
    }

    public void setBinCount(int binCount) {
        if (binCount != this.binCount) {
            this.binCount = binCount < this.distinctValueCount ? binCount : this.distinctValueCount;
            this.fireGroupingChanged(new ValueGroupingChangeEvent((ValueGrouping)this, this.binCount));
        }
    }

    @Override
    protected List<ValueRange> createGroupingModel(DataTable dataTable, double upperBound, double lowerBound) {
        int columnIdx = DataTableColumn.getColumnIndex(dataTable, this.getDataTableColumn());
        HashMap<Double, Integer> distinctValueCountMap = new HashMap<Double, Integer>();
        Vector<Double> sortedDistinctValueList = new Vector<Double>();
        int valueCount = 0;
        for (DataTableRow row : dataTable) {
            Double value = row.getValue(columnIdx);
            if (Double.isNaN(value) || !(value >= lowerBound) || !(value <= upperBound)) continue;
            Integer currentCount = (Integer)distinctValueCountMap.get(value);
            if (currentCount == null) {
                distinctValueCountMap.put(value, 1);
                sortedDistinctValueList.add(value);
            } else {
                distinctValueCountMap.put(value, currentCount + 1);
            }
            ++valueCount;
        }
        Collections.sort(sortedDistinctValueList);
        this.distinctValueCount = distinctValueCountMap.keySet().size();
        LinkedList<ValueRange> valueGroups = new LinkedList<ValueRange>();
        if (sortedDistinctValueList.size() == 0) {
            return valueGroups;
        }
        if (this.binCount > this.distinctValueCount) {
            this.setBinCount(this.distinctValueCount);
        }
        boolean columnIsDate = dataTable.isDateTime(columnIdx);
        double averageBinSize = (double)valueCount / (double)this.binCount;
        int currentUpperIdx = 0;
        int valuesUsed = 0;
        lowerBound = (Double)sortedDistinctValueList.get(0);
        upperBound = 0.0;
        for (int binIdx = 1; binIdx <= this.binCount; ++binIdx) {
            int aimedValueCountForCurrentBin = (int)Math.round((double)binIdx * averageBinSize) - valuesUsed;
            if (aimedValueCountForCurrentBin < 1) {
                aimedValueCountForCurrentBin = 1;
            }
            int remainingBins = this.binCount - binIdx;
            int valueCountInBin = (Integer)distinctValueCountMap.get(sortedDistinctValueList.get(currentUpperIdx));
            int nextValueCount = 0;
            for (int dvIdx = currentUpperIdx + 1; dvIdx < this.distinctValueCount; ++dvIdx) {
                boolean enoughRemainingDistinctValues;
                nextValueCount = valueCountInBin + (Integer)distinctValueCountMap.get(sortedDistinctValueList.get(dvIdx));
                int remainingDistinctValues = this.distinctValueCount - dvIdx - 1;
                boolean bl = enoughRemainingDistinctValues = remainingDistinctValues >= remainingBins;
                if (nextValueCount >= aimedValueCountForCurrentBin || !enoughRemainingDistinctValues) {
                    double nextDifferenceFromAverage;
                    double currentDifferenceFromAverage = Math.abs(aimedValueCountForCurrentBin - valueCountInBin);
                    if ((currentDifferenceFromAverage < (nextDifferenceFromAverage = (double)Math.abs(aimedValueCountForCurrentBin - nextValueCount)) || !enoughRemainingDistinctValues) && valueCountInBin > 0) {
                        currentUpperIdx = dvIdx;
                        nextValueCount = valueCountInBin;
                        break;
                    }
                    currentUpperIdx = dvIdx + 1;
                    break;
                }
                valueCountInBin = nextValueCount;
            }
            if (currentUpperIdx >= this.distinctValueCount) {
                currentUpperIdx = this.distinctValueCount - 1;
            }
            upperBound = (Double)sortedDistinctValueList.get(currentUpperIdx);
            valuesUsed += nextValueCount;
            NumericalValueRange currentGroup = new NumericalValueRange(lowerBound, upperBound, columnIdx, null, true, binIdx == this.binCount);
            valueGroups.add(currentGroup);
            lowerBound = upperBound;
        }
        this.applyAdaptiveVisualRounding(valueGroups, columnIsDate);
        return valueGroups;
    }

    @Override
    public ValueGrouping.GroupingType getGroupingType() {
        return this.type;
    }

    @Override
    public EqualDataFractionGrouping clone() {
        return new EqualDataFractionGrouping(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EqualDataFractionGrouping)) {
            return false;
        }
        EqualDataFractionGrouping tempObj = (EqualDataFractionGrouping)obj;
        if (tempObj.isCategorical() != this.isCategorical()) {
            return false;
        }
        return tempObj.getBinCount() == this.getBinCount();
    }

    @Override
    public boolean definesUpperLowerBounds() {
        return true;
    }
}

