/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.ChartConfigurationException;
import com.owc.gui.charting.configuration.AbstractValueGrouping;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.ValueGrouping;
import com.owc.gui.charting.listener.events.ValueGroupingChangeEvent;
import com.owc.gui.charting.utility.NumericalValueRange;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import java.text.DateFormat;
import java.util.LinkedList;
import java.util.List;

public class EquidistantFixedBinCountBinning
extends AbstractValueGrouping {
    private static final long serialVersionUID = 5255412428639371213L;
    private int binCount;
    private double userDefinedMinValue;
    private double userDefinedMaxValue;
    private boolean autoRange = true;
    private final ValueGrouping.GroupingType type = ValueGrouping.GroupingType.EQUIDISTANT_FIXED_BIN_COUNT;

    public EquidistantFixedBinCountBinning(int binCount, double minValue, double maxValue, DataTableColumn dataTableColumn, boolean categorical, DateFormat dateFormat) throws ChartConfigurationException {
        super(dataTableColumn, categorical, dateFormat);
        if (dataTableColumn.isNominal()) {
            throw new ChartConfigurationException("grouping.illegal_column_type", new Object[]{this.getGroupingType().getName(), dataTableColumn.getName(), dataTableColumn.getValueType(), "numerical or date."});
        }
        this.binCount = binCount;
        this.userDefinedMinValue = minValue;
        this.userDefinedMaxValue = maxValue;
    }

    public EquidistantFixedBinCountBinning(EquidistantFixedBinCountBinning other) {
        super(other.getDataTableColumn(), other.isCategorical(), other.getDateFormat());
        this.binCount = other.binCount;
        this.userDefinedMinValue = other.userDefinedMinValue;
        this.userDefinedMaxValue = other.userDefinedMaxValue;
        this.autoRange = other.autoRange;
        this.forceDataTableColumn(other.getDataTableColumn());
    }

    public int getBinCount() {
        return this.binCount;
    }

    public void setBinCount(int binCount) {
        if (binCount != this.binCount) {
            this.binCount = binCount;
            this.fireGroupingChanged(new ValueGroupingChangeEvent((ValueGrouping)this, binCount));
        }
    }

    public double getMinValue() {
        return this.userDefinedMinValue;
    }

    public void setMinValue(double minValue) {
        if (minValue != this.userDefinedMinValue) {
            this.userDefinedMinValue = minValue;
            this.fireGroupingChanged(new ValueGroupingChangeEvent(this));
        }
    }

    public double getMaxValue() {
        return this.userDefinedMaxValue;
    }

    public void setMaxValue(double maxValue) {
        if (maxValue != this.userDefinedMaxValue) {
            this.userDefinedMaxValue = maxValue;
            this.fireGroupingChanged(new ValueGroupingChangeEvent(this));
        }
    }

    @Override
    protected List<ValueRange> createGroupingModel(DataTable data, double userDefinedUpperDimensionBound, double userDefinedLowerDimensionBound) {
        if (this.getDataTableColumn() == null) {
            return null;
        }
        LinkedList<ValueRange> groupingModel = new LinkedList<ValueRange>();
        double currentMinValue = this.userDefinedMinValue;
        double currentMaxValue = this.userDefinedMaxValue;
        if (this.calculatesAutoRange()) {
            double newMinValue = Double.POSITIVE_INFINITY;
            double newMaxValue = Double.NEGATIVE_INFINITY;
            int columnIdx = DataTableColumn.getColumnIndex(data, this.getDataTableColumn());
            for (DataTableRow row : data) {
                double value = row.getValue(columnIdx);
                if (!(value >= userDefinedLowerDimensionBound) || !(value <= userDefinedUpperDimensionBound)) continue;
                if (newMinValue > value) {
                    newMinValue = value;
                }
                if (!(newMaxValue < value)) continue;
                newMaxValue = value;
            }
            if (!Double.isInfinite(userDefinedLowerDimensionBound) && newMinValue > userDefinedLowerDimensionBound) {
                newMinValue = userDefinedLowerDimensionBound;
            }
            if (!Double.isInfinite(userDefinedUpperDimensionBound) && newMaxValue < userDefinedUpperDimensionBound) {
                newMaxValue = userDefinedUpperDimensionBound;
            }
            currentMinValue = newMinValue;
            currentMaxValue = newMaxValue;
        }
        int columnIdx = DataTableColumn.getColumnIndex(data, this.getDataTableColumn());
        boolean columnIsDate = this.getDataTableColumn().isDate();
        groupingModel = new LinkedList();
        if (this.isCategorical() && (!this.isAutoRanging() || Double.isNaN(currentMinValue))) {
            NumericalValueRange group = new NumericalValueRange(Double.NEGATIVE_INFINITY, currentMinValue, columnIdx, null, true, false);
            groupingModel.add(group);
        }
        boolean includeLowerBound = true;
        boolean includeUpperBound = false;
        double stepWidth = (currentMaxValue - currentMinValue) / (double)this.binCount;
        for (int i = 0; i < this.binCount; ++i) {
            userDefinedLowerDimensionBound = currentMinValue + (currentMaxValue - currentMinValue) / (double)this.binCount * (double)i;
            userDefinedUpperDimensionBound = userDefinedLowerDimensionBound + stepWidth;
            if (i == this.binCount - 1) {
                includeUpperBound = true;
                groupingModel.add(new NumericalValueRange(userDefinedLowerDimensionBound, currentMaxValue, columnIdx, null, includeLowerBound, includeUpperBound));
                continue;
            }
            groupingModel.add(new NumericalValueRange(userDefinedLowerDimensionBound, userDefinedUpperDimensionBound, columnIdx, null, includeLowerBound, includeUpperBound));
        }
        if (this.isCategorical() && (!this.isAutoRanging() || Double.isNaN(currentMaxValue))) {
            NumericalValueRange group = new NumericalValueRange(currentMaxValue, Double.POSITIVE_INFINITY, columnIdx, null, false, true);
            groupingModel.add(group);
        }
        this.applyAdaptiveVisualRounding(groupingModel, columnIsDate);
        return groupingModel;
    }

    @Override
    public ValueGrouping.GroupingType getGroupingType() {
        return this.type;
    }

    @Override
    public ValueGrouping clone() {
        return new EquidistantFixedBinCountBinning(this);
    }

    private boolean calculatesAutoRange() {
        return Double.isNaN(this.userDefinedMinValue) || Double.isNaN(this.userDefinedMaxValue) || this.autoRange;
    }

    public boolean isAutoRanging() {
        return this.autoRange;
    }

    public void setAutoRange(boolean autoRange) {
        if (autoRange != this.autoRange) {
            this.autoRange = autoRange;
            this.fireGroupingChanged(new ValueGroupingChangeEvent(this));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EquidistantFixedBinCountBinning)) {
            return false;
        }
        EquidistantFixedBinCountBinning other = (EquidistantFixedBinCountBinning)obj;
        if (other.isCategorical() != this.isCategorical()) {
            return false;
        }
        if (other.getBinCount() != this.getBinCount()) {
            return false;
        }
        if (other.isAutoRanging() != this.isAutoRanging()) {
            return false;
        }
        if (Double.isNaN(other.getMaxValue()) ? !Double.isNaN(this.getMaxValue()) : other.getMaxValue() != this.getMaxValue()) {
            return false;
        }
        return !(Double.isNaN(other.getMinValue()) ? !Double.isNaN(this.getMinValue()) : other.getMinValue() != this.getMinValue());
    }

    @Override
    public boolean definesUpperLowerBounds() {
        return true;
    }
}

