/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.owc.gui.charting.utility.ValueRange;
import java.util.HashMap;
import java.util.Map;

public class GroupCellKey
implements Cloneable {
    Map<DimensionConfig.PlotDimension, ValueRange> groupCell;

    public GroupCellKey() {
        this.groupCell = new HashMap<DimensionConfig.PlotDimension, ValueRange>();
    }

    public GroupCellKey(Map<DimensionConfig.PlotDimension, ValueRange> groupCell) {
        this.groupCell = groupCell;
    }

    public ValueRange getRangeForDimension(DimensionConfig.PlotDimension d) {
        return this.groupCell.get((Object)d);
    }

    public void setRangeForDimension(DimensionConfig.PlotDimension d, ValueRange range) {
        this.groupCell.put(d, range);
    }

    public void removeRangeForDimension(DimensionConfig.PlotDimension d) {
        this.groupCell.remove((Object)d);
    }

    public int size() {
        return this.groupCell.size();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GroupCellKey)) {
            return false;
        }
        GroupCellKey otherKey = (GroupCellKey)obj;
        Map<DimensionConfig.PlotDimension, ValueRange> otherMap = otherKey.groupCell;
        if (otherMap.size() != this.groupCell.size()) {
            return false;
        }
        for (Map.Entry<DimensionConfig.PlotDimension, ValueRange> entry : this.groupCell.entrySet()) {
            ValueRange otherValue = otherMap.get((Object)entry.getKey());
            ValueRange thisValue = entry.getValue();
            if (thisValue != null ? thisValue.equals(otherValue) : otherValue == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.groupCell.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GroupCellKey: ");
        builder.append(this.groupCell.toString());
        return builder.toString();
    }

    public String getNiceString(PlotConfiguration plotConfiguration) {
        StringBuilder builder = new StringBuilder();
        boolean firstEntry = true;
        for (Map.Entry<DimensionConfig.PlotDimension, ValueRange> entry : this.groupCell.entrySet()) {
            ValueRange range = entry.getValue();
            if (range == null) continue;
            if (firstEntry) {
                firstEntry = false;
            } else {
                builder.append("; ");
            }
            DimensionConfig.PlotDimension dimension = entry.getKey();
            String dimensionAttribute = plotConfiguration.getDimensionConfig(dimension).getDataTableColumn().getName();
            builder.append(dimensionAttribute);
            builder.append(" = ");
            builder.append(range.toString());
        }
        return builder.toString();
    }

    public Object clone() {
        return new GroupCellKey(DataStructureUtils.getMapClone(this.groupCell));
    }
}

