/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.listener.LegendConfigurationListener;
import com.owc.gui.charting.listener.events.LegendConfigurationChangeEvent;
import com.rapidminer.tools.I18N;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jfree.ui.RectangleEdge;

public class LegendConfiguration
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3750439561668289981L;
    public static final Font DEFAULT_LEGEND_FONT = new Font("Dialog", 0, 12);
    private static final boolean DEFAULT_SHOW_DIMENSION_TYPE = true;
    private static final LegendPosition DEFAULT_LEGEND_POSITION = LegendPosition.RIGHT;
    public static final Color DEFAULT_LEGEND_BACKGROUND_COLOR = Color.white;
    public static final Color DEFAULT_LEGEND_FRAME_COLOR = Color.black;
    private static final boolean DEFAULT_SHOW_LEGEND_FRAME = true;
    public static final Color DEFAULT_LEGEND_FONT_COLOR = Color.black;
    private transient List<WeakReference<LegendConfigurationListener>> listeners = new LinkedList<WeakReference<LegendConfigurationListener>>();
    private Font legendFont = DEFAULT_LEGEND_FONT;
    private LegendPosition legendPosition = DEFAULT_LEGEND_POSITION;
    private LegendConfigurationChangeEvent currentEvent = null;
    private boolean showDimensionType = true;
    private Color legendBackgroundColor = DEFAULT_LEGEND_BACKGROUND_COLOR;
    private Color legendFrameColor = DEFAULT_LEGEND_FRAME_COLOR;
    private boolean showLegendFrame = true;
    private Color legendFontColor = DEFAULT_LEGEND_FONT_COLOR;

    public boolean isShowDimensionType() {
        return this.showDimensionType;
    }

    public void setShowDimensionType(boolean showDimensionType) {
        if (showDimensionType != this.showDimensionType) {
            this.showDimensionType = showDimensionType;
            this.fireShowDimensionTypeChanged();
        }
    }

    private void fireShowDimensionTypeChanged() {
        this.fireLegendConfigurationChanged(new LegendConfigurationChangeEvent(this, this.showDimensionType, LegendConfigurationChangeEvent.LegendConfigurationChangeType.SHOW_DIMENSION_TYPE));
    }

    public LegendConfigurationChangeEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(Font legendFont) {
        if (legendFont != this.legendFont) {
            this.legendFont = legendFont;
            this.fireLegendFontChanged();
        }
    }

    public Color getLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    public Color getLegendFrameColor() {
        return this.legendFrameColor;
    }

    public void setLegendBackgroundColor(Color legendBackgroundColor) {
        this.legendBackgroundColor = legendBackgroundColor;
        this.fireLegendConfigurationChanged(new LegendConfigurationChangeEvent(this, legendBackgroundColor, LegendConfigurationChangeEvent.LegendConfigurationChangeType.BACKGROUND_COLOR));
    }

    public void setLegendFrameColor(Color legendFrameColor) {
        this.legendFrameColor = legendFrameColor;
        this.fireLegendConfigurationChanged(new LegendConfigurationChangeEvent(this, legendFrameColor, LegendConfigurationChangeEvent.LegendConfigurationChangeType.FRAME_COLOR));
    }

    public LegendPosition getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(LegendPosition legendPosition) {
        if (legendPosition != this.legendPosition) {
            this.legendPosition = legendPosition;
            this.fireLegendPositionChanged();
        }
    }

    public LegendConfiguration clone() {
        LegendConfiguration clone = new LegendConfiguration();
        clone.legendFont = this.legendFont;
        clone.legendPosition = this.legendPosition;
        clone.showDimensionType = this.showDimensionType;
        clone.legendBackgroundColor = this.legendBackgroundColor;
        clone.legendFrameColor = this.legendFrameColor;
        clone.showLegendFrame = this.showLegendFrame;
        clone.legendFontColor = this.legendFontColor;
        return clone;
    }

    private void fireLegendFontChanged() {
        this.fireLegendConfigurationChanged(new LegendConfigurationChangeEvent(this, this.legendFont));
    }

    private void fireLegendPositionChanged() {
        this.fireLegendConfigurationChanged(new LegendConfigurationChangeEvent(this, this.legendPosition));
    }

    private void fireLegendConfigurationChanged(LegendConfigurationChangeEvent e) {
        this.currentEvent = e;
        Iterator<WeakReference<LegendConfigurationListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            LegendConfigurationListener l = (LegendConfigurationListener)it.next().get();
            if (l != null) {
                l.legendConfigurationChanged(e);
                continue;
            }
            it.remove();
        }
        this.currentEvent = null;
    }

    public void addListener(LegendConfigurationListener l) {
        this.listeners.add(new WeakReference<LegendConfigurationListener>(l));
    }

    public void removeListener(LegendConfigurationListener l) {
        Iterator<WeakReference<LegendConfigurationListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            LegendConfigurationListener listener = (LegendConfigurationListener)it.next().get();
            if (listener != null && listener != l) continue;
            it.remove();
        }
    }

    public void resetToDefaults() {
        this.setLegendFont(DEFAULT_LEGEND_FONT);
        this.setLegendPosition(DEFAULT_LEGEND_POSITION);
        this.setShowDimensionType(true);
        this.setLegendFrameColor(DEFAULT_LEGEND_FRAME_COLOR);
        this.setLegendBackgroundColor(DEFAULT_LEGEND_BACKGROUND_COLOR);
        this.setShowLegendFrame(true);
    }

    public boolean isShowLegendFrame() {
        return this.showLegendFrame;
    }

    public void setShowLegendFrame(boolean showLegendFrame) {
        this.showLegendFrame = showLegendFrame;
        this.fireLegendConfigurationChanged(new LegendConfigurationChangeEvent(this, showLegendFrame, LegendConfigurationChangeEvent.LegendConfigurationChangeType.SHOW_LEGEND_FRAME));
    }

    public Color getLegendFontColor() {
        return this.legendFontColor;
    }

    public void setLegendFontColor(Color newLegendFontColor) {
        this.legendFontColor = newLegendFontColor;
        this.fireLegendConfigurationChanged(new LegendConfigurationChangeEvent(this, this.legendFont));
    }

    public static enum LegendPosition {
        TOP(I18N.getGUILabel((String)"plotter.legendposition.TOP.label", (Object[])new Object[0]), RectangleEdge.TOP),
        BOTTOM(I18N.getGUILabel((String)"plotter.legendposition.BOTTOM.label", (Object[])new Object[0]), RectangleEdge.BOTTOM),
        LEFT(I18N.getGUILabel((String)"plotter.legendposition.LEFT.label", (Object[])new Object[0]), RectangleEdge.LEFT),
        RIGHT(I18N.getGUILabel((String)"plotter.legendposition.RIGHT.label", (Object[])new Object[0]), RectangleEdge.RIGHT),
        NONE(I18N.getGUILabel((String)"plotter.legendposition.NONE.label", (Object[])new Object[0]), null);

        private String name;
        private RectangleEdge position;

        private LegendPosition(String name, RectangleEdge position) {
            this.name = name;
            this.position = position;
        }

        public String getName() {
            return this.name;
        }

        public RectangleEdge getPosition() {
            return this.position;
        }
    }
}

