/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.configuration.LineFormatListener;
import com.owc.gui.charting.listener.events.LineFormatChangeEvent;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.rapidminer.tools.I18N;
import java.awt.BasicStroke;
import java.awt.Color;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LineFormat
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7819380062957065677L;
    private List<WeakReference<LineFormatListener>> listeners = new LinkedList<WeakReference<LineFormatListener>>();
    private LineStyle style = LineStyle.NONE;
    private Color color = Color.GRAY;
    private float width = 1.0f;

    public LineStyle getStyle() {
        return this.style;
    }

    public void setStyle(LineStyle style) {
        if (style != this.style) {
            this.style = style;
            this.fireStyleChanged();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null ? this.color != null : !color.equals(this.color)) {
            this.color = color;
            this.fireColorChanged();
        }
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        if (width != this.width) {
            this.width = width;
            this.fireWidthChanged();
        }
    }

    private void fireWidthChanged() {
        this.fireLineFormatChanged(new LineFormatChangeEvent(this, this.width));
    }

    private void fireColorChanged() {
        this.fireLineFormatChanged(new LineFormatChangeEvent(this, this.color));
    }

    private void fireStyleChanged() {
        this.fireLineFormatChanged(new LineFormatChangeEvent(this, this.style));
    }

    private void fireLineFormatChanged(LineFormatChangeEvent e) {
        Iterator<WeakReference<LineFormatListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            LineFormatListener l = (LineFormatListener)it.next().get();
            if (l != null) {
                l.lineFormatChanged(e);
                continue;
            }
            it.remove();
        }
    }

    public LineFormat clone() {
        LineFormat clone = new LineFormat();
        clone.color = new Color(this.color.getRGB(), true);
        clone.style = this.style;
        clone.width = this.width;
        return clone;
    }

    public BasicStroke getStroke() {
        BasicStroke stroke = this.style.getStroke();
        if (stroke != null) {
            float[] scaledDashArray = this.getScaledDashArray();
            BasicStroke scaledStroke = new BasicStroke(this.getWidth(), stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), scaledDashArray, stroke.getDashPhase());
            return scaledStroke;
        }
        return null;
    }

    float[] getScaledDashArray() {
        float[] scaledDashArray;
        BasicStroke stroke = this.getStyle().getStroke();
        if (stroke == null) {
            return null;
        }
        float[] dashArray = stroke.getDashArray();
        if (dashArray != null) {
            float scalingFactor = this.getWidth();
            if (scalingFactor <= 0.0f) {
                scalingFactor = 1.0f;
            }
            scaledDashArray = scalingFactor != 1.0f ? DataStructureUtils.cloneAndMultiplyArray(dashArray, scalingFactor) : dashArray;
        } else {
            scaledDashArray = dashArray;
        }
        return scaledDashArray;
    }

    public void addLineFormatListener(LineFormatListener l) {
        this.listeners.add(new WeakReference<LineFormatListener>(l));
    }

    public void removeLineFormatListener(LineFormatListener l) {
        Iterator<WeakReference<LineFormatListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            LineFormatListener listener = (LineFormatListener)it.next().get();
            if (l != null) {
                if (listener == null || !listener.equals(l)) continue;
                it.remove();
                continue;
            }
            it.remove();
        }
    }

    public static enum LineStyle {
        NONE(null, I18N.getGUILabel((String)"plotter.linestyle.NONE.label", (Object[])new Object[0])),
        SOLID(StrokeFactory.getSolidStroke(), I18N.getGUILabel((String)"plotter.linestyle.SOLID.label", (Object[])new Object[0])),
        DOTS(StrokeFactory.getDottedStroke(), I18N.getGUILabel((String)"plotter.linestyle.DOTS.label", (Object[])new Object[0])),
        SHORT_DASHES(StrokeFactory.getShortDashedStroke(), I18N.getGUILabel((String)"plotter.linestyle.SHORT_DASHES.label", (Object[])new Object[0])),
        LONG_DASHES(StrokeFactory.getLongDashedStroke(), I18N.getGUILabel((String)"plotter.linestyle.LONG_DASHES.label", (Object[])new Object[0])),
        DASH_DOT(StrokeFactory.getDashDotStroke(), I18N.getGUILabel((String)"plotter.linestyle.DASH_DOT.label", (Object[])new Object[0])),
        STRIPES(StrokeFactory.getStripedStroke(), I18N.getGUILabel((String)"plotter.linestyle.STRIPES.label", (Object[])new Object[0]));

        private final BasicStroke stroke;
        private final String name;

        public BasicStroke getStroke() {
            return this.stroke;
        }

        public String getName() {
            return this.name;
        }

        private LineStyle(BasicStroke stroke, String name) {
            this.stroke = stroke;
            this.name = name;
        }
    }

    private static class StrokeFactory {
        private StrokeFactory() {
        }

        public static BasicStroke getSolidStroke() {
            return new BasicStroke(1.0f, 1, 1);
        }

        public static BasicStroke getDottedStroke() {
            return new BasicStroke(1.0f, 0, 1, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);
        }

        public static BasicStroke getShortDashedStroke() {
            return new BasicStroke(1.0f, 0, 1, 10.0f, new float[]{4.0f, 2.0f}, 0.0f);
        }

        public static BasicStroke getLongDashedStroke() {
            return new BasicStroke(1.0f, 0, 1, 10.0f, new float[]{7.0f, 3.0f}, 0.0f);
        }

        public static BasicStroke getDashDotStroke() {
            return new BasicStroke(1.0f, 0, 1, 10.0f, new float[]{6.0f, 2.0f, 1.0f, 2.0f}, 0.0f);
        }

        public static BasicStroke getStripedStroke() {
            return new BasicStroke(1.0f, 0, 1, 10.0f, new float[]{0.2f, 0.2f}, 0.0f);
        }
    }
}

