/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.data.DimensionConfigData;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.listener.LinkAndBrushListener;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.listener.LinkAndBrushSelection;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.listener.LinkAndBrushSelectionListener;
import com.owc.gui.charting.utility.ContinuousColorProvider;
import com.rapidminer.tools.container.Pair;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jfree.data.Range;

public class LinkAndBrushMaster
implements LinkAndBrushSelectionListener {
    private final PlotConfiguration plotConfig;
    private boolean zoomedIn = false;
    private boolean useGrayForOutliers = false;
    private Map<Integer, Range> rangeAxisIndexToZoomMap = new HashMap<Integer, Range>();
    private Range domainAxisZoom;
    private transient List<WeakReference<LinkAndBrushListener>> listeners = new LinkedList<WeakReference<LinkAndBrushListener>>();

    public LinkAndBrushMaster(PlotConfiguration plotConfig) {
        this.plotConfig = plotConfig;
    }

    public List<PlotConfigurationError> getErrors() {
        LinkedList<PlotConfigurationError> errors = new LinkedList<PlotConfigurationError>();
        return errors;
    }

    public List<PlotConfigurationError> getWarnings() {
        LinkedList<PlotConfigurationError> warnings = new LinkedList<PlotConfigurationError>();
        if (this.zoomedIn) {
            warnings.add(new PlotConfigurationError("zoomed_in", new Object[0]));
        }
        return warnings;
    }

    public boolean isZoomedIn() {
        return this.zoomedIn;
    }

    public void clearZooming(boolean fireEvent) {
        this.zoomedIn = false;
        this.domainAxisZoom = null;
        this.rangeAxisIndexToZoomMap.clear();
        if (fireEvent) {
            this.informLinkAndBrushListeners(new LinkAndBrushSelection(LinkAndBrushSelection.SelectionType.RESTORE_AUTO_BOUNDS, new LinkedList<Pair<Integer, Range>>(), new LinkedList<Pair<Integer, Range>>()));
        }
    }

    public void clearRangeAxisZooming(boolean fireEvent) {
        this.rangeAxisIndexToZoomMap.clear();
        boolean bl = this.zoomedIn = this.domainAxisZoom != null;
        if (fireEvent) {
            this.informLinkAndBrushListeners(new LinkAndBrushSelection(LinkAndBrushSelection.SelectionType.RESTORE_AUTO_BOUNDS, new LinkedList<Pair<Integer, Range>>(), new LinkedList<Pair<Integer, Range>>()));
        }
    }

    public void clearDomainAxisZooming(boolean fireEvent) {
        this.domainAxisZoom = null;
        boolean bl = this.zoomedIn = this.rangeAxisIndexToZoomMap.keySet().size() > 0;
        if (fireEvent) {
            this.informLinkAndBrushListeners(new LinkAndBrushSelection(LinkAndBrushSelection.SelectionType.RESTORE_AUTO_BOUNDS, new LinkedList<Pair<Integer, Range>>(), new LinkedList<Pair<Integer, Range>>()));
        }
    }

    public Range getDomainZoom() {
        return this.domainAxisZoom;
    }

    public Range getRangeAxisZoom(RangeAxisConfig rangeAxisConfig, PlotConfiguration plotConfig) {
        int indexOf = plotConfig.getIndexOfRangeAxisConfigById(rangeAxisConfig.getId());
        return this.rangeAxisIndexToZoomMap.get(indexOf);
    }

    @Override
    public void selectedLinkAndBrushRectangle(LinkAndBrushSelection e) {
        DimensionConfigData dimensionConfigData;
        ContinuousColorProvider colProv;
        DimensionConfigData dimensionConfigData2;
        Double maxColorValue;
        Double minColorValue;
        if (e.getType() == LinkAndBrushSelection.SelectionType.ZOOM_IN) {
            this.zoomedIn = true;
            Pair<Integer, Range> domainAxisRange = e.getDomainAxisRange();
            if (domainAxisRange != null) {
                this.setDomainAxisZoom((Range)domainAxisRange.getSecond(), null);
            }
            List<RangeAxisConfig> rangeAxisConfigs = this.plotConfig.getRangeAxisConfigs();
            List<Pair<Integer, Range>> valueAxisRanges = e.getValueAxisRanges();
            if (valueAxisRanges.size() > 0) {
                for (Pair<Integer, Range> newRangeAxisRangePair : valueAxisRanges) {
                    RangeAxisConfig rangeAxisConfig = rangeAxisConfigs.get((Integer)newRangeAxisRangePair.getFirst());
                    int indexOf = this.plotConfig.getIndexOfRangeAxisConfigById(rangeAxisConfig.getId());
                    this.setRangeAxisZoom(indexOf, (Range)newRangeAxisRangePair.getSecond(), null);
                }
            }
        }
        if (e.getType() == LinkAndBrushSelection.SelectionType.RESTORE_AUTO_BOUNDS) {
            this.clearZooming(false);
        }
        if (e.getType() == LinkAndBrushSelection.SelectionType.COLOR_ZOOM) {
            minColorValue = e.getMinColorValue();
            maxColorValue = e.getMaxColorValue();
            if (e.getPlotInstance() != null) {
                dimensionConfigData2 = e.getPlotInstance().getPlotData().getDimensionConfigData(this.plotConfig.getDefaultDimensionConfigs().get((Object)DimensionConfig.PlotDimension.COLOR));
                colProv = null;
                if (minColorValue != null && dimensionConfigData2 != null && dimensionConfigData2.getColorProvider() instanceof ContinuousColorProvider) {
                    colProv = (ContinuousColorProvider)dimensionConfigData2.getColorProvider();
                    colProv.setMinValue(minColorValue);
                }
                if (maxColorValue != null && dimensionConfigData2 != null && dimensionConfigData2.getColorProvider() instanceof ContinuousColorProvider) {
                    colProv = (ContinuousColorProvider)dimensionConfigData2.getColorProvider();
                    colProv.setMaxValue(maxColorValue);
                }
                if (colProv != null) {
                    colProv.setUseGrayForOutliers(this.useGrayForOutliers);
                }
            }
        } else if (e.getType() == LinkAndBrushSelection.SelectionType.COLOR_SELECTION) {
            minColorValue = e.getMinColorValue();
            maxColorValue = e.getMaxColorValue();
            if (e.getPlotInstance() != null) {
                dimensionConfigData2 = e.getPlotInstance().getPlotData().getDimensionConfigData(this.plotConfig.getDefaultDimensionConfigs().get((Object)DimensionConfig.PlotDimension.COLOR));
                colProv = null;
                if (minColorValue != null && dimensionConfigData2 != null && dimensionConfigData2.getColorProvider() instanceof ContinuousColorProvider) {
                    colProv = (ContinuousColorProvider)dimensionConfigData2.getColorProvider();
                    colProv.setMinValue(minColorValue);
                }
                if (maxColorValue != null && dimensionConfigData2 != null && dimensionConfigData2.getColorProvider() instanceof ContinuousColorProvider) {
                    colProv = (ContinuousColorProvider)dimensionConfigData2.getColorProvider();
                    colProv.setMaxValue(maxColorValue);
                }
                if (colProv != null) {
                    colProv.setUseGrayForOutliers(this.useGrayForOutliers);
                }
            }
        }
        if (e.getType() == LinkAndBrushSelection.SelectionType.RESTORE_COLOR && e.getPlotInstance() != null && (dimensionConfigData = e.getPlotInstance().getPlotData().getDimensionConfigData(this.plotConfig.getDefaultDimensionConfigs().get((Object)DimensionConfig.PlotDimension.COLOR))) != null && dimensionConfigData.getColorProvider() instanceof ContinuousColorProvider) {
            ContinuousColorProvider colProv2 = (ContinuousColorProvider)dimensionConfigData.getColorProvider();
            colProv2.revertMinAndMaxValuesBackToOriginalValues();
        }
        this.informLinkAndBrushListeners(e);
    }

    public void setDomainAxisZoom(Range domainAxisZoom, LinkAndBrushSelection e) {
        if (domainAxisZoom == null) {
            throw new IllegalArgumentException("domainAxisRange must not be null!");
        }
        this.domainAxisZoom = domainAxisZoom;
        if (e != null) {
            this.informLinkAndBrushListeners(e);
        }
    }

    public void setRangeAxisZoom(int indexOfRangeAxis, Range rangeAxisZoom, LinkAndBrushSelection e) {
        if (indexOfRangeAxis < 0) {
            throw new IllegalArgumentException("indexOfRangeAxis must not be < 0");
        }
        this.rangeAxisIndexToZoomMap.put(indexOfRangeAxis, rangeAxisZoom);
        if (e != null) {
            this.informLinkAndBrushListeners(e);
        }
    }

    protected LinkAndBrushMaster clone(PlotConfiguration plotConfig) {
        LinkAndBrushMaster clone = new LinkAndBrushMaster(plotConfig);
        clone.domainAxisZoom = this.domainAxisZoom;
        HashMap<Integer, Range> clonedRangeAxisIndexToZoomMap = new HashMap<Integer, Range>();
        for (Integer key : this.rangeAxisIndexToZoomMap.keySet()) {
            Range value = this.rangeAxisIndexToZoomMap.get(key);
            clonedRangeAxisIndexToZoomMap.put(key, new Range(value.getLowerBound(), value.getUpperBound()));
        }
        clone.rangeAxisIndexToZoomMap = clonedRangeAxisIndexToZoomMap;
        clone.zoomedIn = this.zoomedIn;
        return clone;
    }

    public void addLinkAndBrushListener(LinkAndBrushListener l) {
        this.listeners.add(new WeakReference<LinkAndBrushListener>(l));
    }

    public void removeLinkAndBrushListener(LinkAndBrushListener l) {
        Iterator<WeakReference<LinkAndBrushListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            LinkAndBrushListener listener = (LinkAndBrushListener)it.next().get();
            if (l != null) {
                if (listener == null || !listener.equals(l)) continue;
                it.remove();
                continue;
            }
            it.remove();
        }
    }

    private void informLinkAndBrushListeners(LinkAndBrushSelection e) {
        Iterator<WeakReference<LinkAndBrushListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            WeakReference<LinkAndBrushListener> wrl = it.next();
            LinkAndBrushListener l = (LinkAndBrushListener)wrl.get();
            if (l != null) {
                l.linkAndBrushUpdate(e);
                continue;
            }
            it.remove();
        }
    }

    public boolean isUseGrayForOutliers() {
        return this.useGrayForOutliers;
    }

    public void setUseGrayForOutliers(boolean useGrayForOutliers) {
        this.useGrayForOutliers = useGrayForOutliers;
    }
}

