/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.StaticDebug;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.DomainConfigManager;
import com.owc.gui.charting.configuration.LegendConfiguration;
import com.owc.gui.charting.configuration.LineFormat;
import com.owc.gui.charting.configuration.LinkAndBrushMaster;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.listener.LinkAndBrushListener;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.listener.LinkAndBrushSelection;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.listener.LinkAndBrushSelectionListener;
import com.owc.gui.charting.listener.DimensionConfigListener;
import com.owc.gui.charting.listener.LegendConfigurationListener;
import com.owc.gui.charting.listener.PlotConfigurationListener;
import com.owc.gui.charting.listener.PlotConfigurationProcessingListener;
import com.owc.gui.charting.listener.RangeAxisConfigListener;
import com.owc.gui.charting.listener.events.DimensionConfigChangeEvent;
import com.owc.gui.charting.listener.events.LegendConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.RangeAxisConfigChangeEvent;
import com.owc.gui.charting.listener.events.ValueGroupingChangeEvent;
import com.owc.gui.charting.listener.events.ValueRangeChangeEvent;
import com.owc.gui.charting.listener.events.ValueSourceChangeEvent;
import com.owc.gui.charting.templates.style.ColorRGB;
import com.owc.gui.charting.templates.style.ColorScheme;
import com.owc.gui.charting.utility.CategoricalColorProvider;
import com.owc.gui.charting.utility.ContinuousColorProvider;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.owc.gui.charting.utility.ListUtility;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.ParameterService;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jfree.chart.plot.PlotOrientation;

public class PlotConfiguration
implements DimensionConfigListener,
RangeAxisConfigListener,
Cloneable,
LinkAndBrushSelectionListener,
LegendConfigurationListener,
LinkAndBrushListener,
Serializable {
    private static final long serialVersionUID = -4050504707973990051L;
    public static final Paint DEFAULT_SERIES_OUTLINE_PAINT = Color.BLACK;
    public static final Font DEFAULT_AXES_FONT = new Font("Dialog", 0, 10);
    public static final Color DEFAULT_OUTLINE_COLOR = Color.BLACK;
    private static final double MIN_SHAPE_SCALING_FACTOR = 0.4;
    private static final double MAX_SHAPE_SCALING_FACTOR = 5.0;
    public static final int GUI_PLOTTER_ROWS_MAXIMUM_IF_RAPIDMINER_PROPERTY_NOT_READABLE = 5000;
    private static final String DEFAULT_TITLE_TEXT = null;
    private static final Font DEFAULT_TITLE_FONT = new Font("Arial", 0, 20);
    private static final Color DEFAULT_PLOT_BACKGROUND_COLOR = Color.white;
    private static final Color DEFAULT_FRAME_BACKGROUND_COLOR = Color.white;
    private static final PlotOrientation DEFAULT_PLOT_ORIENTATION = PlotOrientation.VERTICAL;
    private static final float DEFAULT_AXIS_LINE_WIDTH = 1.0f;
    private static final Color DEFAULT_AXIS_COLOR = Color.black;
    public static final Color DEFAULT_TITLE_COLOR = Color.black;
    private boolean initializing = false;
    private final List<RangeAxisConfig> rangeAxisConfigs = new LinkedList<RangeAxisConfig>();
    private final DomainConfigManager domainConfigManager;
    private Map<DimensionConfig.PlotDimension, DefaultDimensionConfig> dimensionConfigMap = new HashMap<DimensionConfig.PlotDimension, DefaultDimensionConfig>();
    private String titleText = DEFAULT_TITLE_TEXT;
    private Font titleFont = DEFAULT_TITLE_FONT;
    private Color plotBackgroundColor = DEFAULT_PLOT_BACKGROUND_COLOR;
    private Color frameBackgroundColor = DEFAULT_FRAME_BACKGROUND_COLOR;
    private Font axesFont = DEFAULT_AXES_FONT;
    private PlotOrientation orientation = DEFAULT_PLOT_ORIENTATION;
    private static int CLASS_ID = 0;
    private int unique_debug_id = -1;
    private boolean cloned_debug = false;
    private Boolean processEvents = new Boolean(true);
    private List<PlotConfigurationChangeEvent> eventList = new LinkedList<PlotConfigurationChangeEvent>();
    private Integer listenersInformedCounter = 0;
    private transient List<WeakReference<PlotConfigurationListener>> defaultListeners = new LinkedList<WeakReference<PlotConfigurationListener>>();
    private transient List<WeakReference<PlotConfigurationListener>> prioritizedListeners = new LinkedList<WeakReference<PlotConfigurationListener>>();
    private transient List<WeakReference<PlotConfigurationProcessingListener>> processingListeners = new LinkedList<WeakReference<PlotConfigurationProcessingListener>>();
    private boolean changingRange;
    private boolean changingGrouping;
    private float axisLineWidth = 1.0f;
    private Color axisLineColor = DEFAULT_AXIS_COLOR;
    private Map<String, ColorScheme> colorSchemes = new HashMap<String, ColorScheme>();
    private String activeSchemeName;
    private PlotConfigurationChangeEvent currentEvent = null;
    private transient LinkAndBrushMaster linkAndBrushMaster;
    private LegendConfiguration legendConfiguration = new LegendConfiguration();
    private int idCounter = 0;
    private Color titleColor = DEFAULT_TITLE_COLOR;

    public PlotConfiguration(DataTableColumn domainColumn) {
        this.unique_debug_id = ++CLASS_ID;
        this.domainConfigManager = new DomainConfigManager(this, domainColumn);
        this.linkAndBrushMaster = new LinkAndBrushMaster(this);
        this.linkAndBrushMaster.addLinkAndBrushListener(this);
        this.domainConfigManager.addDimensionConfigListener(this);
        this.legendConfiguration.addListener(this);
        this.createDefaultColorSchemes();
    }

    private void createDefaultColorSchemes() {
        ColorScheme colorScheme = this.getDefaultColorScheme();
        this.colorSchemes.put(colorScheme.getName(), colorScheme);
        LinkedList<ColorRGB> listOfColors = new LinkedList<ColorRGB>();
        listOfColors.add(new ColorRGB(124, 181, 236));
        listOfColors.add(new ColorRGB(67, 67, 72));
        listOfColors.add(new ColorRGB(144, 237, 125));
        listOfColors.add(new ColorRGB(247, 163, 92));
        listOfColors.add(new ColorRGB(128, 133, 233));
        listOfColors.add(new ColorRGB(241, 92, 128));
        listOfColors.add(new ColorRGB(228, 211, 84));
        listOfColors.add(new ColorRGB(128, 133, 232));
        listOfColors.add(new ColorRGB(141, 70, 83));
        listOfColors.add(new ColorRGB(145, 232, 225));
        ColorScheme cs = new ColorScheme("Pastel", listOfColors);
        this.colorSchemes.put(cs.getName(), cs);
        listOfColors = new LinkedList();
        ColorRGB colorful1 = new ColorRGB(222, 217, 26);
        ColorRGB colorful2 = new ColorRGB(219, 138, 47);
        ColorRGB colorful3 = new ColorRGB(217, 26, 21);
        ColorRGB colorful4 = new ColorRGB(156, 217, 84);
        ColorRGB colorful5 = new ColorRGB(83, 70, 255);
        listOfColors.add(colorful1);
        listOfColors.add(colorful2);
        listOfColors.add(colorful3);
        listOfColors.add(colorful4);
        listOfColors.add(colorful5);
        cs = new ColorScheme("Mud", listOfColors, colorful2, colorful5);
        this.colorSchemes.put(cs.getName(), cs);
        listOfColors = new LinkedList();
        ColorRGB forest1 = new ColorRGB(94, 173, 0);
        ColorRGB forest2 = new ColorRGB(255, 188, 10);
        ColorRGB forest3 = new ColorRGB(189, 39, 53);
        ColorRGB forest4 = new ColorRGB(255, 119, 0);
        ColorRGB forest5 = new ColorRGB(81, 17, 84);
        listOfColors.add(forest1);
        listOfColors.add(forest2);
        listOfColors.add(forest3);
        listOfColors.add(forest4);
        listOfColors.add(forest5);
        cs = new ColorScheme("Forest", listOfColors, forest4, forest5);
        this.colorSchemes.put(cs.getName(), cs);
        listOfColors = new LinkedList();
        ColorRGB baw1 = new ColorRGB(0, 0, 0);
        ColorRGB baw2 = new ColorRGB(204, 204, 204);
        ColorRGB baw3 = new ColorRGB(255, 255, 255);
        ColorRGB baw4 = new ColorRGB(102, 102, 102);
        ColorRGB baw5 = new ColorRGB(51, 51, 51);
        listOfColors.add(baw1);
        listOfColors.add(baw2);
        listOfColors.add(baw3);
        listOfColors.add(baw4);
        listOfColors.add(baw5);
        cs = new ColorScheme("Grayscale", listOfColors, baw2, baw1);
        this.colorSchemes.put(cs.getName(), cs);
        this.activeSchemeName = colorScheme.getName();
    }

    public PlotConfiguration(DataTableColumn domainColumn, ColorScheme activeColorScheme, Map<String, ColorScheme> colorSchemes) {
        this(domainColumn);
        this.colorSchemes = colorSchemes;
        if (activeColorScheme != null) {
            this.setActiveColorScheme(activeColorScheme.getName());
        }
    }

    private PlotConfiguration(DomainConfigManager domainConfigManager, LegendConfiguration legendConfiguration) {
        this.unique_debug_id = ++CLASS_ID;
        this.linkAndBrushMaster = new LinkAndBrushMaster(this);
        this.linkAndBrushMaster.addLinkAndBrushListener(this);
        this.legendConfiguration = legendConfiguration;
        this.domainConfigManager = domainConfigManager;
        domainConfigManager.setPlotConfiguration(this);
        domainConfigManager.addDimensionConfigListener(this);
        legendConfiguration.addListener(this);
    }

    public List<RangeAxisConfig> getRangeAxisConfigs() {
        return this.rangeAxisConfigs;
    }

    public void addRangeAxisConfig(int index, RangeAxisConfig rangeAxis) {
        this.debug("ADDING RANGEAXIS " + rangeAxis.getId());
        this.rangeAxisConfigs.add(index, rangeAxis);
        this.fireRangeAxisAdded(index, rangeAxis);
        rangeAxis.addRangeAxisConfigListener(this);
    }

    public void addRangeAxisConfig(RangeAxisConfig rangeAxis) {
        this.addRangeAxisConfig(this.rangeAxisConfigs.size(), rangeAxis);
    }

    public void removeRangeAxisConfig(RangeAxisConfig rangeAxis) {
        int index = this.rangeAxisConfigs.indexOf(rangeAxis);
        this.removeRangeAxisConfig(index);
    }

    public int getNextId() {
        ++this.idCounter;
        this.debug("Generated ID " + this.idCounter);
        return this.idCounter;
    }

    public void changeIndex(int index, RangeAxisConfig rangeAxis) {
        if (ListUtility.changeIndex(this.rangeAxisConfigs, rangeAxis, index)) {
            this.linkAndBrushMaster.clearZooming(false);
            this.fireRangeAxisMoved(index, rangeAxis);
        }
    }

    public int getRangeAxisCount() {
        return this.rangeAxisConfigs.size();
    }

    public void removeRangeAxisConfig(int index) {
        RangeAxisConfig rangeAxis = this.rangeAxisConfigs.get(index);
        rangeAxis.removeRangeAxisConfigListener(this);
        this.debug(" REMOVING RANGEAXIS with index " + index + " and ID " + rangeAxis.getId());
        this.rangeAxisConfigs.remove(index);
        this.fireRangeAxisRemoved(index, rangeAxis);
    }

    public void addPlotConfigurationListener(PlotConfigurationListener l) {
        this.addPlotConfigurationListener(l, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlotConfigurationListener(PlotConfigurationListener l, boolean prioritized) {
        if (prioritized) {
            List<WeakReference<PlotConfigurationListener>> list = this.prioritizedListeners;
            synchronized (list) {
                this.prioritizedListeners.add(new WeakReference<PlotConfigurationListener>(l));
            }
        }
        List<WeakReference<PlotConfigurationListener>> list = this.defaultListeners;
        synchronized (list) {
            this.defaultListeners.add(new WeakReference<PlotConfigurationListener>(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPrioritizedListenerCount() {
        List<WeakReference<PlotConfigurationListener>> list = this.prioritizedListeners;
        synchronized (list) {
            return this.prioritizedListeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlotConfigurationListener(PlotConfigurationListener l) {
        PlotConfigurationListener listener;
        if (this.prioritizedListeners == null) {
            this.prioritizedListeners = new LinkedList<WeakReference<PlotConfigurationListener>>();
        }
        List<WeakReference<PlotConfigurationListener>> list = this.prioritizedListeners;
        synchronized (list) {
            Iterator<WeakReference<PlotConfigurationListener>> it = this.prioritizedListeners.iterator();
            while (it.hasNext()) {
                listener = (PlotConfigurationListener)it.next().get();
                if (listener != null && listener != l) continue;
                it.remove();
            }
        }
        if (this.defaultListeners == null) {
            this.defaultListeners = new LinkedList<WeakReference<PlotConfigurationListener>>();
        }
        list = this.defaultListeners;
        synchronized (list) {
            Iterator<WeakReference<PlotConfigurationListener>> it_default = this.defaultListeners.iterator();
            while (it_default.hasNext()) {
                listener = (PlotConfigurationListener)it_default.next().get();
                if (listener != null && listener != l) continue;
                it_default.remove();
            }
        }
    }

    public String getTitleText() {
        return this.titleText;
    }

    public void setTitleText(String title) {
        if (!Objects.equals(this.titleText, title)) {
            this.titleText = title;
            this.fireTitleChanged();
        }
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        if (!titleFont.equals(this.titleFont)) {
            this.titleFont = titleFont;
            this.fireTitleChanged();
        }
    }

    public Color getPlotBackgroundColor() {
        return this.plotBackgroundColor;
    }

    public void setPlotBackgroundColor(Color backgroundColor) {
        if (!backgroundColor.equals(this.plotBackgroundColor)) {
            this.plotBackgroundColor = backgroundColor;
            this.firePlotBackgroundColorChanged();
        }
    }

    public Font getAxesFont() {
        return this.axesFont;
    }

    public void setAxesFont(Font axesFont) {
        if (axesFont != this.axesFont) {
            this.axesFont = axesFont;
            this.fireAxesFontChanged();
        }
    }

    public Color getNextColor() {
        int idx = 0;
        HashSet<Color> usedColors = new HashSet<Color>();
        for (ValueSource valueSource : this.getAllValueSources()) {
            usedColors.add(DataStructureUtils.setColorAlpha(valueSource.getSeriesFormat().getItemColor(), 255));
        }
        ColorScheme colorScheme = this.getActiveColorScheme();
        while (usedColors.contains(CategoricalColorProvider.getColorForCategoryIdx(idx, colorScheme))) {
            ++idx;
        }
        return CategoricalColorProvider.getColorForCategoryIdx(idx, colorScheme);
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation orientation) {
        if (!this.orientation.equals((Object)orientation)) {
            this.orientation = orientation;
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, orientation));
        }
    }

    public float getAxisLineWidth() {
        return this.axisLineWidth;
    }

    public Color getAxisLineColor() {
        return this.axisLineColor;
    }

    public void setAxisLineWidth(float axisLineWidth) {
        if (axisLineWidth != this.axisLineWidth) {
            this.axisLineWidth = axisLineWidth;
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, axisLineWidth));
        }
    }

    public void setAxisLineColor(Color axisLineColor) {
        if (!axisLineColor.equals(this.axisLineColor)) {
            this.axisLineColor = axisLineColor;
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, PlotConfigurationChangeEvent.PlotConfigurationChangeType.AXIS_LINE_COLOR, axisLineColor));
        }
    }

    public Color getChartBackgroundColor() {
        return this.frameBackgroundColor;
    }

    public void setFrameBackgroundColor(Color frameBackgroundColor) {
        if (!frameBackgroundColor.equals(this.frameBackgroundColor)) {
            this.frameBackgroundColor = frameBackgroundColor;
            this.fireChartBackgroundChanged();
        }
    }

    private void fireRangeAxisMoved(int index, RangeAxisConfig rangeAxis) {
        if (!this.initializing) {
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, PlotConfigurationChangeEvent.PlotConfigurationChangeType.RANGE_AXIS_CONFIG_MOVED, rangeAxis, index));
        }
    }

    private void fireRangeAxisAdded(int index, RangeAxisConfig rangeAxis) {
        if (!this.initializing) {
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, PlotConfigurationChangeEvent.PlotConfigurationChangeType.RANGE_AXIS_CONFIG_ADDED, rangeAxis, index));
        }
    }

    private void fireRangeAxisRemoved(int index, RangeAxisConfig rangeAxis) {
        if (!this.initializing) {
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, PlotConfigurationChangeEvent.PlotConfigurationChangeType.RANGE_AXIS_CONFIG_REMOVED, rangeAxis, index));
        }
    }

    private void firePlotBackgroundColorChanged() {
        if (!this.initializing) {
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, PlotConfigurationChangeEvent.PlotConfigurationChangeType.PLOT_BACKGROUND_COLOR, this.plotBackgroundColor));
        }
    }

    private void fireLegendChanged(LegendConfigurationChangeEvent change) {
        if (!this.initializing) {
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, change));
        }
    }

    private void fireChartBackgroundChanged() {
        if (!this.initializing) {
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, PlotConfigurationChangeEvent.PlotConfigurationChangeType.FRAME_BACKGROUND_COLOR, this.frameBackgroundColor));
        }
    }

    public void setDimensionConfig(DimensionConfig.PlotDimension dimension, DefaultDimensionConfig dimensionConfig) {
        DimensionConfig currentDimensionConfig = this.dimensionConfigMap.get((Object)dimension);
        if (dimensionConfig != currentDimensionConfig) {
            if (dimensionConfig == null) {
                if (currentDimensionConfig != null) {
                    currentDimensionConfig.removeDimensionConfigListener(this);
                }
                this.dimensionConfigMap.remove((Object)dimension);
                this.fireDimensionConfigRemoved(dimension, currentDimensionConfig);
            } else if (currentDimensionConfig != dimensionConfig) {
                if (currentDimensionConfig != null) {
                    currentDimensionConfig.removeDimensionConfigListener(this);
                }
                this.dimensionConfigMap.put(dimension, dimensionConfig);
                dimensionConfig.addDimensionConfigListener(this);
                this.fireDimensionConfigAdded(dimension, dimensionConfig);
            }
        }
    }

    private void informValueSourcesAboutDimensionChange(DimensionConfigChangeEvent e) {
        for (RangeAxisConfig rangeAxisConfig : this.rangeAxisConfigs) {
            for (ValueSource valueSource : rangeAxisConfig.getValueSources()) {
                valueSource.dimensionConfigChanged(e);
            }
        }
    }

    private void fireAxesFontChanged() {
        if (!this.initializing) {
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, this.axesFont));
        }
    }

    public List<ValueSource> getAllValueSources() {
        LinkedList<ValueSource> resultList = new LinkedList<ValueSource>();
        for (RangeAxisConfig rangeAxisConfig : this.getRangeAxisConfigs()) {
            resultList.addAll(rangeAxisConfig.getValueSources());
        }
        return resultList;
    }

    public DimensionConfig getDimensionConfig(DimensionConfig.PlotDimension dimension) {
        if (dimension == DimensionConfig.PlotDimension.DOMAIN) {
            return this.domainConfigManager;
        }
        return this.dimensionConfigMap.get((Object)dimension);
    }

    public Map<DimensionConfig.PlotDimension, DefaultDimensionConfig> getDefaultDimensionConfigs() {
        return this.dimensionConfigMap;
    }

    public SeriesFormat getAutomaticSeriesFormatForNextValueSource(RangeAxisConfig rangeAxisConfig) {
        SeriesFormat seriesFormat = new SeriesFormat();
        List<ValueSource> valueSourceList = rangeAxisConfig.getValueSources();
        int size = valueSourceList.size();
        if (size > 0) {
            ValueSource lastValueSource = valueSourceList.get(valueSourceList.size() - 1);
            SeriesFormat lastFormat = lastValueSource.getSeriesFormat();
            if (lastFormat.getSeriesType() == SeriesFormat.VisualizationType.LINES_AND_SHAPES) {
                if (lastFormat.getItemShape() == SeriesFormat.ItemShape.NONE) {
                    seriesFormat.setItemShape(SeriesFormat.ItemShape.NONE);
                    LineFormat.LineStyle[] values = LineFormat.LineStyle.values();
                    LineFormat.LineStyle nextItem = values[size % (values.length - 1) + 1];
                    seriesFormat.setLineStyle(nextItem);
                } else {
                    SeriesFormat.ItemShape[] values = SeriesFormat.ItemShape.values();
                    SeriesFormat.ItemShape nextShape = values[size % (values.length - 1) + 1];
                    seriesFormat.setItemShape(nextShape);
                    seriesFormat.setLineStyle(lastFormat.getLineStyle());
                }
                seriesFormat.setLineWidth(lastFormat.getLineWidth());
                seriesFormat.setItemSize(lastFormat.getItemSize());
            }
            seriesFormat.setStackingMode(lastFormat.getStackingMode());
            seriesFormat.setOpacity(lastFormat.getOpacity());
            seriesFormat.setAreaFillStyle(lastFormat.getAreaFillStyle());
        }
        seriesFormat.setItemColor(this.getNextColor());
        return seriesFormat;
    }

    private void fireDimensionConfigAdded(DimensionConfig.PlotDimension dimension, DimensionConfig dimensionConfig) {
        if (!this.initializing) {
            boolean processEvents = this.isProcessingEvents();
            this.setProcessEvents(false);
            this.informValueSourcesAboutDimensionChange(new DimensionConfigChangeEvent(dimensionConfig, dimension, DimensionConfigChangeEvent.DimensionConfigChangeType.RESET));
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, PlotConfigurationChangeEvent.PlotConfigurationChangeType.DIMENSION_CONFIG_ADDED, dimension, dimensionConfig));
            this.setProcessEvents(processEvents);
        }
    }

    private void fireDimensionConfigRemoved(DimensionConfig.PlotDimension dimension, DimensionConfig dimensionConfig) {
        if (!this.initializing) {
            boolean processEvents = this.isProcessingEvents();
            this.setProcessEvents(false);
            this.informValueSourcesAboutDimensionChange(new DimensionConfigChangeEvent(dimensionConfig, dimension, DimensionConfigChangeEvent.DimensionConfigChangeType.RESET));
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, PlotConfigurationChangeEvent.PlotConfigurationChangeType.DIMENSION_CONFIG_REMOVED, dimension, dimensionConfig));
            this.setProcessEvents(processEvents);
        }
    }

    private void fireTitleChanged() {
        if (!this.initializing) {
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, this.titleText));
        }
    }

    private Color getColorFromProperty(String propertyName, Color errorColor) {
        String propertyString = ParameterService.getParameterValue((String)propertyName);
        if (propertyString != null) {
            String[] colors = propertyString.split(",");
            if (colors.length != 3) {
                throw new IllegalArgumentException("Color '" + propertyString + "' defined as value for property '" + propertyName + "' is not a vaild color. Colors must be of the form 'r,g,b'.");
            }
            Color color = new Color(Integer.parseInt(colors[0].trim()), Integer.parseInt(colors[1].trim()), Integer.parseInt(colors[2].trim()));
            return color;
        }
        return errorColor;
    }

    public synchronized void plotConfigurationChangeEventProcessed() {
        this.eventProcessed(false);
    }

    private synchronized void eventProcessed(boolean processedAtOnce) {
        Integer n = this.listenersInformedCounter;
        Integer n2 = this.listenersInformedCounter = Integer.valueOf(this.listenersInformedCounter - 1);
        if (!processedAtOnce && this.listenersInformedCounter <= 0) {
            this.listenersInformedCounter = 0;
            this.resetCurrentEvent();
        }
    }

    private synchronized void resetCurrentEvent() {
        this.informOfProcessingStatus(false);
        this.currentEvent = null;
        this.listenersInformedCounter = 0;
        this.debug("PlotConfiguration: Reset current event..");
        this.processQueueEvent();
    }

    public synchronized void setProcessEvents(Boolean process) {
        this.processEvents = process;
        this.debug(" SET PROCESS EVENTS TO: " + process);
        if (this.processEvents.booleanValue()) {
            this.processQueueEvent();
        }
    }

    public synchronized boolean isProcessingEvents() {
        return this.processEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informOfProcessingStatus(boolean started) {
        LinkedList<WeakReference<PlotConfigurationProcessingListener>> processingListenerCopy = new LinkedList<WeakReference<PlotConfigurationProcessingListener>>();
        if (this.processingListeners == null) {
            this.processingListeners = new LinkedList<WeakReference<PlotConfigurationProcessingListener>>();
        }
        List<WeakReference<PlotConfigurationProcessingListener>> list = this.processingListeners;
        synchronized (list) {
            processingListenerCopy.addAll(this.processingListeners);
        }
        Iterator defaultIt = processingListenerCopy.iterator();
        while (defaultIt.hasNext()) {
            WeakReference wrl = (WeakReference)defaultIt.next();
            PlotConfigurationProcessingListener l = (PlotConfigurationProcessingListener)wrl.get();
            if (l != null) {
                if (started) {
                    l.startProcessing();
                    continue;
                }
                l.endProcessing();
                continue;
            }
            defaultIt.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processQueueEvent() {
        boolean booleanValue = false;
        this.debug("PROCESS EVENT QUEUE");
        booleanValue = this.processEvents;
        this.debug("PROCESS EVENTS: " + booleanValue);
        this.debug("CURRENT EVENT: " + this.currentEvent);
        if (booleanValue && this.currentEvent == null) {
            Object l;
            if (this.eventList.size() <= 0) {
                this.debug("NO CURRENT EVENTS TO HANDLE");
                StaticDebug.emptyDebugLine();
                StaticDebug.emptyDebugLine();
                return;
            }
            this.currentEvent = this.eventList.get(0);
            this.currentEvent.setSource(this.clone());
            this.debug("GOT NEW CURRENT EVENT: " + this.currentEvent);
            StaticDebug.debugEvent(0, this.currentEvent);
            this.eventList.remove(0);
            this.informOfProcessingStatus(true);
            LinkedList<WeakReference<PlotConfigurationListener>> clonedPrioListeners = new LinkedList<WeakReference<PlotConfigurationListener>>();
            if (this.prioritizedListeners == null) {
                this.prioritizedListeners = new LinkedList<WeakReference<PlotConfigurationListener>>();
            }
            List<WeakReference<PlotConfigurationListener>> list = this.prioritizedListeners;
            synchronized (list) {
                clonedPrioListeners.addAll(this.prioritizedListeners);
            }
            Iterator it = clonedPrioListeners.iterator();
            while (it.hasNext()) {
                WeakReference wrl = (WeakReference)it.next();
                l = (PlotConfigurationListener)wrl.get();
                if (l != null) {
                    Integer n = this.listenersInformedCounter;
                    Integer n2 = this.listenersInformedCounter = Integer.valueOf(this.listenersInformedCounter + 1);
                    if (!l.plotConfigurationChanged(this.currentEvent)) continue;
                    this.eventProcessed(true);
                    continue;
                }
                it.remove();
            }
            LinkedList<WeakReference<PlotConfigurationListener>> clonedDefaultListeners = new LinkedList<WeakReference<PlotConfigurationListener>>();
            l = this.defaultListeners;
            synchronized (l) {
                clonedDefaultListeners.addAll(this.defaultListeners);
            }
            Iterator defaultIt = clonedDefaultListeners.iterator();
            while (defaultIt.hasNext()) {
                WeakReference wrl = (WeakReference)defaultIt.next();
                PlotConfigurationListener l2 = (PlotConfigurationListener)wrl.get();
                if (l2 != null) {
                    Integer n = this.listenersInformedCounter;
                    Integer n3 = this.listenersInformedCounter = Integer.valueOf(this.listenersInformedCounter + 1);
                    if (!l2.plotConfigurationChanged(this.currentEvent)) continue;
                    this.eventProcessed(true);
                    continue;
                }
                defaultIt.remove();
            }
            if (this.listenersInformedCounter <= 0) {
                this.resetCurrentEvent();
            }
        }
    }

    private synchronized void addEventToQueue(PlotConfigurationChangeEvent e) {
        this.debug("ADD EVENT TO QUEUE");
        if (this.eventList.size() > 0) {
            PlotConfigurationChangeEvent plotConfigurationChangeEvent = this.eventList.get(0);
            if (plotConfigurationChangeEvent.getType() == PlotConfigurationChangeEvent.PlotConfigurationChangeType.META_CHANGE) {
                plotConfigurationChangeEvent.addPlotConfigChangeEvent(this, e);
                this.debug("ADD EVENT TO META EVENT");
            } else {
                LinkedList<PlotConfigurationChangeEvent> events = new LinkedList<PlotConfigurationChangeEvent>();
                events.add(plotConfigurationChangeEvent);
                events.add(e);
                PlotConfigurationChangeEvent metaEvent = new PlotConfigurationChangeEvent(this, events);
                this.eventList.set(0, metaEvent);
                this.debug("CREATE NEW META EVENT");
            }
        } else {
            this.debug("ADD EVENT TO LIST");
            this.eventList.add(e);
        }
        this.processQueueEvent();
    }

    private void firePlotConfigurationChanged(PlotConfigurationChangeEvent e) {
        if (!this.initializing) {
            this.debug("Firing a PlotConfigChangeEvent");
            this.addEventToQueue(e);
        }
    }

    public DomainConfigManager getDomainConfigManager() {
        return this.domainConfigManager;
    }

    private void debug(String msg) {
        if (this.cloned_debug) {
            StaticDebug.debug("CLONED PlotConfig(" + this.unique_debug_id + "): " + msg);
        } else {
            StaticDebug.debug("PlotConfig(" + this.unique_debug_id + "): " + msg);
        }
    }

    @Override
    public void dimensionConfigChanged(DimensionConfigChangeEvent change) {
        DimensionConfigChangeEvent.DimensionConfigChangeType type = change.getType();
        boolean processEvents = this.isProcessingEvents();
        this.setProcessEvents(false);
        switch (type) {
            case ABOUT_TO_CHANGE_GROUPING: {
                this.changingGrouping = true;
                break;
            }
            case GROUPING_CHANGED: {
                ValueGroupingChangeEvent groupingChange = change.getGroupingChangeEvent();
                if (groupingChange.getType() == ValueGroupingChangeEvent.ValueGroupingChangeType.RESET && this.changingGrouping) {
                    this.changingGrouping = false;
                }
                this.informValueSourcesAboutDimensionChange(change);
                this.linkAndBrushMaster.clearZooming(false);
                this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, change));
                break;
            }
            case RANGE: {
                ValueRangeChangeEvent rangeChange = change.getValueRangeChangedEvent();
                if (rangeChange.getType() == ValueRangeChangeEvent.ValueRangeChangeType.RESET) {
                    // empty if block
                }
                this.informValueSourcesAboutDimensionChange(change);
                this.linkAndBrushMaster.clearZooming(false);
                this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, change));
                break;
            }
            default: {
                if (this.changingGrouping) break;
                this.informValueSourcesAboutDimensionChange(change);
                this.linkAndBrushMaster.clearZooming(false);
                this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, change));
            }
        }
        this.setProcessEvents(processEvents);
    }

    @Override
    public void rangeAxisConfigChanged(RangeAxisConfigChangeEvent e) {
        switch (e.getType()) {
            case AUTO_NAMING: 
            case LABEL: {
                break;
            }
            case VALUE_SOURCE_CHANGED: {
                ValueSourceChangeEvent valueSourceChange = e.getValueSourceChange();
                boolean shouldBreak = false;
                switch (valueSourceChange.getType()) {
                    case SERIES_FORMAT_CHANGED: {
                        shouldBreak = true;
                        break;
                    }
                    default: {
                        this.linkAndBrushMaster.clearZooming(false);
                    }
                }
                if (shouldBreak) break;
            }
            default: {
                this.linkAndBrushMaster.clearRangeAxisZooming(false);
            }
        }
        this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, e));
    }

    public List<PlotConfigurationError> getErrors() {
        LinkedList<PlotConfigurationError> errors = new LinkedList<PlotConfigurationError>();
        errors.addAll(this.domainConfigManager.getErrors());
        errors.addAll(this.linkAndBrushMaster.getErrors());
        for (DimensionConfig dimensionConfig : this.dimensionConfigMap.values()) {
            errors.addAll(dimensionConfig.getErrors());
        }
        for (RangeAxisConfig rangeAxisConfig : this.rangeAxisConfigs) {
            errors.addAll(rangeAxisConfig.getErrors());
        }
        return errors;
    }

    public List<PlotConfigurationError> getWarnings() {
        LinkedList<PlotConfigurationError> warnings = new LinkedList<PlotConfigurationError>();
        warnings.addAll(this.domainConfigManager.getWarnings());
        warnings.addAll(this.linkAndBrushMaster.getWarnings());
        for (DimensionConfig dimensionConfig : this.dimensionConfigMap.values()) {
            warnings.addAll(dimensionConfig.getWarnings());
            if (this.isDimensionUsed(dimensionConfig.getDimension())) continue;
            warnings.add(new PlotConfigurationError("dimension_config_not_used", dimensionConfig.getDimension().getName()));
        }
        boolean emptyAxis = false;
        for (RangeAxisConfig rangeAxisConfig : this.rangeAxisConfigs) {
            warnings.addAll(rangeAxisConfig.getWarnings());
            if (rangeAxisConfig.getSize() != 0) continue;
            emptyAxis = true;
        }
        if (emptyAxis) {
            warnings.add(new PlotConfigurationError("no_data_configuration_assigned", new Object[0]));
        }
        return warnings;
    }

    public boolean isDimensionUsed(DimensionConfig.PlotDimension dimension) {
        if (dimension != DimensionConfig.PlotDimension.DOMAIN) {
            DimensionConfig dimensionConfig = this.getDimensionConfig(dimension);
            if (dimensionConfig == null) {
                return false;
            }
            return dimensionConfig.isGrouping() || this.getDomainConfigManager().getGroupingState() != DomainConfigManager.GroupingState.GROUPED;
        }
        return true;
    }

    public boolean isValid() {
        return this.getErrors().isEmpty();
    }

    public double getMinShapeSize() {
        return 0.4;
    }

    public double getMaxShapeSize() {
        return 5.0;
    }

    public PlotConfiguration clone() {
        PlotConfiguration clone = new PlotConfiguration(this.domainConfigManager.clone(), this.legendConfiguration.clone());
        clone.cloned_debug = true;
        this.debug(" Started CLONING");
        clone.initializing = true;
        clone.domainConfigManager.setPlotConfiguration(clone);
        clone.axesFont = this.axesFont;
        clone.changingGrouping = this.changingGrouping;
        clone.changingRange = this.changingRange;
        clone.frameBackgroundColor = this.frameBackgroundColor;
        clone.colorSchemes = new HashMap<String, ColorScheme>();
        for (String string : this.colorSchemes.keySet()) {
            clone.colorSchemes.put(string, this.colorSchemes.get(string).clone());
        }
        clone.activeSchemeName = this.activeSchemeName;
        clone.axisLineColor = this.axisLineColor;
        clone.axisLineWidth = this.axisLineWidth;
        clone.orientation = this.orientation;
        clone.plotBackgroundColor = this.plotBackgroundColor;
        clone.titleFont = this.titleFont;
        clone.titleText = this.titleText;
        clone.titleColor = this.titleColor;
        clone.idCounter = this.idCounter;
        for (Map.Entry entry : this.dimensionConfigMap.entrySet()) {
            clone.setDimensionConfig((DimensionConfig.PlotDimension)((Object)entry.getKey()), ((DefaultDimensionConfig)entry.getValue()).clone());
        }
        for (RangeAxisConfig rangeAxisConfig : this.getRangeAxisConfigs()) {
            clone.addRangeAxisConfig(rangeAxisConfig.clone());
        }
        for (ValueSource valueSource : clone.getAllValueSources()) {
            valueSource.setDomainConfigManager(clone.getDomainConfigManager());
        }
        clone.linkAndBrushMaster = this.linkAndBrushMaster.clone(clone);
        clone.initializing = false;
        this.debug(" CLONING done");
        return clone;
    }

    public ColorScheme getDefaultColorScheme() {
        LinkedList<ColorRGB> listOfColors = new LinkedList<ColorRGB>();
        Color minColor = this.getColorFromProperty("rapidminer.gui.plotter.legend.mincolor", Color.BLUE);
        ColorRGB minColorRGB = ColorRGB.convertColorToColorRGB(minColor);
        listOfColors.add(minColorRGB);
        Color maxColor = this.getColorFromProperty("rapidminer.gui.plotter.legend.maxcolor", Color.RED);
        ColorRGB maxColorRGB = ColorRGB.convertColorToColorRGB(maxColor);
        listOfColors.add(maxColorRGB);
        Color third = ContinuousColorProvider.getColorForValue(3.0, 255, false, 0.0, 4.0, minColor, maxColor);
        listOfColors.add(ColorRGB.convertColorToColorRGB(third));
        Color second = ContinuousColorProvider.getColorForValue(2.0, 255, false, 0.0, 5.0, minColor, maxColor);
        listOfColors.add(ColorRGB.convertColorToColorRGB(second));
        Color first = ContinuousColorProvider.getColorForValue(1.0, 255, false, 0.0, 5.0, minColor, maxColor);
        listOfColors.add(ColorRGB.convertColorToColorRGB(first));
        return new ColorScheme(I18N.getGUILabel((String)"plotter.default_color_scheme_name.label", (Object[])new Object[0]), listOfColors, minColorRGB, maxColorRGB);
    }

    public void setColorSchemes(Map<String, ColorScheme> colorSchemes, String activeColorSchemeName) {
        boolean changed = false;
        ColorScheme oldActiveScheme = this.getActiveColorScheme();
        if (!colorSchemes.equals(this.colorSchemes)) {
            this.colorSchemes = colorSchemes;
            changed = true;
        }
        if (!oldActiveScheme.equals(colorSchemes.get(activeColorSchemeName))) {
            this.setActiveScheme(activeColorSchemeName);
            changed = true;
        }
        if (changed) {
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, this.getActiveColorScheme()));
        }
    }

    public Map<String, ColorScheme> getColorSchemes() {
        return this.colorSchemes;
    }

    private void setActiveScheme(String name) {
        this.activeSchemeName = name;
        ColorScheme colorScheme = this.colorSchemes.get(name);
        if (colorScheme == null) {
            this.colorSchemes.put(name, this.getDefaultColorScheme());
        }
        boolean processEvents = this.isProcessingEvents();
        this.setProcessEvents(false);
        for (DimensionConfig.PlotDimension dimension : DimensionConfig.PlotDimension.values()) {
            DimensionConfig dimConf = this.getDimensionConfig(dimension);
            if (dimConf == null) continue;
            dimConf.colorSchemeChanged();
        }
        this.setProcessEvents(processEvents);
    }

    public void setActiveColorScheme(String name) {
        if (!this.activeSchemeName.equals(name)) {
            this.setActiveScheme(name);
            this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, this.getActiveColorScheme()));
        }
    }

    public ColorScheme getActiveColorScheme() {
        ColorScheme activeColorScheme = this.colorSchemes.get(this.activeSchemeName);
        if (activeColorScheme == null) {
            return this.getDefaultColorScheme();
        }
        return activeColorScheme;
    }

    public PlotConfigurationChangeEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public void addColorScheme(ColorScheme colorScheme) {
        this.colorSchemes.put(colorScheme.getName(), colorScheme);
    }

    public void addColorSchemeAndSetActive(ColorScheme colorScheme) {
        this.addColorScheme(colorScheme);
        this.setActiveScheme(colorScheme.getName());
        this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, this.getActiveColorScheme()));
    }

    public void removeColorScheme(String name) {
        this.colorSchemes.remove(name);
    }

    public LinkAndBrushMaster getLinkAndBrushMaster() {
        return this.linkAndBrushMaster;
    }

    public boolean isGroupingRequiredForNewValueSource(RangeAxisConfig rangeAxis) {
        List<ValueSource> valueSources = rangeAxis.getValueSources();
        for (ValueSource source : valueSources) {
            if (!source.isUsingDomainGrouping() || !this.getDomainConfigManager().isNominal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void selectedLinkAndBrushRectangle(LinkAndBrushSelection e) {
        this.linkAndBrushMaster.selectedLinkAndBrushRectangle(e);
    }

    public static int getMaxAllowedValueCount() {
        String parameterValue = ParameterService.getParameterValue((String)"rapidminer.gui.plotter.rows.maximum");
        if (parameterValue != null) {
            return Integer.parseInt(parameterValue);
        }
        return 5000;
    }

    @Override
    public void legendConfigurationChanged(LegendConfigurationChangeEvent change) {
        this.fireLegendChanged(change);
    }

    public LegendConfiguration getLegendConfiguration() {
        return this.legendConfiguration;
    }

    public void resetToDefaults() {
        boolean processing = this.isProcessingEvents();
        while (!this.getRangeAxisConfigs().isEmpty()) {
            this.removeRangeAxisConfig(0);
        }
        while (!this.getDefaultDimensionConfigs().isEmpty()) {
            this.setDimensionConfig(this.getDefaultDimensionConfigs().keySet().iterator().next(), null);
        }
        this.domainConfigManager.resetToDefaults();
        this.setAxesFont(DEFAULT_AXES_FONT);
        this.setFrameBackgroundColor(DEFAULT_FRAME_BACKGROUND_COLOR);
        this.setPlotBackgroundColor(DEFAULT_PLOT_BACKGROUND_COLOR);
        this.setOrientation(DEFAULT_PLOT_ORIENTATION);
        this.setTitleText(DEFAULT_TITLE_TEXT);
        this.setAxisLineWidth(1.0f);
        this.setAxisLineColor(DEFAULT_AXIS_COLOR);
        this.legendConfiguration.resetToDefaults();
        this.addRangeAxisConfig(new RangeAxisConfig(null, this));
        this.setProcessEvents(processing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlotConfigurationProcessingListener(PlotConfigurationProcessingListener l) {
        List<WeakReference<PlotConfigurationProcessingListener>> list = this.processingListeners;
        synchronized (list) {
            this.processingListeners.add(new WeakReference<PlotConfigurationProcessingListener>(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlotConfigurationProcessingListener(PlotConfigurationProcessingListener l) {
        List<WeakReference<PlotConfigurationProcessingListener>> list = this.processingListeners;
        synchronized (list) {
            Iterator<WeakReference<PlotConfigurationProcessingListener>> it = this.processingListeners.iterator();
            while (it.hasNext()) {
                WeakReference<PlotConfigurationProcessingListener> listenerRef = it.next();
                if (!l.equals(listenerRef.get())) continue;
                it.remove();
            }
        }
    }

    public RangeAxisConfig getRangeAxisConfigById(int id) {
        for (RangeAxisConfig rangeAxisConfig : this.getRangeAxisConfigs()) {
            if (rangeAxisConfig.getId() != id) continue;
            return rangeAxisConfig;
        }
        return null;
    }

    public int getIndexOfRangeAxisConfigById(int id) {
        int idx = 0;
        for (RangeAxisConfig rangeAxisConfig : this.getRangeAxisConfigs()) {
            if (rangeAxisConfig.getId() == id) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public DefaultDimensionConfig getDefaultDimensionConfigById(int dimensionConfigId) {
        if (this.domainConfigManager.getDomainConfig(true).getId() == dimensionConfigId) {
            return this.domainConfigManager.getDomainConfig(true);
        }
        if (this.domainConfigManager.getDomainConfig(false).getId() == dimensionConfigId) {
            return this.domainConfigManager.getDomainConfig(false);
        }
        for (DefaultDimensionConfig dimensionConfig : this.getDefaultDimensionConfigs().values()) {
            if (dimensionConfig.getId() != dimensionConfigId) continue;
            return dimensionConfig;
        }
        return null;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
        this.fireTitleChanged();
    }

    public void triggerReplot() {
        this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this));
    }

    @Override
    public void linkAndBrushUpdate(LinkAndBrushSelection e) {
        this.firePlotConfigurationChanged(new PlotConfigurationChangeEvent(this, e));
    }
}

