/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.ChartConfigurationException;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DistinctValueGrouping;
import com.owc.gui.charting.configuration.EqualDataFractionGrouping;
import com.owc.gui.charting.configuration.EquidistantFixedBinCountBinning;
import com.owc.gui.charting.listener.ValueGroupingListener;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.tools.I18N;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.List;

public interface ValueGrouping
extends Serializable {
    public List<ValueRange> getGroupingModel(DataTable var1, double var2, double var4);

    public boolean isCategorical();

    public GroupingType getGroupingType();

    public void addListener(ValueGroupingListener var1);

    public void removeListener(ValueGroupingListener var1);

    public ValueGrouping clone();

    public DataTableColumn.ValueType getDomainType();

    public boolean definesUpperLowerBounds();

    public DateFormat getDateFormat();

    public void setDateFormat(DateFormat var1);

    public boolean equals(Object var1);

    public static enum GroupingType {
        NONE(I18N.getGUILabel((String)"plotter.grouping_type.NONE.label", (Object[])new Object[0])),
        EQUIDISTANT_FIXED_BIN_COUNT(I18N.getGUILabel((String)"plotter.grouping_type.EQUIDISTANT_FIXED_BIN_COUNT.label", (Object[])new Object[0])),
        DISTINCT_VALUES(I18N.getGUILabel((String)"plotter.grouping_type.DISTINCT_VALUES.label", (Object[])new Object[0])),
        EQUAL_DATA_FRACTION(I18N.getGUILabel((String)"plotter.grouping_type.EQUAL_DATA_FRACTION.label", (Object[])new Object[0]));

        private final String name;

        private GroupingType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ValueGroupingFactory {
        private static final int binCount = 5;

        public static ValueGrouping getValueGrouping(GroupingType type, DataTableColumn dataTableColumn, boolean categorical, DateFormat dateFormat) throws ChartConfigurationException {
            switch (type) {
                case DISTINCT_VALUES: {
                    return new DistinctValueGrouping(dataTableColumn, categorical, dateFormat);
                }
                case EQUAL_DATA_FRACTION: {
                    return new EqualDataFractionGrouping(dataTableColumn, 5, categorical, dateFormat);
                }
                case EQUIDISTANT_FIXED_BIN_COUNT: {
                    return new EquidistantFixedBinCountBinning(5, Double.NaN, Double.NaN, dataTableColumn, categorical, dateFormat);
                }
                case NONE: {
                    return null;
                }
            }
            throw new RuntimeException("This cannot happen");
        }
    }
}

