/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.data;

import com.owc.gui.charting.ConfigurationChangeResponse;
import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.PlotConfigurationQuickFix;
import com.owc.gui.charting.StaticDebug;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.data.DataTableColumnIndex;
import com.owc.gui.charting.data.PlotData;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.listener.events.DimensionConfigChangeEvent;
import com.owc.gui.charting.utility.CategoricalColorProvider;
import com.owc.gui.charting.utility.CategoricalSizeProvider;
import com.owc.gui.charting.utility.ColorProvider;
import com.owc.gui.charting.utility.ContinuousColorProvider;
import com.owc.gui.charting.utility.ContinuousSizeProvider;
import com.owc.gui.charting.utility.NumericalValueRange;
import com.owc.gui.charting.utility.ShapeProvider;
import com.owc.gui.charting.utility.SizeProvider;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.datatable.SortedDataTableView;
import com.rapidminer.datatable.ValueMappingDataTableView;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public class DimensionConfigData {
    private PlotInstance plotInstance;
    private SizeProvider sizeProvider = null;
    private ColorProvider colorProvider = null;
    private ShapeProvider shapeProvider = null;
    private transient double cachedMinValue = Double.NaN;
    private transient double cachedMaxValue = Double.NaN;
    private transient double cachedMinGroupValue = Double.NaN;
    private transient double cachedMaxGroupValue = Double.NaN;
    private transient List<ValueRange> cachedValueGroups = null;
    private transient List<Double> cachedValues = null;
    private transient List<Double> cachedDistinctValues = null;
    private DataTableColumnIndex columnIdx;
    private DimensionConfigChangeEvent lastProcessedEvent = null;
    private int dimensionConfigId;

    public DimensionConfigData(PlotInstance plotInstance, DefaultDimensionConfig dimensionConfig) {
        this.dimensionConfigId = dimensionConfig.getId();
        this.plotInstance = plotInstance;
        SortedDataTableView dataTable = plotInstance.getPlotData().getSortedDataTableWithoutImplicitUpdate();
        this.columnIdx = new DataTableColumnIndex(this.getDimensionConfig().getDataTableColumn(), (DataTable)dataTable);
    }

    public List<Double> getValues() {
        if (this.cachedValues == null) {
            this.updateValueCache();
        }
        return this.cachedValues;
    }

    protected void updateShapeProvider() {
        if (this.getDimensionConfig().isNominal()) {
            LinkedList<Double> categoryList = new LinkedList();
            if (this.getDimensionConfig().isGrouping()) {
                for (ValueRange valueGroup : this.getGroupingModel()) {
                    categoryList.add(valueGroup.getValue());
                }
            } else {
                categoryList = this.getDistinctValues();
            }
            this.setShapeProvider(new ShapeProvider(categoryList));
        } else {
            this.setShapeProvider(null);
        }
    }

    private void setShapeProvider(ShapeProvider shapeProvider) {
        if (this.shapeProvider != shapeProvider) {
            this.shapeProvider = shapeProvider;
        }
    }

    public String getStringForValue(double value) {
        if (this.getDimensionConfig().isNominal()) {
            if (this.getDimensionConfig().isGrouping()) {
                List<ValueRange> groupingModel = this.getGroupingModel();
                for (ValueRange range : groupingModel) {
                    if (range.getValue() != value && (!Double.isNaN(range.getValue()) || !Double.isNaN(value))) continue;
                    return range.toString();
                }
                return null;
            }
            ValueMappingDataTableView dataTable = this.plotInstance.getPlotData().getValueMappingDataTable();
            int columnIdx = DataTableColumn.getColumnIndex((DataTable)dataTable, this.getDimensionConfig().getDataTableColumn());
            String valueString = Double.isNaN(value) ? I18N.getGUILabel((String)"plotter.unknown_value_label", (Object[])new Object[0]) : dataTable.mapIndex(columnIdx, (int)value);
            return valueString;
        }
        return null;
    }

    private void invalidateFormatProviders() {
        this.colorProvider = null;
        this.shapeProvider = null;
        this.sizeProvider = null;
    }

    private void updateGroupingModel() {
        DefaultDimensionConfig dimensionConfig = this.getDimensionConfig();
        double upperBound = Double.POSITIVE_INFINITY;
        double lowerBound = Double.NEGATIVE_INFINITY;
        if (dimensionConfig.isUsingUserDefinedUpperBound()) {
            upperBound = dimensionConfig.getUserDefinedUpperBound();
        }
        if (dimensionConfig.isUsingUserDefinedLowerBound()) {
            lowerBound = dimensionConfig.getUserDefinedLowerBound();
        }
        this.cachedValueGroups = dimensionConfig.getGrouping().getGroupingModel((DataTable)this.plotInstance.getPlotData().getDataTable(), upperBound, lowerBound);
        int maxAllowedValueCount = PlotConfiguration.getMaxAllowedValueCount();
        if (this.cachedValueGroups.size() > maxAllowedValueCount) {
            ConfigurationChangeResponse response = new ConfigurationChangeResponse();
            response.addError(new PlotConfigurationError("too_many_values_in_plot", dimensionConfig.getDimension().getName()));
            this.plotInstance.getMasterOfDesaster().registerConfigurationChangeResponse(response);
            this.cachedValueGroups = new LinkedList<ValueRange>();
            this.cachedMinGroupValue = 0.0;
            this.cachedMaxGroupValue = 1.0;
            return;
        }
        this.cachedMinGroupValue = Double.POSITIVE_INFINITY;
        this.cachedMaxGroupValue = Double.NEGATIVE_INFINITY;
        for (ValueRange group : this.cachedValueGroups) {
            double value = group.getValue();
            if (value < this.cachedMinGroupValue) {
                this.cachedMinGroupValue = value;
            }
            if (!(value > this.cachedMaxGroupValue)) continue;
            this.cachedMaxGroupValue = value;
        }
    }

    public List<ValueRange> getGroupingModel() {
        if (this.getDimensionConfig().isGrouping()) {
            if (this.cachedValueGroups == null) {
                this.updateGroupingModel();
            }
            return this.cachedValueGroups;
        }
        return null;
    }

    public ColorProvider getColorProvider() {
        if (this.colorProvider == null) {
            this.updateColorProvider();
        }
        return this.colorProvider;
    }

    public SizeProvider getSizeProvider() {
        if (this.sizeProvider == null) {
            this.updateSizeProvider();
        }
        return this.sizeProvider;
    }

    private void setColorProvider(ColorProvider colorProvider) {
        this.colorProvider = colorProvider;
    }

    public List<Double> getDistinctValues() {
        if (this.cachedDistinctValues == null) {
            this.cachedDistinctValues = new LinkedList<Double>();
            if (this.getDimensionConfig().isGrouping()) {
                List<ValueRange> valueRanges = this.getGroupingModel();
                for (ValueRange range : valueRanges) {
                    if (range != null) {
                        this.cachedDistinctValues.add(range.getValue());
                        continue;
                    }
                    this.cachedDistinctValues.add(Double.NaN);
                }
            } else {
                HashSet<Double> distinctValuesSet = new HashSet<Double>();
                for (Double value : this.getValues()) {
                    if (!distinctValuesSet.add(value)) continue;
                    this.cachedDistinctValues.add(value);
                }
            }
            Collections.sort(this.cachedDistinctValues);
        }
        return this.cachedDistinctValues;
    }

    public ShapeProvider getShapeProvider() {
        if (this.shapeProvider == null) {
            this.updateShapeProvider();
        }
        return this.shapeProvider;
    }

    public void clearCache() {
        this.cachedValues = null;
        this.cachedValueGroups = null;
        this.cachedDistinctValues = null;
        this.cachedMinValue = Double.NaN;
        this.cachedMaxValue = Double.NaN;
        this.cachedMinGroupValue = Double.NaN;
        this.cachedMaxGroupValue = Double.NaN;
        this.columnIdx.invalidate();
        this.invalidateFormatProviders();
    }

    protected void updateValueCache() {
        SortedDataTableView dataTable = this.plotInstance.getPlotData().getDataTable();
        this.cachedValues = new LinkedList<Double>();
        if (this.columnIdx.getIndex() == -1) {
            this.cachedMinValue = Double.NaN;
            this.cachedMaxValue = Double.NaN;
            return;
        }
        this.cachedMinValue = Double.POSITIVE_INFINITY;
        this.cachedMaxValue = Double.NEGATIVE_INFINITY;
        boolean useUserDefinedRange = this.getDimensionConfig().isUsingUserDefinedLowerBound() || this.getDimensionConfig().isUsingUserDefinedUpperBound();
        Object userDefinedRange = null;
        if (useUserDefinedRange && (userDefinedRange = this.getDimensionConfig().getUserDefinedRangeClone((DataTable)dataTable)) instanceof NumericalValueRange) {
            NumericalValueRange numericalUserDefinedRange = (NumericalValueRange)userDefinedRange;
            if (!this.getDimensionConfig().isUsingUserDefinedLowerBound()) {
                numericalUserDefinedRange.setLowerBound(Double.NEGATIVE_INFINITY);
            }
            if (!this.getDimensionConfig().isUsingUserDefinedUpperBound()) {
                numericalUserDefinedRange.setUpperBound(Double.POSITIVE_INFINITY);
            }
            userDefinedRange = numericalUserDefinedRange;
        }
        for (DataTableRow row : dataTable) {
            if (useUserDefinedRange && !userDefinedRange.keepRow(row)) continue;
            Double value = row.getValue(this.columnIdx.getIndex());
            this.cachedValues.add(value);
            if (Double.isInfinite(value) || Double.isNaN(value)) continue;
            if (this.cachedMinValue > value) {
                this.cachedMinValue = value;
            }
            if (!(this.cachedMaxValue < value)) continue;
            this.cachedMaxValue = value;
        }
        if (this.cachedMaxValue < this.cachedMinValue) {
            boolean maxInfinite = Double.isInfinite(this.cachedMaxValue);
            boolean minInfinite = Double.isInfinite(this.cachedMinValue);
            if (maxInfinite || minInfinite) {
                if (maxInfinite) {
                    this.cachedMaxValue = Double.POSITIVE_INFINITY;
                }
                if (minInfinite) {
                    this.cachedMinValue = Double.NEGATIVE_INFINITY;
                }
            } else {
                this.cachedMaxValue = this.cachedMinValue + 1.0;
            }
        }
    }

    public NumericalValueRange getEffectiveRange() {
        if (this.getDimensionConfig().isNominal()) {
            return null;
        }
        if (!this.getDimensionConfig().isUsingUserDefinedLowerBound() || !this.getDimensionConfig().isUsingUserDefinedUpperBound()) {
            if (Double.isNaN(this.cachedMaxValue)) {
                this.updateValueCache();
                this.debug((Object)((Object)this.getDimensionConfig().getDimension()) + " min: " + this.cachedMinValue);
                this.debug((Object)((Object)this.getDimensionConfig().getDimension()) + " max: " + this.cachedMaxValue);
            }
            double effectiveMin = this.cachedMinValue;
            double effectiveMax = this.cachedMaxValue;
            if (!this.getDimensionConfig().isUsingUserDefinedLowerBound() && !this.getDimensionConfig().isUsingUserDefinedUpperBound()) {
                return new NumericalValueRange(effectiveMin, effectiveMax, this.columnIdx.getIndex(), true, true);
            }
            if (this.getDimensionConfig().isUsingUserDefinedLowerBound()) {
                effectiveMin = this.getDimensionConfig().getUserDefinedLowerBound();
                if (effectiveMin > effectiveMax) {
                    effectiveMax = effectiveMin + 1.0;
                }
                return new NumericalValueRange(effectiveMin, effectiveMax, this.columnIdx.getIndex(), true, true);
            }
            effectiveMax = this.getDimensionConfig().getUserDefinedUpperBound();
            if (effectiveMin > effectiveMax) {
                effectiveMin = effectiveMax - 1.0;
            }
            return new NumericalValueRange(effectiveMin, effectiveMax, this.columnIdx.getIndex(), true, true);
        }
        return (NumericalValueRange)this.getDimensionConfig().getUserDefinedRangeClone(this.plotInstance.getPlotData().getOriginalDataTable());
    }

    protected void updateColorProvider() {
        if (this.getDimensionConfig().isNominal()) {
            List<Double> categoryList = this.getDistinctValues();
            this.setColorProvider(new CategoricalColorProvider(this.plotInstance, categoryList, 255));
        } else {
            this.setColorProvider(new ContinuousColorProvider(this.plotInstance, this.getMinValue(), this.getMaxValue(), 255, this.getDimensionConfig().isLogarithmic()));
        }
    }

    protected void updateSizeProvider() {
        PlotConfiguration plotConfiguration = this.plotInstance.getCurrentPlotConfigurationClone();
        if (this.getDimensionConfig().isNominal()) {
            List<Double> categoryList = this.getDistinctValues();
            this.setSizeProvider(new CategoricalSizeProvider(categoryList, plotConfiguration.getMinShapeSize(), plotConfiguration.getMaxShapeSize()));
        } else {
            double minValue = this.getMinValue();
            double maxValue = this.getMaxValue();
            this.setSizeProvider(new ContinuousSizeProvider(minValue, maxValue, plotConfiguration.getMinShapeSize(), plotConfiguration.getMaxShapeSize(), this.getDimensionConfig().isLogarithmic()));
        }
    }

    private void setSizeProvider(SizeProvider sizeProvider) {
        this.sizeProvider = sizeProvider;
    }

    public double getMinValue() {
        if (this.getDimensionConfig().isGrouping()) {
            if (Double.isNaN(this.cachedMinGroupValue)) {
                this.updateGroupingModel();
            }
            return this.cachedMinGroupValue;
        }
        if (Double.isNaN(this.cachedMinValue)) {
            this.updateValueCache();
        }
        return this.getEffectiveRange().getLowerBound();
    }

    public double getMaxValue() {
        if (this.getDimensionConfig().isGrouping()) {
            if (Double.isNaN(this.cachedMaxGroupValue)) {
                this.updateGroupingModel();
            }
            return this.cachedMaxGroupValue;
        }
        if (Double.isNaN(this.cachedMaxValue)) {
            this.updateValueCache();
        }
        return this.getEffectiveRange().getUpperBound();
    }

    public int getValueCount() {
        if (this.getDimensionConfig().isGrouping()) {
            return this.getGroupingModel().size();
        }
        return this.getValues().size();
    }

    public boolean hasDuplicateValues() {
        int distinctValueCount = this.getDistinctValues().size();
        return distinctValueCount < this.getValueCount();
    }

    public boolean isLogarithmicPossible() {
        if (this.getMinValue() < 0.0) {
            return false;
        }
        return !this.getDimensionConfig().isNominal();
    }

    public int getDistinctValueCount() {
        return this.getDistinctValues().size();
    }

    public void dimensionConfigChanged(DimensionConfigChangeEvent e) {
        if (e == null || e == this.lastProcessedEvent) {
            return;
        }
        this.lastProcessedEvent = e;
        DimensionConfig.PlotDimension dimension = e.getSource().getDimension();
        DimensionConfig dimConf = this.plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(dimension);
        if (dimConf == null) {
            this.debug("DimensionConfigData: ### ATTENTION #### DimensionConfig for dimension " + (Object)((Object)dimension) + " is null! Meta change event?");
            return;
        }
        switch (e.getType()) {
            case COLUMN: {
                this.columnIdx.setDataTableColumn(dimConf.getDataTableColumn());
            }
            case RESET: 
            case GROUPING_CHANGED: 
            case RANGE: 
            case SORTING: 
            case SCALING: {
                this.clearCache();
                this.invalidateFormatProviders();
                break;
            }
            case COLOR_SCHEME: {
                this.debug("Color scheme has changed. " + this + " invalidate format providers");
                this.invalidateFormatProviders();
                break;
            }
        }
    }

    private void debug(String string) {
        StaticDebug.debug("DimensionConfigData: " + (Object)((Object)this.getDimensionConfig().getDimension()) + " " + string);
    }

    public List<PlotConfigurationError> getErrors() {
        ShapeProvider shapeProvider;
        LinkedList<PlotConfigurationError> errorList = new LinkedList<PlotConfigurationError>();
        if (this.cachedValueGroups != null) {
            this.plotInstance.getCurrentPlotConfigurationClone();
            if (this.cachedValueGroups.size() > PlotConfiguration.getMaxAllowedValueCount()) {
                errorList.add(new PlotConfigurationError("too_many_values_in_plot", this.getDimensionConfig().getDimension().getName()));
            }
        }
        if (this.getDimensionConfig().getDimension() == DimensionConfig.PlotDimension.SHAPE && (shapeProvider = this.getShapeProvider()) != null && shapeProvider.maxCategoryCount() < this.getDistinctValues().size()) {
            PlotConfigurationError error = new PlotConfigurationError("too_many_values_in_dimension", DimensionConfig.PlotDimension.SHAPE.getName(), this.getDistinctValues().size(), shapeProvider.maxCategoryCount());
            errorList.add(error);
        }
        if (!this.getDimensionConfig().isNominal() && this.getDimensionConfig().isLogarithmic() && this.getMinValue() <= 0.0) {
            PlotConfigurationError error = new PlotConfigurationError("log_axis_contains_zero", this.getDimensionConfig().getDimension().getName());
            PlotConfigurationQuickFix quickFix = new PlotConfigurationQuickFix(new DimensionConfigChangeEvent(this.getDimensionConfig(), this.getDimensionConfig().getDimension(), false, DimensionConfigChangeEvent.DimensionConfigChangeType.SCALING));
            error.addQuickFix(quickFix);
            errorList.add(error);
        }
        return errorList;
    }

    public List<PlotConfigurationError> getWarnings() {
        LinkedList<PlotConfigurationError> warnings = new LinkedList<PlotConfigurationError>();
        if (this.getDimensionConfig() != null) {
            if (this.getDimensionConfig().getDimension() == DimensionConfig.PlotDimension.COLOR && this.getDimensionConfig().getValueType() == DataTableColumn.ValueType.NOMINAL) {
                ColorProvider colorProvider = this.getColorProvider();
                int categoryCount = this.getDistinctValueCount();
                int colorListSize = this.plotInstance.getCurrentPlotConfigurationClone().getActiveColorScheme().getColors().size();
                if (colorProvider != null && colorListSize < categoryCount) {
                    PlotConfigurationError warning = new PlotConfigurationError("darken_category_colors", categoryCount, colorListSize);
                    warnings.add(warning);
                }
            }
            PlotData plotData = this.plotInstance.getPlotData();
            if ((this.getDimensionConfig().isUsingUserDefinedLowerBound() || this.getDimensionConfig().isUsingUserDefinedUpperBound()) && plotData.isDataTableValid() && plotData.getDataTable().getRowNumber() == 0) {
                warnings.add(new PlotConfigurationError("user_range_includes_no_data", this.getDimensionConfig().getDimension().getName()));
            }
        } else {
            LogService.getRoot().log(Level.WARNING, "com.owc.gui.charting.data.DimensionConfigData.null_dimension_config");
        }
        return warnings;
    }

    public int getColumnIdx() {
        this.dimensionConfigChanged(this.lastProcessedEvent);
        return this.columnIdx.getIndex();
    }

    public String toString() {
        return "DimensionConfigData for " + this.getDimensionConfig().toString();
    }

    public void setDataTable(DataTable dataTable) {
        this.columnIdx.setDataTable(dataTable);
    }

    public DefaultDimensionConfig getDimensionConfig() {
        return this.plotInstance.getCurrentPlotConfigurationClone().getDefaultDimensionConfigById(this.dimensionConfigId);
    }
}

