/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.data;

import com.owc.gui.charting.MasterOfDesaster;
import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.data.PlotData;
import com.owc.gui.charting.listener.PlotConfigurationListener;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.rapidminer.datatable.DataTable;
import java.util.LinkedList;
import java.util.List;

public class PlotInstance
implements PlotConfigurationListener {
    private PlotConfiguration masterPlotConfiguration;
    private PlotData plotData;
    private MasterOfDesaster masterOfDesaster = new MasterOfDesaster();
    private PlotConfiguration currentPlotConfigurationClone;

    public PlotInstance(PlotConfiguration plotConfiguration, DataTable dataTable) {
        this.masterPlotConfiguration = plotConfiguration;
        this.masterPlotConfiguration.addPlotConfigurationListener(this, true);
        this.currentPlotConfigurationClone = plotConfiguration.clone();
        this.plotData = new PlotData(this, dataTable);
    }

    public PlotConfiguration getCurrentPlotConfigurationClone() {
        return this.currentPlotConfigurationClone;
    }

    public PlotConfiguration getMasterPlotConfiguration() {
        return this.masterPlotConfiguration;
    }

    public PlotData getPlotData() {
        return this.plotData;
    }

    public void setPlotData(PlotData plotData) {
        this.plotData = plotData;
    }

    public MasterOfDesaster getMasterOfDesaster() {
        return this.masterOfDesaster;
    }

    public List<PlotConfigurationError> getErrors() {
        LinkedList<PlotConfigurationError> errorList = new LinkedList<PlotConfigurationError>();
        errorList.addAll(this.currentPlotConfigurationClone.getErrors());
        errorList.addAll(this.plotData.getErrors());
        return errorList;
    }

    public List<PlotConfigurationError> getWarnings() {
        LinkedList<PlotConfigurationError> warnings = new LinkedList<PlotConfigurationError>();
        warnings.addAll(this.currentPlotConfigurationClone.getWarnings());
        warnings.addAll(this.plotData.getWarnings());
        return warnings;
    }

    public boolean isValid() {
        return this.currentPlotConfigurationClone.isValid() && this.plotData.isValid();
    }

    public boolean hasWarnings() {
        return this.currentPlotConfigurationClone.getWarnings().size() > 0 || this.plotData.getWarnings().size() > 0;
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        this.currentPlotConfigurationClone = change.getSource();
        return true;
    }

    public void triggerReplot() {
        this.masterPlotConfiguration.triggerReplot();
    }

    public void setPlotConfiguration(PlotConfiguration configuration) {
        this.masterPlotConfiguration = configuration;
        this.masterPlotConfiguration.addPlotConfigurationListener(this, true);
        this.currentPlotConfigurationClone = configuration.clone();
        this.triggerReplot();
    }
}

