/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.data;

import com.owc.gui.charting.ConfigurationChangeResponse;
import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.StaticDebug;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.GroupCellKey;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.DimensionConfigData;
import com.owc.gui.charting.data.GroupCellData;
import com.owc.gui.charting.data.GroupCellKeyAndData;
import com.owc.gui.charting.data.GroupCellSeriesData;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.listener.events.ValueSourceChangeEvent;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableFilterCondition;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.datatable.FilteredDataTable;
import com.rapidminer.tools.container.Pair;
import com.rapidminer.tools.math.function.aggregation.AggregationFunction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ValueSourceData {
    private ValueSource valueSource;
    private GroupCellSeriesData cachedSeriesDataForAllGroupCells = null;
    private Map<GroupCellKey, DataTable> cachedGroupCellToDataTableMap = null;
    private double cachedMinValue = Double.NaN;
    private double cachedMaxValue = Double.NaN;
    private PlotInstance plotInstance;
    private Map<ValueSource.SeriesUsageType, Integer> dataTableColumnIdxMap = new HashMap<ValueSource.SeriesUsageType, Integer>();
    private ValueSourceChangeEvent lastProcessedEvent = null;
    private Set<Double> cachedDistinctValues = null;

    public ValueSourceData(ValueSource valueSource, PlotInstance plotInstance) {
        this.valueSource = valueSource;
        this.plotInstance = plotInstance;
        this.updateDataTableColumns();
    }

    public void clearCache() {
        this.invalidateGroupingCache();
    }

    public double getAggregatedValueForGroupCell(ValueSource.SeriesUsageType seriesUsage, GroupCellKey groups) {
        DataTable data = this.getDataTableForGroupCell(groups);
        if (data == null) {
            return Double.NaN;
        }
        double[] doubleArray = new double[data.getRowNumber()];
        int i = 0;
        int columnIdx = this.getDataTableColumnIdx(seriesUsage);
        for (DataTableRow d : data) {
            doubleArray[i] = d.getValue(columnIdx);
            ++i;
        }
        AggregationFunction aggregationFunction = this.valueSource.getAggregationFunction(seriesUsage);
        double calculate = aggregationFunction.calculate(doubleArray);
        if (Double.isInfinite(calculate)) {
            calculate = Double.NaN;
        }
        return calculate;
    }

    private int getDataTableColumnIdx(ValueSource.SeriesUsageType seriesUsageType) {
        Integer idx = this.dataTableColumnIdxMap.get((Object)seriesUsageType);
        if (idx != null) {
            return idx;
        }
        return -1;
    }

    public DataTable getDataTableForGroupCell(GroupCellKey groupCellKey) {
        if (this.cachedGroupCellToDataTableMap == null) {
            this.applyGrouping();
        }
        return this.cachedGroupCellToDataTableMap.get(groupCellKey);
    }

    public Set<GroupCellKey> getNonEmptyGroupCells() {
        if (this.cachedGroupCellToDataTableMap == null) {
            this.applyGrouping();
        }
        return this.cachedGroupCellToDataTableMap.keySet();
    }

    private void createGroupCellData(Vector<DimensionConfig.PlotDimension> dimensionList, int dimensionIdx, DataTable data, GroupCellKey groupCellKey) {
        block11: {
            List<ValueRange> allValueGroups;
            int nextIdx;
            DimensionConfig.PlotDimension dimension;
            block9: {
                block10: {
                    if (data == null) {
                        return;
                    }
                    dimension = null;
                    if (dimensionIdx < dimensionList.size()) {
                        dimension = dimensionList.get(dimensionIdx);
                    }
                    DefaultDimensionConfig dimensionConfig = dimension == DimensionConfig.PlotDimension.DOMAIN ? this.valueSource.getDomainConfig() : (DefaultDimensionConfig)this.plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(dimension);
                    DimensionConfigData dimensionConfigData = this.plotInstance.getPlotData().getDimensionConfigData(dimensionConfig);
                    if (!dimensionConfig.isValid() || dimensionConfigData.getColumnIdx() < 0) {
                        ConfigurationChangeResponse response = new ConfigurationChangeResponse();
                        response.addError(new PlotConfigurationError("undefined_dimension", dimensionConfig.getDimension().getName()));
                        this.plotInstance.getMasterOfDesaster().registerConfigurationChangeResponse(response);
                        return;
                    }
                    if (groupCellKey == null) {
                        groupCellKey = new GroupCellKey();
                    }
                    nextIdx = dimensionIdx + 1;
                    allValueGroups = null;
                    allValueGroups = dimensionConfigData.getGroupingModel();
                    if (allValueGroups != null) break block9;
                    if (dimensionIdx >= dimensionList.size() - 1) break block10;
                    this.createGroupCellData(dimensionList, nextIdx, data, groupCellKey);
                    break block11;
                }
                if (data == null) break block11;
                this.cachedGroupCellToDataTableMap.put((GroupCellKey)groupCellKey.clone(), data);
                break block11;
            }
            Vector<ValueRange> valueGroupsForFiltering = dimension == DimensionConfig.PlotDimension.DOMAIN ? new Vector<ValueRange>(this.valueSource.getAggregationWindowing().applyOnGrouping(allValueGroups)) : new Vector<ValueRange>(allValueGroups);
            int idx = 0;
            for (ValueRange group : allValueGroups) {
                groupCellKey.setRangeForDimension(dimension, group);
                FilteredDataTable dataFilteredToValueGroupRange = new FilteredDataTable(data);
                ValueRange condition = valueGroupsForFiltering.get(idx);
                if (condition != null) {
                    dataFilteredToValueGroupRange.addCondition((DataTableFilterCondition)condition);
                } else {
                    dataFilteredToValueGroupRange = null;
                }
                if (dimensionIdx < dimensionList.size() - 1) {
                    this.createGroupCellData(dimensionList, nextIdx, (DataTable)dataFilteredToValueGroupRange, groupCellKey);
                } else {
                    this.cachedGroupCellToDataTableMap.put((GroupCellKey)groupCellKey.clone(), (DataTable)dataFilteredToValueGroupRange);
                }
                ++idx;
            }
        }
    }

    private void applyGrouping() {
        this.cachedGroupCellToDataTableMap = new HashMap<GroupCellKey, DataTable>();
        Vector<DimensionConfig.PlotDimension> dimensionList = new Vector<DimensionConfig.PlotDimension>();
        dimensionList.addAll(this.plotInstance.getCurrentPlotConfigurationClone().getDefaultDimensionConfigs().keySet());
        dimensionList.add(DimensionConfig.PlotDimension.DOMAIN);
        this.createGroupCellData(dimensionList, 0, this.plotInstance.getPlotData().getDataTable(this.valueSource.isSamplingSuggested()), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupCellSeriesData getSeriesDataForAllGroupCells() {
        ValueSourceData valueSourceData = this;
        synchronized (valueSourceData) {
            if (this.cachedSeriesDataForAllGroupCells == null) {
                Vector<DimensionConfig.PlotDimension> dimensions = new Vector<DimensionConfig.PlotDimension>();
                for (Map.Entry<DimensionConfig.PlotDimension, DefaultDimensionConfig> dimensionEntry : this.plotInstance.getCurrentPlotConfigurationClone().getDefaultDimensionConfigs().entrySet()) {
                    DimensionConfig.PlotDimension d = dimensionEntry.getKey();
                    if (d == DimensionConfig.PlotDimension.DOMAIN || d == DimensionConfig.PlotDimension.VALUE) {
                        throw new RuntimeException("This should not happen!");
                    }
                    dimensions.add(d);
                }
                this.cachedSeriesDataForAllGroupCells = this.recursivelyGetSeriesDataForAllGroupCells(dimensions, 0, null, null);
            }
        }
        return this.cachedSeriesDataForAllGroupCells;
    }

    private GroupCellSeriesData recursivelyGetSeriesDataForAllGroupCells(Vector<DimensionConfig.PlotDimension> dimensions, int dimensionIdx, GroupCellKey groupCellKey, GroupCellSeriesData dataForAllGroupCells) {
        if (groupCellKey == null) {
            groupCellKey = new GroupCellKey();
        }
        if (dataForAllGroupCells == null) {
            dataForAllGroupCells = new GroupCellSeriesData();
        }
        if (dimensionIdx < dimensions.size()) {
            DimensionConfig.PlotDimension currentDimension = dimensions.get(dimensionIdx);
            DefaultDimensionConfig currentDimensionConfig = (DefaultDimensionConfig)this.plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(currentDimension);
            DimensionConfigData currentDimensionConfigData = this.plotInstance.getPlotData().getDimensionConfigData(currentDimensionConfig);
            int nextDimensionIdx = dimensionIdx + 1;
            List<ValueRange> allValueGroups = currentDimensionConfigData.getGroupingModel();
            if (allValueGroups == null) {
                this.recursivelyGetSeriesDataForAllGroupCells(dimensions, nextDimensionIdx, groupCellKey, dataForAllGroupCells);
            } else {
                for (ValueRange group : allValueGroups) {
                    groupCellKey.setRangeForDimension(currentDimension, group);
                    this.recursivelyGetSeriesDataForAllGroupCells(dimensions, nextDimensionIdx, groupCellKey, dataForAllGroupCells);
                }
            }
        } else {
            DefaultDimensionConfig xDimensionConfig = this.valueSource.getDomainConfig();
            DimensionConfigData xDimensionConfigData = this.plotInstance.getPlotData().getDimensionConfigData(xDimensionConfig);
            List<ValueRange> xValueGroups = xDimensionConfigData.getGroupingModel();
            if (xValueGroups == null) {
                groupCellKey.removeRangeForDimension(DimensionConfig.PlotDimension.DOMAIN);
                DataTable dataForCurrentCell = this.getDataTableForGroupCell(groupCellKey);
                if (dataForCurrentCell != null) {
                    int valueCountInCell = dataForCurrentCell.getRowNumber();
                    GroupCellData groupCellData = new GroupCellData();
                    Vector<DimensionConfig.PlotDimension> allDimensions = new Vector<DimensionConfig.PlotDimension>(dimensions.size() + 2);
                    allDimensions.addAll(dimensions);
                    allDimensions.add(DimensionConfig.PlotDimension.SELECTED);
                    allDimensions.add(DimensionConfig.PlotDimension.DOMAIN);
                    allDimensions.add(DimensionConfig.PlotDimension.VALUE);
                    for (ValueSource.SeriesUsageType usageType : this.valueSource.getDefinedUsageTypes()) {
                        groupCellData.initDataForUsageType(usageType, allDimensions, valueCountInCell);
                    }
                    DataTable dataTable = this.plotInstance.getPlotData().getDataTable(this.valueSource.isSamplingSuggested());
                    int currentRowIdx = 0;
                    for (DataTableRow row : dataForCurrentCell) {
                        for (ValueSource.SeriesUsageType usageType : this.valueSource.getDefinedUsageTypes()) {
                            Map<DimensionConfig.PlotDimension, double[]> dataForUsageType = groupCellData.getDataForUsageType(usageType);
                            for (DimensionConfig.PlotDimension dimension : dimensions) {
                                DimensionConfig dimensionConfig = this.plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(dimension);
                                int columnIdx = DataTableColumn.getColumnIndex(dataTable, dimensionConfig.getDataTableColumn());
                                dataForUsageType.get((Object)((Object)dimension))[currentRowIdx] = row.getValue(columnIdx);
                            }
                            double yValue = row.getValue(this.dataTableColumnIdxMap.get((Object)usageType).intValue());
                            double xValue = row.getValue(DataTableColumn.getColumnIndex(dataTable, this.valueSource.getDomainConfig().getDataTableColumn()));
                            dataForUsageType.get((Object)((Object)DimensionConfig.PlotDimension.SELECTED))[currentRowIdx] = 1.0;
                            dataForUsageType.get((Object)((Object)DimensionConfig.PlotDimension.VALUE))[currentRowIdx] = yValue;
                            dataForUsageType.get((Object)((Object)DimensionConfig.PlotDimension.DOMAIN))[currentRowIdx] = xValue;
                        }
                        ++currentRowIdx;
                    }
                    dataForAllGroupCells.addGroupCell(new GroupCellKeyAndData((GroupCellKey)groupCellKey.clone(), groupCellData));
                }
            } else {
                int valueCountInCell = xValueGroups.size();
                GroupCellData groupCellData = new GroupCellData();
                Vector<DimensionConfig.PlotDimension> allDimensions = new Vector<DimensionConfig.PlotDimension>(dimensions.size() + 2);
                allDimensions.addAll(dimensions);
                allDimensions.add(DimensionConfig.PlotDimension.SELECTED);
                allDimensions.add(DimensionConfig.PlotDimension.DOMAIN);
                allDimensions.add(DimensionConfig.PlotDimension.VALUE);
                for (ValueSource.SeriesUsageType usageType : this.valueSource.getDefinedUsageTypes()) {
                    groupCellData.initDataForUsageType(usageType, allDimensions, valueCountInCell);
                }
                for (ValueSource.SeriesUsageType usageType : this.valueSource.getDefinedUsageTypes()) {
                    int xGroupIdx = 0;
                    Map<DimensionConfig.PlotDimension, double[]> dataForUsageType = groupCellData.getDataForUsageType(usageType);
                    for (ValueRange group : xValueGroups) {
                        groupCellKey.setRangeForDimension(DimensionConfig.PlotDimension.DOMAIN, group);
                        for (DimensionConfig.PlotDimension dimension : dimensions) {
                            ValueRange valueRange = groupCellKey.getRangeForDimension(dimension);
                            double value = Double.NaN;
                            if (valueRange != null) {
                                value = valueRange.getValue();
                            }
                            dataForUsageType.get((Object)((Object)dimension))[xGroupIdx] = value;
                        }
                        dataForUsageType.get((Object)((Object)DimensionConfig.PlotDimension.SELECTED))[xGroupIdx] = 1.0;
                        double y = this.getAggregatedValueForGroupCell(usageType, groupCellKey);
                        dataForUsageType.get((Object)((Object)DimensionConfig.PlotDimension.DOMAIN))[xGroupIdx] = xDimensionConfig.getGrouping().isCategorical() ? group.getValue() : group.getValue();
                        dataForUsageType.get((Object)((Object)DimensionConfig.PlotDimension.VALUE))[xGroupIdx] = y;
                        ++xGroupIdx;
                    }
                }
                groupCellKey.removeRangeForDimension(DimensionConfig.PlotDimension.DOMAIN);
                dataForAllGroupCells.addGroupCell(new GroupCellKeyAndData((GroupCellKey)groupCellKey.clone(), groupCellData));
            }
        }
        return dataForAllGroupCells;
    }

    public int getSeriesCount() {
        if (this.getSeriesDataForAllGroupCells() != null) {
            return this.getSeriesDataForAllGroupCells().groupCellCount();
        }
        return 0;
    }

    public double[] getAbsoluteUtilityValues(GroupCellKeyAndData groupCellKeyAndData, boolean secondary) {
        GroupCellData groupCellData;
        Map<DimensionConfig.PlotDimension, double[]> absoluteUtilityData;
        SeriesFormat.IndicatorType errorIndicator = this.valueSource.getSeriesFormat().getUtilityUsage();
        if (errorIndicator == SeriesFormat.IndicatorType.DIFFERENCE && !secondary) {
            return null;
        }
        if (this.dataTableColumnIdxMap.get((Object)ValueSource.SeriesUsageType.INDICATOR_1) == null || errorIndicator == SeriesFormat.IndicatorType.NONE) {
            return null;
        }
        ValueSource.SeriesUsageType seriesUsage = ValueSource.SeriesUsageType.INDICATOR_1;
        if (!secondary && this.dataTableColumnIdxMap.get((Object)ValueSource.SeriesUsageType.INDICATOR_2) != null) {
            seriesUsage = ValueSource.SeriesUsageType.INDICATOR_2;
        }
        if ((absoluteUtilityData = (groupCellData = groupCellKeyAndData.getData()).getDataForUsageType(seriesUsage)) == null) {
            return null;
        }
        boolean relative = this.valueSource.isUsingRelativeIndicator();
        if (!relative) {
            return absoluteUtilityData.get((Object)DimensionConfig.PlotDimension.VALUE);
        }
        double[] relativeValues = new double[groupCellKeyAndData.getData().getSize()];
        double[] mainSeries = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES).get((Object)DimensionConfig.PlotDimension.VALUE);
        double[] utilitySeries = absoluteUtilityData.get((Object)DimensionConfig.PlotDimension.VALUE);
        for (int valueIdx = 0; valueIdx < mainSeries.length; ++valueIdx) {
            double value = secondary ? mainSeries[valueIdx] + utilitySeries[valueIdx] : mainSeries[valueIdx] - utilitySeries[valueIdx];
            relativeValues[valueIdx] = value;
        }
        return relativeValues;
    }

    public Pair<Double, Double> getMinAndMaxValue() {
        if (Double.isNaN(this.cachedMinValue) || Double.isNaN(this.cachedMaxValue)) {
            SeriesFormat.IndicatorType errorIndicator = this.valueSource.getSeriesFormat().getUtilityUsage();
            if (errorIndicator == SeriesFormat.IndicatorType.NONE) {
                Pair<Double, Double> minMaxPair = this.calculateMinMaxFast();
                this.cachedMinValue = (Double)minMaxPair.getFirst();
                this.cachedMaxValue = (Double)minMaxPair.getSecond();
                return minMaxPair;
            }
            boolean utility1Set = false;
            if (this.dataTableColumnIdxMap.get((Object)ValueSource.SeriesUsageType.INDICATOR_1) != null) {
                utility1Set = true;
            }
            if (utility1Set) {
                Pair<Double, Double> minMaxPair = this.calculateMinMaxWithUtilities();
                this.cachedMinValue = (Double)minMaxPair.getFirst();
                this.cachedMaxValue = (Double)minMaxPair.getSecond();
                return minMaxPair;
            }
            Pair<Double, Double> minMaxPair = this.calculateMinMaxFast();
            this.cachedMinValue = (Double)minMaxPair.getFirst();
            this.cachedMaxValue = (Double)minMaxPair.getSecond();
            return minMaxPair;
        }
        return new Pair((Object)this.cachedMinValue, (Object)this.cachedMaxValue);
    }

    private Pair<Double, Double> calculateMinMaxWithUtilities() {
        this.debug("ValueSourceData: calculateMinMaxWithUtilities");
        Pair<Double, Double> yMinMax = this.calculateMinMaxFast();
        double minValue = (Double)yMinMax.getFirst();
        double maxValue = (Double)yMinMax.getSecond();
        for (GroupCellKeyAndData groupCellKeyAndData : this.getSeriesDataForAllGroupCells()) {
            double[] lowerValues;
            int n;
            double[] upperValues = this.getAbsoluteUtilityValues(groupCellKeyAndData, true);
            if (upperValues != null) {
                double[] dArray = upperValues;
                int n2 = dArray.length;
                for (n = 0; n < n2; ++n) {
                    Double value = dArray[n];
                    if (value < minValue) {
                        minValue = value;
                    }
                    if (!(value > maxValue)) continue;
                    maxValue = value;
                }
            }
            if (this.valueSource.getSeriesFormat().getUtilityUsage() == SeriesFormat.IndicatorType.DIFFERENCE) continue;
            double[] dArray = lowerValues = this.getAbsoluteUtilityValues(groupCellKeyAndData, false);
            n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double value = dArray[i];
                if (value < minValue) {
                    minValue = value;
                }
                if (!(value > maxValue)) continue;
                maxValue = value;
            }
        }
        Pair minMaxValues = new Pair((Object)minValue, (Object)maxValue);
        this.debug("min: " + minMaxValues.getFirst());
        this.debug("max: " + minMaxValues.getSecond());
        return minMaxValues;
    }

    private Pair<Double, Double> calculateMinMaxFast() {
        this.debug("ValueSourceData: calculateMinMaxFast()");
        Pair minMaxValues = new Pair((Object)Double.POSITIVE_INFINITY, (Object)Double.NEGATIVE_INFINITY);
        GroupCellSeriesData dataForAllGroupCells = this.getSeriesDataForAllGroupCells();
        Set<Double> yValues = dataForAllGroupCells.getDistinctValues(ValueSource.SeriesUsageType.MAIN_SERIES, DimensionConfig.PlotDimension.VALUE);
        for (Double value : yValues) {
            if (value < (Double)minMaxValues.getFirst()) {
                minMaxValues.setFirst((Object)value);
            }
            if (!(value > (Double)minMaxValues.getSecond())) continue;
            minMaxValues.setSecond((Object)value);
        }
        if (yValues.isEmpty()) {
            minMaxValues.setFirst((Object)Double.NEGATIVE_INFINITY);
            minMaxValues.setSecond((Object)Double.POSITIVE_INFINITY);
        }
        this.debug("min: " + minMaxValues.getFirst());
        this.debug("max: " + minMaxValues.getSecond());
        return minMaxValues;
    }

    public double getMinValue() {
        if (Double.isNaN(this.cachedMinValue)) {
            this.getMinAndMaxValue();
        }
        return this.cachedMinValue;
    }

    public double getMaxValue() {
        if (Double.isNaN(this.cachedMaxValue)) {
            this.getMinAndMaxValue();
        }
        return this.cachedMaxValue;
    }

    private void invalidateMinMaxCache() {
        this.cachedMinValue = Double.NaN;
        this.cachedMaxValue = Double.NaN;
    }

    private void invalidateValueCache() {
        this.debug("ValueSourceData: invalidateValueCache()");
        this.cachedSeriesDataForAllGroupCells = null;
        this.cachedDistinctValues = null;
        this.invalidateMinMaxCache();
    }

    private void invalidateGroupingCache() {
        this.cachedGroupCellToDataTableMap = null;
        this.invalidateValueCache();
    }

    private void updateDataTableColumns() {
        this.dataTableColumnIdxMap.clear();
        for (ValueSource.SeriesUsageType seriesUsageType : this.valueSource.getDefinedUsageTypes()) {
            DataTableColumn dataTableColumn = this.valueSource.getDataTableColumn(seriesUsageType);
            int columnIdx = DataTableColumn.getColumnIndex(this.plotInstance.getPlotData().getOriginalDataTable(), dataTableColumn);
            this.dataTableColumnIdxMap.put(seriesUsageType, columnIdx);
        }
    }

    public String getStringForValue(ValueSource.SeriesUsageType seriesUsage, double y) {
        if (this.valueSource.isNominal()) {
            return this.plotInstance.getPlotData().getValueMappingDataTable().mapIndex(this.getDataTableColumnIdx(seriesUsage), (int)y);
        }
        return null;
    }

    public void valueSourceChanged(ValueSourceChangeEvent e, ValueSource clonedValueSource) {
        if (e == null || e == this.lastProcessedEvent) {
            return;
        }
        this.lastProcessedEvent = e;
        if (clonedValueSource == null) {
            this.debug("ValueSourceData: ### CAUTION #### ValueSource with ID " + this.valueSource.getId() + " is null!");
            return;
        }
        this.setValueSource(clonedValueSource);
        switch (e.getType()) {
            case AGGREGATION_FUNCTION_MAP: 
            case DATATABLE_COLUMN_MAP: {
                this.updateDataTableColumns();
                this.invalidateValueCache();
                break;
            }
            case AGGREGATION_WINDOWING_CHANGED: 
            case USES_GROUPING: 
            case UPDATED: {
                this.invalidateGroupingCache();
                break;
            }
            case USE_RELATIVE_UTILITIES: 
            case SERIES_FORMAT_CHANGED: {
                this.invalidateMinMaxCache();
                break;
            }
        }
    }

    private void debug(String string) {
        StaticDebug.debug("ValueSourceData: " + string);
    }

    public ValueSource getValueSource() {
        return this.valueSource;
    }

    public List<PlotConfigurationError> getErrors() {
        LinkedList<PlotConfigurationError> errorList = new LinkedList<PlotConfigurationError>();
        return errorList;
    }

    public List<PlotConfigurationError> getWarnings() {
        LinkedList<PlotConfigurationError> warnings = new LinkedList<PlotConfigurationError>();
        return warnings;
    }

    public Set<Double> getDistinctValues() {
        if (this.cachedDistinctValues == null) {
            this.updateDistinctValues();
        }
        return this.cachedDistinctValues;
    }

    private void updateDistinctValues() {
        this.cachedDistinctValues = new HashSet<Double>();
        for (GroupCellKeyAndData groupCellKeyAndData : this.getSeriesDataForAllGroupCells()) {
            GroupCellData groupCellData = groupCellKeyAndData.getData();
            Map<DimensionConfig.PlotDimension, double[]> dataForUsageType = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES);
            for (double value : dataForUsageType.get((Object)DimensionConfig.PlotDimension.VALUE)) {
                this.cachedDistinctValues.add(value);
            }
        }
    }

    private void setValueSource(ValueSource valueSource) {
        if (valueSource != null && valueSource.getId() == this.valueSource.getId()) {
            this.valueSource = valueSource;
        }
    }
}

