/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart;

import com.owc.gui.charting.ChartPlottimeException;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.DomainConfigManager;
import com.owc.gui.charting.configuration.LinkAndBrushMaster;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.DomainConfigManagerData;
import com.owc.gui.charting.data.GroupCellData;
import com.owc.gui.charting.data.GroupCellKeyAndData;
import com.owc.gui.charting.data.GroupCellSeriesData;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.data.RangeAxisData;
import com.owc.gui.charting.data.ValueSourceData;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.axis.CustomDateAxis;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.axis.CustomLogarithmicAxis;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.axis.CustomNumberAxis;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.axis.CustomSymbolAxis;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.axis.LinkAndBrushAxis;
import com.owc.gui.charting.utility.NumericalValueRange;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.container.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.Range;

public class ChartAxisFactory {
    private ChartAxisFactory() {
    }

    public static ValueAxis createRangeAxis(RangeAxisConfig rangeAxisConfig, PlotInstance plotInstance) throws ChartPlottimeException {
        LinkAndBrushAxis rangeAxis;
        String label;
        if (rangeAxisConfig.getValueType() == DataTableColumn.ValueType.UNKNOWN || rangeAxisConfig.getValueType() == DataTableColumn.ValueType.INVALID) {
            return null;
        }
        RangeAxisData rangeAxisData = plotInstance.getPlotData().getRangeAxisData(rangeAxisConfig);
        double initialUpperBound = rangeAxisData.getUpperViewBound();
        double initialLowerBound = rangeAxisData.getLowerViewBound();
        double upperBound = initialUpperBound;
        double lowerBound = initialLowerBound;
        LinkAndBrushMaster linkAndBrushMaster = plotInstance.getMasterPlotConfiguration().getLinkAndBrushMaster();
        Range axisZoom = linkAndBrushMaster.getRangeAxisZoom(rangeAxisConfig, plotInstance.getCurrentPlotConfigurationClone());
        List<ValueSource> valueSources = rangeAxisConfig.getValueSources();
        if (rangeAxisConfig.hasAbsolutStackedPlot()) {
            for (ValueSource valueSource : valueSources) {
                SeriesFormat.VisualizationType seriesType = valueSource.getSeriesFormat().getSeriesType();
                if (seriesType != SeriesFormat.VisualizationType.BARS && seriesType != SeriesFormat.VisualizationType.AREA || valueSource.getSeriesFormat().getStackingMode() != SeriesFormat.StackingMode.ABSOLUTE) continue;
                Pair<Double, Double> minMax = ChartAxisFactory.calculateUpperAndLowerBounds(valueSource, plotInstance);
                if (upperBound < (Double)minMax.getSecond()) {
                    upperBound = (Double)minMax.getSecond();
                }
                if (!(lowerBound > (Double)minMax.getFirst())) continue;
                lowerBound = (Double)minMax.getFirst();
            }
        }
        double margin = upperBound - lowerBound;
        if (lowerBound == upperBound) {
            margin = lowerBound;
        }
        if (margin == 0.0) {
            margin = 0.1;
        }
        double normalPad = 0.05 * margin;
        if (rangeAxisConfig.isLogarithmicAxis()) {
            if (!rangeAxisConfig.isUsingUserDefinedLowerViewBound()) {
                lowerBound -= 0.15 * lowerBound;
            }
            if (!rangeAxisConfig.isUsingUserDefinedUpperViewBound()) {
                upperBound += 0.15 * upperBound;
            }
        } else {
            if (!rangeAxisConfig.isUsingUserDefinedLowerViewBound()) {
                lowerBound -= normalPad;
            }
            if (!rangeAxisConfig.isUsingUserDefinedUpperViewBound()) {
                upperBound += normalPad;
            }
        }
        boolean includeZero = false;
        if (ChartAxisFactory.isIncludingZero(rangeAxisConfig, initialLowerBound) && !rangeAxisConfig.isUsingUserDefinedLowerViewBound()) {
            lowerBound = 0.0;
            includeZero = true;
        }
        boolean upToOne = false;
        if (rangeAxisConfig.mustHaveUpperBoundOne(initialUpperBound) && !rangeAxisConfig.isUsingUserDefinedUpperViewBound()) {
            upperBound = 1.0;
            upToOne = true;
        }
        if (includeZero && !upToOne) {
            upperBound *= 1.05;
        }
        if ((label = rangeAxisConfig.getLabel()) == null) {
            label = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
        }
        if (rangeAxisConfig.getValueType() == DataTableColumn.ValueType.NOMINAL && !valueSources.isEmpty()) {
            int maxValue = Integer.MIN_VALUE;
            for (ValueSource valueSource : rangeAxisData.getRangeAxisConfig().getValueSources()) {
                ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
                double maxValueInSource = valueSourceData.getMaxValue();
                if (!(maxValueInSource > (double)maxValue)) continue;
                maxValue = (int)maxValueInSource;
            }
            Vector<String> yValueStrings = new Vector<String>(maxValue);
            yValueStrings.setSize(maxValue + 1);
            ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSources.get(0));
            for (int i = 0; i <= maxValue; ++i) {
                yValueStrings.set(i, valueSourceData.getStringForValue(ValueSource.SeriesUsageType.MAIN_SERIES, i));
            }
            String[] yValueStringArray = new String[yValueStrings.size()];
            int i = 0;
            Iterator iterator = yValueStrings.iterator();
            while (iterator.hasNext()) {
                String s;
                yValueStringArray[i] = s = (String)iterator.next();
                ++i;
            }
            CustomSymbolAxis symbolRangeAxis = new CustomSymbolAxis(null, yValueStringArray);
            symbolRangeAxis.setVisible(true);
            symbolRangeAxis.setAutoRangeIncludesZero(false);
            symbolRangeAxis.saveUpperBound(upperBound, initialUpperBound);
            symbolRangeAxis.saveLowerBound(lowerBound, initialLowerBound);
            symbolRangeAxis.setLabel(label);
            Font axesFont = plotInstance.getCurrentPlotConfigurationClone().getAxesFont();
            if (axesFont != null) {
                symbolRangeAxis.setLabelFont(axesFont);
                symbolRangeAxis.setTickLabelFont(axesFont);
            }
            if (axisZoom != null) {
                symbolRangeAxis.setRange(axisZoom);
            }
            rangeAxis = symbolRangeAxis;
        } else if (rangeAxisConfig.getValueType() == DataTableColumn.ValueType.NUMERICAL) {
            LinkAndBrushAxis numberRangeAxis;
            if (rangeAxisConfig.isLogarithmicAxis()) {
                if (rangeAxisData.getMinYValue() <= 0.0) {
                    throw new ChartPlottimeException("log_axis_contains_zero", label);
                }
                numberRangeAxis = new CustomLogarithmicAxis(null);
                ((CustomLogarithmicAxis)numberRangeAxis).saveUpperBound(upperBound, initialUpperBound);
                ((CustomLogarithmicAxis)numberRangeAxis).saveLowerBound(lowerBound, initialLowerBound);
            } else {
                numberRangeAxis = new CustomNumberAxis();
                ((CustomNumberAxis)numberRangeAxis).saveUpperBound(upperBound, initialUpperBound);
                ((CustomNumberAxis)numberRangeAxis).saveLowerBound(lowerBound, initialLowerBound);
            }
            numberRangeAxis.setAutoRangeIncludesZero(false);
            numberRangeAxis.setVisible(true);
            numberRangeAxis.setLabel(label);
            Font axesFont = plotInstance.getCurrentPlotConfigurationClone().getAxesFont();
            if (axesFont != null) {
                numberRangeAxis.setLabelFont(axesFont);
                numberRangeAxis.setTickLabelFont(axesFont);
            }
            if (axisZoom != null) {
                numberRangeAxis.setRange(axisZoom);
            }
            rangeAxis = numberRangeAxis;
        } else if (rangeAxisConfig.getValueType() == DataTableColumn.ValueType.DATE_TIME) {
            if (rangeAxisConfig.isLogarithmicAxis()) {
                throw new ChartPlottimeException("logarithmic_not_supported_for_value_type", new Object[]{label, DataTableColumn.ValueType.DATE_TIME});
            }
            CustomDateAxis dateRangeAxis = new CustomDateAxis();
            dateRangeAxis.saveUpperBound(upperBound, initialUpperBound);
            dateRangeAxis.saveLowerBound(lowerBound, initialLowerBound);
            dateRangeAxis.setVisible(true);
            dateRangeAxis.setLabel(label);
            Font axesFont = plotInstance.getCurrentPlotConfigurationClone().getAxesFont();
            if (axesFont != null) {
                dateRangeAxis.setLabelFont(axesFont);
            }
            if (axisZoom != null) {
                dateRangeAxis.setRange(axisZoom);
            }
            rangeAxis = dateRangeAxis;
        } else {
            throw new RuntimeException("Unknown value type. This should not happen");
        }
        ChartAxisFactory.formatAxis(plotInstance.getCurrentPlotConfigurationClone(), (Axis)rangeAxis);
        return rangeAxis;
    }

    private static Pair<Double, Double> calculateUpperAndLowerBounds(ValueSource valueSource, PlotInstance plotInstance) {
        Pair minMax = new Pair((Object)Double.POSITIVE_INFINITY, (Object)Double.NEGATIVE_INFINITY);
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        GroupCellSeriesData dataForAllGroupCells = valueSourceData.getSeriesDataForAllGroupCells();
        HashMap<Double, Double> stackedYValues = new HashMap<Double, Double>();
        for (GroupCellKeyAndData groupCellKeyAndData : dataForAllGroupCells) {
            GroupCellData groupCellData = groupCellKeyAndData.getData();
            Map<DimensionConfig.PlotDimension, double[]> dataForUsageType = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES);
            double[] xValues = dataForUsageType.get((Object)DimensionConfig.PlotDimension.DOMAIN);
            double[] yValues = dataForUsageType.get((Object)DimensionConfig.PlotDimension.VALUE);
            int rowCount = xValues.length;
            for (int row = 0; row < rowCount; ++row) {
                Double x = xValues[row];
                Double stackedYValue = (Double)stackedYValues.get(x);
                double d = yValues[row];
                if (Double.isNaN(d)) continue;
                if (stackedYValue == null) {
                    stackedYValues.put(x, d);
                    continue;
                }
                double value = stackedYValue + d;
                stackedYValues.put(x, value);
            }
        }
        for (Double xValue : stackedYValues.keySet()) {
            Double yValue = (Double)stackedYValues.get(xValue);
            if (yValue > (Double)minMax.getSecond()) {
                minMax.setSecond((Object)yValue);
            }
            if (!(yValue < (Double)minMax.getFirst())) continue;
            minMax.setFirst((Object)yValue);
        }
        return minMax;
    }

    public static CategoryAxis createCategoryDomainAxis(PlotConfiguration plotConfiguration) {
        CategoryAxis domainAxis = new CategoryAxis(null);
        String label = plotConfiguration.getDomainConfigManager().getLabel();
        if (label == null) {
            label = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
        }
        domainAxis.setLabel(label);
        Font axesFont = plotConfiguration.getAxesFont();
        if (axesFont != null) {
            domainAxis.setLabelFont(axesFont);
            domainAxis.setTickLabelFont(axesFont);
        }
        if (plotConfiguration.getOrientation() != PlotOrientation.HORIZONTAL) {
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.5707963267948966));
        }
        ChartAxisFactory.formatAxis(plotConfiguration, (Axis)domainAxis);
        return domainAxis;
    }

    private static boolean isIncludingZero(RangeAxisConfig rangeAxisConfig, double initialLowerBound) {
        SeriesFormat.VisualizationType seriesType;
        SeriesFormat seriesFormat;
        int includeZero = 0;
        boolean minValueBiggerOrEqualZero = initialLowerBound >= 0.0;
        boolean hasRelatives = false;
        boolean hasAreaOrBars = false;
        List<ValueSource> valueSources = rangeAxisConfig.getValueSources();
        for (ValueSource valueSource : valueSources) {
            seriesFormat = valueSource.getSeriesFormat();
            seriesType = seriesFormat.getSeriesType();
            if (seriesType != SeriesFormat.VisualizationType.BARS && seriesType != SeriesFormat.VisualizationType.AREA) continue;
            hasAreaOrBars = true;
        }
        if (!hasAreaOrBars) {
            return false;
        }
        for (ValueSource valueSource : valueSources) {
            seriesFormat = valueSource.getSeriesFormat();
            seriesType = seriesFormat.getSeriesType();
            if (seriesType == SeriesFormat.VisualizationType.BARS || seriesType == SeriesFormat.VisualizationType.AREA) {
                if (!hasRelatives) {
                    boolean bl = hasRelatives = seriesFormat.getStackingMode() == SeriesFormat.StackingMode.RELATIVE;
                }
                if (!minValueBiggerOrEqualZero) continue;
                ++includeZero;
                continue;
            }
            if (!minValueBiggerOrEqualZero) continue;
            ++includeZero;
        }
        boolean allSourcesAreBarsOrArea = includeZero == valueSources.size();
        boolean containsRelativeAndMinBiggerZero = hasRelatives && minValueBiggerOrEqualZero;
        return allSourcesAreBarsOrArea || containsRelativeAndMinBiggerZero;
    }

    private static ValueAxis createNumberOrDateDomainAxis(PlotInstance plotInstance, boolean date) throws ChartPlottimeException {
        String label;
        Object domainAxis;
        double lowerBound;
        PlotConfiguration plotConfiguration = plotInstance.getCurrentPlotConfigurationClone();
        DomainConfigManager domainConfigManager = plotConfiguration.getDomainConfigManager();
        DomainConfigManagerData domainConfigManagerData = plotInstance.getPlotData().getDomainConfigManagerData();
        DefaultDimensionConfig domainConfig = domainConfigManager.getDomainConfig(false);
        if (domainConfig.isNominal()) {
            throw new IllegalArgumentException("Cannot create nominal domain axis from numerical domain config.");
        }
        NumericalValueRange range = domainConfigManagerData.getEffectiveRange();
        double upperBound = range.getUpperBound();
        double lowerBoundWithMargin = lowerBound = range.getLowerBound();
        double upperBoundWithMargin = upperBound;
        LinkAndBrushMaster linkAndBrushMaster = plotInstance.getMasterPlotConfiguration().getLinkAndBrushMaster();
        Range domainZoom = linkAndBrushMaster.getDomainZoom();
        boolean logarithmic = false;
        if (domainConfigManager.isLogarithmicDomainAxis()) {
            logarithmic = true;
            if (date) {
                logarithmic = false;
            }
        }
        if (logarithmic) {
            if (range.getLowerBound() <= 0.0) {
                throw new ChartPlottimeException("axis_configuration_error", domainConfigManager.getDimension().getName());
            }
            CustomLogarithmicAxis customLogAxis = new CustomLogarithmicAxis(null);
            if (!domainConfigManager.isUsingUserDefinedLowerBound()) {
                lowerBoundWithMargin = lowerBound - 0.15 * lowerBound;
            }
            if (!domainConfigManager.isUsingUserDefinedUpperBound()) {
                upperBoundWithMargin = upperBound + 0.15 * upperBound;
            }
            customLogAxis.saveUpperBound(upperBoundWithMargin, upperBound);
            customLogAxis.saveLowerBound(lowerBoundWithMargin, lowerBound);
            domainAxis = customLogAxis;
        } else {
            LinkAndBrushAxis linkAndBrushAxis;
            if (date) {
                CustomDateAxis dateAxis = new CustomDateAxis(null);
                if (domainConfig.isUsingUserDefinedDateFormat()) {
                    dateAxis.setDateFormatOverride(domainConfig.getDateFormat());
                    dateAxis.setTimeZone(TimeZone.getTimeZone("GMT"));
                }
                linkAndBrushAxis = dateAxis;
            } else {
                linkAndBrushAxis = new CustomNumberAxis(null);
                ((NumberAxis)linkAndBrushAxis).setAutoRangeIncludesZero(false);
            }
            domainAxis = (ValueAxis)linkAndBrushAxis;
            double margin = upperBound - lowerBound;
            double pad = 0.04 * margin;
            if (!domainConfigManager.isUsingUserDefinedLowerBound()) {
                lowerBoundWithMargin = lowerBound - pad;
            }
            if (!domainConfigManager.isUsingUserDefinedUpperBound()) {
                upperBoundWithMargin = upperBound + pad;
            }
            linkAndBrushAxis.saveUpperBound(upperBoundWithMargin, upperBound);
            linkAndBrushAxis.saveLowerBound(lowerBoundWithMargin, lowerBound);
        }
        if (domainZoom != null) {
            domainAxis.setRange(domainZoom);
        }
        if ((label = domainConfigManager.getLabel()) == null) {
            label = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
        }
        domainAxis.setLabel(label);
        Font axesFont = plotConfiguration.getAxesFont();
        if (axesFont != null) {
            domainAxis.setLabelFont(axesFont);
            domainAxis.setTickLabelFont(axesFont);
        }
        ChartAxisFactory.formatAxis(plotConfiguration, (Axis)domainAxis);
        return domainAxis;
    }

    public static void formatAxis(PlotConfiguration plotConfiguration, Axis axis) {
        Color axisColor = plotConfiguration.getAxisLineColor();
        if (axis != null) {
            axis.setAxisLinePaint((Paint)axisColor);
            axis.setAxisLineStroke((Stroke)new BasicStroke(plotConfiguration.getAxisLineWidth()));
            axis.setLabelPaint((Paint)axisColor);
            axis.setTickLabelPaint((Paint)axisColor);
        }
    }

    public static ValueAxis createNumericalDomainAxis(PlotInstance plotInstance) throws ChartPlottimeException {
        return ChartAxisFactory.createNumberOrDateDomainAxis(plotInstance, false);
    }

    public static ValueAxis createDateDomainAxis(PlotInstance plotInstance) throws ChartPlottimeException {
        return ChartAxisFactory.createNumberOrDateDomainAxis(plotInstance, true);
    }
}

