/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart;

import com.owc.gui.charting.ChartPlottimeException;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.GroupCellKey;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.DimensionConfigData;
import com.owc.gui.charting.data.GroupCellData;
import com.owc.gui.charting.data.GroupCellKeyAndData;
import com.owc.gui.charting.data.GroupCellSeriesData;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.data.ValueSourceData;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.container.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.SeriesException;
import org.jfree.data.statistics.DefaultMultiValueCategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.data.xy.DefaultIntervalXYDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ChartDatasetFactory {
    private ChartDatasetFactory() {
    }

    public static XYSeriesCollection createXYSeriesCollection(ValueSource valueSource, PlotInstance plotInstance, double autoWidthFraction, boolean allowDuplicates, boolean sortByDomain) throws ChartPlottimeException {
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        if (autoWidthFraction > 0.0) {
            xyDataset.setAutoWidth(true);
        } else {
            xyDataset.setAutoWidth(false);
            xyDataset.setIntervalWidth(0.0);
        }
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        ChartDatasetFactory.assertMaxValueCountNotExceededOrThrowException(valueSourceData);
        GroupCellSeriesData dataForAllGroupCells = valueSourceData.getSeriesDataForAllGroupCells();
        for (GroupCellKeyAndData groupCellKeyAndData : dataForAllGroupCells) {
            GroupCellKey groupCellKey = groupCellKeyAndData.getKey();
            GroupCellData groupCellData = groupCellKeyAndData.getData();
            String seriesName = ChartDatasetFactory.generateSeriesName(valueSource, groupCellKey, plotInstance.getCurrentPlotConfigurationClone());
            XYSeries series = new XYSeries((Comparable)((Object)seriesName), sortByDomain, allowDuplicates);
            Map<DimensionConfig.PlotDimension, double[]> dataForUsageType = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES);
            int rowCount = dataForUsageType.get((Object)DimensionConfig.PlotDimension.DOMAIN).length;
            double[] xValues = dataForUsageType.get((Object)DimensionConfig.PlotDimension.DOMAIN);
            double[] yValues = dataForUsageType.get((Object)DimensionConfig.PlotDimension.VALUE);
            try {
                for (int row = 0; row < rowCount; ++row) {
                    double x = xValues[row];
                    double y = yValues[row];
                    if (Double.isNaN(x)) continue;
                    series.add(x, y);
                }
            }
            catch (SeriesException e) {
                throw new ChartPlottimeException("duplicate_value", valueSource.toString(), DimensionConfig.PlotDimension.DOMAIN.getName());
            }
            xyDataset.addSeries(series);
        }
        if (xyDataset.getIntervalWidth() > 0.0) {
            xyDataset.setIntervalWidth(xyDataset.getIntervalWidth() * autoWidthFraction);
        }
        return xyDataset;
    }

    public static DefaultIntervalXYDataset createDefaultIntervalXYDataset(ValueSource valueSource, PlotInstance plotInstance, boolean createRangeIntervals) throws ChartPlottimeException {
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        ChartDatasetFactory.assertMaxValueCountNotExceededOrThrowException(valueSourceData);
        GroupCellSeriesData dataForAllGroupCells = valueSourceData.getSeriesDataForAllGroupCells();
        DefaultIntervalXYDataset intervalDataset = new DefaultIntervalXYDataset();
        DefaultDimensionConfig domainConfig = valueSource.getDomainConfig();
        DimensionConfigData domainConfigData = plotInstance.getPlotData().getDimensionConfigData(domainConfig);
        for (GroupCellKeyAndData groupCellKeyAndData : dataForAllGroupCells) {
            GroupCellKey groupCellKey = groupCellKeyAndData.getKey();
            GroupCellData groupCellData = groupCellKeyAndData.getData();
            GroupCellKey groupCellKeyClone = (GroupCellKey)groupCellKey.clone();
            groupCellKeyClone.removeRangeForDimension(DimensionConfig.PlotDimension.DOMAIN);
            String seriesName = ChartDatasetFactory.generateSeriesName(valueSource, groupCellKeyClone, plotInstance.getCurrentPlotConfigurationClone());
            List<ValueRange> domainValueGroups = domainConfigData.getGroupingModel();
            boolean domainValueIdx = false;
            boolean domainLowerIdx = true;
            int domainUpperIdx = 2;
            int rangeValueIdx = 3;
            int rangeLowerIdx = 4;
            int rangeUpperIdx = 5;
            Map<DimensionConfig.PlotDimension, double[]> dataForMainSeries = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES);
            int rowCount = dataForMainSeries.get((Object)DimensionConfig.PlotDimension.DOMAIN).length;
            double[] domainValues = dataForMainSeries.get((Object)DimensionConfig.PlotDimension.DOMAIN);
            double[] rangeValues = dataForMainSeries.get((Object)DimensionConfig.PlotDimension.VALUE);
            double[] upperErrorValues = null;
            double[] lowerErrorValues = null;
            upperErrorValues = valueSourceData.getAbsoluteUtilityValues(groupCellKeyAndData, true);
            lowerErrorValues = valueSourceData.getAbsoluteUtilityValues(groupCellKeyAndData, false);
            if (createRangeIntervals && upperErrorValues == null) {
                throw new ChartPlottimeException("undefined_series", new Object[]{valueSource.toString(), ValueSource.SeriesUsageType.INDICATOR_1});
            }
            double[][] series = new double[6][rowCount];
            Iterator<ValueRange> domainGroupIterator = null;
            if (domainValueGroups != null) {
                domainGroupIterator = domainValueGroups.iterator();
            }
            for (int row = 0; row < rowCount; ++row) {
                ValueRange currentDomainGroup;
                double domainValue;
                double domainLower = domainValue = domainValues[row];
                double domainUpper = domainValue;
                if (domainGroupIterator != null && (currentDomainGroup = domainGroupIterator.next()).definesUpperLowerBound()) {
                    domainLower = currentDomainGroup.getLowerBound();
                    domainUpper = currentDomainGroup.getUpperBound();
                }
                double rangeValue = rangeValues[row];
                double rangeUpper = upperErrorValues != null ? upperErrorValues[row] : Double.NaN;
                double rangeLower = lowerErrorValues != null ? lowerErrorValues[row] : Double.NaN;
                series[0][row] = domainValue;
                series[1][row] = domainLower;
                series[2][row] = domainUpper;
                series[3][row] = rangeValue;
                series[4][row] = rangeLower;
                series[5][row] = rangeUpper;
            }
            intervalDataset.addSeries((Comparable)((Object)seriesName), series);
        }
        return intervalDataset;
    }

    public static CategoryDataset createDefaultCategoryDataset(ValueSource valueSource, PlotInstance plotInstance, boolean fillWithZero, boolean allowValuesLessThanZero) throws ChartPlottimeException {
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        ChartDatasetFactory.assertMaxValueCountNotExceededOrThrowException(valueSourceData);
        GroupCellSeriesData dataForAllGroupCells = valueSourceData.getSeriesDataForAllGroupCells();
        DefaultDimensionConfig domainConfig = valueSource.getDomainConfig();
        DimensionConfigData domainConfigData = plotInstance.getPlotData().getDimensionConfigData(domainConfig);
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (GroupCellKeyAndData groupCellKeyAndData : dataForAllGroupCells) {
            String xString;
            double xValue;
            int row;
            GroupCellKey groupCellKey = groupCellKeyAndData.getKey();
            GroupCellData groupCellData = groupCellKeyAndData.getData();
            GroupCellKey groupCellKeyClone = (GroupCellKey)groupCellKey.clone();
            String seriesName = ChartDatasetFactory.generateSeriesName(valueSource, groupCellKeyClone, plotInstance.getCurrentPlotConfigurationClone());
            Map<DimensionConfig.PlotDimension, double[]> dataForUsageType = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES);
            double[] xValues = dataForUsageType.get((Object)DimensionConfig.PlotDimension.DOMAIN);
            double[] yValues = dataForUsageType.get((Object)DimensionConfig.PlotDimension.VALUE);
            int rowCount = xValues.length;
            for (row = 0; row < rowCount; ++row) {
                xValue = xValues[row];
                xString = null;
                xString = domainConfigData.getStringForValue(xValue);
                Double y = yValues[row];
                if (!allowValuesLessThanZero && y < 0.0) {
                    throw new ChartPlottimeException("illegal_zero_value", valueSource.toString());
                }
                if (xString == null) continue;
                dataset.addValue((Number)y, (Comparable)((Object)seriesName), (Comparable)((Object)xString));
            }
            if (!fillWithZero) continue;
            for (row = 0; row < rowCount; ++row) {
                xValue = xValues[row];
                xString = null;
                xString = domainConfigData.getStringForValue(xValue);
                Number value = dataset.getValue((Comparable)((Object)seriesName), (Comparable)((Object)xString));
                if (value != null && !Double.isNaN(value.doubleValue())) continue;
                dataset.addValue(0.0, (Comparable)((Object)seriesName), (Comparable)((Object)xString));
            }
        }
        return dataset;
    }

    public static String generateSeriesName(ValueSource valueSource, GroupCellKey groupCellKey, PlotConfiguration plotConfiguration) {
        String filterName = groupCellKey.getNiceString(plotConfiguration);
        String seriesName = valueSource.getLabel();
        StringBuilder builder = new StringBuilder();
        if (seriesName == null) {
            seriesName = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
        }
        builder.append(seriesName);
        if (filterName.length() != 0) {
            builder.append(" [");
            builder.append(filterName);
            builder.append("]");
        }
        return builder.toString();
    }

    public static XYDataset createDefaultXYDataset(ValueSource valueSource, PlotInstance plotInstace) throws ChartPlottimeException {
        DefaultXYDataset dataset = new DefaultXYDataset();
        ValueSourceData valueSourceData = plotInstace.getPlotData().getValueSourceData(valueSource);
        for (int seriesIdx = 0; seriesIdx < valueSourceData.getSeriesCount(); ++seriesIdx) {
            ChartDatasetFactory.addSeriesToDefaultXYDataset(valueSource, seriesIdx, plotInstace, dataset);
        }
        return dataset;
    }

    public static XYDataset createDefaultXYDataset(ValueSource valueSource, int seriesIdx, PlotInstance plotInstance) throws ChartPlottimeException {
        DefaultXYDataset dataset = new DefaultXYDataset();
        ChartDatasetFactory.addSeriesToDefaultXYDataset(valueSource, seriesIdx, plotInstance, dataset);
        return dataset;
    }

    private static void addSeriesToDefaultXYDataset(ValueSource valueSource, int seriesIdx, PlotInstance plotInstance, DefaultXYDataset dataset) throws ChartPlottimeException {
        boolean xIdx = false;
        boolean yIdx = true;
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        ChartDatasetFactory.assertMaxValueCountNotExceededOrThrowException(valueSourceData);
        GroupCellSeriesData dataForAllGroupCells = valueSourceData.getSeriesDataForAllGroupCells();
        GroupCellKeyAndData groupCellKeyAndData = dataForAllGroupCells.getGroupCellKeyAndData(seriesIdx);
        GroupCellKey groupCellKey = groupCellKeyAndData.getKey();
        GroupCellData groupCellData = groupCellKeyAndData.getData();
        GroupCellKey groupCellKeyClone = (GroupCellKey)groupCellKey.clone();
        String seriesName = ChartDatasetFactory.generateSeriesName(valueSource, groupCellKeyClone, plotInstance.getCurrentPlotConfigurationClone());
        String differenceName = "__&%" + seriesName + "%&__";
        Map<DimensionConfig.PlotDimension, double[]> mainData = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES);
        double[] xValues = mainData.get((Object)DimensionConfig.PlotDimension.DOMAIN);
        double[] yValues = mainData.get((Object)DimensionConfig.PlotDimension.VALUE);
        double[][] mainSeries = new double[2][xValues.length];
        mainSeries[0] = xValues;
        mainSeries[1] = yValues;
        dataset.addSeries((Comparable)((Object)seriesName), mainSeries);
        if (valueSource.getSeriesFormat().getUtilityUsage() == SeriesFormat.IndicatorType.DIFFERENCE) {
            double[] differenceValues = valueSourceData.getAbsoluteUtilityValues(groupCellKeyAndData, true);
            if (differenceValues == null) {
                throw new ChartPlottimeException("undefined_series", new Object[]{valueSource.toString(), ValueSource.SeriesUsageType.INDICATOR_1});
            }
            double[][] differenceSeries = new double[2][xValues.length];
            differenceSeries[0] = xValues;
            differenceSeries[1] = differenceValues;
            dataset.addSeries((Comparable)((Object)differenceName), differenceSeries);
        }
    }

    public static DefaultTableXYDataset createDefaultTableXYDataset(ValueSource valueSource, PlotInstance plotInstance) throws ChartPlottimeException {
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        ChartDatasetFactory.assertMaxValueCountNotExceededOrThrowException(valueSourceData);
        GroupCellSeriesData dataForAllGroupCells = valueSourceData.getSeriesDataForAllGroupCells();
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        for (GroupCellKeyAndData groupCellKeyAndData : dataForAllGroupCells) {
            GroupCellKey groupCellKey = groupCellKeyAndData.getKey();
            GroupCellData groupCellData = groupCellKeyAndData.getData();
            Map<DimensionConfig.PlotDimension, double[]> dataForUsageType = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES);
            double[] xValues = dataForUsageType.get((Object)DimensionConfig.PlotDimension.DOMAIN);
            double[] yValues = dataForUsageType.get((Object)DimensionConfig.PlotDimension.VALUE);
            int rowCount = xValues.length;
            String seriesName = ChartDatasetFactory.generateSeriesName(valueSource, groupCellKey, plotInstance.getCurrentPlotConfigurationClone());
            XYSeries series = new XYSeries((Comparable)((Object)seriesName), false, false);
            for (int row = 0; row < rowCount; ++row) {
                double x = xValues[row];
                double y = yValues[row];
                try {
                    if (Double.isNaN(x)) continue;
                    series.add(x, y, false);
                    continue;
                }
                catch (SeriesException e) {
                    throw new ChartPlottimeException("duplicate_value", valueSource.toString(), DimensionConfig.PlotDimension.DOMAIN.getName());
                }
            }
            dataset.addSeries(series);
        }
        dataset.setAutoWidth(true);
        return dataset;
    }

    public static DefaultStatisticalCategoryDataset createDefaultStatisticalCategoryDataset(ValueSource valueSource, PlotInstance plotInstance) throws ChartPlottimeException {
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        ChartDatasetFactory.assertMaxValueCountNotExceededOrThrowException(valueSourceData);
        GroupCellSeriesData dataForAllGroupCells = valueSourceData.getSeriesDataForAllGroupCells();
        DefaultStatisticalCategoryDataset dataset = new DefaultStatisticalCategoryDataset();
        DefaultDimensionConfig domainConfig = valueSource.getDomainConfig();
        DimensionConfigData domainConfigData = plotInstance.getPlotData().getDimensionConfigData(domainConfig);
        for (GroupCellKeyAndData groupCellKeyAndData : dataForAllGroupCells) {
            GroupCellKey groupCellKey = groupCellKeyAndData.getKey();
            GroupCellData groupCellData = groupCellKeyAndData.getData();
            String seriesName = ChartDatasetFactory.generateSeriesName(valueSource, groupCellKey, plotInstance.getCurrentPlotConfigurationClone());
            Map<DimensionConfig.PlotDimension, double[]> mainSeriesData = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES);
            double[] xValues = mainSeriesData.get((Object)DimensionConfig.PlotDimension.DOMAIN);
            double[] yValues = mainSeriesData.get((Object)DimensionConfig.PlotDimension.VALUE);
            double[] yErrorValues = valueSourceData.getAbsoluteUtilityValues(groupCellKeyAndData, true);
            if (yErrorValues == null) {
                throw new ChartPlottimeException("undefined_series", new Object[]{valueSource.toString(), ValueSource.SeriesUsageType.INDICATOR_1});
            }
            if (groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.INDICATOR_2) != null) {
                throw new ChartPlottimeException("unsymmetric_utility_not_supported", valueSource.toString());
            }
            int rowCount = xValues.length;
            for (int row = 0; row < rowCount; ++row) {
                double xValue = xValues[row];
                String xString = domainConfigData.getStringForValue(xValue);
                double yValue = yValues[row];
                double yErrorValue = yErrorValues[row] - yValue;
                dataset.add(yValue, yErrorValue, (Comparable)((Object)seriesName), (Comparable)((Object)xString));
            }
        }
        return dataset;
    }

    public static DefaultMultiValueCategoryDataset createDefaultMultiValueCategoryDataset(ValueSource valueSource, PlotInstance plotInstance) throws ChartPlottimeException {
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        ChartDatasetFactory.assertMaxValueCountNotExceededOrThrowException(valueSourceData);
        GroupCellSeriesData dataForAllGroupCells = valueSourceData.getSeriesDataForAllGroupCells();
        DefaultMultiValueCategoryDataset dataset = new DefaultMultiValueCategoryDataset();
        DefaultDimensionConfig domainConfig = valueSource.getDomainConfig();
        DimensionConfigData domainConfigData = plotInstance.getPlotData().getDimensionConfigData(domainConfig);
        for (GroupCellKeyAndData groupCellKeyAndData : dataForAllGroupCells) {
            HashMap valueListsForDomainValues = new HashMap();
            for (Double value : domainConfigData.getDistinctValues()) {
                valueListsForDomainValues.put(value, new LinkedList());
            }
            GroupCellKey groupCellKey = groupCellKeyAndData.getKey();
            GroupCellData groupCellData = groupCellKeyAndData.getData();
            String seriesName = ChartDatasetFactory.generateSeriesName(valueSource, groupCellKey, plotInstance.getCurrentPlotConfigurationClone());
            Map<DimensionConfig.PlotDimension, double[]> mainSeriesData = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES);
            double[] xValues = mainSeriesData.get((Object)DimensionConfig.PlotDimension.DOMAIN);
            double[] yValues = mainSeriesData.get((Object)DimensionConfig.PlotDimension.VALUE);
            int rowCount = xValues.length;
            for (int row = 0; row < rowCount; ++row) {
                double xValue = xValues[row];
                double yValue = yValues[row];
                ((List)valueListsForDomainValues.get(xValue)).add(yValue);
            }
            for (Double value : domainConfigData.getDistinctValues()) {
                String xString = domainConfigData.getStringForValue(value);
                dataset.add((List)valueListsForDomainValues.get(value), (Comparable)((Object)seriesName), (Comparable)((Object)xString));
            }
        }
        return dataset;
    }

    public static DefaultMultiValueCategoryDataset createAnnotatedDefaultMultiValueCategoryDataset(ValueSource valueSource, PlotInstance plotInstance) throws ChartPlottimeException {
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        ChartDatasetFactory.assertMaxValueCountNotExceededOrThrowException(valueSourceData);
        GroupCellSeriesData dataForAllGroupCells = valueSourceData.getSeriesDataForAllGroupCells();
        DefaultMultiValueCategoryDataset dataset = new DefaultMultiValueCategoryDataset();
        DefaultDimensionConfig domainConfig = valueSource.getDomainConfig();
        DimensionConfigData domainConfigData = plotInstance.getPlotData().getDimensionConfigData(domainConfig);
        for (GroupCellKeyAndData groupCellKeyAndData : dataForAllGroupCells) {
            HashMap valueListsForDomainValues = new HashMap();
            for (Double value : domainConfigData.getDistinctValues()) {
                valueListsForDomainValues.put(value, new LinkedList());
            }
            GroupCellKey groupCellKey = groupCellKeyAndData.getKey();
            GroupCellData groupCellData = groupCellKeyAndData.getData();
            String seriesName = ChartDatasetFactory.generateSeriesName(valueSource, groupCellKey, plotInstance.getCurrentPlotConfigurationClone());
            Map<DimensionConfig.PlotDimension, double[]> mainSeriesData = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES);
            double[] xValues = mainSeriesData.get((Object)DimensionConfig.PlotDimension.DOMAIN);
            double[] yValues = mainSeriesData.get((Object)DimensionConfig.PlotDimension.VALUE);
            int rowCount = xValues.length;
            for (int row = 0; row < rowCount; ++row) {
                double xValue = xValues[row];
                double yValue = yValues[row];
                Pair valueRowNumberPair = new Pair((Object)yValue, (Object)row);
                ((List)valueListsForDomainValues.get(xValue)).add(valueRowNumberPair);
            }
            for (Double value : domainConfigData.getDistinctValues()) {
                String xString = domainConfigData.getStringForValue(value);
                dataset.add((List)valueListsForDomainValues.get(value), (Comparable)((Object)seriesName), (Comparable)((Object)xString));
            }
        }
        return dataset;
    }

    private static void assertMaxValueCountNotExceededOrThrowException(ValueSourceData valueSourceData) throws ChartPlottimeException {
        if (valueSourceData == null) {
            return;
        }
        int maxAllowedValueCount = PlotConfiguration.getMaxAllowedValueCount();
        for (GroupCellKeyAndData groupCellKeyAndData : valueSourceData.getSeriesDataForAllGroupCells()) {
            int size = groupCellKeyAndData.getData().getSize();
            if (size <= maxAllowedValueCount) continue;
            throw new ChartPlottimeException("too_many_values_in_plot", valueSourceData.getValueSource().toString());
        }
    }
}

