/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart;

import com.owc.gui.charting.engine.jfreechart.CrosshairOverlay;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.ChartPanel;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleEdge;

public class MultiAxesCrosshairOverlay
extends CrosshairOverlay {
    private static final long serialVersionUID = 1L;
    private Vector<ArrayList<Crosshair>> rangeCrosshairs = new Vector();

    @Override
    public void addRangeCrosshair(Crosshair crosshair) {
        this.addRangeCrosshair(0, crosshair);
    }

    public void addRangeCrosshair(int axisIdx, Crosshair crosshair) {
        while (this.rangeCrosshairs.size() < axisIdx + 1) {
            this.rangeCrosshairs.add(new ArrayList());
        }
        this.rangeCrosshairs.get(axisIdx).add(crosshair);
        crosshair.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void removeRangeCrosshair(Crosshair crosshair) {
        this.removeRangeCrosshair(0, crosshair);
    }

    public void removeRangeCrosshair(int axisIdx, Crosshair crosshair) {
        if (this.rangeCrosshairs.size() > axisIdx) {
            ArrayList<Crosshair> crosshairsForRange = this.rangeCrosshairs.get(axisIdx);
            crosshairsForRange.remove(crosshair);
            crosshair.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void clearRangeCrosshairs() {
        for (List list : this.rangeCrosshairs) {
            for (Crosshair crosshair : list) {
                crosshair.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
        this.rangeCrosshairs.clear();
    }

    @Override
    public List<Crosshair> getRangeCrosshairs() {
        return this.getRangeCrosshairs(0);
    }

    private List<Crosshair> getRangeCrosshairs(int axisIdx) {
        return this.rangeCrosshairs.get(axisIdx);
    }

    @Override
    public void paintOverlay(Graphics2D g2, ChartPanel chartPanel) {
        Shape savedClip = g2.getClip();
        Rectangle2D dataArea = chartPanel.getScreenDataArea();
        g2.clip(dataArea);
        JFreeChart chart = chartPanel.getChart();
        XYPlot plot = (XYPlot)chart.getPlot();
        ValueAxis xAxis = plot.getDomainAxis();
        RectangleEdge xAxisEdge = plot.getDomainAxisEdge();
        for (Crosshair ch : this.getDomainCrosshairs()) {
            if (!ch.isVisible()) continue;
            double x = ch.getValue();
            double xx = xAxis.valueToJava2D(x, dataArea, xAxisEdge);
            if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                this.drawVerticalCrosshair(g2, dataArea, xx, ch);
                continue;
            }
            this.drawHorizontalCrosshair(g2, dataArea, xx, ch);
        }
        int rangeAxisIdx = 0;
        for (ArrayList<Crosshair> crosshairsForRange : this.rangeCrosshairs) {
            ValueAxis yAxis = plot.getRangeAxis(rangeAxisIdx);
            RectangleEdge yAxisEdge = plot.getRangeAxisEdge(rangeAxisIdx);
            for (Crosshair ch : crosshairsForRange) {
                if (!ch.isVisible()) continue;
                double y = ch.getValue();
                double yy = yAxis.valueToJava2D(y, dataArea, yAxisEdge);
                if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                    this.drawHorizontalCrosshair(g2, dataArea, yy, ch);
                    continue;
                }
                this.drawVerticalCrosshair(g2, dataArea, yy, ch);
            }
            g2.setClip(savedClip);
            ++rangeAxisIdx;
        }
    }
}

