/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart.legend;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BlockResult;
import org.jfree.chart.block.EntityBlockParams;
import org.jfree.chart.block.EntityBlockResult;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;

public class ColoredBlockContainer
extends BlockContainer {
    private static final long serialVersionUID = 1L;
    private Paint fillPaint;

    public ColoredBlockContainer(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public ColoredBlockContainer(Paint fillPaint, Arrangement arrangement) {
        super(arrangement);
        this.fillPaint = fillPaint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        area = this.drawFill(g2, area);
        super.draw(g2, area);
    }

    private Rectangle2D drawFill(Graphics2D g2, Rectangle2D area) {
        Rectangle2D filledArea = (Rectangle2D)area.clone();
        filledArea = this.trimMargin(filledArea);
        filledArea = this.trimBorder(filledArea);
        area = this.trimPadding(area);
        g2.setPaint(this.fillPaint);
        g2.fill(filledArea);
        this.drawBorder(g2, filledArea);
        return filledArea;
    }

    public Object draw(Graphics2D g2, Rectangle2D area, Object params) {
        area = this.drawFill(g2, area);
        EntityBlockParams ebp = null;
        StandardEntityCollection sec = null;
        if (params instanceof EntityBlockParams && (ebp = (EntityBlockParams)params).getGenerateEntities()) {
            sec = new StandardEntityCollection();
        }
        Rectangle2D contentArea = (Rectangle2D)area.clone();
        contentArea = this.trimMargin(contentArea);
        this.drawBorder(g2, contentArea);
        contentArea = this.trimBorder(contentArea);
        contentArea = this.trimPadding(contentArea);
        for (Block block : this.getBlocks()) {
            Rectangle2D bounds = block.getBounds();
            double y = area.getY() + (area.getHeight() - bounds.getHeight()) / 2.0;
            Rectangle2D.Double drawArea = new Rectangle2D.Double(bounds.getX() + area.getX(), y, bounds.getWidth(), bounds.getHeight());
            Object r = block.draw(g2, (Rectangle2D)drawArea, params);
            if (sec == null || !(r instanceof EntityBlockResult)) continue;
            EntityBlockResult ebr = (EntityBlockResult)r;
            EntityCollection ec = ebr.getEntityCollection();
            sec.addAll(ec);
        }
        BlockResult result = null;
        if (sec != null) {
            result = new BlockResult();
            result.setEntityCollection((EntityCollection)sec);
        }
        return result;
    }
}

