/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart.legend;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.title.LegendGraphic;
import org.jfree.ui.RectangleAnchor;
import org.jfree.util.ShapeUtilities;

public class CustomLegendGraphic
extends LegendGraphic {
    private static final long serialVersionUID = 1L;

    public CustomLegendGraphic(Shape shape, Paint fillPaint) {
        super(shape, fillPaint);
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        Point2D location;
        area = this.trimMargin(area);
        this.drawBorder(g2, area);
        area = this.trimBorder(area);
        area = this.trimPadding(area);
        if (this.isLineVisible()) {
            location = RectangleAnchor.coordinates((Rectangle2D)area, (RectangleAnchor)this.getShapeLocation());
            Shape aLine = ShapeUtilities.createTranslatedShape((Shape)this.getLine(), (RectangleAnchor)this.getShapeAnchor(), (double)location.getX(), (double)location.getY());
            g2.setPaint(this.getLinePaint());
            g2.setStroke(this.getLineStroke());
            g2.draw(aLine);
        }
        if (this.isShapeVisible()) {
            location = RectangleAnchor.coordinates((Rectangle2D)area, (RectangleAnchor)this.getShapeLocation());
            Shape s = ShapeUtilities.createTranslatedShape((Shape)this.getShape(), (RectangleAnchor)this.getShapeAnchor(), (double)location.getX(), (double)location.getY());
            if (this.isShapeFilled()) {
                Paint p = this.getFillPaint();
                if (p instanceof GradientPaint) {
                    GradientPaint gp = (GradientPaint)this.getFillPaint();
                    p = this.getFillPaintTransformer().transform(gp, s);
                } else if (p instanceof LinearGradientPaint) {
                    LinearGradientPaint gradient = (LinearGradientPaint)p;
                    Rectangle2D bounds = s.getBounds2D();
                    p = CustomLegendGraphic.getTranslatedLinearGradientPaint(gradient, new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), false);
                }
                g2.setPaint(p);
                g2.fill(s);
            }
            if (this.isShapeOutlineVisible()) {
                g2.setPaint(this.getOutlinePaint());
                g2.setStroke(this.getOutlineStroke());
                g2.draw(s);
            }
        }
    }

    private static LinearGradientPaint getTranslatedLinearGradientPaint(LinearGradientPaint gradient, Point2D startPoint, Point2D endPoint, boolean vertical) {
        if (vertical) {
            return new LinearGradientPaint(0.0f, (float)startPoint.getY(), 0.0f, (float)endPoint.getY(), gradient.getFractions(), gradient.getColors());
        }
        return new LinearGradientPaint((float)startPoint.getX(), 0.0f, (float)endPoint.getX(), 0.0f, gradient.getFractions(), gradient.getColors());
    }
}

