/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart.legend;

import com.owc.gui.charting.engine.jfreechart.legend.ColoredBlockContainer;
import com.owc.gui.charting.engine.jfreechart.legend.CustomLegendGraphic;
import com.owc.gui.charting.engine.jfreechart.legend.FlankedShapeLegendItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.CenterArrangement;
import org.jfree.chart.block.LabelBlock;
import org.jfree.chart.title.LegendGraphic;
import org.jfree.chart.title.LegendItemBlockContainer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.ui.RectangleEdge;

public class SmartLegendTitle
extends LegendTitle {
    private static final long serialVersionUID = 1L;

    public SmartLegendTitle(LegendItemSource source, Arrangement hLayout, Arrangement vLayout) {
        super(source, hLayout, vLayout);
    }

    public SmartLegendTitle(LegendItemSource source) {
        super(source);
    }

    protected Block createLegendItemBlock(LegendItem item) {
        if (item instanceof FlankedShapeLegendItem) {
            return this.createFlankedShapeLegendItem((FlankedShapeLegendItem)item);
        }
        return this.createDefaultLegendItem(item);
    }

    private Block createDefaultLegendItem(LegendItem item) {
        Paint textPaint;
        BlockContainer result = null;
        Shape shape = item.getShape();
        if (shape == null) {
            shape = new Rectangle();
        }
        LegendGraphic lg = new LegendGraphic(shape, item.getFillPaint());
        lg.setFillPaintTransformer(item.getFillPaintTransformer());
        lg.setShapeFilled(item.isShapeFilled());
        lg.setLine(item.getLine());
        lg.setLineStroke(item.getLineStroke());
        lg.setLinePaint(item.getLinePaint());
        lg.setLineVisible(item.isLineVisible());
        lg.setShapeVisible(item.isShapeVisible());
        lg.setShapeOutlineVisible(item.isShapeOutlineVisible());
        lg.setOutlinePaint(item.getOutlinePaint());
        lg.setOutlineStroke(item.getOutlineStroke());
        lg.setPadding(this.getLegendItemGraphicPadding());
        LegendItemBlockContainer legendItem = new LegendItemBlockContainer((Arrangement)new BorderArrangement(), item.getDataset(), item.getSeriesKey());
        lg.setShapeAnchor(this.getLegendItemGraphicAnchor());
        lg.setShapeLocation(this.getLegendItemGraphicLocation());
        legendItem.add((Block)lg, (Object)this.getLegendItemGraphicEdge());
        Font textFont = item.getLabelFont();
        if (textFont == null) {
            textFont = this.getItemFont();
        }
        if ((textPaint = item.getLabelPaint()) == null) {
            textPaint = this.getItemPaint();
        }
        LabelBlock labelBlock = new LabelBlock(item.getLabel(), textFont, textPaint);
        labelBlock.setPadding(this.getItemLabelPadding());
        legendItem.add((Block)labelBlock);
        legendItem.setToolTipText(item.getToolTipText());
        legendItem.setURLText(item.getURLText());
        result = new BlockContainer((Arrangement)new CenterArrangement());
        result.add((Block)legendItem);
        return result;
    }

    private Block createFlankedShapeLegendItem(FlankedShapeLegendItem item) {
        Paint textPaint;
        BlockContainer result = null;
        CustomLegendGraphic lg = new CustomLegendGraphic(item.getShape(), item.getFillPaint());
        lg.setFillPaintTransformer(item.getFillPaintTransformer());
        lg.setShapeFilled(item.isShapeFilled());
        lg.setLine(item.getLine());
        lg.setLineStroke(item.getLineStroke());
        lg.setLinePaint(item.getLinePaint());
        lg.setLineVisible(item.isLineVisible());
        lg.setShapeVisible(item.isShapeVisible());
        lg.setShapeOutlineVisible(item.isShapeOutlineVisible());
        lg.setOutlinePaint(item.getOutlinePaint());
        lg.setOutlineStroke(item.getOutlineStroke());
        lg.setPadding(this.getLegendItemGraphicPadding());
        LegendItemBlockContainer legendItem = new LegendItemBlockContainer((Arrangement)new BorderArrangement(), item.getDataset(), item.getSeriesKey());
        Font textFont = item.getLabelFont();
        if (textFont == null) {
            textFont = this.getItemFont();
        }
        if ((textPaint = item.getLabelPaint()) == null) {
            textPaint = this.getItemPaint();
        }
        ColoredBlockContainer graphicsContainer = new ColoredBlockContainer(new Color(0, 0, 0, 0), (Arrangement)new BorderArrangement());
        Font smallerTextFont = textFont.deriveFont((float)textFont.getSize() * 0.8f);
        Font labelTextFont = textFont;
        LabelBlock labelBlock = new LabelBlock(item.getLeftShapeLabel(), smallerTextFont, textPaint);
        graphicsContainer.add((Block)labelBlock, RectangleEdge.LEFT);
        graphicsContainer.add((Block)lg, null);
        labelBlock = new LabelBlock(item.getRightShapeLabel(), smallerTextFont, textPaint);
        graphicsContainer.add((Block)labelBlock, RectangleEdge.RIGHT);
        legendItem.add((Block)graphicsContainer, (Object)this.getLegendItemGraphicEdge());
        labelBlock = new LabelBlock(item.getLabel(), labelTextFont, textPaint);
        labelBlock.setPadding(this.getItemLabelPadding());
        legendItem.add((Block)labelBlock);
        legendItem.setToolTipText(item.getToolTipText());
        legendItem.setURLText(item.getURLText());
        result = new BlockContainer((Arrangement)new CenterArrangement());
        result.add((Block)legendItem);
        return result;
    }

    public static Paint transformLinearGradient(LinearGradientPaint paint, Shape target) {
        Rectangle2D bounds = target.getBounds2D();
        float left = (float)bounds.getMinX();
        float right = (float)bounds.getMaxX();
        LinearGradientPaint newPaint = new LinearGradientPaint(left, 0.0f, right, 0.0f, paint.getFractions(), paint.getColors());
        return newPaint;
    }
}

