/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart.link_and_brush.axis;

import com.owc.gui.charting.engine.jfreechart.link_and_brush.axis.LinkAndBrushAxis;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.chart.axis.DateAxis;
import org.jfree.data.Range;

public class CustomDateAxis
extends DateAxis
implements LinkAndBrushAxis {
    private static final long serialVersionUID = 1L;
    private double upperBoundCache = Double.NEGATIVE_INFINITY;
    private double lowerBoundCache = Double.POSITIVE_INFINITY;
    private double upperBoundWithoutMargin = Double.NEGATIVE_INFINITY;
    private double lowerBoundWithoutMargin = Double.POSITIVE_INFINITY;

    public CustomDateAxis() {
    }

    public CustomDateAxis(String label) {
        super(label);
    }

    public CustomDateAxis(String label, TimeZone zone, Locale locale) {
        super(label, zone, locale);
    }

    public void resizeRange(double percent, double anchorValue) {
        if (percent > 0.0) {
            double halfLength = this.getRange().getLength() * percent / 2.0;
            Range adjusted = new Range(anchorValue - halfLength, anchorValue + halfLength);
            this.setRange(adjusted);
        } else {
            this.restoreAutoRange(true);
        }
    }

    public void resizeRange2(double percent, double anchorValue) {
        if (percent > 0.0) {
            double left = anchorValue - this.getLowerBound();
            double right = this.getUpperBound() - anchorValue;
            Range adjusted = new Range(anchorValue - left * percent, anchorValue + right * percent);
            this.setRange(adjusted);
        } else {
            this.restoreAutoRange(true);
        }
    }

    @Override
    public Range calculateZoomRange(double lowerPercent, double upperPercent, boolean zoomIn) {
        double start = this.getRange().getLowerBound();
        double length = this.getRange().getLength();
        Range adjusted = null;
        adjusted = this.isInverted() ? new Range(start + length * (1.0 - upperPercent), start + length * (1.0 - lowerPercent)) : new Range(start + length * lowerPercent, start + length * upperPercent);
        if (zoomIn) {
            this.setRange(adjusted);
        }
        return adjusted;
    }

    @Override
    public Range restoreAutoRange(boolean zoomOut) {
        if (this.upperBoundCache < this.lowerBoundCache) {
            this.upperBoundCache = this.lowerBoundCache + 1.0;
        }
        Range autoRange = new Range(this.lowerBoundCache, this.upperBoundCache);
        if (zoomOut) {
            this.setRange(autoRange);
        }
        return new Range(this.lowerBoundWithoutMargin, this.upperBoundWithoutMargin);
    }

    public void setLowerBound(double min) {
        if (this.getRange().getUpperBound() > min) {
            this.lowerBoundCache = min;
            this.setRange(new Range(min, this.getRange().getUpperBound()));
        } else {
            this.lowerBoundCache = min + 1.0;
            this.setRange(new Range(min, min + 1.0));
        }
    }

    public void setUpperBound(double max) {
        if (this.getRange().getLowerBound() < max) {
            this.upperBoundCache = max;
            this.setRange(new Range(this.getRange().getLowerBound(), max));
        } else {
            this.upperBoundCache = max - 1.0;
            this.setRange(max - 1.0, max);
        }
    }

    @Override
    public void saveUpperBound(double max, double maxWOMargin) {
        this.setUpperBound(max);
        this.upperBoundWithoutMargin = maxWOMargin;
    }

    @Override
    public void saveLowerBound(double min, double minWOMargin) {
        this.setLowerBound(min);
        this.lowerBoundWithoutMargin = minWOMargin;
    }
}

