/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart.link_and_brush.listener;

import com.owc.gui.charting.data.PlotInstance;
import com.rapidminer.tools.container.Pair;
import java.util.List;
import org.jfree.data.Range;

public class LinkAndBrushSelection {
    private final List<Pair<Integer, Range>> domainAxisRanges;
    private final List<Pair<Integer, Range>> valueAxisRanges;
    private final SelectionType type;
    private Double minColorValue;
    private Double maxColorValue;
    private PlotInstance plotInstance;

    public LinkAndBrushSelection(SelectionType type, List<Pair<Integer, Range>> domainAxisRanges, List<Pair<Integer, Range>> rangeAxisRanges) {
        this(type, domainAxisRanges, rangeAxisRanges, null, null, null);
    }

    public LinkAndBrushSelection(SelectionType type, List<Pair<Integer, Range>> domainAxisRanges, List<Pair<Integer, Range>> rangeAxisRanges, Double minColorValue, Double maxColorValue, PlotInstance plotInstance) {
        if (domainAxisRanges == null || rangeAxisRanges == null) {
            throw new IllegalArgumentException("Null range axes are not allowed!");
        }
        this.type = type;
        this.domainAxisRanges = domainAxisRanges;
        this.valueAxisRanges = rangeAxisRanges;
        this.minColorValue = minColorValue;
        this.maxColorValue = maxColorValue;
        this.plotInstance = plotInstance;
    }

    public List<Pair<Integer, Range>> getDomainAxisRanges() {
        return this.domainAxisRanges;
    }

    public Pair<Integer, Range> getDomainAxisRange() {
        if (this.domainAxisRanges.size() > 0) {
            return this.domainAxisRanges.get(0);
        }
        return null;
    }

    public SelectionType getType() {
        return this.type;
    }

    public List<Pair<Integer, Range>> getValueAxisRanges() {
        return this.valueAxisRanges;
    }

    public Double getMinColorValue() {
        return this.minColorValue;
    }

    public Double getMaxColorValue() {
        return this.maxColorValue;
    }

    public PlotInstance getPlotInstance() {
        return this.plotInstance;
    }

    public void setPlotInstance(PlotInstance plotInstance) {
        this.plotInstance = plotInstance;
    }

    public static enum SelectionType {
        ZOOM_IN,
        ZOOM_OUT,
        RESTORE_AUTO_BOUNDS,
        SELECTION,
        RESTORE_SELECTION,
        COLOR_ZOOM,
        COLOR_SELECTION,
        RESTORE_COLOR;

    }
}

