/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart.link_and_brush.plots;

import com.owc.gui.charting.engine.jfreechart.link_and_brush.axis.LinkAndBrushAxis;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.plots.LinkAndBrushPlot;
import com.rapidminer.tools.container.Pair;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;

public class LinkAndBrushXYPlot
extends XYPlot
implements LinkAndBrushPlot {
    private static final long serialVersionUID = 1L;

    @Override
    public List<Pair<Integer, Range>> calculateDomainAxesZoom(double lowerPercent, double upperPercent, boolean zoomIn) {
        LinkedList<Pair<Integer, Range>> newRanges = new LinkedList<Pair<Integer, Range>>();
        for (int i = 0; i < this.getDomainAxisCount(); ++i) {
            ValueAxis domainAxis = this.getDomainAxis(i);
            if (domainAxis == null) continue;
            if (domainAxis instanceof LinkAndBrushAxis) {
                Range calculateZoomRange = ((LinkAndBrushAxis)domainAxis).calculateZoomRange(lowerPercent, upperPercent, zoomIn);
                newRanges.add((Pair<Integer, Range>)new Pair((Object)i, (Object)calculateZoomRange));
                continue;
            }
            if (!zoomIn) continue;
            domainAxis.zoomRange(lowerPercent, upperPercent);
        }
        return newRanges;
    }

    @Override
    public List<Pair<Integer, Range>> calculateRangeAxesZoom(double lowerPercent, double upperPercent, PlotRenderingInfo info, Point2D source, boolean zoomIn) {
        LinkedList<Pair<Integer, Range>> newRanges = new LinkedList<Pair<Integer, Range>>();
        for (int i = 0; i < this.getRangeAxisCount(); ++i) {
            ValueAxis rangeAxis = this.getRangeAxis(i);
            if (rangeAxis == null) continue;
            if (rangeAxis instanceof LinkAndBrushAxis) {
                Range calculateZoomRange = ((LinkAndBrushAxis)rangeAxis).calculateZoomRange(lowerPercent, upperPercent, zoomIn);
                newRanges.add((Pair<Integer, Range>)new Pair((Object)i, (Object)calculateZoomRange));
                continue;
            }
            if (!zoomIn) continue;
            rangeAxis.zoomRange(lowerPercent, upperPercent);
        }
        return newRanges;
    }

    @Override
    public List<Pair<Integer, Range>> restoreAutoDomainAxisBounds(boolean zoomOut) {
        LinkedList<Pair<Integer, Range>> newRanges = new LinkedList<Pair<Integer, Range>>();
        for (int i = 0; i < this.getDomainAxisCount(); ++i) {
            ValueAxis domainAxis = this.getDomainAxis(i);
            if (domainAxis == null || !(domainAxis instanceof LinkAndBrushAxis)) continue;
            Range zoomedOutRange = ((LinkAndBrushAxis)domainAxis).restoreAutoRange(zoomOut);
            newRanges.add((Pair<Integer, Range>)new Pair((Object)i, (Object)zoomedOutRange));
        }
        return newRanges;
    }

    @Override
    public List<Pair<Integer, Range>> restoreAutoRangeAxisBounds(boolean zoomOut) {
        LinkedList<Pair<Integer, Range>> newRanges = new LinkedList<Pair<Integer, Range>>();
        for (int i = 0; i < this.getRangeAxisCount(); ++i) {
            ValueAxis rangeAxis = this.getRangeAxis(i);
            if (rangeAxis == null || !(rangeAxis instanceof LinkAndBrushAxis)) continue;
            Range zoomedOutRange = ((LinkAndBrushAxis)rangeAxis).restoreAutoRange(zoomOut);
            newRanges.add((Pair<Integer, Range>)new Pair((Object)i, (Object)zoomedOutRange));
        }
        return newRanges;
    }
}

