/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart.renderer;

import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.engine.jfreechart.RenderFormatDelegate;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedRenderer;
import com.owc.gui.charting.listener.RenderFormatDelegateChangeListener;
import com.owc.gui.charting.utility.DataStructureUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import org.jfree.chart.renderer.category.StatisticalLineAndShapeRenderer;

public class FormattedStatisticalLineAndShapeRenderer
extends StatisticalLineAndShapeRenderer
implements FormattedRenderer,
RenderFormatDelegateChangeListener {
    private static final long serialVersionUID = 1L;
    private RenderFormatDelegate formatDelegate = new RenderFormatDelegate();

    public FormattedStatisticalLineAndShapeRenderer() {
        this.formatDelegate.addListener(this);
    }

    public FormattedStatisticalLineAndShapeRenderer(boolean linesVisible, boolean shapesVisible) {
        super(linesVisible, shapesVisible);
    }

    @Override
    public RenderFormatDelegate getFormatDelegate() {
        return this.formatDelegate;
    }

    public Paint getItemPaint(int seriesIdx, int valueIdx) {
        Paint paintFromDelegate = this.getFormatDelegate().getItemPaint(seriesIdx, valueIdx);
        if (paintFromDelegate == null) {
            return super.getItemPaint(seriesIdx, valueIdx);
        }
        return paintFromDelegate;
    }

    public Shape getItemShape(int seriesIdx, int valueIdx) {
        Shape shapeFromDelegate = this.getFormatDelegate().getItemShape(seriesIdx, valueIdx);
        if (shapeFromDelegate == null) {
            return super.getItemShape(seriesIdx, valueIdx);
        }
        return shapeFromDelegate;
    }

    @Override
    public void renderFormatDelegateChanged(RenderFormatDelegate source) {
        SeriesFormat seriesFormat = source.getSeriesFormat();
        if (seriesFormat != null) {
            this.setErrorIndicatorStroke(new BasicStroke(Math.round((double)seriesFormat.getLineWidth() / 2.0), 2, 0));
        }
    }

    public Paint getItemOutlinePaint(int seriesIdx, int valueIdx) {
        if (this.getFormatDelegate().isItemSelected(seriesIdx, valueIdx)) {
            return super.getItemOutlinePaint(seriesIdx, valueIdx);
        }
        return DataStructureUtils.setColorAlpha(Color.LIGHT_GRAY, 20);
    }
}

