/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart.renderer;

import com.owc.gui.charting.StaticDebug;
import com.owc.gui.charting.engine.jfreechart.RenderFormatDelegate;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedRenderer;
import com.owc.gui.charting.utility.DataStructureUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;

public class FormattedXYDifferenceRenderer
extends XYDifferenceRenderer
implements FormattedRenderer {
    private static final long serialVersionUID = 1L;
    private RenderFormatDelegate formatDelegate = new RenderFormatDelegate();
    private int trueSeriesIdx;

    public FormattedXYDifferenceRenderer(int trueSeriesIdx) {
        this.trueSeriesIdx = trueSeriesIdx;
    }

    @Override
    public RenderFormatDelegate getFormatDelegate() {
        return this.formatDelegate;
    }

    public Paint getItemPaint(int seriesIdx, int valueIdx) {
        Paint paintFromDelegate = this.getFormatDelegate().getItemPaint(this.trueSeriesIdx, valueIdx);
        if (paintFromDelegate == null) {
            return super.getItemPaint(seriesIdx, valueIdx);
        }
        return paintFromDelegate;
    }

    public Shape getItemShape(int seriesIdx, int valueIdx) {
        Shape shapeFromDelegate = this.getFormatDelegate().getItemShape(seriesIdx, valueIdx);
        if (shapeFromDelegate == null) {
            return super.getItemShape(seriesIdx, valueIdx);
        }
        return shapeFromDelegate;
    }

    public Paint getPositivePaint() {
        StaticDebug.debug("getPositivePaint(): " + this.trueSeriesIdx);
        Color color = this.getFormatDelegate().getSeriesColor(this.trueSeriesIdx);
        if (color != null) {
            return DataStructureUtils.setColorAlpha(color, color.getAlpha() / 2);
        }
        return super.getPositivePaint();
    }

    public Paint getNegativePaint() {
        StaticDebug.debug("getNegativePaint(): " + this.trueSeriesIdx);
        Color color = this.getFormatDelegate().getSeriesColor(this.trueSeriesIdx);
        if (color != null) {
            return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha() / 2);
        }
        return super.getNegativePaint();
    }

    public Paint getItemOutlinePaint(int seriesIdx, int valueIdx) {
        if (this.getFormatDelegate().isItemSelected(seriesIdx, valueIdx)) {
            return super.getItemOutlinePaint(seriesIdx, valueIdx);
        }
        return DataStructureUtils.setColorAlpha(Color.LIGHT_GRAY, 20);
    }
}

