/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.AbstractConfigurationPanel;
import com.owc.gui.charting.gui.treenodes.ValueSourceTreeNode;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeSelectionDependentPanel
extends AbstractConfigurationPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private ValueSource currentValueSource = null;
    private ValueSourceTreeNode valueSourceNode = null;

    public AbstractTreeSelectionDependentPanel(JTree plotConfigurationTree, PlotInstance plotInstance) {
        super(plotInstance);
        plotConfigurationTree.addTreeSelectionListener(this);
    }

    public ValueSource getSelectedValueSource() {
        return this.currentValueSource;
    }

    public ValueSourceTreeNode getSelectedValueSourceTreeNode() {
        return this.valueSourceNode;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
        if (newLeadSelectionPath == null) {
            return;
        }
        Object lastPathComponent = newLeadSelectionPath.getLastPathComponent();
        if (lastPathComponent instanceof ValueSourceTreeNode) {
            this.valueSourceNode = (ValueSourceTreeNode)lastPathComponent;
            ValueSource selectedValueSource = this.valueSourceNode.getUserObject();
            if (selectedValueSource == this.currentValueSource) {
                return;
            }
            this.currentValueSource = selectedValueSource;
            this.adaptGUI();
        } else {
            this.currentValueSource = null;
            this.valueSourceNode = null;
        }
    }
}

