/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.gui.dnd.DataTableColumnDropTextFieldTransferHandler;
import com.owc.gui.charting.gui.dnd.DataTableColumnListTransferHandler;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dnd.DragListener;
import com.rapidminer.gui.flow.processrendering.draw.ProcessDrawer;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.border.Border;

public class AttributeDropTextField
extends JTextField
implements DragListener {
    private static final long serialVersionUID = 1L;
    private Border ongoingDropBorder;
    private Border dropEndedBorder;

    public AttributeDropTextField(JTree plotConfigurationTree, DataTableColumnListTransferHandler th, ValueSource.SeriesUsageType type) {
        th.addDragListener(this);
        this.setFocusable(false);
        this.setEditable(false);
        this.setBackground(Color.white);
        this.setTransferHandler((TransferHandler)((Object)new DataTableColumnDropTextFieldTransferHandler(plotConfigurationTree, type, this)));
        this.ongoingDropBorder = BorderFactory.createLineBorder(ProcessDrawer.BORDER_DRAG_COLOR, 1);
        this.dropEndedBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    }

    public void dragStarted(Transferable t) {
        TransferHandler.TransferSupport support = new TransferHandler.TransferSupport((Component)this, t);
        boolean doesSupportFlavor = ((DataTableColumnDropTextFieldTransferHandler)((Object)this.getTransferHandler())).doesSupportFlavor(support);
        if (doesSupportFlavor) {
            switch (RapidMinerGUI.getDragHighlighteMode()) {
                case FULL: {
                    this.setBackground(ProcessDrawer.INNER_DRAG_COLOR);
                }
                case BORDER: {
                    this.setBorder(this.ongoingDropBorder);
                    break;
                }
            }
        }
    }

    public void dragEnded() {
        this.setBorder(this.dropEndedBorder);
        this.setBackground(Color.WHITE);
    }
}

