/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.AbstractConfigurationPanel;
import com.owc.gui.charting.gui.FontDialog;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.tools.I18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AxisConfigurationContainer
extends AbstractConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private ResourceLabel axesFontLabel;
    private JButton axesFontChooserButton;
    private JSpinner domainAxisWidthSpinner;
    private JButton domainAxisLineColorChooserButton;
    private final int fontSize = 12;

    public AxisConfigurationContainer(PlotInstance plotInstance) {
        super(plotInstance);
        this.createComponents();
        this.registerAsPlotConfigurationListener();
        this.adaptGUI();
    }

    private void createComponents() {
        this.axesFontLabel = new ResourceLabel("plotter.configuration_dialog.axes_font", new Object[0]);
        this.axesFontChooserButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.axis_font", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                AxisConfigurationContainer.this.createAxesFontDialog();
            }
        });
        this.axesFontLabel.setLabelFor((Component)this.axesFontChooserButton);
        this.addTwoComponentRow(this, (JComponent)this.axesFontLabel, this.axesFontChooserButton);
        ResourceLabel domainAxisLineColorLabel = new ResourceLabel("plotter.configuration_dialog.global_config_panel.axis_color", new Object[0]);
        this.domainAxisLineColorChooserButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.global_config_panel.axis_color", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                AxisConfigurationContainer.this.createDomainAxisColorDialog();
            }
        });
        domainAxisLineColorLabel.setLabelFor(this.domainAxisLineColorChooserButton);
        this.addTwoComponentRow(this, (JComponent)domainAxisLineColorLabel, this.domainAxisLineColorChooserButton);
        ResourceLabel domainAxisWidthLabel = new ResourceLabel("plotter.configuration_dialog.global_config_panel.axis_width", new Object[0]);
        this.domainAxisWidthSpinner = new JSpinner(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), null, (Number)1.0));
        domainAxisWidthLabel.setLabelFor(this.domainAxisWidthSpinner);
        this.domainAxisWidthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Double value = (Double)AxisConfigurationContainer.this.domainAxisWidthSpinner.getValue();
                AxisConfigurationContainer.this.getPlotConfiguration().setAxisLineWidth(value.floatValue());
            }
        });
        this.addTwoComponentRow(this, (JComponent)domainAxisWidthLabel, this.domainAxisWidthSpinner);
    }

    @Override
    protected void adaptGUI() {
        Font axesFont = this.getPlotConfiguration().getAxesFont();
        if (axesFont != null) {
            this.axesFontLabel.setFont(new Font(axesFont.getFamily(), axesFont.getStyle(), 12));
        }
        this.domainAxisLineWidthChanged(Float.valueOf(this.getPlotConfiguration().getAxisLineWidth()));
    }

    private void domainAxisLineWidthChanged(Float domainAxisLineWidth) {
        this.domainAxisWidthSpinner.setValue(domainAxisLineWidth.doubleValue());
    }

    private void createDomainAxisColorDialog() {
        Color newLineColor;
        Color oldColor = this.getPlotConfiguration().getAxisLineColor();
        if (oldColor == null) {
            oldColor = Color.black;
        }
        if ((newLineColor = JColorChooser.showDialog(this, I18N.getGUILabel((String)"plotter.configuration_dialog.global_config_panel.plot_background_color_title.label", (Object[])new Object[0]), oldColor)) != null && !newLineColor.equals(oldColor)) {
            this.getPlotConfiguration().setAxisLineColor(newLineColor);
        }
    }

    private void createAxesFontDialog() {
        Font axesFont = this.getPlotConfiguration().getAxesFont();
        if (axesFont == null) {
            axesFont = PlotConfiguration.DEFAULT_AXES_FONT;
        }
        FontDialog fontDialog = new FontDialog(this, axesFont, "plotter.configuration_dialog.global_config_panel.select_axes_font");
        fontDialog.setVisible(true);
        fontDialog.requestFocus();
        if (fontDialog.getReturnStatus() == 1) {
            this.getPlotConfiguration().setAxesFont(fontDialog.getFont());
        }
        fontDialog.dispose();
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        PlotConfigurationChangeEvent.PlotConfigurationChangeType type = change.getType();
        switch (type) {
            case META_CHANGE: {
                this.adaptGUI();
                break;
            }
            case AXES_FONT: {
                this.adaptGUI();
                break;
            }
            case AXIS_LINE_WIDTH: {
                this.adaptGUI();
                break;
            }
        }
        return true;
    }
}

