/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.MasterOfDesaster;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.engine.jfreechart.JFreeChartPlotEngine;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.LinkAndBrushChartPanel;
import com.owc.gui.charting.gui.AbstractConfigurationPanel;
import com.owc.gui.charting.gui.AttributeSelectionDialog;
import com.owc.gui.charting.gui.DimensionConfigPanel;
import com.owc.gui.charting.gui.GlobalConfigurationPanel;
import com.owc.gui.charting.gui.PlotConfigurationTree;
import com.owc.gui.charting.gui.PlotConfigurationTreeModel;
import com.owc.gui.charting.gui.RangeAxisConfigPanel;
import com.owc.gui.charting.gui.ValueSourceConfigurationPanel;
import com.owc.gui.charting.gui.cellrenderer.DataTableColumnListCellRenderer;
import com.owc.gui.charting.gui.cellrenderer.EnumComboBoxCellRenderer;
import com.owc.gui.charting.gui.dnd.DataTableColumnListTransferHandler;
import com.owc.gui.charting.gui.dnd.PlotConfigurationTreeTransferHandler;
import com.owc.gui.charting.gui.treenodes.DimensionConfigTreeNode;
import com.owc.gui.charting.gui.treenodes.PlotConfigurationTreeNode;
import com.owc.gui.charting.gui.treenodes.RangeAxisConfigTreeNode;
import com.owc.gui.charting.gui.treenodes.ValueSourceTreeNode;
import com.owc.gui.charting.listener.MasterOfDesasterListener;
import com.owc.gui.charting.listener.PlotConfigurationProcessingListener;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.owc.gui.charting.utility.DataTransformation;
import com.owc.objects.charting.ChartConfigurationObject;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableExampleSetAdapter;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.export.PrintableComponent;
import com.rapidminer.gui.dnd.DragListener;
import com.rapidminer.gui.flow.processrendering.draw.ProcessDrawer;
import com.rapidminer.gui.tools.ExtendedHTMLJEditorPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import com.rapidminer.tools.I18N;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.RuntimeErrorException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ChartConfigurationPanel
extends AbstractConfigurationPanel
implements MasterOfDesasterListener,
DragListener,
PlotConfigurationProcessingListener,
PrintableComponent {
    private static final Insets STANDARD_INSETS = new Insets(2, 2, 2, 2);
    private static final long serialVersionUID = 1L;
    private static final int LEFT_SIDE_WIDTH = 100;
    private static final Dimension MAX_LIST_AND_TREE_DIMENSION = new Dimension(100, 300);
    private static final Dimension MIN_LIST_AND_TREE_DIMENSION = new Dimension(100, 100);
    private static final Dimension PREFFERED_LIST_AND_TREE_DIMENSION = new Dimension(100, 170);
    private static final int PREFERRED_CHART_HEIGTH = 500;
    private static final int PERFERRED_CHART_WIDTH = 600;
    private static final int MAX_CHART_HEIGTH = 650;
    private static final int MAX_CHART_WIDTH = 780;
    private static final int MIN_CHART_HEIGTH = 200;
    private static final int MIN_CHART_WIDTH = 200;
    private static final Dimension PREFERRED_CHART_SIZE = new Dimension(600, 500);
    private static final Dimension MAX_CHART_SIZE = new Dimension(780, 650);
    private static final Dimension MIN_CHART_SIZE = new Dimension(200, 200);
    private static final String EMPTY = "Empty";
    private static final String GLOBAL_CONFIG = "GlobalConfig";
    private static final String RANGE_AXIS_CONFIG = "RangeAxisConfig";
    private static final String VALUE_SOURCE_CONFIG = "ValueSourceConfig";
    private static final String COLOR_DIMENSION_CONFIG = "ColorDimensionConfig";
    private static final String SIZE_DIMENSION_CONFIG = "SizeDimensionConfig";
    private static final String SHAPE_DIMENSION_CONFIG = "ShapeDimensionConfig";
    private static final String DOMAIN_DIMENSION = "DomainDimension";
    private DataTable dataTable;
    private final JFreeChartPlotEngine plotEngine;
    private final LinkAndBrushChartPanel chartPanel;
    private JList<DataTableColumn> attributeList = new JList();
    private ExtendedHTMLJEditorPane statusTextArea;
    private PlotConfigurationTree plotConfigurationTree;
    private JPanel configurationContainerPanel;
    private final boolean smallIcons;
    private boolean allowCollapse = true;
    private DataTableColumnListTransferHandler attributeListTransferHandler;
    private JPopupMenu rangeAxisPopupMenu = new JPopupMenu("Remove Axis");
    private JPopupMenu valueSourcePopupMenu;
    private JPopupMenu dimensionConfigPopupMenu;
    private static final Color DROP_BORDER_COLOR = ProcessDrawer.BORDER_DRAG_COLOR;
    private static final Border ONGOING_DROP_BORDER = BorderFactory.createLineBorder(DROP_BORDER_COLOR, 2);
    private static final Border DROP_ENDED_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private JScrollPane plotConfigurationTreeScrollPane;
    private PlotConfigurationTreeTransferHandler plotConfigurationTreeTransferHandler;
    private JPanel leftSideConfigPanel;
    private JPanel leftSideShowHiddenPanel;
    private JScrollPane chartPanelScrollPane;
    private JScrollPane statusTextAreaScrollPane;
    private MasterOfDesaster masterOfDesaster;
    private JButton resetButton;
    private JMenuItem removeRangeAxisMenuItem;
    private JMenuItem removeAttributeFromDimensionMenuItem;
    private transient DataTable cachedDePivotedDataTable;
    private JComboBox<AbstractConfigurationPanel.DatasetTransformationType> datasetTransformationSelectionComboBox;
    private JButton configureDataSetTransformationButton;
    private PlotConfiguration dePivotedPlotConfig;
    private String exampleSetSource = null;

    public ChartConfigurationPanel(boolean smallIcons, PlotInstance plotInstance, DataTable dataTable, PlotConfiguration dePivotedPlotConfig, String exampleSetSource) {
        this(smallIcons, plotInstance, dataTable, dePivotedPlotConfig);
        this.exampleSetSource = exampleSetSource;
    }

    public ChartConfigurationPanel(boolean smallIcons, PlotInstance plotInstance, DataTable dataTable) {
        super(plotInstance);
        this.smallIcons = smallIcons;
        this.dataTable = dataTable;
        this.cachedDePivotedDataTable = null;
        this.plotEngine = new JFreeChartPlotEngine(plotInstance, true);
        this.chartPanel = this.plotEngine.getChartPanel();
        this.plotEngine.startInitializing();
        this.masterOfDesaster = plotInstance.getMasterOfDesaster();
        this.createComponents();
        this.registerAsPlotConfigurationListener();
        this.plotConfigurationTree.setSelectionPath(this.plotConfigurationTree.getPathForRow(0));
        this.masterOfDesaster.addListener(this);
        this.attributeListTransferHandler.addDragListener(this);
        this.plotConfigurationTreeTransferHandler.addDragListener(this);
        this.attributeList.requestFocusInWindow();
        this.plotConfigurationTree.expandAll();
        this.plotEngine.endInitializing();
    }

    public ChartConfigurationPanel(boolean smallIcons, PlotInstance plotInstance, DataTable dataTable, PlotConfiguration dePivotedPlotConfig) {
        this(smallIcons, plotInstance, dataTable);
        this.dePivotedPlotConfig = dePivotedPlotConfig;
    }

    private DataTable getDePivotedDataTable(Collection<String> excludedNumericalAttributeList, Collection<String> selectedNominalToNumericAttributesList) {
        if (this.cachedDePivotedDataTable == null || selectedNominalToNumericAttributesList != null || excludedNumericalAttributeList != null) {
            Vector<DataTableColumn> dataTableColumns = this.assembleDataTableColumnList(this.dataTable);
            ArrayList<String> selectedNumericAttributes = new ArrayList<String>();
            for (DataTableColumn column : dataTableColumns) {
                if (!column.isNumerical() || excludedNumericalAttributeList.contains(column.getName())) continue;
                selectedNumericAttributes.add(column.getName());
            }
            ExampleSet metaSet = DataTransformation.createDePivotizedExampleSet(DataTableExampleSetAdapter.createExampleSetFromDataTable((DataTable)this.dataTable), selectedNumericAttributes, selectedNominalToNumericAttributesList);
            if (metaSet == null) {
                return null;
            }
            this.cachedDePivotedDataTable = new DataTableExampleSetAdapter(metaSet, null);
        }
        return this.cachedDePivotedDataTable;
    }

    @Override
    public void print(Graphics pg) {
        JPanel printPanel = new JPanel(){
            private static final long serialVersionUID = 7315234075649335574L;

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                ChartConfigurationPanel.this.plotEngine.getChartPanel().print(g2);
            }
        };
        Insets insets = this.plotEngine.getChartPanel().getInsets();
        int w = this.plotEngine.getChartPanel().getWidth() - insets.left - insets.right;
        int h = this.plotEngine.getChartPanel().getHeight() - insets.top - insets.bottom;
        printPanel.setSize(new Dimension(w, h));
        printPanel.print(pg);
    }

    private void createPopups() {
        this.rangeAxisPopupMenu = new JPopupMenu();
        this.removeRangeAxisMenuItem = new JMenuItem(I18N.getGUILabel((String)"plotter.configuration_dialog.remove_axis_menu_item.label", (Object[])new Object[0]));
        this.removeRangeAxisMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartConfigurationPanel.this.removeRangeAxisAction();
            }
        });
        this.rangeAxisPopupMenu.add(this.removeRangeAxisMenuItem);
        this.valueSourcePopupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(I18N.getGUILabel((String)"plotter.configuration_dialog.remove_source_menu_item.label", (Object[])new Object[0]));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartConfigurationPanel.this.removeValueSourceAction();
            }
        });
        this.valueSourcePopupMenu.add(menuItem);
        this.dimensionConfigPopupMenu = new JPopupMenu();
        this.removeAttributeFromDimensionMenuItem = new JMenuItem(I18N.getGUILabel((String)"plotter.configuration_dialog.remove_attribute_menu_item.label", (Object[])new Object[0]));
        this.removeAttributeFromDimensionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartConfigurationPanel.this.removeAttributeFromDimensionAction();
            }
        });
        this.dimensionConfigPopupMenu.add(this.removeAttributeFromDimensionMenuItem);
    }

    private PlotInstance getNewDePivotedPlotInstance(PlotConfiguration newPlotConfig, Collection<String> excludedNumericalAttributeList, Collection<String> selectedNominalToNumericAttributesList) {
        DataTable transformed = this.getDePivotedDataTable(excludedNumericalAttributeList, selectedNominalToNumericAttributesList);
        if (transformed == null) {
            return null;
        }
        if (newPlotConfig == null) {
            newPlotConfig = new PlotConfiguration(new DataTableColumn("-Empty-", DataTableColumn.ValueType.INVALID));
        }
        PlotInstance plotInstance = new PlotInstance(newPlotConfig, transformed);
        return plotInstance;
    }

    private void createComponents() {
        this.setLayout(new GridBagLayout());
        this.createPopups();
        GridBagConstraints itemConstraint = new GridBagConstraints();
        this.leftSideConfigPanel = this.createLeftSidePanel();
        itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 0.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.insets = new Insets(5, 10, 2, 2);
        this.add((Component)this.leftSideConfigPanel, itemConstraint);
        this.leftSideShowHiddenPanel = new JPanel(new GridBagLayout());
        this.leftSideShowHiddenPanel.setBackground(Color.red);
        JButton showConfigButton = new JButton((Action)new ResourceAction(this.smallIcons, "plotter.configuration_dialog.show_configuration", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ChartConfigurationPanel.this.leftSideShowHiddenPanel.setVisible(false);
                ChartConfigurationPanel.this.leftSideConfigPanel.setVisible(true);
                ChartConfigurationPanel.this.statusTextArea.setVisible(true);
                ChartConfigurationPanel.this.statusTextAreaScrollPane.setVisible(true);
                ChartConfigurationPanel.this.chartPanel.chartChanged(null);
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.insets = STANDARD_INSETS;
        itemConstraint.anchor = 11;
        itemConstraint.weightx = 0.0;
        itemConstraint.weighty = 0.0;
        itemConstraint.fill = 0;
        itemConstraint.gridwidth = 0;
        this.leftSideShowHiddenPanel.add((Component)showConfigButton, itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.anchor = 15;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.fill = 1;
        itemConstraint.gridwidth = 0;
        this.leftSideShowHiddenPanel.add((Component)new JPanel(), itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.insets = STANDARD_INSETS;
        itemConstraint.weightx = 0.0;
        itemConstraint.weighty = 1.0;
        this.leftSideShowHiddenPanel.setVisible(false);
        this.add((Component)this.leftSideShowHiddenPanel, itemConstraint);
        JPanel rightSidePanel = this.createRightSidePanel();
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = 0;
        itemConstraint.insets = STANDARD_INSETS;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.fill = 1;
        this.add((Component)rightSidePanel, itemConstraint);
    }

    private JPanel createRightSidePanel() {
        JPanel rightSidePanel = new JPanel(new GridBagLayout());
        this.chartPanelScrollPane = new JScrollPane(this.chartPanel);
        this.chartPanelScrollPane.setPreferredSize(PREFERRED_CHART_SIZE);
        this.chartPanelScrollPane.setMaximumSize(MAX_CHART_SIZE);
        this.chartPanelScrollPane.setMinimumSize(MIN_CHART_SIZE);
        this.chartPanelScrollPane.setBorder(null);
        this.chartPanelScrollPane.setHorizontalScrollBarPolicy(30);
        this.chartPanelScrollPane.setVerticalScrollBarPolicy(20);
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 0.5;
        itemConstraint.gridwidth = 0;
        itemConstraint.insets = STANDARD_INSETS;
        rightSidePanel.add((Component)this.chartPanelScrollPane, itemConstraint);
        this.statusTextArea = new ExtendedHTMLJEditorPane("", this.masterOfDesaster.toHtmlString());
        this.statusTextArea.installDefaultStylesheet();
        this.statusTextArea.setEditable(false);
        this.statusTextArea.setFocusable(false);
        this.statusTextArea.setDoubleBuffered(true);
        this.statusTextAreaScrollPane = new JScrollPane((Component)this.statusTextArea);
        this.statusTextAreaScrollPane.setHorizontalScrollBarPolicy(31);
        this.statusTextAreaScrollPane.setPreferredSize(new Dimension(600, 100));
        this.statusTextAreaScrollPane.setMinimumSize(new Dimension(200, 70));
        this.statusTextAreaScrollPane.setMaximumSize(new Dimension(780, 120));
        this.statusTextAreaScrollPane.setWheelScrollingEnabled(true);
        itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 0.1;
        itemConstraint.gridwidth = 0;
        itemConstraint.insets = STANDARD_INSETS;
        rightSidePanel.add((Component)this.statusTextAreaScrollPane, itemConstraint);
        return rightSidePanel;
    }

    private JPanel createLeftSidePanel() {
        GridBagConstraints itemConstraint = new GridBagConstraints();
        Insets standardInsets = STANDARD_INSETS;
        JPanel leftSidePanel = new JPanel(new GridBagLayout());
        JPanel datasetTranformationContainerPanel = new JPanel(new GridBagLayout());
        ResourceLabel datasetTransformationLabel = new ResourceLabel("plotter.datasetTransformation", new Object[0]);
        datasetTransformationLabel.setFont(datasetTransformationLabel.getFont().deriveFont(1));
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 0;
        itemConstraint.weightx = 0.0;
        itemConstraint.gridwidth = 1;
        itemConstraint.anchor = 17;
        itemConstraint.insets = new Insets(0, 0, 0, 5);
        datasetTranformationContainerPanel.add((Component)datasetTransformationLabel, itemConstraint);
        this.datasetTransformationSelectionComboBox = new JComboBox<AbstractConfigurationPanel.DatasetTransformationType>(AbstractConfigurationPanel.DatasetTransformationType.values());
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = 0;
        itemConstraint.fill = 2;
        itemConstraint.insets = standardInsets;
        this.datasetTransformationSelectionComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (ChartConfigurationPanel.this.datasetTransformationSelectionComboBox.getSelectedItem() != ChartConfigurationPanel.this.getCurrentTranformationType()) {
                    AbstractConfigurationPanel.DatasetTransformationType type = (AbstractConfigurationPanel.DatasetTransformationType)((Object)ChartConfigurationPanel.this.datasetTransformationSelectionComboBox.getSelectedItem());
                    if (!ChartConfigurationPanel.this.changeDatatableTransformationType(type, false)) {
                        ChartConfigurationPanel.this.datasetTransformationSelectionComboBox.setSelectedItem((Object)ChartConfigurationPanel.this.getCurrentTranformationType());
                    }
                    ChartConfigurationPanel.this.configureDataSetTransformationButton.setEnabled((AbstractConfigurationPanel.DatasetTransformationType)((Object)ChartConfigurationPanel.this.datasetTransformationSelectionComboBox.getSelectedItem()) != AbstractConfigurationPanel.DatasetTransformationType.ORIGINAL);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.datasetTransformationSelectionComboBox.setRenderer(new EnumComboBoxCellRenderer("plotter.DatasetTransformationType"));
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = -1;
        itemConstraint.fill = 2;
        datasetTranformationContainerPanel.add(this.datasetTransformationSelectionComboBox, itemConstraint);
        this.configureDataSetTransformationButton = new JButton((Action)new ResourceAction(this.smallIcons, "plotter.configure_dataset_transformation", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                AbstractConfigurationPanel.DatasetTransformationType type = (AbstractConfigurationPanel.DatasetTransformationType)((Object)ChartConfigurationPanel.this.datasetTransformationSelectionComboBox.getSelectedItem());
                ChartConfigurationPanel.this.changeDatatableTransformationType(type, true);
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 2;
        itemConstraint.weightx = 0.0;
        itemConstraint.gridwidth = 0;
        itemConstraint.fill = 0;
        this.configureDataSetTransformationButton.setEnabled(false);
        datasetTranformationContainerPanel.add((Component)this.configureDataSetTransformationButton, itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = 0;
        itemConstraint.fill = 2;
        leftSidePanel.add((Component)datasetTranformationContainerPanel, itemConstraint);
        ResourceLabel attributeListLabel = new ResourceLabel("plotter.configuration_dialog.attribute_list", new Object[0]);
        Font oldFont = attributeListLabel.getFont();
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 2));
        attributeListLabel.setFont(new Font(oldFont.getFamily(), 1, oldFont.getSize()));
        labelPanel.add((Component)attributeListLabel);
        labelPanel.add(new JLabel(" "));
        ResourceLabel dragLabel = new ResourceLabel("plotter.configuration_dialog.drag_from_here", new Object[0]);
        labelPanel.add((Component)dragLabel);
        labelPanel.add(Box.createHorizontalGlue());
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 0.0;
        itemConstraint.fill = 2;
        itemConstraint.gridwidth = -1;
        itemConstraint.insets = STANDARD_INSETS;
        leftSidePanel.add((Component)labelPanel, itemConstraint);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        JButton saveButton = new JButton((Action)new ResourceAction(this.smallIcons, "save", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ChartConfigurationObject object = new ChartConfigurationObject(ChartConfigurationPanel.this.getPlotConfiguration());
                String location = RepositoryLocationChooser.selectLocation(null, (String)"", (Component)RapidMinerGUI.getMainFrame(), (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)true);
                if (location != null) {
                    try {
                        RepositoryLocation locationObject = new RepositoryLocation(location);
                        RepositoryManager.getInstance(null).store((IOObject)object, locationObject, null);
                    }
                    catch (RepositoryException ex) {
                        ex.printStackTrace();
                    }
                    catch (MalformedRepositoryLocationException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = -1;
        itemConstraint.insets = STANDARD_INSETS;
        buttonPanel.add((Component)saveButton, itemConstraint);
        JButton loadButton = new JButton((Action)new ResourceAction(this.smallIcons, "load", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                String location = RepositoryLocationChooser.selectLocation(null, (String)"", (Component)RapidMinerGUI.getMainFrame(), (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)true);
                if (location != null) {
                    try {
                        IOObject data;
                        RepositoryLocation repositoryLocation = new RepositoryLocation(location);
                        Entry entry = repositoryLocation.locateEntry();
                        if (entry == null) {
                            throw new RepositoryException("Entry '" + location + "' does not exist.");
                        }
                        if (entry instanceof IOObjectEntry) {
                            IOObjectEntry ioobjectEntry = (IOObjectEntry)entry;
                            data = ioobjectEntry.retrieveData(null);
                            if (!(data instanceof ChartConfigurationObject)) {
                                throw new RepositoryException("Entry needs to be a Chart Configuration Object");
                            }
                        } else {
                            throw new RepositoryException("Entry '" + location + "' is not a data entry, but " + entry.getType());
                        }
                        ChartConfigurationObject chartConfiguration = (ChartConfigurationObject)data;
                        ChartConfigurationPanel.this.setPlotConfiguration(chartConfiguration.getConfiguration());
                    }
                    catch (RepositoryException ex) {
                        ex.printStackTrace();
                    }
                    catch (MalformedRepositoryLocationException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = -1;
        itemConstraint.insets = STANDARD_INSETS;
        buttonPanel.add((Component)loadButton, itemConstraint);
        JButton hideButton = new JButton((Action)new ResourceAction(this.smallIcons, "plotter.configuration_dialog.hide_configuration", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                boolean visible = !ChartConfigurationPanel.this.leftSideConfigPanel.isVisible();
                ChartConfigurationPanel.this.leftSideConfigPanel.setVisible(visible);
                ChartConfigurationPanel.this.statusTextArea.setVisible(visible);
                ChartConfigurationPanel.this.statusTextAreaScrollPane.setVisible(visible);
                ChartConfigurationPanel.this.leftSideShowHiddenPanel.setVisible(!visible);
                ChartConfigurationPanel.this.chartPanel.chartChanged(null);
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = 0;
        itemConstraint.insets = STANDARD_INSETS;
        buttonPanel.add((Component)hideButton, itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = 0;
        itemConstraint.insets = STANDARD_INSETS;
        leftSidePanel.add((Component)buttonPanel, itemConstraint);
        Vector<DataTableColumn> attributeVector = this.assembleDataTableColumnList(this.dataTable);
        this.attributeList = new JList<DataTableColumn>(attributeVector);
        attributeListLabel.setLabelFor(this.attributeList);
        this.attributeList.setDragEnabled(true);
        this.attributeList.setCellRenderer(new DataTableColumnListCellRenderer());
        this.attributeListTransferHandler = new DataTableColumnListTransferHandler();
        this.attributeList.setTransferHandler((TransferHandler)((Object)this.attributeListTransferHandler));
        this.attributeList.setSelectionMode(2);
        JScrollPane attributeListScrollPane = new JScrollPane(this.attributeList);
        attributeListScrollPane.setPreferredSize(PREFFERED_LIST_AND_TREE_DIMENSION);
        attributeListScrollPane.setMaximumSize(MAX_LIST_AND_TREE_DIMENSION);
        attributeListScrollPane.setMinimumSize(MIN_LIST_AND_TREE_DIMENSION);
        attributeListScrollPane.setHorizontalScrollBarPolicy(31);
        attributeListScrollPane.setVerticalScrollBarPolicy(20);
        itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 0.5;
        itemConstraint.gridwidth = 0;
        itemConstraint.insets = standardInsets;
        leftSidePanel.add((Component)attributeListScrollPane, itemConstraint);
        ResourceLabel plotConfigurationLabel = new ResourceLabel("plotter.configuration_dialog.chart_configuration", new Object[0]);
        Font oldFont2 = plotConfigurationLabel.getFont();
        JPanel labelPanel2 = new JPanel();
        labelPanel2.setLayout(new BoxLayout(labelPanel2, 2));
        plotConfigurationLabel.setFont(new Font(oldFont2.getFamily(), 1, oldFont2.getSize()));
        labelPanel2.add((Component)plotConfigurationLabel);
        labelPanel2.add(new JLabel(" "));
        ResourceLabel dropLabel = new ResourceLabel("plotter.configuration_dialog.drop_here", new Object[0]);
        labelPanel2.add((Component)dropLabel);
        labelPanel2.add(Box.createHorizontalGlue());
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 0.0;
        itemConstraint.fill = 2;
        itemConstraint.gridwidth = 0;
        itemConstraint.insets = STANDARD_INSETS;
        leftSidePanel.add((Component)labelPanel2, itemConstraint);
        this.plotConfigurationTree = new PlotConfigurationTree(this.getPlotConfiguration(), this.dataTable, this.attributeListTransferHandler);
        this.plotConfigurationTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
                if (newLeadSelectionPath == null) {
                    CardLayout cl = (CardLayout)ChartConfigurationPanel.this.configurationContainerPanel.getLayout();
                    cl.show(ChartConfigurationPanel.this.configurationContainerPanel, ChartConfigurationPanel.EMPTY);
                    return;
                }
                Object lastPathComponent = newLeadSelectionPath.getLastPathComponent();
                if (lastPathComponent instanceof PlotConfigurationTreeNode) {
                    CardLayout cl = (CardLayout)ChartConfigurationPanel.this.configurationContainerPanel.getLayout();
                    cl.show(ChartConfigurationPanel.this.configurationContainerPanel, ChartConfigurationPanel.GLOBAL_CONFIG);
                } else if (lastPathComponent instanceof RangeAxisConfigTreeNode) {
                    CardLayout cl = (CardLayout)ChartConfigurationPanel.this.configurationContainerPanel.getLayout();
                    cl.show(ChartConfigurationPanel.this.configurationContainerPanel, ChartConfigurationPanel.RANGE_AXIS_CONFIG);
                } else if (lastPathComponent instanceof ValueSourceTreeNode) {
                    CardLayout cl = (CardLayout)ChartConfigurationPanel.this.configurationContainerPanel.getLayout();
                    cl.show(ChartConfigurationPanel.this.configurationContainerPanel, ChartConfigurationPanel.VALUE_SOURCE_CONFIG);
                } else if (lastPathComponent instanceof DimensionConfigTreeNode) {
                    CardLayout cl = (CardLayout)ChartConfigurationPanel.this.configurationContainerPanel.getLayout();
                    switch (((DimensionConfigTreeNode)lastPathComponent).getDimension()) {
                        case COLOR: {
                            cl.show(ChartConfigurationPanel.this.configurationContainerPanel, ChartConfigurationPanel.COLOR_DIMENSION_CONFIG);
                            break;
                        }
                        case SHAPE: {
                            cl.show(ChartConfigurationPanel.this.configurationContainerPanel, ChartConfigurationPanel.SHAPE_DIMENSION_CONFIG);
                            break;
                        }
                        case DOMAIN: {
                            cl.show(ChartConfigurationPanel.this.configurationContainerPanel, ChartConfigurationPanel.DOMAIN_DIMENSION);
                            break;
                        }
                        case SIZE: {
                            cl.show(ChartConfigurationPanel.this.configurationContainerPanel, ChartConfigurationPanel.SIZE_DIMENSION_CONFIG);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unsupported Dimension Config.. this should not happen");
                        }
                    }
                }
            }
        });
        MouseAdapter ma = new MouseAdapter(){

            private void myPopupEvent(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                JTree tree = (JTree)e.getSource();
                TreePath path = tree.getPathForLocation(x, y);
                if (path == null) {
                    return;
                }
                tree.setSelectionPath(path);
                TreeNode node = (TreeNode)path.getLastPathComponent();
                if (node instanceof RangeAxisConfigTreeNode) {
                    PlotConfiguration plotConfig = (PlotConfiguration)((DefaultMutableTreeNode)tree.getModel().getRoot()).getUserObject();
                    ChartConfigurationPanel.this.removeRangeAxisMenuItem.setEnabled(plotConfig.getRangeAxisCount() > 1);
                    ChartConfigurationPanel.this.rangeAxisPopupMenu.show(tree, x, y);
                } else if (node instanceof ValueSourceTreeNode) {
                    ChartConfigurationPanel.this.valueSourcePopupMenu.show(tree, x, y);
                } else if (node instanceof DimensionConfigTreeNode) {
                    DimensionConfig config = ((DimensionConfigTreeNode)node).getUserObject();
                    if (config != null) {
                        if (config.getDimension() == DimensionConfig.PlotDimension.DOMAIN && ChartConfigurationPanel.this.getPlotConfiguration().getDomainConfigManager().getDataTableColumn().getValueType() == DataTableColumn.ValueType.INVALID) {
                            ChartConfigurationPanel.this.removeAttributeFromDimensionMenuItem.setEnabled(false);
                        } else {
                            ChartConfigurationPanel.this.removeAttributeFromDimensionMenuItem.setEnabled(true);
                        }
                    } else {
                        ChartConfigurationPanel.this.removeAttributeFromDimensionMenuItem.setEnabled(false);
                    }
                    ChartConfigurationPanel.this.dimensionConfigPopupMenu.show(tree, x, y);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.myPopupEvent(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.myPopupEvent(e);
                }
            }
        };
        this.plotConfigurationTree.addMouseListener(ma);
        this.plotConfigurationTree.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 127) {
                    JTree tree = (JTree)e.getSource();
                    TreePath selectionPath = ChartConfigurationPanel.this.plotConfigurationTree.getSelectionPath();
                    if (selectionPath != null) {
                        Object node = selectionPath.getLastPathComponent();
                        if (node instanceof RangeAxisConfigTreeNode) {
                            PlotConfiguration plotConfig = (PlotConfiguration)((DefaultMutableTreeNode)tree.getModel().getRoot()).getUserObject();
                            if (plotConfig.getRangeAxisCount() > 1) {
                                ChartConfigurationPanel.this.removeRangeAxisAction();
                            }
                        } else if (node instanceof ValueSourceTreeNode) {
                            ChartConfigurationPanel.this.removeValueSourceAction();
                        } else if (node instanceof DimensionConfigTreeNode) {
                            ChartConfigurationPanel.this.removeAttributeFromDimensionAction();
                        }
                    }
                    e.consume();
                }
            }
        });
        this.plotConfigurationTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                if (!ChartConfigurationPanel.this.allowCollapse) {
                    throw new ExpandVetoException(event);
                }
            }
        });
        this.plotConfigurationTreeTransferHandler = new PlotConfigurationTreeTransferHandler(this.plotConfigurationTree);
        this.plotConfigurationTree.setTransferHandler((TransferHandler)((Object)this.plotConfigurationTreeTransferHandler));
        this.plotConfigurationTreeScrollPane = new JScrollPane(this.plotConfigurationTree);
        plotConfigurationLabel.setLabelFor(this.plotConfigurationTree);
        this.plotConfigurationTreeScrollPane.setPreferredSize(PREFFERED_LIST_AND_TREE_DIMENSION);
        this.plotConfigurationTreeScrollPane.setMaximumSize(MAX_LIST_AND_TREE_DIMENSION);
        this.plotConfigurationTreeScrollPane.setMinimumSize(MIN_LIST_AND_TREE_DIMENSION);
        this.plotConfigurationTreeScrollPane.setHorizontalScrollBarPolicy(31);
        this.plotConfigurationTreeScrollPane.setVerticalScrollBarPolicy(20);
        this.plotConfigurationTreeScrollPane.setBorder(DROP_ENDED_BORDER);
        itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.gridwidth = 0;
        itemConstraint.insets = standardInsets;
        leftSidePanel.add((Component)this.plotConfigurationTreeScrollPane, itemConstraint);
        this.configurationContainerPanel = new JPanel(new CardLayout());
        GlobalConfigurationPanel globalConfigPanel = new GlobalConfigurationPanel(this.getCurrentPlotInstance());
        this.addPlotInstanceChangeListener(globalConfigPanel);
        this.configurationContainerPanel.add((Component)globalConfigPanel, GLOBAL_CONFIG);
        RangeAxisConfigPanel rangeAxisPanel = new RangeAxisConfigPanel(this.plotConfigurationTree, this.getCurrentPlotInstance());
        this.addPlotInstanceChangeListener(rangeAxisPanel);
        this.configurationContainerPanel.add((Component)rangeAxisPanel, RANGE_AXIS_CONFIG);
        ValueSourceConfigurationPanel plotAxesConfigPanel = new ValueSourceConfigurationPanel(this.smallIcons, this.plotConfigurationTree, this.attributeListTransferHandler, this.getCurrentPlotInstance());
        this.addPlotInstanceChangeListener(plotAxesConfigPanel);
        this.configurationContainerPanel.add((Component)plotAxesConfigPanel, VALUE_SOURCE_CONFIG);
        DimensionConfigPanel domainDimensionPanel = new DimensionConfigPanel(DimensionConfig.PlotDimension.DOMAIN, this.plotConfigurationTree, this.getCurrentPlotInstance());
        this.addPlotInstanceChangeListener(domainDimensionPanel);
        this.configurationContainerPanel.add((Component)domainDimensionPanel, DOMAIN_DIMENSION);
        this.configurationContainerPanel.add((Component)new JPanel(), EMPTY);
        DimensionConfigPanel dimensionConfigPanel = new DimensionConfigPanel(DimensionConfig.PlotDimension.COLOR, this.plotConfigurationTree, this.getCurrentPlotInstance());
        this.addPlotInstanceChangeListener(dimensionConfigPanel);
        this.configurationContainerPanel.add((Component)dimensionConfigPanel, COLOR_DIMENSION_CONFIG);
        dimensionConfigPanel = new DimensionConfigPanel(DimensionConfig.PlotDimension.SHAPE, this.plotConfigurationTree, this.getCurrentPlotInstance());
        this.addPlotInstanceChangeListener(dimensionConfigPanel);
        this.configurationContainerPanel.add((Component)dimensionConfigPanel, SHAPE_DIMENSION_CONFIG);
        dimensionConfigPanel = new DimensionConfigPanel(DimensionConfig.PlotDimension.SIZE, this.plotConfigurationTree, this.getCurrentPlotInstance());
        this.addPlotInstanceChangeListener(dimensionConfigPanel);
        this.configurationContainerPanel.add((Component)dimensionConfigPanel, SIZE_DIMENSION_CONFIG);
        CardLayout cl = (CardLayout)this.configurationContainerPanel.getLayout();
        cl.show(this.configurationContainerPanel, EMPTY);
        itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.insets = STANDARD_INSETS;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 0.0;
        itemConstraint.gridwidth = 0;
        leftSidePanel.add((Component)this.configurationContainerPanel, itemConstraint);
        return leftSidePanel;
    }

    private void removeRangeAxisAction() {
        RangeAxisConfigTreeNode node = (RangeAxisConfigTreeNode)this.plotConfigurationTree.getSelectionPath().getLastPathComponent();
        RangeAxisConfig axisConfig = node.getUserObject();
        this.getPlotConfiguration().removeRangeAxisConfig(axisConfig);
    }

    private void removeValueSourceAction() {
        ValueSourceTreeNode node = (ValueSourceTreeNode)this.plotConfigurationTree.getSelectionPath().getLastPathComponent();
        ValueSource source = node.getUserObject();
        RangeAxisConfigTreeNode parent = (RangeAxisConfigTreeNode)node.getParent();
        if (parent == null) {
            new RuntimeErrorException(null, "ValueSource Node has no parent!!").printStackTrace();
        } else {
            RangeAxisConfig rangeAxis = parent.getUserObject();
            rangeAxis.removeValueSource(source);
        }
    }

    private void removeAttributeFromDimensionAction() {
        DimensionConfigTreeNode node = (DimensionConfigTreeNode)this.plotConfigurationTree.getSelectionPath().getLastPathComponent();
        DimensionConfig config = node.getUserObject();
        if (config != null) {
            if (config.getDimension() != DimensionConfig.PlotDimension.DOMAIN) {
                this.getPlotConfiguration().setDimensionConfig(config.getDimension(), null);
            } else {
                this.getPlotConfiguration().getDomainConfigManager().setDataTableColumn(new DataTableColumn(null, DataTableColumn.ValueType.INVALID));
            }
        }
    }

    private Vector<DataTableColumn> assembleDataTableColumnList(DataTable dataTable) {
        Vector<DataTableColumn> dataTableColumnVector = new Vector<DataTableColumn>();
        int numberOfColumns = dataTable.getNumberOfColumns();
        for (int i = 0; i < numberOfColumns; ++i) {
            dataTableColumnVector.add(new DataTableColumn(dataTable, i));
        }
        return dataTableColumnVector;
    }

    private boolean changeDatatableTransformationType(AbstractConfigurationPanel.DatasetTransformationType type, boolean reconfigure) {
        PlotInstance plotInstance = this.getPlotInstance(type);
        if (plotInstance == null || reconfigure) {
            if (type == AbstractConfigurationPanel.DatasetTransformationType.DE_PIVOTED) {
                LinkedList<DataTableColumn> columns = new LinkedList<DataTableColumn>();
                Vector<DataTableColumn> dataTableColumns = this.assembleDataTableColumnList(this.dataTable);
                for (DataTableColumn column : dataTableColumns) {
                    if (!column.isNominal() && !column.isNumerical() || column.getName().equals("id") || column.getName().equals("value") || column.getName().equals("attribute")) continue;
                    columns.add(column);
                }
                Collection<String> selectedAttributeExclusionList = null;
                AttributeSelectionDialog dialog = new AttributeSelectionDialog(columns);
                dialog.setVisible(true);
                if (!dialog.wasConfirmed()) {
                    return false;
                }
                selectedAttributeExclusionList = dialog.getSelectedAttributeNames();
                LinkedList<String> nominalToNumericalAttributeList = new LinkedList<String>();
                LinkedList<String> excludedNumericalAttributesList = new LinkedList<String>();
                if (selectedAttributeExclusionList != null) {
                    for (DataTableColumn column : dataTableColumns) {
                        String name = column.getName();
                        if (selectedAttributeExclusionList.contains(name)) {
                            if (!column.isNumerical()) continue;
                            excludedNumericalAttributesList.add(name);
                            continue;
                        }
                        if (!column.isNominal()) continue;
                        nominalToNumericalAttributeList.add(name);
                    }
                }
                PlotConfiguration currentPlotConfiguration = null;
                currentPlotConfiguration = plotInstance != null ? plotInstance.getMasterPlotConfiguration() : this.dePivotedPlotConfig;
                if ((plotInstance = this.getNewDePivotedPlotInstance(currentPlotConfiguration, excludedNumericalAttributesList, nominalToNumericalAttributeList)) == null) {
                    SwingTools.showVerySimpleErrorMessage((String)"plotter.no_datatable_for_transformation_type", (Object[])new Object[]{type});
                    return false;
                }
            } else {
                SwingTools.showVerySimpleErrorMessage((String)"plotter.no_datatable_for_transformation_type", (Object[])new Object[]{type});
                return false;
            }
        }
        this.plotInstanceChanged(null, plotInstance, type);
        return true;
    }

    @Override
    public void masterOfDesasterChanged(MasterOfDesaster masterOfDesaster) {
        final String htmlString = masterOfDesaster.toHtmlString();
        if (this.statusTextArea != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChartConfigurationPanel.this.statusTextArea.setText(htmlString);
                    ChartConfigurationPanel.this.statusTextArea.setCaretPosition(0);
                    ChartConfigurationPanel.this.statusTextAreaScrollPane.scrollRectToVisible(new Rectangle(1, 1, 1, 1));
                }
            });
        }
    }

    public void dragStarted(Transferable t) {
        TransferHandler.TransferSupport support = new TransferHandler.TransferSupport((Component)this, t);
        boolean doesSupportFlavor = ((PlotConfigurationTreeTransferHandler)((Object)this.plotConfigurationTree.getTransferHandler())).doesSupportFlavor(support);
        if (doesSupportFlavor) {
            if (SwingUtilities.isEventDispatchThread()) {
                switch (RapidMinerGUI.getDragHighlighteMode()) {
                    case FULL: {
                        this.plotConfigurationTree.setBackground(ProcessDrawer.INNER_DRAG_COLOR);
                    }
                    case BORDER: {
                        this.plotConfigurationTreeScrollPane.setBorder(ONGOING_DROP_BORDER);
                        break;
                    }
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        switch (RapidMinerGUI.getDragHighlighteMode()) {
                            case FULL: {
                                ChartConfigurationPanel.this.plotConfigurationTree.setBackground(ProcessDrawer.INNER_DRAG_COLOR);
                            }
                            case BORDER: {
                                ChartConfigurationPanel.this.plotConfigurationTreeScrollPane.setBorder(ONGOING_DROP_BORDER);
                                break;
                            }
                        }
                    }
                });
            }
        }
    }

    public void dragEnded() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.plotConfigurationTreeScrollPane.setBorder(DROP_ENDED_BORDER);
            this.plotConfigurationTree.setBackground(Color.WHITE);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChartConfigurationPanel.this.plotConfigurationTreeScrollPane.setBorder(DROP_ENDED_BORDER);
                    ChartConfigurationPanel.this.plotConfigurationTree.setBackground(Color.WHITE);
                }
            });
        }
    }

    @Override
    protected void adaptGUI() {
        this.plotConfigurationTree.treeDidChange();
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        if (this.plotConfigurationTree == null) {
            return true;
        }
        switch (change.getType()) {
            case DIMENSION_CONFIG_ADDED: {
                this.adaptGUI();
                break;
            }
            case DIMENSION_CONFIG_CHANGED: {
                this.adaptGUI();
                break;
            }
            case DIMENSION_CONFIG_REMOVED: {
                this.adaptGUI();
                break;
            }
            case RANGE_AXIS_CONFIG_ADDED: {
                this.adaptGUI();
                break;
            }
            case RANGE_AXIS_CONFIG_CHANGED: {
                this.adaptGUI();
                break;
            }
            case RANGE_AXIS_CONFIG_REMOVED: {
                this.adaptGUI();
                break;
            }
            case META_CHANGE: {
                this.adaptGUI();
                break;
            }
        }
        return true;
    }

    @Override
    public void startProcessing() {
        this.resetButton.setEnabled(false);
    }

    @Override
    public void endProcessing() {
        this.resetButton.setEnabled(true);
    }

    @Override
    public void plotInstanceChanged(PlotInstance oldPlotInstance, PlotInstance newPlotInstance, AbstractConfigurationPanel.DatasetTransformationType newType) {
        this.unregisterAsPlotConfigurationListener();
        this.masterOfDesaster.removeListener(this);
        this.setPlotInstance(newPlotInstance, newType);
        this.masterOfDesaster = this.getCurrentPlotInstance().getMasterOfDesaster();
        this.masterOfDesaster.addListener(this);
        this.registerAsPlotConfigurationListener();
        Vector<Object> columnList = new Vector();
        switch (newType) {
            case DE_PIVOTED: {
                columnList = this.assembleDataTableColumnList(this.getDePivotedDataTable(null, null));
                break;
            }
            default: {
                columnList = this.assembleDataTableColumnList(this.dataTable);
            }
        }
        DefaultListModel<DataTableColumn> attributeListModel = new DefaultListModel<DataTableColumn>();
        for (DataTableColumn dataTableColumn : columnList) {
            attributeListModel.addElement(dataTableColumn);
        }
        this.attributeList.setModel(attributeListModel);
        PlotConfigurationTreeModel newModel = (PlotConfigurationTreeModel)this.plotConfigurationTree.getModel();
        newModel.exchangePlotConfiguration(this.getPlotConfiguration());
        this.plotConfigurationTree.expandAll();
        this.plotEngine.setPlotInstance(newPlotInstance);
    }

    public JFreeChartPlotEngine getPlotEngine() {
        return this.plotEngine;
    }

    public Component getExportComponent() {
        LinkAndBrushChartPanel newLaBPanel = new LinkAndBrushChartPanel(this.getPlotEngine().getChartPanel().getChart(), this.getPlotEngine().getChartPanel().getWidth(), this.getPlotEngine().getChartPanel().getHeight(), this.getPlotEngine().getChartPanel().getMinimumDrawWidth(), this.getPlotEngine().getChartPanel().getMinimumDrawHeight(), false, false);
        newLaBPanel.setSize(this.getPlotEngine().getChartPanel().getSize());
        newLaBPanel.setOverlayList(this.getPlotEngine().getChartPanel().getOverlayList());
        return newLaBPanel;
    }

    public String getExportIconName() {
        return I18N.getGUIMessage((String)"gui.cards.result_view.advanced_charts.icon", (Object[])new Object[0]);
    }

    public String getExportName() {
        return I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.cards.result_view.advanced_charts.title", (Object[])new Object[0]);
    }

    public String getIdentifier() {
        return this.exampleSetSource;
    }
}

