/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.AbstractConfigurationPanel;
import com.owc.gui.charting.gui.FontDialog;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.tools.I18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;

public class ChartTitleConfigurationContainer
extends AbstractConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private ResourceLabel titleFontLabel;
    private JButton titleFontChooserButton;
    private JButton titleColorChooserButton;

    public ChartTitleConfigurationContainer(PlotInstance plotInstance) {
        super(plotInstance);
        this.createComponents();
        this.adaptGUI();
    }

    private void createComponents() {
        this.titleFontLabel = new ResourceLabel("plotter.configuration_dialog.title_font", new Object[0]);
        this.titleFontChooserButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.title_font", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ChartTitleConfigurationContainer.this.createTitleFontDialog();
            }
        });
        this.titleFontLabel.setLabelFor((Component)this.titleFontChooserButton);
        this.addTwoComponentRow(this, (JComponent)this.titleFontLabel, this.titleFontChooserButton);
        ResourceLabel titleColorLabel = new ResourceLabel("plotter.configuration_dialog.title_color", new Object[0]);
        this.titleColorChooserButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.title_color", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ChartTitleConfigurationContainer.this.createTitleColorDialog();
            }
        });
        titleColorLabel.setLabelFor(this.titleColorChooserButton);
        this.addTwoComponentRow(this, (JComponent)titleColorLabel, this.titleColorChooserButton);
    }

    @Override
    protected void adaptGUI() {
    }

    private void createTitleColorDialog() {
        Color newLineColor;
        Color oldColor = this.getPlotConfiguration().getTitleColor();
        if (oldColor == null) {
            oldColor = PlotConfiguration.DEFAULT_TITLE_COLOR;
        }
        if ((newLineColor = JColorChooser.showDialog(this, I18N.getGUILabel((String)"plotter.configuration_dialog.global_config_panel.title_font_color_title.label", (Object[])new Object[0]), oldColor)) != null && !newLineColor.equals(oldColor)) {
            this.getPlotConfiguration().setTitleColor(newLineColor);
        }
    }

    private void createTitleFontDialog() {
        Font titleFont = this.getPlotConfiguration().getTitleFont();
        if (titleFont == null) {
            titleFont = new Font("Dialog", 0, 10);
        }
        FontDialog fontDialog = new FontDialog(this, titleFont, "plotter.configuration_dialog.global_config_panel.select_title_font");
        fontDialog.setVisible(true);
        fontDialog.requestFocus();
        if (fontDialog.getReturnStatus() == 1) {
            Font font = fontDialog.getFont();
            this.getPlotConfiguration().setTitleFont(font);
        }
        fontDialog.dispose();
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        return true;
    }
}

