/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.ChartConfigurationException;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.EqualDataFractionGrouping;
import com.owc.gui.charting.configuration.LegendConfiguration;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.engine.jfreechart.JFreeChartPlotEngine;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.ChartPanel;
import com.owc.gui.charting.gui.cellrenderer.ColorListCellRenderer;
import com.owc.gui.charting.gui.cellrenderer.ColorRGBComboBoxCellRenderer;
import com.owc.gui.charting.gui.cellrenderer.ColorSchemeComboBoxRenderer;
import com.owc.gui.charting.listener.PlotConfigurationListener;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.owc.gui.charting.templates.style.ColorRGB;
import com.owc.gui.charting.templates.style.ColorScheme;
import com.owc.gui.charting.utility.ContinuousColorProvider;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableExampleSetAdapter;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.gui.tools.dialogs.ConfirmDialog;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ColorSchemeDialog
extends ButtonDialog
implements PlotConfigurationListener {
    private static final long serialVersionUID = 1L;
    private JList<Color> colorList;
    private JPopupMenu popupMenu;
    private JButton addCategoryButton;
    private JButton removeSchemeButton;
    private JButton removeCategoryColorButton;
    private JScrollPane colorListScrollPane;
    private JPanel categoryAndGradientConfigPanel;
    private JComboBox<Object> colorSchemeComboBox;
    private JMenuItem removeMenuItem;
    private JMenuItem changeColorMenuItem;
    private JButton revertButton;
    private JButton saveButton;
    private DefaultListModel<Color> nominalColorListModel;
    private DefaultComboBoxModel<Color> gradientStartColorComboBoxModel;
    private DefaultComboBoxModel<Color> gradientEndColorComboBoxModel;
    private DefaultComboBoxModel<Object> colorSchemeComboBoxModel;
    private JComboBox<Color> gradientEndColorComboBox;
    private JComboBox<Color> gradientStartColorComboBox;
    private GradientPreview preview;
    private Dimension preferredGradientComboBoxSize = new Dimension(42, 20);
    private String initialActiveColorSchemeName;
    private Map<String, ColorScheme> initialColorSchemes;
    private String currentActiveColorSchemeName;
    private Map<String, ColorScheme> currentColorSchemes;
    private PlotConfiguration gradientPlotConfig;
    private PlotConfiguration nominalPlotConfig;
    private boolean adaptingModels;
    private JButton renameSchemeButton;
    private ChartPanel gradientPreviewPanel;
    private JFreeChartPlotEngine nominalPlotter;
    private JFreeChartPlotEngine gradientPlotter;
    private ChartPanel nominalPreviewPanel;
    private PlotConfiguration plotConfig;
    private boolean initializing = false;
    private JMenuItem moveUpColorMenuItem;
    private JMenuItem moveDownColorMenuItem;

    public ColorSchemeDialog(Component actionComp, String key, PlotConfiguration plotConfig, Object ... arguments) {
        super(actionComp != null ? SwingUtilities.getWindowAncestor(actionComp) : null, key, Dialog.ModalityType.APPLICATION_MODAL, arguments);
        this.plotConfig = plotConfig;
        this.initializing = true;
        this.nominalColorListModel = new DefaultListModel();
        this.gradientStartColorComboBoxModel = new DefaultComboBoxModel();
        this.gradientEndColorComboBoxModel = new DefaultComboBoxModel();
        this.colorSchemeComboBoxModel = new DefaultComboBoxModel();
        this.setResizable(false);
        this.createPreviewPlotBackend(new JPanel().getBackground(), plotConfig.getActiveColorScheme().getColors().size());
        this.createComponents();
        this.save(plotConfig.getColorSchemes(), plotConfig.getActiveColorScheme().getName());
        this.initializing = false;
        this.adaptPreviewPlots();
        this.setLocationRelativeTo(actionComp);
    }

    private void createComponents() {
        this.popupMenu = new JPopupMenu();
        this.removeMenuItem = new JMenuItem(I18N.getGUILabel((String)"plotter.configuration_dialog.color_scheme_dialog.remove_color_menu_item.label", (Object[])new Object[0]));
        this.removeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorSchemeDialog.this.removeSelectedColorAction();
            }
        });
        this.popupMenu.add(this.removeMenuItem);
        this.changeColorMenuItem = new JMenuItem(I18N.getGUILabel((String)"plotter.configuration_dialog.color_scheme_dialog.change_color_menu_item.label", (Object[])new Object[0]));
        this.changeColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorSchemeDialog.this.replaceSelectedColorAction();
            }
        });
        this.popupMenu.add(this.changeColorMenuItem);
        this.popupMenu.addSeparator();
        this.moveUpColorMenuItem = new JMenuItem(I18N.getGUILabel((String)"plotter.configuration_dialog.color_scheme_dialog.move_up_menu_item.label", (Object[])new Object[0]));
        this.moveUpColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorSchemeDialog.this.moveSelectedColorUpAction();
            }
        });
        this.popupMenu.add(this.moveUpColorMenuItem);
        this.moveDownColorMenuItem = new JMenuItem(I18N.getGUILabel((String)"plotter.configuration_dialog.color_scheme_dialog.move_down_menu_item.label", (Object[])new Object[0]));
        this.moveDownColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorSchemeDialog.this.moveSelectedColorDownAction();
            }
        });
        this.popupMenu.add(this.moveDownColorMenuItem);
        JPanel containerPanel = new JPanel(new GridBagLayout());
        containerPanel.setPreferredSize(new Dimension(520, 450));
        JPanel configurePanel = new JPanel(new GridBagLayout());
        configurePanel.setPreferredSize(new Dimension(220, 400));
        configurePanel.setBorder(BorderFactory.createTitledBorder(I18N.getGUILabel((String)"plotter.configuration_dialog.color_scheme_dialog.scheme_configuration_border.label", (Object[])new Object[0])));
        JPanel schemeComboBoxPanel = this.createSchemeComboBoxPanel();
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.gridwidth = 0;
        itemConstraint.insets = new Insets(2, 2, 2, 5);
        configurePanel.add((Component)schemeComboBoxPanel, itemConstraint);
        this.categoryAndGradientConfigPanel = new JPanel(new GridBagLayout());
        JPanel categoryConfigurationPanel = this.createColorCategoriesPanel();
        itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.insets = new Insets(2, 2, 2, 5);
        itemConstraint.gridwidth = 0;
        this.categoryAndGradientConfigPanel.add((Component)categoryConfigurationPanel, itemConstraint);
        JPanel gradientConfigPanel = this.createGradientConfigurationPanel();
        itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.insets = new Insets(2, 2, 2, 5);
        itemConstraint.gridwidth = 0;
        this.categoryAndGradientConfigPanel.add((Component)gradientConfigPanel, itemConstraint);
        GridBagConstraints itemConstraint2 = new GridBagConstraints();
        itemConstraint2.fill = 1;
        itemConstraint2.weightx = 1.0;
        itemConstraint2.weighty = 1.0;
        itemConstraint2.gridwidth = 0;
        itemConstraint2.insets = new Insets(2, 2, 2, 5);
        configurePanel.add((Component)this.categoryAndGradientConfigPanel, itemConstraint2);
        itemConstraint2 = new GridBagConstraints();
        itemConstraint2.fill = 1;
        itemConstraint2.weightx = 1.0;
        itemConstraint2.weighty = 1.0;
        itemConstraint2.gridwidth = -1;
        containerPanel.add((Component)configurePanel, itemConstraint2);
        this.createPlotPreviewPanel(containerPanel);
        LinkedList<JButton> buttons = new LinkedList<JButton>();
        buttons.add(this.makeOkButton());
        ResourceAction saveAction = new ResourceAction("plotter.configuration_dialog.color_scheme_dialog.save_button", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ColorSchemeDialog.this.save(ColorSchemeDialog.this.currentColorSchemes, ColorSchemeDialog.this.currentActiveColorSchemeName);
                ColorSchemeDialog.this.plotConfig.setColorSchemes(ColorSchemeDialog.this.currentColorSchemes, ColorSchemeDialog.this.currentActiveColorSchemeName);
            }
        };
        this.saveButton = new JButton((Action)saveAction);
        buttons.add(this.saveButton);
        this.saveButton.setEnabled(false);
        ResourceAction revertAction = new ResourceAction("plotter.configuration_dialog.color_scheme_dialog.revert_button", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ColorSchemeDialog.this.revert();
            }
        };
        this.revertButton = new JButton((Action)revertAction);
        this.revertButton.setEnabled(false);
        buttons.add(this.revertButton);
        buttons.add(this.makeCancelButton("plotter.configuration_dialog.color_scheme_dialog.cancel_button"));
        this.layoutDefault(containerPanel, buttons);
    }

    private void createPlotPreviewPanel(JPanel containerPanel) {
        JPanel previewPanel = new JPanel(new GridBagLayout());
        previewPanel.setPreferredSize(new Dimension(300, 300));
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.gridwidth = 0;
        this.nominalPreviewPanel = this.nominalPlotter.getChartPanel();
        this.nominalPreviewPanel.setPreferredSize(new Dimension(150, 150));
        previewPanel.add((Component)this.nominalPreviewPanel, itemConstraint);
        this.gradientPreviewPanel = this.gradientPlotter.getChartPanel();
        this.gradientPreviewPanel.setPreferredSize(new Dimension(150, 150));
        previewPanel.add((Component)this.gradientPreviewPanel, itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.gridwidth = -1;
        containerPanel.add((Component)previewPanel, itemConstraint);
    }

    private JPanel createGradientConfigurationPanel() {
        JPanel gradientConfigPanel = new JPanel(new GridBagLayout());
        gradientConfigPanel.setPreferredSize(new Dimension(100, 50));
        ResourceLabel gradientLabel = new ResourceLabel("plotter.configuration_dialog.color_scheme_dialog.gradient_preview", new Object[0]);
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.fill = 1;
        itemConstraint.gridwidth = 0;
        itemConstraint.insets = new Insets(2, 2, 2, 2);
        gradientConfigPanel.add((Component)gradientLabel, itemConstraint);
        JPanel comboBoxPanel = new JPanel(new GridBagLayout());
        JPanel startGradientPanel = this.createStartGradientPanel();
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = -1;
        itemConstraint.anchor = 17;
        itemConstraint.fill = 2;
        comboBoxPanel.add((Component)startGradientPanel, itemConstraint);
        JPanel endGradientPanel = this.createEndGradientPanel();
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = -1;
        itemConstraint.anchor = 13;
        itemConstraint.fill = 2;
        comboBoxPanel.add((Component)endGradientPanel, itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 0.0;
        itemConstraint.fill = 2;
        itemConstraint.gridwidth = 0;
        itemConstraint.insets = new Insets(2, 2, 2, 2);
        gradientConfigPanel.add((Component)comboBoxPanel, itemConstraint);
        JLabel zeroLabel = new JLabel("0");
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 0.0;
        itemConstraint.weighty = 0.0;
        itemConstraint.fill = 0;
        itemConstraint.insets = new Insets(2, 2, 2, 2);
        gradientConfigPanel.add((Component)zeroLabel, itemConstraint);
        this.preview = new GradientPreview(null);
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.fill = 1;
        itemConstraint.insets = new Insets(2, 2, 2, 2);
        gradientConfigPanel.add((Component)this.preview, itemConstraint);
        zeroLabel = new JLabel("1");
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 0.0;
        itemConstraint.weighty = 0.0;
        itemConstraint.fill = 0;
        itemConstraint.insets = new Insets(2, 2, 2, 2);
        itemConstraint.gridwidth = 0;
        gradientConfigPanel.add((Component)zeroLabel, itemConstraint);
        return gradientConfigPanel;
    }

    private JPanel createEndGradientPanel() {
        JPanel endGradientPanel = new JPanel(new GridBagLayout());
        ResourceLabel gradientEndLabel = new ResourceLabel("plotter.configuration_dialog.color_scheme_dialog.gradient_end", new Object[0]);
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = -1;
        itemConstraint.insets = new Insets(0, 2, 0, 0);
        endGradientPanel.add((Component)gradientEndLabel, itemConstraint);
        this.gradientEndColorComboBox = new JComboBox<Color>(this.gradientEndColorComboBoxModel);
        gradientEndLabel.setLabelFor(this.gradientEndColorComboBox);
        this.gradientEndColorComboBox.setPreferredSize(this.preferredGradientComboBoxSize);
        this.gradientEndColorComboBox.setRenderer(new ColorRGBComboBoxCellRenderer());
        this.gradientEndColorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = (Color)ColorSchemeDialog.this.gradientEndColorComboBox.getSelectedItem();
                if (color != null && !ColorSchemeDialog.this.adaptingModels) {
                    ColorSchemeDialog.this.saveButton.setEnabled(true);
                    ColorSchemeDialog.this.revertButton.setEnabled(true);
                    ColorSchemeDialog.this.getCurrentActiveColorScheme().setGradientEndColor(ColorRGB.convertColorToColorRGB(color));
                }
                ColorSchemeDialog.this.adaptGradientPlot();
                ColorSchemeDialog.this.calculateGradientPreview();
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = 0;
        itemConstraint.insets = new Insets(0, 2, 0, 0);
        endGradientPanel.add(this.gradientEndColorComboBox, itemConstraint);
        return endGradientPanel;
    }

    private JPanel createStartGradientPanel() {
        JPanel startGradientPanel = new JPanel(new GridBagLayout());
        ResourceLabel gradientStartLabel = new ResourceLabel("plotter.configuration_dialog.color_scheme_dialog.gradient_start", new Object[0]);
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = -1;
        itemConstraint.insets = new Insets(0, 5, 5, 5);
        startGradientPanel.add((Component)gradientStartLabel, itemConstraint);
        this.gradientStartColorComboBox = new JComboBox<Color>(this.gradientStartColorComboBoxModel);
        gradientStartLabel.setLabelFor(this.gradientStartColorComboBox);
        this.gradientStartColorComboBox.setPreferredSize(this.preferredGradientComboBoxSize);
        this.gradientStartColorComboBox.setRenderer(new ColorRGBComboBoxCellRenderer());
        this.gradientStartColorComboBox.setEditable(false);
        this.gradientStartColorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = (Color)ColorSchemeDialog.this.gradientStartColorComboBox.getSelectedItem();
                if (color != null && !ColorSchemeDialog.this.adaptingModels) {
                    ColorSchemeDialog.this.saveButton.setEnabled(true);
                    ColorSchemeDialog.this.revertButton.setEnabled(true);
                    ColorSchemeDialog.this.getCurrentActiveColorScheme().setGradientStartColor(ColorRGB.convertColorToColorRGB(color));
                }
                ColorSchemeDialog.this.adaptGradientPlot();
                ColorSchemeDialog.this.calculateGradientPreview();
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = -1;
        startGradientPanel.add(this.gradientStartColorComboBox, itemConstraint);
        return startGradientPanel;
    }

    private JPanel createColorCategoriesPanel() {
        JPanel categoryColorsConfigurationPanel = new JPanel(new GridBagLayout());
        categoryColorsConfigurationPanel.setPreferredSize(new Dimension(180, 200));
        GridBagConstraints itemConstraint = new GridBagConstraints();
        ResourceLabel categoryColorsLabel = new ResourceLabel("plotter.configuration_dialog.color_scheme_dialog.category_colors", new Object[0]);
        itemConstraint.fill = 2;
        itemConstraint.anchor = 17;
        itemConstraint.gridwidth = -1;
        itemConstraint.insets = new Insets(0, 5, 5, 5);
        itemConstraint.weightx = 1.0;
        categoryColorsConfigurationPanel.add((Component)categoryColorsLabel, itemConstraint);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.removeCategoryColorButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.color_scheme_dialog.remove_category_color_button", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ColorSchemeDialog.this.removeSelectedColorAction();
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = -1;
        itemConstraint.fill = 0;
        buttonPanel.add((Component)this.removeCategoryColorButton, itemConstraint);
        this.addCategoryButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.color_scheme_dialog.add_category_color_button", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                Color oldColor = Color.white;
                Color newSchemeColor = ColorSchemeDialog.this.createColorDialog(oldColor);
                if (newSchemeColor != null && !newSchemeColor.equals(oldColor)) {
                    ColorSchemeDialog.this.addColorAction(newSchemeColor);
                }
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = 0;
        itemConstraint.fill = 0;
        buttonPanel.add((Component)this.addCategoryButton, itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = 0;
        itemConstraint.fill = 0;
        itemConstraint.anchor = 13;
        itemConstraint.insets = new Insets(0, 5, 5, 5);
        categoryColorsConfigurationPanel.add((Component)buttonPanel, itemConstraint);
        JPanel categoryListPanel = new JPanel(new GridBagLayout());
        this.colorList = new JList<Color>(this.nominalColorListModel);
        categoryColorsLabel.setLabelFor(this.colorList);
        this.colorList.setCellRenderer(new ColorListCellRenderer());
        this.colorList.setSelectionMode(0);
        MouseAdapter ma = new MouseAdapter(){

            private void myPopupEvent(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                JList list = (JList)e.getSource();
                list.setSelectedIndex(list.locationToIndex(e.getPoint()));
                Color selectedColor = (Color)list.getSelectedValue();
                if (selectedColor == null) {
                    return;
                }
                ColorSchemeDialog.this.removeMenuItem.setEnabled(ColorSchemeDialog.this.nominalColorListModel.getSize() > 2);
                ColorSchemeDialog.this.popupMenu.show(list, x, y);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.myPopupEvent(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.myPopupEvent(e);
                }
            }
        };
        this.colorList.addMouseListener(ma);
        this.colorList.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 127 && ColorSchemeDialog.this.nominalColorListModel.getSize() > 2) {
                    ColorSchemeDialog.this.removeSelectedColorAction();
                }
                if (key == 113) {
                    ColorSchemeDialog.this.replaceSelectedColorAction();
                }
                if (key == 38 && SwingTools.isControlOrMetaDown((KeyEvent)e)) {
                    ColorSchemeDialog.this.moveSelectedColorUpAction();
                }
                if (key == 40 && SwingTools.isControlOrMetaDown((KeyEvent)e)) {
                    ColorSchemeDialog.this.moveSelectedColorDownAction();
                }
            }
        });
        this.colorListScrollPane = new JScrollPane(this.colorList);
        this.colorListScrollPane.setPreferredSize(new Dimension(170, 200));
        this.colorListScrollPane.setMaximumSize(new Dimension(170, 200));
        this.colorListScrollPane.setMinimumSize(new Dimension(170, 180));
        this.colorListScrollPane.setHorizontalScrollBarPolicy(31);
        this.colorListScrollPane.setVerticalScrollBarPolicy(20);
        itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 0.0;
        itemConstraint.weighty = 0.5;
        itemConstraint.gridwidth = -1;
        categoryListPanel.add((Component)this.colorListScrollPane, itemConstraint);
        JPanel upAndDownButtonPanel = new JPanel(new GridBagLayout());
        JButton upButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.move_color_up", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ColorSchemeDialog.this.moveSelectedColorUpAction();
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = 0;
        itemConstraint.weightx = 0.0;
        itemConstraint.weighty = 0.0;
        itemConstraint.fill = 0;
        itemConstraint.insets = new Insets(0, 2, 0, 12);
        upAndDownButtonPanel.add((Component)upButton, itemConstraint);
        JButton downButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.move_color_down", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ColorSchemeDialog.this.moveSelectedColorDownAction();
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = 0;
        itemConstraint.weightx = 0.0;
        itemConstraint.weighty = 0.0;
        itemConstraint.fill = 0;
        itemConstraint.insets = new Insets(0, 2, 0, 12);
        upAndDownButtonPanel.add((Component)downButton, itemConstraint);
        JPanel spacer = new JPanel();
        itemConstraint.gridwidth = 0;
        itemConstraint.weightx = 0.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.fill = 3;
        upAndDownButtonPanel.add((Component)spacer, itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = 0;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.fill = 3;
        categoryListPanel.add((Component)upAndDownButtonPanel, itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = 0;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.fill = 1;
        categoryColorsConfigurationPanel.add((Component)categoryListPanel, itemConstraint);
        return categoryColorsConfigurationPanel;
    }

    private JPanel createSchemeComboBoxPanel() {
        JPanel schemeListPanel = new JPanel(new GridBagLayout());
        GridBagConstraints itemConstraint = new GridBagConstraints();
        ResourceLabel actviceSchemeLabel = new ResourceLabel("plotter.configuration_dialog.color_scheme_dialog.active_scheme", new Object[0]);
        itemConstraint.fill = 2;
        itemConstraint.anchor = 17;
        itemConstraint.gridwidth = -1;
        itemConstraint.insets = new Insets(0, 5, 5, 5);
        itemConstraint.weightx = 1.0;
        actviceSchemeLabel.setBackground(Color.red);
        schemeListPanel.add((Component)actviceSchemeLabel, itemConstraint);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.renameSchemeButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.color_scheme_dialog.rename_scheme_button", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                String newName = ColorSchemeDialog.this.createNameDialog(ColorSchemeDialog.this.currentActiveColorSchemeName);
                if (newName != null && !newName.equals(ColorSchemeDialog.this.currentActiveColorSchemeName)) {
                    ColorSchemeDialog.this.renameColorSchemeAction(newName);
                }
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = -1;
        itemConstraint.fill = 0;
        buttonPanel.add((Component)this.renameSchemeButton, itemConstraint);
        this.removeSchemeButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.color_scheme_dialog.remove_scheme_button", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ConfirmDialog dialog = new ConfirmDialog(SwingUtilities.getWindowAncestor((Component)e.getSource()), "plotter.configuration_dialog.confirm_color_scheme_delete", 0, false, new Object[0]);
                dialog.setLocationRelativeTo((Component)e.getSource());
                dialog.setVisible(true);
                if (dialog.getReturnOption() == 0) {
                    ColorSchemeDialog.this.removeColorSchemeAction((ColorScheme)ColorSchemeDialog.this.colorSchemeComboBox.getSelectedItem());
                }
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = 0;
        itemConstraint.fill = 0;
        buttonPanel.add((Component)this.removeSchemeButton, itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridwidth = 0;
        itemConstraint.fill = 0;
        itemConstraint.anchor = 13;
        itemConstraint.insets = new Insets(0, 5, 5, 5);
        schemeListPanel.add((Component)buttonPanel, itemConstraint);
        this.colorSchemeComboBox = new JComboBox<Object>(this.colorSchemeComboBoxModel);
        actviceSchemeLabel.setLabelFor(this.colorSchemeComboBox);
        this.colorSchemeComboBox.setRenderer(new ColorSchemeComboBoxRenderer());
        this.colorSchemeComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Object selectedValue = ColorSchemeDialog.this.colorSchemeComboBox.getSelectedItem();
                if (selectedValue instanceof ColorScheme) {
                    ColorScheme selection = (ColorScheme)selectedValue;
                    if (selection != null && !ColorSchemeDialog.this.currentActiveColorSchemeName.equals(selection.getName())) {
                        ColorSchemeDialog.this.currentActiveColorSchemeName = selection.getName();
                        ColorSchemeDialog.this.adaptModels();
                    }
                } else {
                    String newName = I18N.getGUILabel((String)"plotter.new_color_scheme_name.label", (Object[])new Object[0]);
                    String suffix = "";
                    int counter = 1;
                    while (ColorSchemeDialog.this.currentColorSchemes.get(newName + suffix) != null) {
                        suffix = "_" + counter;
                        ++counter;
                    }
                    String userSelectedName = ColorSchemeDialog.this.createNameDialog(newName = newName + suffix);
                    if (userSelectedName == null) {
                        ColorSchemeDialog.this.colorSchemeComboBox.setSelectedItem(ColorSchemeDialog.this.getCurrentActiveColorScheme());
                        return;
                    }
                    ColorSchemeDialog.this.addNewColorSchemeAction(userSelectedName);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 0.0;
        itemConstraint.weighty = 0.0;
        itemConstraint.gridwidth = 0;
        schemeListPanel.add(this.colorSchemeComboBox, itemConstraint);
        return schemeListPanel;
    }

    private void createPreviewPlotBackend(Color background, int groupinBins) {
        EqualDataFractionGrouping edfgColor;
        EqualDataFractionGrouping edfg;
        DataTableExampleSetAdapter dataTable;
        try {
            ExampleSet exampleSet = (ExampleSet)((IOObjectEntry)new RepositoryLocation("//Samples/data/Iris").locateEntry()).retrieveData(null);
            dataTable = new DataTableExampleSetAdapter(exampleSet, null);
        }
        catch (MalformedRepositoryLocationException e) {
            return;
        }
        catch (RepositoryException e) {
            return;
        }
        if (dataTable == null || dataTable.getColumnNumber() < 2) {
            return;
        }
        DataTableColumn domainColumn = new DataTableColumn((DataTable)dataTable, 0);
        DataTableColumn mainColumn = new DataTableColumn((DataTable)dataTable, 1);
        Font titleFont = new Font("Lucida Sans", 0, 12);
        this.gradientPlotConfig = new PlotConfiguration(domainColumn);
        this.gradientPlotConfig.setTitleText(I18N.getGUILabel((String)"plotter.configuration_dialog.color_scheme_dialog.numerical_gradient_preview.label", (Object[])new Object[0]));
        this.gradientPlotConfig.setFrameBackgroundColor(background);
        this.gradientPlotConfig.getDomainConfigManager().setLabel("");
        this.gradientPlotConfig.setTitleFont(titleFont);
        this.gradientPlotConfig.getLegendConfiguration().setLegendPosition(LegendConfiguration.LegendPosition.NONE);
        RangeAxisConfig rangeAxis = new RangeAxisConfig("", this.gradientPlotConfig);
        ValueSource valueSource = new ValueSource(this.gradientPlotConfig, mainColumn, null, false);
        rangeAxis.addValueSource(valueSource, this.gradientPlotConfig.getAutomaticSeriesFormatForNextValueSource(rangeAxis));
        this.gradientPlotConfig.addRangeAxisConfig(rangeAxis);
        DefaultDimensionConfig colorDimension = new DefaultDimensionConfig(this.gradientPlotConfig, mainColumn, DimensionConfig.PlotDimension.COLOR);
        this.gradientPlotConfig.setDimensionConfig(DimensionConfig.PlotDimension.COLOR, colorDimension);
        PlotInstance plotInstance = new PlotInstance(this.gradientPlotConfig, (DataTable)dataTable);
        this.gradientPlotter = new JFreeChartPlotEngine(plotInstance, true);
        this.nominalPlotConfig = new PlotConfiguration(domainColumn);
        this.nominalPlotConfig.setTitleText(I18N.getGUILabel((String)"plotter.configuration_dialog.color_scheme_dialog.nominal_color_preview.label", (Object[])new Object[0]));
        this.nominalPlotConfig.setFrameBackgroundColor(background);
        this.nominalPlotConfig.getDomainConfigManager().setLabel("");
        this.nominalPlotConfig.setTitleFont(titleFont);
        this.nominalPlotConfig.getLegendConfiguration().setLegendPosition(LegendConfiguration.LegendPosition.NONE);
        try {
            edfg = new EqualDataFractionGrouping(domainColumn, 4, true, DateFormat.getDateTimeInstance());
        }
        catch (ChartConfigurationException e1) {
            return;
        }
        this.nominalPlotConfig.getDomainConfigManager().setGrouping(edfg);
        RangeAxisConfig nominalRangeAxis = new RangeAxisConfig("", this.nominalPlotConfig);
        ValueSource nominalValueSource = new ValueSource(this.nominalPlotConfig, mainColumn, AbstractAggregationFunction.AggregationFunctionType.count, true);
        nominalValueSource.getSeriesFormat().setSeriesType(SeriesFormat.VisualizationType.BARS);
        nominalValueSource.getSeriesFormat().setStackingMode(SeriesFormat.StackingMode.RELATIVE);
        nominalRangeAxis.addValueSource(nominalValueSource, this.nominalPlotConfig.getAutomaticSeriesFormatForNextValueSource(nominalRangeAxis));
        this.nominalPlotConfig.addRangeAxisConfig(nominalRangeAxis);
        DefaultDimensionConfig nominalColorDimension = new DefaultDimensionConfig(this.nominalPlotConfig, mainColumn, DimensionConfig.PlotDimension.COLOR);
        try {
            edfgColor = new EqualDataFractionGrouping(mainColumn, groupinBins, true, DateFormat.getDateTimeInstance());
        }
        catch (ChartConfigurationException e1) {
            return;
        }
        nominalColorDimension.setGrouping(edfgColor);
        this.nominalPlotConfig.setDimensionConfig(DimensionConfig.PlotDimension.COLOR, nominalColorDimension);
        PlotInstance nominalPlotInstance = new PlotInstance(this.nominalPlotConfig, (DataTable)dataTable);
        this.nominalPlotter = new JFreeChartPlotEngine(nominalPlotInstance, true);
        this.gradientPlotter.endInitializing();
        this.nominalPlotter.endInitializing();
    }

    private Color createColorDialog(Color oldColor) {
        return JColorChooser.showDialog((Component)((Object)this), I18N.getGUILabel((String)"plotter.configuration_dialog.color_scheme_dialog.new_category_color.label", (Object[])new Object[0]), oldColor);
    }

    private String createNameDialog(String oldName) {
        String newName = SwingTools.showInputDialog((String)"plotter.configuration_dialog.color_scheme_dialog.rename", (String)oldName, (Object[])new Object[0]);
        if (newName != null) {
            boolean success;
            boolean bl = success = this.currentColorSchemes.get(newName) == null;
            if (newName.equals(oldName)) {
                success = true;
            }
            if (!success) {
                SwingTools.showVerySimpleErrorMessage((String)"cannot_rename_entry", (Object[])new Object[]{oldName, newName});
                return oldName;
            }
            return newName;
        }
        return null;
    }

    private void calculateGradientPreview() {
        Color startColor = (Color)this.gradientStartColorComboBox.getSelectedItem();
        Color endColor = (Color)this.gradientEndColorComboBox.getSelectedItem();
        if (startColor != null && endColor != null) {
            int width = this.preview.getWidth() - 1;
            ContinuousColorProvider colorProvider = new ContinuousColorProvider(1.0, width, startColor, endColor, 255, false);
            float[] fractions = new float[width];
            Color[] colors = new Color[width];
            for (int i = 0; i < width; ++i) {
                float fraction = (float)i / ((float)width - 1.0f);
                double fractionValue = 1.0f + fraction * (float)(width - 1);
                colors[i] = colorProvider.getColorForValue(fractionValue);
                fractions[i] = fraction;
            }
            Point leftPoint = new Point(0, 0);
            Point rightPoint = new Point(width, 0);
            LinearGradientPaint gradient = new LinearGradientPaint(leftPoint, rightPoint, fractions, colors, MultipleGradientPaint.CycleMethod.REFLECT);
            this.preview.setGradientPaint(gradient);
            this.preview.repaint();
        }
    }

    private ColorScheme getCurrentActiveColorScheme() {
        return this.currentColorSchemes.get(this.currentActiveColorSchemeName);
    }

    private void moveSelectedColorUpAction() {
        Color color = this.colorList.getSelectedValue();
        int oldIndex = this.colorList.getSelectedIndex();
        if (color != null) {
            if (oldIndex == 0) {
                return;
            }
            this.nominalColorListModel.remove(oldIndex);
            int newIndex = oldIndex - 1;
            this.nominalColorListModel.add(newIndex, color);
            this.getCurrentActiveColorScheme().exchange(oldIndex, newIndex);
            this.adaptNominalPlot();
            this.colorList.setSelectedIndex(newIndex);
            this.saveButton.setEnabled(true);
            this.revertButton.setEnabled(true);
        }
    }

    private void moveSelectedColorDownAction() {
        Color color = this.colorList.getSelectedValue();
        int oldIndex = this.colorList.getSelectedIndex();
        if (color != null) {
            if (oldIndex == this.nominalColorListModel.getSize() - 1) {
                return;
            }
            this.nominalColorListModel.remove(oldIndex);
            int newIndex = oldIndex + 1;
            this.nominalColorListModel.add(newIndex, color);
            this.getCurrentActiveColorScheme().exchange(oldIndex, newIndex);
            this.adaptNominalPlot();
            this.colorList.setSelectedIndex(newIndex);
            this.saveButton.setEnabled(true);
            this.revertButton.setEnabled(true);
        }
    }

    private void replaceSelectedColorAction() {
        Color oldColor = this.colorList.getSelectedValue();
        Color newSchemeColor = this.createColorDialog(oldColor);
        if (newSchemeColor != null && !newSchemeColor.equals(oldColor)) {
            this.replaceColorAction(newSchemeColor, oldColor);
            this.adaptPreviewPlots();
        }
    }

    private void removeSelectedColorAction() {
        Color color = this.colorList.getSelectedValue();
        if (color != null) {
            this.saveButton.setEnabled(true);
            this.revertButton.setEnabled(true);
            this.nominalColorListModel.removeElement(color);
            this.getCurrentActiveColorScheme().removeColor(ColorRGB.convertColorToColorRGB(color));
            Color oldStartingColor = (Color)this.gradientStartColorComboBox.getSelectedItem();
            this.gradientStartColorComboBoxModel.removeElement(color);
            if (!color.equals(oldStartingColor)) {
                this.gradientStartColorComboBox.setSelectedItem(oldStartingColor);
            }
            this.gradientStartColorComboBox.setSelectedItem(oldStartingColor);
            Color oldEndingColor = (Color)this.gradientEndColorComboBox.getSelectedItem();
            this.gradientEndColorComboBoxModel.removeElement(color);
            if (!color.equals(oldEndingColor)) {
                this.gradientEndColorComboBox.setSelectedItem(oldEndingColor);
            }
            this.checkIfButtonsEnabled();
            this.adaptPreviewPlots();
        }
    }

    private void addColorAction(Color newSchemeColor) {
        this.saveButton.setEnabled(true);
        this.revertButton.setEnabled(true);
        if (!this.nominalColorListModel.contains(newSchemeColor)) {
            this.nominalColorListModel.addElement(newSchemeColor);
            this.colorList.ensureIndexIsVisible(this.nominalColorListModel.getSize() - 1);
            this.getCurrentActiveColorScheme().addColor(ColorRGB.convertColorToColorRGB(newSchemeColor));
            Color oldStartingColor = (Color)this.gradientStartColorComboBox.getSelectedItem();
            this.gradientStartColorComboBoxModel.addElement(newSchemeColor);
            this.gradientStartColorComboBox.setSelectedItem(oldStartingColor);
            Color oldEndingColor = (Color)this.gradientEndColorComboBox.getSelectedItem();
            this.gradientEndColorComboBoxModel.addElement(newSchemeColor);
            this.gradientEndColorComboBox.setSelectedItem(oldEndingColor);
            this.checkIfButtonsEnabled();
            this.adaptNominalPlot();
        }
    }

    private void renameColorSchemeAction(String newName) {
        this.saveButton.setEnabled(true);
        this.revertButton.setEnabled(true);
        ColorScheme currentActiveScheme = this.getCurrentActiveColorScheme();
        this.currentColorSchemes.remove(this.currentActiveColorSchemeName);
        currentActiveScheme.setName(newName);
        this.currentColorSchemes.put(newName, currentActiveScheme);
        this.currentActiveColorSchemeName = newName;
        int indexOf = this.colorSchemeComboBoxModel.getIndexOf(currentActiveScheme);
        this.colorSchemeComboBoxModel.removeElement(currentActiveScheme);
        this.colorSchemeComboBoxModel.insertElementAt(currentActiveScheme, indexOf);
        this.colorSchemeComboBoxModel.setSelectedItem(currentActiveScheme);
    }

    private void replaceColorAction(Color newSchemeColor, Color oldSchemeColor) {
        this.saveButton.setEnabled(true);
        this.revertButton.setEnabled(true);
        int index = this.nominalColorListModel.indexOf(oldSchemeColor);
        this.nominalColorListModel.set(index, newSchemeColor);
        this.colorList.ensureIndexIsVisible(index);
        this.getCurrentActiveColorScheme().setColor(ColorRGB.convertColorToColorRGB(oldSchemeColor), ColorRGB.convertColorToColorRGB(newSchemeColor));
        Color oldStartingColor = (Color)this.gradientStartColorComboBox.getSelectedItem();
        this.gradientStartColorComboBoxModel.removeAllElements();
        Color oldEndingColor = (Color)this.gradientEndColorComboBox.getSelectedItem();
        this.gradientEndColorComboBoxModel.removeAllElements();
        int size = this.nominalColorListModel.getSize();
        for (int i = 0; i < size; ++i) {
            Color color = this.nominalColorListModel.getElementAt(i);
            this.gradientStartColorComboBoxModel.addElement(color);
            this.gradientEndColorComboBoxModel.addElement(color);
        }
        this.gradientStartColorComboBox.setSelectedItem(oldStartingColor);
        this.gradientEndColorComboBox.setSelectedItem(oldEndingColor);
        this.checkIfButtonsEnabled();
    }

    private void addNewColorSchemeAction(String name) {
        this.saveButton.setEnabled(true);
        this.revertButton.setEnabled(true);
        ColorScheme newColorScheme = this.gradientPlotConfig.getDefaultColorScheme();
        newColorScheme.setName(name);
        this.currentColorSchemes.put(name, newColorScheme);
        this.currentActiveColorSchemeName = name;
        this.adaptModels();
    }

    private void removeColorSchemeAction(ColorScheme schemeToRemove) {
        this.saveButton.setEnabled(true);
        this.revertButton.setEnabled(true);
        this.currentColorSchemes.remove(schemeToRemove.getName());
        this.colorSchemeComboBoxModel.removeElement(schemeToRemove);
        this.colorSchemeComboBox.setSelectedIndex(0);
        ColorScheme selectedItem = (ColorScheme)this.colorSchemeComboBox.getSelectedItem();
        this.currentActiveColorSchemeName = selectedItem == null ? this.gradientPlotConfig.getDefaultColorScheme().getName() : selectedItem.getName();
        this.adaptModels();
    }

    private void revert() {
        this.save(this.initialColorSchemes, this.initialActiveColorSchemeName);
    }

    private void save(Map<String, ColorScheme> colorSchemes, String activeSchemeId) {
        this.saveButton.setEnabled(false);
        this.revertButton.setEnabled(false);
        HashMap<String, ColorScheme> initialColorSchemes = new HashMap<String, ColorScheme>();
        HashMap<String, ColorScheme> currentColorSchemes = new HashMap<String, ColorScheme>();
        for (ColorScheme scheme : colorSchemes.values()) {
            if (scheme == null) continue;
            initialColorSchemes.put(scheme.getName(), scheme.clone());
            currentColorSchemes.put(scheme.getName(), scheme.clone());
        }
        this.currentActiveColorSchemeName = activeSchemeId;
        this.initialActiveColorSchemeName = activeSchemeId;
        this.initialColorSchemes = initialColorSchemes;
        this.currentColorSchemes = currentColorSchemes;
        this.adaptModels();
    }

    protected void ok() {
        this.plotConfig.setColorSchemes(this.currentColorSchemes, this.currentActiveColorSchemeName);
        super.ok();
    }

    private void adaptModels() {
        this.adaptingModels = true;
        this.nominalColorListModel.clear();
        this.gradientStartColorComboBoxModel.removeAllElements();
        this.gradientEndColorComboBoxModel.removeAllElements();
        this.colorSchemeComboBoxModel.removeAllElements();
        List<ColorRGB> colors = this.getCurrentActiveColorScheme().getColors();
        for (ColorRGB color : colors) {
            Color convertToColor = ColorRGB.convertToColor(color);
            this.nominalColorListModel.addElement(convertToColor);
            this.gradientStartColorComboBoxModel.addElement(convertToColor);
            this.gradientEndColorComboBoxModel.addElement(convertToColor);
        }
        Color gradientStartColor = ColorRGB.convertToColor(this.getCurrentActiveColorScheme().getGradientStartColor());
        Color gradientEndColor = ColorRGB.convertToColor(this.getCurrentActiveColorScheme().getGradientEndColor());
        this.gradientStartColorComboBox.setSelectedItem(gradientStartColor);
        this.gradientEndColorComboBox.setSelectedItem(gradientEndColor);
        for (ColorScheme colorScheme : this.currentColorSchemes.values()) {
            if (colorScheme == null) continue;
            this.colorSchemeComboBoxModel.addElement(colorScheme);
        }
        this.colorSchemeComboBoxModel.addElement(I18N.getGUILabel((String)"plotter.configuration_dialog.color_scheme_dialog.add_new_scheme.label", (Object[])new Object[0]));
        this.colorSchemeComboBox.setSelectedItem(this.getCurrentActiveColorScheme());
        this.calculateGradientPreview();
        this.checkIfButtonsEnabled();
        this.adaptPreviewPlots();
        this.adaptingModels = false;
    }

    private void adaptNominalPlot() {
        if (!this.initializing) {
            EqualDataFractionGrouping edfg = (EqualDataFractionGrouping)this.nominalPlotConfig.getDimensionConfig(DimensionConfig.PlotDimension.COLOR).getGrouping();
            edfg.setBinCount(this.getCurrentActiveColorScheme().getColors().size());
            this.nominalPlotConfig.addColorSchemeAndSetActive(this.getCurrentActiveColorScheme());
        }
    }

    private void adaptGradientPlot() {
        if (!this.initializing) {
            this.gradientPlotConfig.addColorSchemeAndSetActive(this.getCurrentActiveColorScheme());
        }
    }

    private void adaptPreviewPlots() {
        this.adaptNominalPlot();
        this.adaptGradientPlot();
    }

    private void checkIfButtonsEnabled() {
        this.removeCategoryColorButton.setEnabled(this.nominalColorListModel.getSize() > 2);
        boolean enableSchemeRemove = !((ColorScheme)this.colorSchemeComboBox.getSelectedItem()).getName().equals(I18N.getGUILabel((String)"plotter.default_color_scheme_name.label", (Object[])new Object[0]));
        this.removeSchemeButton.setEnabled(this.colorSchemeComboBoxModel.getSize() > 2 && enableSchemeRemove);
        this.renameSchemeButton.setEnabled(enableSchemeRemove);
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        PlotConfigurationChangeEvent.PlotConfigurationChangeType type = change.getType();
        switch (type) {
            case COLOR_SCHEME: {
                PlotConfiguration plotConfig = change.getSource();
                this.save(plotConfig.getColorSchemes(), plotConfig.getActiveColorScheme().getName());
                break;
            }
        }
        return true;
    }

    private class GradientPreview
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private LinearGradientPaint gradientPaint;
        public static final int WIDTH = 50;
        private static final int HEIGHT = 30;

        public GradientPreview(LinearGradientPaint paint) {
            this.gradientPaint = paint;
            this.setSize(new Dimension(50, 30));
            this.setPreferredSize(new Dimension(50, 30));
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            if (this.gradientPaint == null) {
                g2d.setPaint(Color.gray);
            } else {
                g2d.setPaint(this.gradientPaint);
            }
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        public void setGradientPaint(LinearGradientPaint gradientPaint) {
            this.gradientPaint = gradientPaint;
        }
    }
}

