/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.ChartConfigurationException;
import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.DomainConfigManager;
import com.owc.gui.charting.configuration.ValueGrouping;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.AbstractConfigurationPanel;
import com.owc.gui.charting.gui.GroupingConfigurationPanel;
import com.owc.gui.charting.gui.cellrenderer.EnumComboBoxCellRenderer;
import com.owc.gui.charting.gui.popup.PopupAction;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Objects;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DimensionConfigPanel
extends AbstractConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private final DimensionConfig.PlotDimension dimension;
    private ResourceLabel dimensionLabelLabel;
    private JTextField dimensionLabelTextField;
    private JCheckBox automateLabelCheckBox;
    private ResourceLabel dateFormatLabel;
    private JTextField dateFormatTextField;
    private JCheckBox useDefaultDateFormatCheckBox;
    private JCheckBox logarithmicCheckBox;
    private JLabel upperBoundLabel;
    private JSpinner upperBoundSpinner;
    private JLabel lowerBoundLabel;
    private JSpinner lowerBoundSpinner;
    private JLabel logarithmicLabel;
    private JLabel groupingLabel;
    private JComboBox<ValueGrouping.GroupingType> groupingComboBox;
    private JToggleButton groupingConfigButton;
    private GroupingConfigurationPanel groupingConfigurationPanel;
    private JCheckBox lowerBoundCheckBox;
    private JCheckBox upperBoundCheckBox;
    private JLabel sortingLabel;
    private AbstractButton sortedCheckBox;

    public DimensionConfigPanel(DimensionConfig.PlotDimension dimension, JTree plotConfigurationTree, PlotInstance plotInstance) {
        super(plotInstance);
        this.dimension = dimension;
        this.groupingConfigurationPanel = new GroupingConfigurationPanel(plotConfigurationTree, plotInstance, dimension);
        this.addPlotInstanceChangeListener(this.groupingConfigurationPanel);
        this.createComponents();
        this.registerAsPlotConfigurationListener();
        this.adaptGUI();
    }

    private void createComponents() {
        this.dimensionLabelLabel = new ResourceLabel("plotter.configuration_dialog.dimension_axis_title", new Object[0]);
        this.dimensionLabelTextField = new JTextField();
        this.dimensionLabelLabel.setLabelFor((Component)this.dimensionLabelTextField);
        this.dimensionLabelTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DimensionConfig dimensionConfig = DimensionConfigPanel.this.getPlotConfiguration().getDimensionConfig(DimensionConfigPanel.this.dimension);
                if (dimensionConfig != null) {
                    String oldLabel = dimensionConfig.getLabel();
                    String newLabel = DimensionConfigPanel.this.dimensionLabelTextField.getText();
                    if (oldLabel != null && !oldLabel.equals(newLabel) || oldLabel == null && newLabel.length() > 0) {
                        if (newLabel.length() > 0) {
                            dimensionConfig.setLabel(newLabel);
                        } else {
                            dimensionConfig.setLabel(null);
                        }
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.dimensionLabelTextField.setPreferredSize(new Dimension(100, 22));
        this.automateLabelCheckBox = new JCheckBox(I18N.getGUILabel((String)"plotter.configuration_dialog.automatic_axis_label.label", (Object[])new Object[0]));
        this.automateLabelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DimensionConfig dimensionConfig = DimensionConfigPanel.this.getPlotConfiguration().getDimensionConfig(DimensionConfigPanel.this.dimension);
                if (dimensionConfig != null) {
                    dimensionConfig.setAutoNaming(DimensionConfigPanel.this.automateLabelCheckBox.isSelected());
                }
            }
        });
        this.addThreeComponentRow(this, (JLabel)this.dimensionLabelLabel, this.dimensionLabelTextField, this.automateLabelCheckBox);
        this.dateFormatLabel = new ResourceLabel("plotter.configuration_dialog.date_format", new Object[0]);
        this.dateFormatTextField = new JTextField();
        this.dateFormatLabel.setLabelFor((Component)this.dateFormatTextField);
        this.dateFormatTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DimensionConfig dimensionConfig = DimensionConfigPanel.this.getPlotConfiguration().getDimensionConfig(DimensionConfigPanel.this.dimension);
                if (dimensionConfig != null) {
                    String oldFormat = dimensionConfig.getUserDefinedDateFormatString();
                    String newFormat = DimensionConfigPanel.this.dateFormatTextField.getText();
                    if (oldFormat != null && !oldFormat.equals(newFormat) || oldFormat == null && newFormat.length() > 0) {
                        if (newFormat.length() > 0) {
                            dimensionConfig.setUserDefinedDateFormatString(newFormat);
                        } else {
                            dimensionConfig.setLabel(null);
                        }
                    }
                }
            }
        });
        this.useDefaultDateFormatCheckBox = new JCheckBox(I18N.getGUILabel((String)"plotter.configuration_dialog.use_default_date_format.label", (Object[])new Object[0]));
        this.useDefaultDateFormatCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DimensionConfig dimensionConfig = DimensionConfigPanel.this.getPlotConfiguration().getDimensionConfig(DimensionConfigPanel.this.dimension);
                if (dimensionConfig != null) {
                    dimensionConfig.setUseUserDefinedDateFormat(!DimensionConfigPanel.this.useDefaultDateFormatCheckBox.isSelected());
                }
            }
        });
        this.addThreeComponentRow(this, (JLabel)this.dateFormatLabel, this.dateFormatTextField, this.useDefaultDateFormatCheckBox);
        this.groupingLabel = new ResourceLabel("plotter.configuration_dialog.grouping", new Object[0]);
        this.groupingLabel.setPreferredSize(new Dimension(80, 15));
        this.groupingComboBox = new JComboBox<ValueGrouping.GroupingType>(ValueGrouping.GroupingType.values());
        this.groupingLabel.setLabelFor(this.groupingComboBox);
        this.groupingComboBox.setRenderer(new EnumComboBoxCellRenderer("plotter.grouping_type"));
        this.groupingComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                DimensionConfig dimensionConfig = DimensionConfigPanel.this.getPlotConfiguration().getDimensionConfig(DimensionConfigPanel.this.dimension);
                if (dimensionConfig != null) {
                    boolean groupingTypeChanged;
                    ValueGrouping.GroupingType groupingType = (ValueGrouping.GroupingType)((Object)DimensionConfigPanel.this.groupingComboBox.getSelectedItem());
                    ValueGrouping grouping = dimensionConfig.getGrouping();
                    boolean newGroupingNoneAndOldGroupingSet = groupingType == ValueGrouping.GroupingType.NONE && grouping != null;
                    boolean newGroupingAndNotGrouping = groupingType != ValueGrouping.GroupingType.NONE && grouping == null;
                    boolean bl = groupingTypeChanged = grouping != null && groupingType != grouping.getGroupingType();
                    if (newGroupingNoneAndOldGroupingSet || newGroupingAndNotGrouping || groupingTypeChanged) {
                        ValueGrouping oldGrouping = grouping;
                        boolean categorical = true;
                        if (oldGrouping != null) {
                            categorical = oldGrouping.isCategorical();
                        }
                        ValueGrouping newGrouping = null;
                        try {
                            newGrouping = ValueGrouping.ValueGroupingFactory.getValueGrouping(groupingType, dimensionConfig.getDataTableColumn(), categorical, dimensionConfig.getDateFormat());
                            dimensionConfig.setGrouping(newGrouping);
                        }
                        catch (ChartConfigurationException e1) {
                            PlotConfigurationError plotConfigurationError = e1.getResponse().getErrors().get(0);
                            SwingTools.showVerySimpleErrorMessage((String)plotConfigurationError.getErrorId(), (Object[])plotConfigurationError.getMessageParameters());
                            if (oldGrouping == null) {
                                DimensionConfigPanel.this.groupingComboBox.setSelectedItem((Object)ValueGrouping.GroupingType.NONE);
                            } else {
                                DimensionConfigPanel.this.groupingComboBox.setSelectedItem((Object)oldGrouping.getGroupingType());
                            }
                            DimensionConfigPanel.this.adaptGUI();
                            return;
                        }
                    }
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.groupingConfigButton = new JToggleButton((Action)((Object)new PopupAction(true, "plotter.configuration_dialog.configure_grouping", (Component)this.groupingConfigurationPanel, PopupAction.PopupPosition.HORIZONTAL, new Object[0])));
        this.addThreeComponentRow(this, this.groupingLabel, this.groupingComboBox, this.groupingConfigButton);
        this.logarithmicLabel = new ResourceLabel("plotter.configuration_dialog.logarithmic", new Object[0]);
        this.logarithmicCheckBox = new JCheckBox();
        this.logarithmicLabel.setLabelFor(this.logarithmicCheckBox);
        this.logarithmicCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DimensionConfig dimensionConfig = DimensionConfigPanel.this.getPlotConfiguration().getDimensionConfig(DimensionConfigPanel.this.dimension);
                if (dimensionConfig != null) {
                    dimensionConfig.setLogarithmic(DimensionConfigPanel.this.logarithmicCheckBox.isSelected());
                }
            }
        });
        this.addTwoComponentRow(this, this.logarithmicLabel, this.logarithmicCheckBox);
        if (this.dimension == DimensionConfig.PlotDimension.DOMAIN) {
            this.sortingLabel = new ResourceLabel("plotter.configuration_dialog.sorting", new Object[0]);
            this.sortedCheckBox = new JCheckBox();
            this.sortingLabel.setLabelFor(this.sortedCheckBox);
            this.sortedCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DomainConfigManager domainMngr = DimensionConfigPanel.this.getPlotConfiguration().getDomainConfigManager();
                    if (DimensionConfigPanel.this.sortedCheckBox.isSelected()) {
                        domainMngr.setSortingMode(DomainConfigManager.Sorting.ASCENDING);
                    } else {
                        domainMngr.setSortingMode(DomainConfigManager.Sorting.NONE);
                    }
                }
            });
            this.addTwoComponentRow(this, this.sortingLabel, this.sortedCheckBox);
        }
        this.upperBoundLabel = new ResourceLabel("plotter.configuration_dialog.upper_filter", new Object[0]);
        this.upperBoundSpinner = new JSpinner(new SpinnerNumberModel((Number)1.0, null, null, (Number)0.1));
        this.upperBoundLabel.setLabelFor(this.upperBoundSpinner);
        this.upperBoundSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Double newUpperBound;
                Double oldUpperBound;
                DimensionConfig dimensionConfig = DimensionConfigPanel.this.getPlotConfiguration().getDimensionConfig(DimensionConfigPanel.this.dimension);
                if (dimensionConfig != null && !Objects.equals(oldUpperBound = dimensionConfig.getUserDefinedUpperBound(), newUpperBound = (Double)DimensionConfigPanel.this.upperBoundSpinner.getValue())) {
                    dimensionConfig.setUpperBound(newUpperBound);
                }
            }
        });
        this.upperBoundCheckBox = new JCheckBox(I18N.getGUILabel((String)"plotter.configuration_dialog.use_filter.label", (Object[])new Object[0]));
        this.upperBoundCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DimensionConfig dimensionConfig = DimensionConfigPanel.this.getPlotConfiguration().getDimensionConfig(DimensionConfigPanel.this.dimension);
                if (dimensionConfig != null) {
                    dimensionConfig.setUseUserDefinedUpperBound(DimensionConfigPanel.this.upperBoundCheckBox.isSelected());
                }
            }
        });
        this.addThreeComponentRow(this, this.upperBoundLabel, this.upperBoundSpinner, this.upperBoundCheckBox);
        this.lowerBoundLabel = new ResourceLabel("plotter.configuration_dialog.lower_filter", new Object[0]);
        this.lowerBoundSpinner = new JSpinner(new SpinnerNumberModel((Number)0.0, null, null, (Number)0.1));
        this.lowerBoundLabel.setLabelFor(this.lowerBoundSpinner);
        this.lowerBoundSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Double newLowerBound;
                Double oldLowerBound;
                DimensionConfig dimensionConfig = DimensionConfigPanel.this.getPlotConfiguration().getDimensionConfig(DimensionConfigPanel.this.dimension);
                if (dimensionConfig != null && !Objects.equals(oldLowerBound = dimensionConfig.getUserDefinedLowerBound(), newLowerBound = (Double)DimensionConfigPanel.this.lowerBoundSpinner.getValue())) {
                    dimensionConfig.setLowerBound(newLowerBound);
                }
            }
        });
        this.lowerBoundCheckBox = new JCheckBox(I18N.getGUILabel((String)"plotter.configuration_dialog.use_filter.label", (Object[])new Object[0]));
        this.lowerBoundCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DimensionConfig dimensionConfig = DimensionConfigPanel.this.getPlotConfiguration().getDimensionConfig(DimensionConfigPanel.this.dimension);
                if (dimensionConfig != null) {
                    dimensionConfig.setUseUserDefinedLowerBound(DimensionConfigPanel.this.lowerBoundCheckBox.isSelected());
                }
            }
        });
        this.addThreeComponentRow(this, this.lowerBoundLabel, this.lowerBoundSpinner, this.lowerBoundCheckBox);
        JPanel spacerPanel = new JPanel();
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.gridwidth = 0;
        this.add((Component)spacerPanel, itemConstraint);
    }

    private void upperBoundChanged(Double upperBound) {
        this.upperBoundSpinner.setValue(upperBound);
    }

    private void lowerBoundChanged(Double lowerBound) {
        this.lowerBoundSpinner.setValue(lowerBound);
    }

    private void useLowerBoundChanged(boolean useLowerBound, boolean nominalAxis) {
        this.lowerBoundCheckBox.setSelected(useLowerBound);
        this.lowerBoundSpinner.setEnabled(useLowerBound && !nominalAxis);
        this.lowerBoundCheckBox.setEnabled(!nominalAxis);
        this.lowerBoundLabel.setEnabled(!nominalAxis);
    }

    private void useUpperBoundChanged(boolean useUpperBound, boolean nominalAxis) {
        this.upperBoundCheckBox.setSelected(useUpperBound);
        this.upperBoundSpinner.setEnabled(useUpperBound && !nominalAxis);
        this.upperBoundCheckBox.setEnabled(!nominalAxis);
        this.upperBoundLabel.setEnabled(!nominalAxis);
    }

    private void logarithmicChanged(boolean logarithmic) {
        this.logarithmicCheckBox.setSelected(logarithmic);
    }

    private void dimensionLabelChanged(String label) {
        if (!this.dimensionLabelTextField.getText().equals(label)) {
            if (label != null) {
                this.dimensionLabelTextField.setText(label);
            } else {
                this.dimensionLabelTextField.setText("");
            }
        }
    }

    private void autoNamingChanged(boolean autoNaming) {
        this.automateLabelCheckBox.setSelected(autoNaming);
        this.dimensionLabelTextField.setEnabled(!autoNaming);
    }

    @Override
    protected void adaptGUI() {
        DimensionConfig dimensionConfig = this.getPlotConfiguration().getDimensionConfig(this.dimension);
        DataTable dataTable = this.getCurrentPlotInstance().getPlotData().getOriginalDataTable();
        if (dimensionConfig != null && dimensionConfig.getDataTableColumn().isValidForDataTable(dataTable)) {
            boolean enableOptions;
            this.enableAllComponents();
            boolean bl = enableOptions = !dimensionConfig.getDataTableColumn().isNominal() && !dimensionConfig.getDataTableColumn().isDate();
            if (this.dimension == DimensionConfig.PlotDimension.DOMAIN) {
                DomainConfigManager domCnfMngr = (DomainConfigManager)dimensionConfig;
                this.sortedCheckBox.setSelected(domCnfMngr.getSortingMode() != DomainConfigManager.Sorting.NONE);
                this.sortedCheckBox.setVisible(enableOptions);
                this.sortingLabel.setVisible(enableOptions);
            }
            boolean dateFormatConfigVisible = dimensionConfig.getDataTableColumn().isDate();
            this.dateFormatTextField.setVisible(dateFormatConfigVisible);
            this.dateFormatLabel.setVisible(dateFormatConfigVisible);
            this.useDefaultDateFormatCheckBox.setVisible(dateFormatConfigVisible);
            String userDefinedDateFormatString = dimensionConfig.getUserDefinedDateFormatString();
            String text = this.dateFormatTextField.getText();
            if (!text.equals(userDefinedDateFormatString)) {
                this.dateFormatTextField.setText(userDefinedDateFormatString);
            }
            this.dateFormatTextField.setEnabled(dimensionConfig.isUsingUserDefinedDateFormat());
            this.useDefaultDateFormatCheckBox.setSelected(!dimensionConfig.isUsingUserDefinedDateFormat());
            this.lowerBoundCheckBox.setVisible(enableOptions);
            this.lowerBoundLabel.setVisible(enableOptions);
            this.lowerBoundSpinner.setVisible(enableOptions);
            this.upperBoundCheckBox.setVisible(enableOptions);
            this.upperBoundLabel.setVisible(enableOptions);
            this.upperBoundSpinner.setVisible(enableOptions);
            this.logarithmicLabel.setVisible(enableOptions);
            this.logarithmicCheckBox.setVisible(enableOptions);
            Vector<ValueGrouping.GroupingType> validGroupings = dimensionConfig.getValidGroupingTypes();
            DefaultComboBoxModel<ValueGrouping.GroupingType> model = new DefaultComboBoxModel<ValueGrouping.GroupingType>(validGroupings);
            this.groupingComboBox.setModel(model);
            this.autoNamingChanged(dimensionConfig.isAutoNaming());
            this.dimensionLabelChanged(dimensionConfig.getLabel());
            boolean groupingEnabled = false;
            ValueGrouping grouping = dimensionConfig.getGrouping();
            ValueGrouping.GroupingType groupingType = null;
            if (grouping != null) {
                groupingType = grouping.getGroupingType();
                if (groupingType != ValueGrouping.GroupingType.DISTINCT_VALUES || dimensionConfig.getDataTableColumn().getValueType() != DataTableColumn.ValueType.NOMINAL) {
                    groupingEnabled = true;
                }
                this.groupingComboBox.setSelectedItem((Object)groupingType);
            } else {
                this.groupingComboBox.setSelectedItem((Object)ValueGrouping.GroupingType.NONE);
            }
            this.groupingConfigButton.setEnabled(groupingEnabled);
            this.logarithmicChanged(dimensionConfig.isLogarithmic());
            boolean nominal = dimensionConfig.getDataTableColumn().getValueType() == DataTableColumn.ValueType.NOMINAL && dimensionConfig.isNominal();
            this.lowerBoundChanged(dimensionConfig.getUserDefinedLowerBound());
            this.useLowerBoundChanged(dimensionConfig.isUsingUserDefinedLowerBound(), nominal);
            this.upperBoundChanged(dimensionConfig.getUserDefinedUpperBound());
            this.useUpperBoundChanged(dimensionConfig.isUsingUserDefinedUpperBound(), nominal);
        } else {
            this.disableAllComponents();
        }
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        this.adaptGUI();
        return true;
    }
}

