/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontDialog
extends ButtonDialog {
    private static final String BOLD_ITALIC = "Bold Italic";
    private static final String ITALIC = "Italic";
    private static final String BOLD = "Bold";
    private static final String PLAIN = "Plain";
    private static final long serialVersionUID = 1L;
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private Font font;
    private int returnStatus;
    private JPanel mainPanel;
    private JPanel fontPanel;
    private JLabel fontLabel;
    private JLabel styleLabel;
    private JLabel sizeLabel;
    private JList<String> fontList;
    private JScrollPane fontScrollPane;
    private JList<String> styleList;
    private JScrollPane styleScrollPane;
    private JList<String> sizeList;
    private JScrollPane sizeScrollPane;
    private JPanel previewPanel;
    private JLabel previewLabel;

    public FontDialog(Component parent, Font font, String i18nKey) {
        super(parent != null ? SwingUtilities.getWindowAncestor(parent) : null, i18nKey, Dialog.ModalityType.APPLICATION_MODAL, new Object[0]);
        this.font = font;
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FontDialog.this.closeDialog(e);
            }
        });
        this.createComponents();
        this.pack();
        this.setSize(new Dimension(443, 429));
        this.setLocationRelativeTo(parent);
        this.initComponents(font);
        ResourceAction cancelAction = new ResourceAction(i18nKey, new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                FontDialog.this.doClose(0);
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "CANCEL");
        this.getRootPane().getActionMap().put("CANCEL", (Action)cancelAction);
    }

    private void createComponents() {
        GridBagConstraints itemConstraint = new GridBagConstraints();
        Insets standardInsets = new Insets(1, 1, 1, 1);
        this.mainPanel = new JPanel(new GridLayout(2, 1));
        this.fontPanel = new JPanel(new GridBagLayout());
        this.fontLabel = new ResourceLabel("plotter.configuration_dialog.font_dialog.font", new Object[0]);
        itemConstraint.fill = 2;
        itemConstraint.insets = standardInsets;
        itemConstraint.weightx = 2.0;
        this.fontPanel.add((Component)this.fontLabel, itemConstraint);
        this.styleLabel = new ResourceLabel("plotter.configuration_dialog.font_dialog.style", new Object[0]);
        itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 2;
        itemConstraint.insets = standardInsets;
        this.fontPanel.add((Component)this.styleLabel, itemConstraint);
        this.sizeLabel = new ResourceLabel("plotter.configuration_dialog.font_dialog.size", new Object[0]);
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 0.2;
        itemConstraint.fill = 2;
        itemConstraint.insets = standardInsets;
        this.fontPanel.add((Component)this.sizeLabel, itemConstraint);
        this.fontList = new JList<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(Locale.getDefault()));
        this.fontLabel.setLabelFor(this.fontList);
        this.fontList.setSelectionMode(0);
        this.fontList.setSelectedValue(this.font.getFamily(Locale.getDefault()), true);
        this.fontList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FontDialog.this.fontListValueChanged(e);
            }
        });
        this.fontScrollPane = new JScrollPane();
        this.fontScrollPane.setViewportView(this.fontList);
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 0;
        itemConstraint.gridy = 1;
        itemConstraint.ipadx = 1;
        itemConstraint.weightx = 2.0;
        itemConstraint.fill = 1;
        this.fontPanel.add((Component)this.fontScrollPane, itemConstraint);
        this.styleList = new JList<String>(new AbstractListModel<String>(){
            private static final long serialVersionUID = 1L;
            String[] strings = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.styleLabel.setLabelFor(this.styleList);
        this.styleList.setSelectionMode(0);
        this.styleList.setSelectedValue(this.font.getStyle(), true);
        this.styleList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FontDialog.this.styleListValueChanged(e);
            }
        });
        this.styleScrollPane = new JScrollPane();
        this.styleScrollPane.setViewportView(this.styleList);
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 1;
        itemConstraint.gridy = 1;
        itemConstraint.fill = 2;
        itemConstraint.ipadx = 1;
        itemConstraint.insets = standardInsets;
        this.fontPanel.add((Component)this.styleScrollPane, itemConstraint);
        this.sizeList = new JList<String>(new AbstractListModel<String>(){
            private static final long serialVersionUID = 1L;
            String[] strings = new String[]{"8", "10", "11", "12", "14", "16", "20", "24", "28", "36", "48", "72", "96"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.sizeLabel.setLabelFor(this.sizeList);
        this.sizeList.setSelectedValue(this.font.getSize(), true);
        this.sizeList.setSelectionMode(0);
        this.sizeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FontDialog.this.sizeListValueChanged(e);
            }
        });
        this.sizeScrollPane = new JScrollPane();
        this.sizeScrollPane.setViewportView(this.sizeList);
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 2;
        itemConstraint.gridy = 1;
        itemConstraint.fill = 2;
        itemConstraint.ipadx = 1;
        itemConstraint.insets = standardInsets;
        itemConstraint.weightx = 0.2;
        this.fontPanel.add((Component)this.sizeScrollPane, itemConstraint);
        this.mainPanel.add(this.fontPanel);
        this.previewPanel = new JPanel(new BorderLayout());
        this.previewPanel.setBorder(new TitledBorder(null, "Preview", 0, 0, new Font("Dialog", 0, 12)));
        this.previewLabel = new JLabel("ABCDEFG abcdefg", 0);
        this.previewLabel.setFont(this.font);
        this.previewPanel.add((Component)this.previewLabel, "Center");
        this.mainPanel.add(this.previewPanel);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton okayButton = new JButton((Action)new ResourceAction(false, "plotter.configuration_dialog.okay", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                FontDialog.this.okayButtonPerformed();
            }
        });
        this.getRootPane().setDefaultButton(okayButton);
        buttonPanel.add(okayButton);
        JButton cancelButton = new JButton((Action)new ResourceAction(false, "plotter.configuration_dialog.cancel", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                FontDialog.this.cancelButtonPerformed();
            }
        });
        buttonPanel.add(cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    private void initComponents(Font font) {
        this.fontList.setSelectedValue(font.getFamily(), true);
        this.fontList.ensureIndexIsVisible(this.fontList.getSelectedIndex());
        this.fontListValueChanged(null);
        int size = font.getSize();
        int sizeListSize = this.sizeList.getModel().getSize();
        int distance = Integer.MAX_VALUE;
        int nearestIndex = -1;
        for (int i = 0; i < sizeListSize; ++i) {
            int value = Integer.parseInt(this.sizeList.getModel().getElementAt(i));
            int d = Math.abs(value - size);
            if (d >= distance) continue;
            nearestIndex = i;
            distance = d;
        }
        if (nearestIndex >= 0) {
            this.sizeList.setSelectedIndex(nearestIndex);
        } else {
            this.sizeList.setSelectedValue("12", true);
        }
        this.sizeList.ensureIndexIsVisible(this.sizeList.getSelectedIndex());
        this.sizeListValueChanged(null);
        int style = font.getStyle();
        String selectedValue = null;
        switch (style) {
            case 0: {
                selectedValue = PLAIN;
                break;
            }
            case 1: {
                selectedValue = BOLD;
                break;
            }
            case 2: {
                selectedValue = ITALIC;
                break;
            }
            default: {
                selectedValue = BOLD_ITALIC;
            }
        }
        this.styleList.setSelectedValue(selectedValue, true);
        this.styleList.ensureIndexIsVisible(this.styleList.getSelectedIndex());
        this.styleListValueChanged(null);
    }

    private void cancelButtonPerformed() {
        this.doClose(0);
    }

    private void okayButtonPerformed() {
        this.doClose(1);
    }

    public Font getFont() {
        return this.font;
    }

    private void fontListValueChanged(ListSelectionEvent e) {
        this.font = new Font(this.fontList.getSelectedValue(), this.font.getStyle(), this.font.getSize());
        this.previewLabel.setFont(this.font);
    }

    private void styleListValueChanged(ListSelectionEvent e) {
        int style = -1;
        String selectedStyle = this.styleList.getSelectedValue();
        if (selectedStyle == PLAIN) {
            style = 0;
        }
        if (selectedStyle == BOLD) {
            style = 1;
        }
        if (selectedStyle == ITALIC) {
            style = 2;
        }
        if (selectedStyle == BOLD_ITALIC) {
            style = 3;
        }
        this.font = new Font(this.font.getFamily(), style, this.font.getSize());
        this.previewLabel.setFont(this.font);
    }

    private void sizeListValueChanged(ListSelectionEvent e) {
        int size = Integer.parseInt(this.sizeList.getSelectedValue());
        this.font = new Font(this.font.getFamily(), this.font.getStyle(), size);
        this.previewLabel.setFont(this.font);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }
}

