/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.ValueGrouping;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.AbstractConfigurationPanel;
import com.owc.gui.charting.gui.groupingpanel.DistinctValueGroupingCardPanel;
import com.owc.gui.charting.gui.groupingpanel.EqualDataFractionCardPanel;
import com.owc.gui.charting.gui.groupingpanel.EquidistantFixedBinCountCardPanel;
import com.owc.gui.charting.gui.treenodes.DimensionConfigTreeNode;
import com.owc.gui.charting.listener.PlotInstanceChangedListener;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class GroupingConfigurationPanel
extends AbstractConfigurationPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private Map<ValueGrouping.GroupingType, JPanel> groupingTypeToCardMap = new HashMap<ValueGrouping.GroupingType, JPanel>();
    private final DimensionConfig.PlotDimension dimension;

    public GroupingConfigurationPanel(JTree plotConfigurationTree, PlotInstance plotIntance, DimensionConfig.PlotDimension dimension) {
        super(plotIntance);
        this.setLayout(new CardLayout());
        this.dimension = dimension;
        this.createComponents(dimension);
        this.registerAsPlotConfigurationListener();
        plotConfigurationTree.addTreeSelectionListener(this);
        this.adaptGUI();
    }

    private void createComponents(DimensionConfig.PlotDimension dimension) {
        for (ValueGrouping.GroupingType groupingType : ValueGrouping.GroupingType.values()) {
            JPanel groupingCardPanel = null;
            switch (groupingType) {
                case EQUAL_DATA_FRACTION: {
                    groupingCardPanel = new EqualDataFractionCardPanel(this.getCurrentPlotInstance(), dimension);
                    this.addPlotInstanceChangeListener((PlotInstanceChangedListener)((Object)groupingCardPanel));
                    break;
                }
                case EQUIDISTANT_FIXED_BIN_COUNT: {
                    groupingCardPanel = new EquidistantFixedBinCountCardPanel(this.getCurrentPlotInstance(), dimension);
                    this.addPlotInstanceChangeListener((PlotInstanceChangedListener)((Object)groupingCardPanel));
                    break;
                }
                case NONE: {
                    groupingCardPanel = new JPanel();
                    break;
                }
                case DISTINCT_VALUES: {
                    groupingCardPanel = new DistinctValueGroupingCardPanel(this.getCurrentPlotInstance(), dimension);
                    this.addPlotInstanceChangeListener((PlotInstanceChangedListener)((Object)groupingCardPanel));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown grouping type " + (Object)((Object)groupingType));
                }
            }
            this.add((Component)groupingCardPanel, groupingType.toString());
            this.groupingTypeToCardMap.put(groupingType, groupingCardPanel);
        }
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, ValueGrouping.GroupingType.NONE.toString());
    }

    @Override
    protected void adaptGUI() {
        DimensionConfig dimensionConfig = this.getPlotConfiguration().getDimensionConfig(this.dimension);
        if (dimensionConfig != null) {
            CardLayout cl = (CardLayout)this.getLayout();
            ValueGrouping.GroupingType groupingType = null;
            ValueGrouping grouping = dimensionConfig.getGrouping();
            groupingType = grouping != null ? grouping.getGroupingType() : ValueGrouping.GroupingType.NONE;
            cl.show(this, groupingType.toString());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
        if (newLeadSelectionPath != null && newLeadSelectionPath.getLastPathComponent() instanceof DimensionConfigTreeNode) {
            this.adaptGUI();
        }
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        this.adaptGUI();
        return true;
    }
}

