/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.LineFormat;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.AbstractTreeSelectionDependentPanel;
import com.owc.gui.charting.gui.cellrenderer.EnumComboBoxCellRenderer;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.tools.I18N;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class LineChartConfigurationPanel
extends AbstractTreeSelectionDependentPanel {
    private static final long serialVersionUID = 1L;
    private JLabel itemShapeLabel;
    private JComboBox<SeriesFormat.ItemShape> itemShapeComboBox;
    private JLabel itemColorLabel;
    private JButton itemColorButton;
    private JLabel opacityLabel;
    private JSlider opacitySlider;
    private JLabel lineStyleLabel;
    private JComboBox<LineFormat.LineStyle> lineStyleComboBox;
    private JLabel lineWidthLabel;
    private JSpinner lineWidthSpinner;
    private JLabel itemFillLabel;
    private JComboBox<SeriesFormat.FillStyle> itemFillComboBox;
    private JLabel itemSizeLabel;
    private JSpinner itemSizeSpinner;

    public LineChartConfigurationPanel(boolean smallIcons, JTree plotConfigurationTree, PlotInstance plotInstance) {
        super(plotConfigurationTree, plotInstance);
        this.createComponents(smallIcons);
        this.registerAsPlotConfigurationListener();
        this.initComponents();
    }

    private void createComponents(boolean smallIcons) {
        Dimension preferredSize = new Dimension(70, 24);
        this.itemShapeLabel = new ResourceLabel("plotter.configuration_dialog.itemshape", new Object[0]);
        this.itemShapeLabel.setPreferredSize(preferredSize);
        this.itemShapeComboBox = new JComboBox<SeriesFormat.ItemShape>(SeriesFormat.ItemShape.values());
        this.itemShapeLabel.setLabelFor(this.itemShapeComboBox);
        this.itemShapeComboBox.setPreferredSize(preferredSize);
        this.itemShapeComboBox.setRenderer(new EnumComboBoxCellRenderer("plotter.dotstyle"));
        this.itemShapeComboBox.setSelectedIndex(0);
        this.itemShapeComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (LineChartConfigurationPanel.this.getSelectedValueSource() != null) {
                    LineChartConfigurationPanel.this.getSelectedValueSource().getSeriesFormat().setItemShape((SeriesFormat.ItemShape)((Object)LineChartConfigurationPanel.this.itemShapeComboBox.getSelectedItem()));
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.addTwoComponentRow(this, this.itemShapeLabel, this.itemShapeComboBox);
        this.itemSizeLabel = new ResourceLabel("plotter.configuration_dialog.item_size", new Object[0]);
        this.itemSizeLabel.setPreferredSize(preferredSize);
        this.itemSizeSpinner = new JSpinner(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), null, (Number)0.1));
        this.itemSizeLabel.setLabelFor(this.itemSizeSpinner);
        this.itemSizeSpinner.setPreferredSize(preferredSize);
        this.itemSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LineChartConfigurationPanel.this.getSelectedValueSource() != null) {
                    Double newItemSize = (Double)LineChartConfigurationPanel.this.itemSizeSpinner.getValue();
                    LineChartConfigurationPanel.this.getSelectedValueSource().getSeriesFormat().setItemSize(newItemSize);
                }
            }
        });
        this.addTwoComponentRow(this, this.itemSizeLabel, this.itemSizeSpinner);
        this.lineStyleLabel = new ResourceLabel("plotter.configuration_dialog.line_style", new Object[0]);
        this.lineStyleLabel.setPreferredSize(preferredSize);
        this.lineStyleComboBox = new JComboBox<LineFormat.LineStyle>(LineFormat.LineStyle.values());
        this.lineStyleLabel.setLabelFor(this.lineStyleComboBox);
        this.lineStyleComboBox.setPreferredSize(preferredSize);
        this.lineStyleComboBox.setSelectedIndex(0);
        this.lineStyleComboBox.setRenderer(new EnumComboBoxCellRenderer("plotter.linestyle"));
        this.lineStyleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LineChartConfigurationPanel.this.getSelectedValueSource() != null) {
                    SeriesFormat format = LineChartConfigurationPanel.this.getSelectedValueSource().getSeriesFormat();
                    LineFormat.LineStyle selectedItem = (LineFormat.LineStyle)((Object)LineChartConfigurationPanel.this.lineStyleComboBox.getSelectedItem());
                    if (selectedItem != LineFormat.LineStyle.NONE && format.getAreaFillStyle() != SeriesFormat.FillStyle.SOLID) {
                        format.setAreaFillStyle(SeriesFormat.FillStyle.SOLID);
                    }
                    format.setLineStyle(selectedItem);
                }
            }
        });
        this.addTwoComponentRow(this, this.lineStyleLabel, this.lineStyleComboBox);
        this.lineWidthLabel = new ResourceLabel("plotter.configuration_dialog.line_width", new Object[0]);
        this.lineWidthLabel.setPreferredSize(preferredSize);
        this.lineWidthSpinner = new JSpinner(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f)));
        this.lineWidthLabel.setLabelFor(this.lineWidthSpinner);
        this.lineWidthSpinner.setPreferredSize(preferredSize);
        this.lineWidthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LineChartConfigurationPanel.this.getSelectedValueSource() != null) {
                    float newLineWidth = ((Float)LineChartConfigurationPanel.this.lineWidthSpinner.getValue()).floatValue();
                    LineChartConfigurationPanel.this.getSelectedValueSource().getSeriesFormat().setLineWidth(newLineWidth);
                }
            }
        });
        this.addTwoComponentRow(this, this.lineWidthLabel, this.lineWidthSpinner);
        this.itemColorLabel = new ResourceLabel("plotter.configuration_dialog.item_color", new Object[0]);
        this.itemColorLabel.setPreferredSize(new Dimension(70, 24));
        this.itemColorButton = new JButton((Action)new ResourceAction(smallIcons, "plotter.configuration_dialog.choose_item_color", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                LineChartConfigurationPanel.this.createItemColorDialog();
            }
        });
        this.itemColorLabel.setLabelFor(this.itemColorButton);
        this.itemColorButton.setPreferredSize(preferredSize);
        this.addTwoComponentRow(this, this.itemColorLabel, this.itemColorButton);
        this.itemFillLabel = new ResourceLabel("plotter.configuration_dialog.fill_style", new Object[0]);
        this.itemFillLabel.setPreferredSize(preferredSize);
        this.itemFillComboBox = new JComboBox<SeriesFormat.FillStyle>(SeriesFormat.FillStyle.values());
        this.itemFillLabel.setLabelFor(this.itemFillComboBox);
        this.itemFillComboBox.setPreferredSize(preferredSize);
        this.itemFillComboBox.setSelectedIndex(0);
        this.itemFillComboBox.setRenderer(new EnumComboBoxCellRenderer("plotter.fillstyle"));
        this.itemFillComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LineChartConfigurationPanel.this.getSelectedValueSource() != null) {
                    LineChartConfigurationPanel.this.getSelectedValueSource().getSeriesFormat().setAreaFillStyle((SeriesFormat.FillStyle)((Object)LineChartConfigurationPanel.this.itemFillComboBox.getSelectedItem()));
                }
            }
        });
        this.addTwoComponentRow(this, this.itemFillLabel, this.itemFillComboBox);
        this.opacityLabel = new ResourceLabel("plotter.configuration_dialog.opacity", new Object[0]);
        this.opacityLabel.setPreferredSize(preferredSize);
        this.opacitySlider = new JSlider(0, 255, 125);
        this.opacityLabel.setLabelFor(this.opacitySlider);
        this.opacitySlider.setPreferredSize(preferredSize);
        this.opacitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting() && LineChartConfigurationPanel.this.getSelectedValueSource() != null) {
                    int newOpacity = LineChartConfigurationPanel.this.opacitySlider.getValue();
                    LineChartConfigurationPanel.this.getSelectedValueSource().getSeriesFormat().setOpacity(newOpacity);
                }
            }
        });
        this.addTwoComponentRow(this, this.opacityLabel, this.opacitySlider);
    }

    private void initComponents() {
        this.adaptGUI();
    }

    private void createItemColorDialog() {
        if (this.getSelectedValueSource() != null) {
            Color itemColor = this.getSelectedValueSource().getSeriesFormat().getItemColor();
            Color newItemColor = JColorChooser.showDialog(this, I18N.getGUILabel((String)"plotter.configuration_dialog.choose_color.label", (Object[])new Object[0]), itemColor);
            if (newItemColor != null) {
                this.getSelectedValueSource().getSeriesFormat().setItemColor(newItemColor);
            }
        }
    }

    private void itemShapeChanged(SeriesFormat.ItemShape itemShape) {
        this.itemShapeComboBox.setSelectedItem((Object)itemShape);
    }

    private void lineStyleChanged(LineFormat.LineStyle lineStyle) {
        if (lineStyle == this.lineStyleComboBox.getSelectedItem()) {
            return;
        }
        this.lineStyleComboBox.setSelectedItem((Object)lineStyle);
        boolean enable = false;
        if (lineStyle != LineFormat.LineStyle.NONE) {
            enable = true;
        }
        this.lineWidthLabel.setEnabled(enable);
        this.lineWidthSpinner.setEnabled(enable);
    }

    private void lineWidthChanged(Float lineWidth) {
        this.lineWidthSpinner.setValue(lineWidth);
    }

    private void itemFillChanged(SeriesFormat.FillStyle style) {
        this.itemFillComboBox.setSelectedItem((Object)style);
    }

    private void opacityChanged(Integer integer) {
        this.opacitySlider.setValue(integer);
    }

    private void itemSizeChanged(Double itemSize) {
        this.itemSizeSpinner.setValue(itemSize);
    }

    @Override
    protected void adaptGUI() {
        if (this.getSelectedValueSource() != null) {
            SeriesFormat format = this.getSelectedValueSource().getSeriesFormat();
            this.opacityChanged(format.getOpacity());
            this.itemShapeChanged(format.getItemShape());
            this.lineStyleChanged(format.getLineStyle());
            this.lineWidthChanged(Float.valueOf(format.getLineWidth()));
            this.itemFillChanged(format.getAreaFillStyle());
            this.itemSizeChanged(format.getItemSize());
        }
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        this.adaptGUI();
        return true;
    }
}

