/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.gui.PlotConfigurationTreeModel;
import com.owc.gui.charting.gui.cellrenderer.PlotConfigurationTreeCellRenderer;
import com.owc.gui.charting.gui.dnd.DataTableColumnListTransferHandler;
import com.owc.gui.charting.gui.dnd.PlotConfigurationTreeTransferHandler;
import com.owc.gui.charting.gui.treenodes.PlotConfigurationTreeNode;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.dnd.DragListener;
import com.rapidminer.gui.look.Colors;
import javax.swing.DropMode;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PlotConfigurationTree
extends JTree {
    private static final long serialVersionUID = 1L;

    public PlotConfigurationTree(PlotConfiguration plotConfiguration, DataTable dataTable, DataTableColumnListTransferHandler aTH) {
        this.expandAll();
        this.setRowHeight(0);
        this.getSelectionModel().setSelectionMode(1);
        this.setExpandsSelectedPaths(true);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        this.setShowsRootHandles(false);
        this.setBackground(Colors.WHITE);
        this.setCellRenderer(new PlotConfigurationTreeCellRenderer(aTH));
        this.putClientProperty("JTree.lineStyle", "Horizontal");
        this.createNewTreeModel(plotConfiguration);
    }

    public void expandAll() {
        this.cancelEditing();
        TreeModel tm = this.getModel();
        Object root = tm.getRoot();
        if (root != null) {
            this.expandAllPaths(new TreePath(root), tm);
        }
    }

    public void expandAllPaths(TreePath path) {
        this.cancelEditing();
        this.expandAllPaths(path, this.getModel());
    }

    protected void expandAllPaths(TreePath path, TreeModel treeModel) {
        this.expandPath(path);
        Object node = path.getLastPathComponent();
        int n = treeModel.getChildCount(node);
        for (int index = 0; index < n; ++index) {
            Object child = treeModel.getChild(node, index);
            this.expandAllPaths(path.pathByAddingChild(child));
        }
    }

    @Override
    public void setTransferHandler(TransferHandler newHandler) {
        if (newHandler instanceof PlotConfigurationTreeTransferHandler) {
            DragListener cellRenderer = (DragListener)this.getCellRenderer();
            PlotConfigurationTreeTransferHandler plotConfigurationTreeTransferHandler = (PlotConfigurationTreeTransferHandler)((Object)newHandler);
            if (cellRenderer != null) {
                plotConfigurationTreeTransferHandler.removeDragListener(cellRenderer);
            }
            plotConfigurationTreeTransferHandler.addDragListener(cellRenderer);
        }
        super.setTransferHandler(newHandler);
    }

    public void createNewTreeModel(PlotConfiguration plotConfiguration) {
        PlotConfigurationTreeNode rootNode = new PlotConfigurationTreeNode(plotConfiguration);
        PlotConfigurationTreeModel treeModel = new PlotConfigurationTreeModel(rootNode, plotConfiguration, this);
        this.setModel(treeModel);
        treeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                PlotConfigurationTree.this.repaint();
                PlotConfigurationTree.this.expandAll();
                TreePath selectionPath = PlotConfigurationTree.this.getSelectionPath();
                if (selectionPath != null) {
                    PlotConfigurationTree.this.scrollPathToVisible(selectionPath);
                }
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                PlotConfigurationTree.this.repaint();
                PlotConfigurationTree.this.expandAll();
                TreePath selectionPath = PlotConfigurationTree.this.getSelectionPath();
                if (selectionPath != null) {
                    PlotConfigurationTree.this.scrollPathToVisible(selectionPath);
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                PlotConfigurationTree.this.repaint();
                PlotConfigurationTree.this.expandAll();
                TreePath selectionPath = PlotConfigurationTree.this.getSelectionPath();
                if (selectionPath != null) {
                    PlotConfigurationTree.this.scrollPathToVisible(selectionPath);
                }
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                PlotConfigurationTree.this.repaint();
                PlotConfigurationTree.this.expandAll();
                TreePath selectionPath = PlotConfigurationTree.this.getSelectionPath();
                if (selectionPath != null) {
                    PlotConfigurationTree.this.scrollPathToVisible(selectionPath);
                }
            }
        });
    }
}

