/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.gui.PlotConfigurationTree;
import com.owc.gui.charting.gui.treenodes.DimensionConfigTreeNode;
import com.owc.gui.charting.gui.treenodes.PlotConfigurationTreeNode;
import com.owc.gui.charting.gui.treenodes.RangeAxisConfigTreeNode;
import com.owc.gui.charting.gui.treenodes.ValueSourceTreeNode;
import com.owc.gui.charting.listener.PlotConfigurationListener;
import com.owc.gui.charting.listener.events.DimensionConfigChangeEvent;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.RangeAxisConfigChangeEvent;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PlotConfigurationTreeModel
extends DefaultTreeModel
implements PlotConfigurationListener {
    private static final long serialVersionUID = 1L;
    private final PlotConfigurationTree plotConfigTree;
    private PlotConfiguration plotConfig;
    public static int NUMBER_OF_PERMANENT_DIMENSIONS = 4;

    public PlotConfigurationTreeModel(DefaultMutableTreeNode root, PlotConfiguration plotConfig, PlotConfigurationTree plotConfigTree) {
        super(root);
        this.plotConfig = plotConfig;
        this.plotConfigTree = plotConfigTree;
        if (root != null) {
            this.fillNewPlotConfigNode(plotConfig);
        }
        if (plotConfig != null) {
            plotConfig.addPlotConfigurationListener(this);
        }
    }

    private void rangeAxisConfigAdded(int index, RangeAxisConfig rangeAxis) {
        RangeAxisConfigTreeNode newChild = new RangeAxisConfigTreeNode(rangeAxis);
        this.insertNodeInto(newChild, (MutableTreeNode)this.root, index + NUMBER_OF_PERMANENT_DIMENSIONS);
        List<ValueSource> rangeAxisValueSources = rangeAxis.getValueSources();
        if (rangeAxis.getValueSources().size() > 0) {
            int idx = 0;
            for (ValueSource source : rangeAxisValueSources) {
                this.valueSourceAdded(idx, source, rangeAxis);
                ++idx;
            }
        } else {
            TreePath pathToNewChild = new TreePath(this.getPathToRoot(newChild));
            this.makeVisibleAndSelect(pathToNewChild);
        }
    }

    private void rangeAxisConfigRemoved(int index, RangeAxisConfig rangeAxis) {
        this.removeNodeFromParent((MutableTreeNode)this.root.getChildAt(index + NUMBER_OF_PERMANENT_DIMENSIONS));
        this.reload();
        this.plotConfigTree.expandAll();
        int childCount = this.root.getChildCount();
        TreeNode newSelection = null;
        newSelection = childCount > NUMBER_OF_PERMANENT_DIMENSIONS ? this.root.getChildAt(childCount - 1) : this.root;
        TreePath path = new TreePath(this.getPathToRoot(newSelection));
        this.makeVisibleAndSelect(path);
    }

    private void dimensionConfigAdded(DimensionConfig.PlotDimension dimension, DimensionConfig dimensionConfig) {
        PlotConfigurationTreeNode root = (PlotConfigurationTreeNode)this.root;
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChild(dimension);
        child.setUserObject(dimensionConfig);
        TreePath path = new TreePath(this.getPathToRoot(child));
        this.makeVisibleAndSelect(path);
    }

    private void dimensionConfigRemoved(DimensionConfig.PlotDimension dimension, DimensionConfig dimensionConfig) {
        PlotConfigurationTreeNode root = (PlotConfigurationTreeNode)this.root;
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChild(dimension);
        child.setUserObject(null);
    }

    private void rangeAxisMoved(int index, RangeAxisConfig rangeAxisConfig) {
        PlotConfigurationTreeNode rootNode = (PlotConfigurationTreeNode)this.root;
        RangeAxisConfigTreeNode childNode = (RangeAxisConfigTreeNode)rootNode.getChild(rangeAxisConfig);
        this.removeNodeFromParent(childNode);
        int newIndex = index + NUMBER_OF_PERMANENT_DIMENSIONS;
        this.insertNodeInto(childNode, rootNode, newIndex);
        TreePath path = new TreePath(this.getPathToRoot(childNode));
        this.makeVisibleAndSelect(path);
    }

    private void valueSourcesCleared(RangeAxisConfig source) {
        RangeAxisConfigTreeNode rangeAxisNode = this.getRangeAxisTreeNode(source);
        if (rangeAxisNode != null) {
            int childCount = rangeAxisNode.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                this.removeNodeFromParent((MutableTreeNode)rangeAxisNode.getChildAt(i));
            }
        } else {
            throw new RuntimeException("RangeAxisConfig source is not present in TreeModel. This should not happen.");
        }
        TreePath path = new TreePath(this.getPathToRoot(rangeAxisNode));
        this.makeVisibleAndSelect(path);
    }

    private void valueSourceAdded(int index, ValueSource valueSource, RangeAxisConfig source) {
        RangeAxisConfigTreeNode rangeAxisNode = this.getRangeAxisTreeNode(source);
        if (rangeAxisNode != null) {
            TreeNode child = rangeAxisNode.getChild(valueSource);
            if (child != null) {
                return;
            }
        } else {
            throw new RuntimeException("RangeAxisConfig source is not present in TreeModel. This should not happen.");
        }
        ValueSourceTreeNode newChild = new ValueSourceTreeNode(valueSource);
        this.insertNodeInto(newChild, rangeAxisNode, index);
        TreePath path = new TreePath(this.getPathToRoot(newChild));
        this.makeVisibleAndSelect(path);
    }

    private void valueSourceRemoved(ValueSource valueSource, RangeAxisConfig source) {
        TreePath path;
        RangeAxisConfigTreeNode rangeAxisNode = this.getRangeAxisTreeNode(source);
        if (rangeAxisNode != null) {
            TreeNode valueSourceNode = rangeAxisNode.getChild(valueSource);
            if (valueSourceNode == null) {
                throw new RuntimeException("ValueSource is not present in TreeModel. This should not happen.");
            }
            int oldIndex = rangeAxisNode.getIndex(valueSourceNode);
            this.removeNodeFromParent((MutableTreeNode)valueSourceNode);
            int childCount = rangeAxisNode.getChildCount();
            TreeNode newSelection = null;
            path = new TreePath(this.getPathToRoot(rangeAxisNode));
            if (oldIndex < childCount) {
                newSelection = rangeAxisNode.getChildAt(oldIndex);
                path = path.pathByAddingChild(newSelection);
            } else if (childCount > 0) {
                newSelection = rangeAxisNode.getChildAt(childCount - 1);
                path = path.pathByAddingChild(newSelection);
            }
        } else {
            throw new RuntimeException("RangeAxisConfig source is not present in TreeModel. This should not happen.");
        }
        this.makeVisibleAndSelect(path);
    }

    private void makeVisibleAndSelect(TreePath path) {
        this.reload();
        this.plotConfigTree.expandAll();
        this.plotConfigTree.makeVisible(path);
        this.plotConfigTree.scrollPathToVisible(path);
        this.plotConfigTree.setSelectionPath(path);
    }

    private void valueSourceMoved(int index, ValueSource valueSource, RangeAxisConfig source) {
        PlotConfigurationTreeNode rootNode = (PlotConfigurationTreeNode)this.root;
        RangeAxisConfigTreeNode sourceNode = (RangeAxisConfigTreeNode)rootNode.getChild(source);
        ValueSourceTreeNode childNode = (ValueSourceTreeNode)sourceNode.getChild(valueSource);
        this.removeNodeFromParent(childNode);
        this.insertNodeInto(childNode, sourceNode, index);
        TreePath path = new TreePath(this.getPathToRoot(childNode));
        this.makeVisibleAndSelect(path);
    }

    private void rangeAxisConfigChanged(RangeAxisConfigChangeEvent change) {
        PlotConfigurationTreeNode rootNode = (PlotConfigurationTreeNode)this.root;
        RangeAxisConfigTreeNode rangeAxisNode = (RangeAxisConfigTreeNode)rootNode.getChild(change.getSource());
        RangeAxisConfigChangeEvent.RangeAxisConfigChangeType type = change.getType();
        switch (type) {
            case CLEARED: {
                this.valueSourcesCleared(change.getSource());
                break;
            }
            case VALUE_SOURCE_ADDED: {
                this.valueSourceAdded(change.getIndex(), change.getValueSource(), change.getSource());
                break;
            }
            case VALUE_SOURCE_CHANGED: {
                ValueSource source = change.getValueSourceChange().getSource();
                ValueSourceTreeNode valueSourceNode = (ValueSourceTreeNode)rangeAxisNode.getChild(source);
                this.nodeChanged(valueSourceNode);
                break;
            }
            case VALUE_SOURCE_MOVED: {
                this.valueSourceMoved(change.getIndex(), change.getValueSource(), change.getSource());
                break;
            }
            case VALUE_SOURCE_REMOVED: {
                this.valueSourceRemoved(change.getValueSource(), change.getSource());
                break;
            }
            default: {
                this.nodeChanged(rangeAxisNode);
            }
        }
    }

    public void exchangePlotConfiguration(PlotConfiguration newPlotConfig) {
        if (this.plotConfig != null) {
            this.plotConfig.removePlotConfigurationListener(this);
        }
        this.plotConfig = newPlotConfig;
        this.setRoot(new PlotConfigurationTreeNode(newPlotConfig));
        this.fillNewPlotConfigNode(newPlotConfig);
        newPlotConfig.addPlotConfigurationListener(this);
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        PlotConfigurationChangeEvent.PlotConfigurationChangeType type = change.getType();
        RangeAxisConfigChangeEvent rangeAxisConfigChange = change.getRangeAxisConfigChange();
        switch (type) {
            case DIMENSION_CONFIG_ADDED: {
                this.dimensionConfigAdded(change.getDimension(), change.getDimensionConfig());
                break;
            }
            case DIMENSION_CONFIG_CHANGED: {
                this.dimensionConfigChanged(change);
                break;
            }
            case DIMENSION_CONFIG_REMOVED: {
                this.dimensionConfigRemoved(change.getDimension(), change.getDimensionConfig());
                break;
            }
            case RANGE_AXIS_CONFIG_ADDED: {
                this.rangeAxisConfigAdded(change.getIndex(), change.getRangeAxisConfig());
                break;
            }
            case RANGE_AXIS_CONFIG_CHANGED: {
                this.rangeAxisConfigChanged(rangeAxisConfigChange);
                break;
            }
            case RANGE_AXIS_CONFIG_MOVED: {
                this.rangeAxisMoved(change.getIndex(), change.getRangeAxisConfig());
                break;
            }
            case RANGE_AXIS_CONFIG_REMOVED: {
                this.rangeAxisConfigRemoved(change.getIndex(), change.getRangeAxisConfig());
                break;
            }
            case META_CHANGE: {
                for (PlotConfigurationChangeEvent events : change.getPlotConfigChangeEvents()) {
                    this.plotConfigurationChanged(events);
                }
                break;
            }
        }
        return true;
    }

    private void dimensionConfigChanged(PlotConfigurationChangeEvent change) {
        PlotConfigurationTreeNode rootNode = (PlotConfigurationTreeNode)this.root;
        DimensionConfigChangeEvent dimensionChange = change.getDimensionChange();
        DimensionConfigTreeNode dimensionConfigNode = (DimensionConfigTreeNode)rootNode.getChild(dimensionChange.getDimension());
        this.nodeChanged(dimensionConfigNode);
        if (dimensionChange.getType() == DimensionConfigChangeEvent.DimensionConfigChangeType.COLUMN) {
            TreePath path = new TreePath(this.getPathToRoot(dimensionConfigNode));
            this.makeVisibleAndSelect(path);
        }
    }

    private RangeAxisConfigTreeNode getRangeAxisTreeNode(RangeAxisConfig rangeAxis) {
        PlotConfigurationTreeNode root = (PlotConfigurationTreeNode)this.root;
        return (RangeAxisConfigTreeNode)root.getChild(rangeAxis);
    }

    private void fillNewPlotConfigNode(PlotConfiguration plotConfig) {
        if (plotConfig.getRangeAxisCount() == 0) {
            plotConfig.addRangeAxisConfig(new RangeAxisConfig(null, plotConfig));
        }
        this.insertNodeInto(new DimensionConfigTreeNode(DimensionConfig.PlotDimension.DOMAIN, plotConfig.getDomainConfigManager()), (MutableTreeNode)this.root, this.root.getChildCount());
        this.insertNodeInto(new DimensionConfigTreeNode(DimensionConfig.PlotDimension.COLOR, plotConfig.getDimensionConfig(DimensionConfig.PlotDimension.COLOR)), (MutableTreeNode)this.root, this.root.getChildCount());
        this.insertNodeInto(new DimensionConfigTreeNode(DimensionConfig.PlotDimension.SHAPE, plotConfig.getDimensionConfig(DimensionConfig.PlotDimension.SHAPE)), (MutableTreeNode)this.root, this.root.getChildCount());
        this.insertNodeInto(new DimensionConfigTreeNode(DimensionConfig.PlotDimension.SIZE, plotConfig.getDimensionConfig(DimensionConfig.PlotDimension.SIZE)), (MutableTreeNode)this.root, this.root.getChildCount());
        List<RangeAxisConfig> rangeAxisConfigs = plotConfig.getRangeAxisConfigs();
        int idx = 0;
        for (RangeAxisConfig rangeAxis : rangeAxisConfigs) {
            this.rangeAxisConfigAdded(idx, rangeAxis);
            ++idx;
        }
    }
}

