/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.AbstractTreeSelectionDependentPanel;
import com.owc.gui.charting.gui.AreaAndBarChartConfigurationPanel;
import com.owc.gui.charting.gui.LineChartConfigurationPanel;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JTree;

public class SeriesFormatConfigurationPanel
extends AbstractTreeSelectionDependentPanel {
    private static final long serialVersionUID = 1L;
    private final String AREA_BAR = "area/bar";
    private final String LINES = "lines";
    private LineChartConfigurationPanel lineChartPanel;
    private AreaAndBarChartConfigurationPanel areaAndBarChartPanel;

    public SeriesFormatConfigurationPanel(boolean smallIcons, JTree plotConfigurationTree, PlotInstance plotInstance) {
        super(plotConfigurationTree, plotInstance);
        this.setLayout(new CardLayout());
        this.lineChartPanel = new LineChartConfigurationPanel(smallIcons, plotConfigurationTree, plotInstance);
        this.addPlotInstanceChangeListener(this.lineChartPanel);
        this.areaAndBarChartPanel = new AreaAndBarChartConfigurationPanel(smallIcons, plotConfigurationTree, plotInstance);
        this.addPlotInstanceChangeListener(this.areaAndBarChartPanel);
        this.add((Component)this.lineChartPanel, "lines");
        this.add((Component)this.areaAndBarChartPanel, "area/bar");
        this.registerAsPlotConfigurationListener();
    }

    @Override
    protected void adaptGUI() {
        if (this.getSelectedValueSource() != null) {
            SeriesFormat.VisualizationType seriesType = this.getSelectedValueSource().getSeriesFormat().getSeriesType();
            if (seriesType == SeriesFormat.VisualizationType.AREA || seriesType == SeriesFormat.VisualizationType.BARS) {
                CardLayout cardLayout = (CardLayout)this.getLayout();
                cardLayout.show(this, "area/bar");
            } else {
                CardLayout cardLayout = (CardLayout)this.getLayout();
                cardLayout.show(this, "lines");
            }
        }
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        this.adaptGUI();
        return true;
    }
}

