/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.AggregationWindowing;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.AbstractTreeSelectionDependentPanel;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.rapidminer.gui.tools.ResourceLabel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WindowingConfigurationContainer
extends AbstractTreeSelectionDependentPanel {
    private static final long serialVersionUID = 1L;
    private JLabel grabLeftLabel;
    private JSpinner grabLeftSpinner;
    private JLabel grabRightLabel;
    private JSpinner grabRightSpinner;
    private JLabel includeIncompleteGroupsLabel;
    private JCheckBox includeIncompleteGroupsCheckBox;

    public WindowingConfigurationContainer(JTree plotConfigurationTree, PlotInstance plotInstance) {
        super(plotConfigurationTree, plotInstance);
        this.createComponents();
        this.registerAsPlotConfigurationListener();
    }

    private void createComponents() {
        this.grabLeftLabel = new ResourceLabel("plotter.configuration_dialog.grab_left", new Object[0]);
        this.grabLeftSpinner = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(-1), null, (Number)1));
        this.grabLeftLabel.setLabelFor(this.grabLeftSpinner);
        this.grabLeftSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int newGrabLeft;
                int oldGrabLeft;
                AggregationWindowing aggregationWindowing;
                ValueSource selectedValueSource = WindowingConfigurationContainer.this.getSelectedValueSource();
                if (selectedValueSource != null && (aggregationWindowing = selectedValueSource.getAggregationWindowing()) != null && (oldGrabLeft = aggregationWindowing.getGrabLeft()) != (newGrabLeft = ((Integer)WindowingConfigurationContainer.this.grabLeftSpinner.getValue()).intValue())) {
                    aggregationWindowing.setGrabLeft(newGrabLeft);
                }
            }
        });
        this.addTwoComponentRow(this, this.grabLeftLabel, this.grabLeftSpinner);
        this.grabRightLabel = new ResourceLabel("plotter.configuration_dialog.grab_right", new Object[0]);
        this.grabRightSpinner = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(-1), null, (Number)1));
        this.grabRightLabel.setLabelFor(this.grabRightSpinner);
        this.grabRightSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int newGrabRight;
                int oldGrabRight;
                AggregationWindowing aggregationWindowing;
                ValueSource selectedValueSource = WindowingConfigurationContainer.this.getSelectedValueSource();
                if (selectedValueSource != null && (aggregationWindowing = selectedValueSource.getAggregationWindowing()) != null && (oldGrabRight = aggregationWindowing.getGrabRight()) != (newGrabRight = ((Integer)WindowingConfigurationContainer.this.grabRightSpinner.getValue()).intValue())) {
                    aggregationWindowing.setGrabRight(newGrabRight);
                }
            }
        });
        this.addTwoComponentRow(this, this.grabRightLabel, this.grabRightSpinner);
        this.includeIncompleteGroupsLabel = new ResourceLabel("plotter.configuration_dialog.incomplete_groups", new Object[0]);
        this.includeIncompleteGroupsCheckBox = new JCheckBox();
        this.includeIncompleteGroupsLabel.setLabelFor(this.includeIncompleteGroupsCheckBox);
        this.includeIncompleteGroupsCheckBox.setSelected(true);
        this.includeIncompleteGroupsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AggregationWindowing aggregationWindowing;
                ValueSource selectedValueSource = WindowingConfigurationContainer.this.getSelectedValueSource();
                if (selectedValueSource != null && (aggregationWindowing = selectedValueSource.getAggregationWindowing()) != null) {
                    aggregationWindowing.setIncludeIncompleteGroups(WindowingConfigurationContainer.this.includeIncompleteGroupsCheckBox.isSelected());
                }
            }
        });
        this.addTwoComponentRow(this, this.includeIncompleteGroupsLabel, this.includeIncompleteGroupsCheckBox);
    }

    private void grabLeftChanged(Integer value) {
        this.grabLeftSpinner.setValue(value);
    }

    private void grabRightChanged(Integer value) {
        this.grabRightSpinner.setValue(value);
    }

    private void incompleteGroupsChanged(boolean incompleteGroups) {
        this.includeIncompleteGroupsCheckBox.setSelected(incompleteGroups);
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        this.adaptGUI();
        return true;
    }

    @Override
    protected void adaptGUI() {
        AggregationWindowing windowing;
        ValueSource selectedValueSource = this.getSelectedValueSource();
        if (selectedValueSource != null && (windowing = selectedValueSource.getAggregationWindowing()) != null) {
            this.grabLeftChanged(windowing.getGrabLeft());
            this.grabRightChanged(windowing.getGrabRight());
            this.incompleteGroupsChanged(windowing.isIncludingIncompleteGroups());
        }
    }
}

