/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.cellrenderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class ColorRGBComboBoxCellRenderer<E>
implements ListCellRenderer<E> {
    private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private final Border focusBorder = BorderFactory.createLineBorder(Color.gray, 2);
    private final Border noFocusBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private Map<Color, Icon> colorMap = new HashMap<Color, Icon>();

    @Override
    public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel listCellRendererComponent = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, (Object)value, index, isSelected, cellHasFocus);
        listCellRendererComponent.setPreferredSize(new Dimension(50, 20));
        if (!(value instanceof Color)) {
            return listCellRendererComponent;
        }
        listCellRendererComponent.setText("");
        Color color = (Color)value;
        Icon iicon = this.colorMap.get(color);
        if (iicon == null) {
            this.colorMap.put(color, this.createColoredRectangleIcon(color));
            iicon = this.colorMap.get(color);
        }
        listCellRendererComponent.setIcon(iicon);
        listCellRendererComponent.setBackground(color);
        if (isSelected && index != -1) {
            listCellRendererComponent.setBorder(this.focusBorder);
        } else {
            listCellRendererComponent.setBorder(this.noFocusBorder);
        }
        return listCellRendererComponent;
    }

    protected Icon createColoredRectangleIcon(Color color) {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (color != null) {
            Color newColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
            g2.setColor(newColor);
        } else {
            g2.setColor(Color.gray);
        }
        g2.fillRect(0, 0, 10, 10);
        return new ImageIcon(bufferedImage);
    }
}

