/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.cellrenderer;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class EnumComboBoxCellRenderer<E>
implements ListCellRenderer<E> {
    private final String i18nKeyPrefix;
    private final Map<Object, String> textCache = new HashMap<Object, String>();
    private final Map<Object, ImageIcon> iconCache = new HashMap<Object, ImageIcon>();
    private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

    public EnumComboBoxCellRenderer(String key) {
        this.i18nKeyPrefix = key;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel listCellRendererComponent = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, (Object)value, index, isSelected, cellHasFocus);
        String text = this.textCache.get(value);
        ImageIcon icon = this.iconCache.get(value);
        if (text == null) {
            text = I18N.getMessageOrNull((ResourceBundle)I18N.getGUIBundle(), (String)("gui.label." + this.i18nKeyPrefix + "." + value + ".label"), (Object[])new Object[0]);
            if (text != null) {
                this.textCache.put(value, text);
            } else {
                text = this.i18nKeyPrefix + "." + value;
            }
            String iconId = I18N.getMessageOrNull((ResourceBundle)I18N.getGUIBundle(), (String)("gui.label." + this.i18nKeyPrefix + "." + value + ".icon"), (Object[])new Object[0]);
            if (iconId != null) {
                icon = SwingTools.createIcon((String)("16/" + iconId));
                this.iconCache.put(value, icon);
            }
        }
        listCellRendererComponent.setText(text);
        listCellRendererComponent.setIcon(icon);
        return listCellRendererComponent;
    }
}

