/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.cellrenderer;

import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.gui.cellrenderer.TreeNodeColors;
import com.owc.gui.charting.gui.dnd.DataTableColumnListTransferHandler;
import com.owc.gui.charting.gui.treenodes.DimensionConfigTreeNode;
import com.owc.gui.charting.gui.treenodes.PlotConfigurationTreeNode;
import com.owc.gui.charting.gui.treenodes.RangeAxisConfigTreeNode;
import com.owc.gui.charting.gui.treenodes.ValueSourceTreeNode;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dnd.DragListener;
import com.rapidminer.gui.flow.processrendering.draw.ProcessDrawer;
import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.Transferable;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class PlotConfigurationTreeCellRenderer
extends DefaultTreeCellRenderer
implements DragListener {
    private final Font TREE_FONT = UIManager.getFont("Tree.font");
    private final Color SELECTED_COLOR = UIManager.getColor("Tree.selectionBackground");
    private final Color NOT_SELECTED_COLOR = Colors.WHITE;
    private final Color TEXT_SELECTED_COLOR = UIManager.getColor("Tree.selectionForeground");
    private final Color TEXT_NON_SELECTED_COLOR = UIManager.getColor("Tree.textForeground");
    private final Color BORDER_SELECTION_COLOR = UIManager.getColor("Tree.selectionBorderColor").darker();
    private Icon ERROR_ICON;
    private Icon WARNING_ICON;
    private Border focusBorder;
    private Border nonFocusBorder;
    private static final long serialVersionUID = 1L;
    private final DimensionAndRangeAxisTreeCellPanel dimensionAndRangeAxisRenderPanel;
    private final GlobalAndValueSourceTreeCellPanel globalAndValueSourceRenderPanel;
    private boolean dragging;
    private Border draggingNotFocusedBorder;

    public PlotConfigurationTreeCellRenderer(DataTableColumnListTransferHandler aTH) {
        aTH.addDragListener(this);
        this.ERROR_ICON = SwingTools.createIcon((String)("16/" + I18N.getMessageOrNull((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.plotter.configuratiom_dialog.error_icon", (Object[])new Object[0])));
        this.WARNING_ICON = SwingTools.createIcon((String)("16/" + I18N.getMessageOrNull((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.plotter.configuratiom_dialog.warning_icon", (Object[])new Object[0])));
        this.focusBorder = BorderFactory.createLineBorder(this.BORDER_SELECTION_COLOR);
        this.nonFocusBorder = BorderFactory.createLineBorder(Color.white);
        this.draggingNotFocusedBorder = BorderFactory.createLineBorder(ProcessDrawer.INNER_DRAG_COLOR);
        this.dimensionAndRangeAxisRenderPanel = new DimensionAndRangeAxisTreeCellPanel();
        this.globalAndValueSourceRenderPanel = new GlobalAndValueSourceTreeCellPanel();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof PlotConfigurationTreeNode) {
            this.globalAndValueSourceRenderPanel.updateTreeCell(tree, (PlotConfigurationTreeNode)value, selected, expanded, leaf, row, hasFocus, this.dragging);
            return this.globalAndValueSourceRenderPanel;
        }
        if (value instanceof ValueSourceTreeNode) {
            this.globalAndValueSourceRenderPanel.updateTreeCell(tree, (ValueSourceTreeNode)value, selected, expanded, leaf, row, hasFocus, this.dragging);
            return this.globalAndValueSourceRenderPanel;
        }
        if (value instanceof RangeAxisConfigTreeNode) {
            this.dimensionAndRangeAxisRenderPanel.updateTreeCell(tree, (RangeAxisConfigTreeNode)value, selected, expanded, leaf, row, hasFocus, this.dragging);
            return this.dimensionAndRangeAxisRenderPanel;
        }
        if (value instanceof DimensionConfigTreeNode) {
            this.dimensionAndRangeAxisRenderPanel.updateTreeCell(tree, (DimensionConfigTreeNode)value, selected, expanded, leaf, row, hasFocus, this.dragging);
            return this.dimensionAndRangeAxisRenderPanel;
        }
        return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    protected Color getValueTypeColor(DataTableColumn.ValueType type) {
        switch (type) {
            case DATE_TIME: {
                return TreeNodeColors.getDateColor();
            }
            case INVALID: {
                return TreeNodeColors.getInvalidColor();
            }
            case NOMINAL: {
                return TreeNodeColors.getNominalColor();
            }
            case NUMERICAL: {
                return TreeNodeColors.getNumericalColor();
            }
        }
        return TreeNodeColors.getWarningColor();
    }

    public void dragStarted(Transferable t) {
        this.dragging = true;
    }

    public void dragEnded() {
        this.dragging = false;
    }

    private class GlobalAndValueSourceTreeCellPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel nameLabel;
        private JLabel errorIconLabel;

        public GlobalAndValueSourceTreeCellPanel() {
            this.setLayout(new BorderLayout());
            this.nameLabel = new JLabel("");
            this.nameLabel.setFont(PlotConfigurationTreeCellRenderer.this.TREE_FONT);
            this.nameLabel.setHorizontalAlignment(2);
            this.add((Component)this.nameLabel, "Center");
            this.errorIconLabel = new JLabel("");
            this.add((Component)this.errorIconLabel, "East");
        }

        public void updateTreeCell(JTree tree, PlotConfigurationTreeNode value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus, boolean dragging) {
            this.adaptPlotConfigurationCell(tree, value, selected, expanded, leaf, row, hasFocus);
            this.adaptContainerStyle(tree, value, selected, expanded, leaf, row, hasFocus, dragging, true);
        }

        public void updateTreeCell(JTree tree, ValueSourceTreeNode value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus, boolean dragging) {
            this.adaptValueSource(tree, value, selected, expanded, leaf, row, hasFocus, dragging);
        }

        private void adaptContainerStyle(JTree tree, Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus, boolean dragging, boolean setForeGround) {
            SwingTools.setEnabledRecursive((Component)this, (boolean)tree.isEnabled());
            Color fg = null;
            Color bg = null;
            boolean highlightingEnabled = RapidMinerGUI.getDragHighlighteMode().equals((Object)RapidMinerGUI.DragHighlightMode.FULL);
            JTree.DropLocation dropLocation = tree.getDropLocation();
            if (dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row) {
                fg = PlotConfigurationTreeCellRenderer.this.TEXT_SELECTED_COLOR;
                bg = PlotConfigurationTreeCellRenderer.this.SELECTED_COLOR;
            } else if (selected && !dragging) {
                fg = PlotConfigurationTreeCellRenderer.this.TEXT_SELECTED_COLOR;
                bg = PlotConfigurationTreeCellRenderer.this.SELECTED_COLOR;
            } else {
                fg = PlotConfigurationTreeCellRenderer.this.TEXT_NON_SELECTED_COLOR;
                bg = highlightingEnabled && dragging ? ProcessDrawer.INNER_DRAG_COLOR : PlotConfigurationTreeCellRenderer.this.NOT_SELECTED_COLOR;
            }
            if (setForeGround) {
                this.nameLabel.setForeground(fg);
            }
            this.setBackground(bg);
            if (hasFocus) {
                this.setBorder(PlotConfigurationTreeCellRenderer.this.focusBorder);
            } else if (highlightingEnabled && dragging) {
                this.setBorder(PlotConfigurationTreeCellRenderer.this.draggingNotFocusedBorder);
            } else {
                this.setBorder(PlotConfigurationTreeCellRenderer.this.nonFocusBorder);
            }
        }

        private void adaptPlotConfigurationCell(JTree tree, PlotConfigurationTreeNode node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String icon;
            String i18nKey = "plotter.configuration_dialog.global_configuration";
            Font fontValue = PlotConfigurationTreeCellRenderer.this.TREE_FONT;
            if (fontValue == null) {
                fontValue = this.nameLabel.getFont();
            }
            if ((icon = I18N.getMessageOrNull((ResourceBundle)I18N.getGUIBundle(), (String)("gui.label." + i18nKey + ".icon"), (Object[])new Object[0])) != null) {
                ImageIcon iicon = SwingTools.createIcon((String)("16/" + icon));
                this.nameLabel.setIcon(iicon);
            }
            this.nameLabel.setText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)("gui.label." + i18nKey + ".label"), (Object[])new Object[0]));
            this.errorIconLabel.setIcon(null);
        }

        private void adaptValueSource(JTree tree, ValueSourceTreeNode node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus, boolean dragging) {
            boolean foregroundSet;
            String valueText;
            Font fontValue = PlotConfigurationTreeCellRenderer.this.TREE_FONT;
            if (fontValue == null) {
                fontValue = this.nameLabel.getFont();
            }
            fontValue = new Font(fontValue.getFamily(), 0, fontValue.getSize());
            this.nameLabel.setFont(fontValue);
            ValueSource valueSource = node.getUserObject();
            String i18nKey = null;
            i18nKey = valueSource.getSeriesFormat().getSeriesType() == SeriesFormat.VisualizationType.LINES_AND_SHAPES ? "plotter.configuration_dialog.line_value_source" : (valueSource.getSeriesFormat().getSeriesType() == SeriesFormat.VisualizationType.AREA ? "plotter.configuration_dialog.area_value_source" : "plotter.configuration_dialog.bar_value_source");
            String icon = I18N.getMessageOrNull((ResourceBundle)I18N.getGUIBundle(), (String)("gui.label." + i18nKey + ".icon"), (Object[])new Object[0]);
            if (icon != null) {
                ImageIcon iicon = SwingTools.createIcon((String)("16/" + icon));
                this.nameLabel.setIcon(iicon);
            }
            if ((valueText = valueSource.getLabel()) == null) {
                valueText = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
            }
            if (!valueSource.isAutoNaming()) {
                valueText = valueText + " [";
                valueText = valueText + valueSource.getAutoLabel();
                valueText = valueText + "]";
            }
            valueText = I18N.getGUILabel((String)"plotter.series_label.label", (Object[])new Object[0]) + valueText;
            this.nameLabel.setText(valueText);
            Icon errorLabelIcon = null;
            Color foregroundColor = PlotConfigurationTreeCellRenderer.this.getValueTypeColor(valueSource.getValueType());
            if (foregroundColor != null && foregroundColor.equals(TreeNodeColors.getWarningColor())) {
                errorLabelIcon = PlotConfigurationTreeCellRenderer.this.WARNING_ICON;
            }
            if (!valueSource.getErrors().isEmpty()) {
                foregroundColor = TreeNodeColors.getInvalidColor();
                errorLabelIcon = PlotConfigurationTreeCellRenderer.this.ERROR_ICON;
            }
            this.errorIconLabel.setIcon(errorLabelIcon);
            boolean bl = foregroundSet = foregroundColor != null;
            if (foregroundSet) {
                this.nameLabel.setForeground(foregroundColor);
            }
            this.adaptContainerStyle(tree, node, selected, expanded, leaf, row, hasFocus, dragging, !foregroundSet);
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 3, retDimension.height + 3);
            }
            return retDimension;
        }
    }

    private class DimensionAndRangeAxisTreeCellPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel nameLabel;
        private JLabel attributeLabel;
        private JLabel errorIconLabel;
        private final int CELL_WIDTH = 355;
        private final int CELL_HEIGTH = 18;

        public DimensionAndRangeAxisTreeCellPanel() {
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(355, 18));
            this.nameLabel = new JLabel("");
            this.nameLabel.setFont(PlotConfigurationTreeCellRenderer.this.TREE_FONT);
            this.nameLabel.setPreferredSize(new Dimension(140, 18));
            this.add((Component)this.nameLabel, "West");
            this.attributeLabel = new JLabel("");
            this.attributeLabel.setFont(PlotConfigurationTreeCellRenderer.this.TREE_FONT);
            this.attributeLabel.setHorizontalAlignment(2);
            this.attributeLabel.setPreferredSize(new Dimension(155, 18));
            this.add((Component)this.attributeLabel, "Center");
            this.errorIconLabel = new JLabel("");
            this.add((Component)this.errorIconLabel, "East");
        }

        public void updateTreeCell(JTree tree, RangeAxisConfigTreeNode value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus, boolean dragging) {
            this.adaptRangeAxisCell(tree, value, selected, expanded, leaf, row, hasFocus, dragging);
        }

        public void updateTreeCell(JTree tree, DimensionConfigTreeNode value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus, boolean dragging) {
            this.adaptDimensionCell(tree, value, selected, expanded, leaf, row, hasFocus, dragging);
        }

        private void adaptContainerStyle(JTree tree, Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus, boolean dragging, boolean setForeground) {
            SwingTools.setEnabledRecursive((Component)this, (boolean)tree.isEnabled());
            Color fg = null;
            Color bg = null;
            boolean highlightingEnabled = RapidMinerGUI.getDragHighlighteMode().equals((Object)RapidMinerGUI.DragHighlightMode.FULL);
            JTree.DropLocation dropLocation = tree.getDropLocation();
            if (dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row) {
                fg = PlotConfigurationTreeCellRenderer.this.TEXT_SELECTED_COLOR;
                bg = PlotConfigurationTreeCellRenderer.this.SELECTED_COLOR;
            } else if (selected && !dragging) {
                fg = PlotConfigurationTreeCellRenderer.this.TEXT_SELECTED_COLOR;
                bg = PlotConfigurationTreeCellRenderer.this.SELECTED_COLOR;
            } else {
                fg = PlotConfigurationTreeCellRenderer.this.TEXT_NON_SELECTED_COLOR;
                bg = highlightingEnabled && dragging ? ProcessDrawer.INNER_DRAG_COLOR : PlotConfigurationTreeCellRenderer.this.NOT_SELECTED_COLOR;
            }
            if (setForeground) {
                this.nameLabel.setForeground(fg);
                this.attributeLabel.setForeground(fg);
            }
            this.setBackground(bg);
            if (hasFocus) {
                this.setBorder(PlotConfigurationTreeCellRenderer.this.focusBorder);
            } else if (highlightingEnabled && dragging) {
                this.setBorder(PlotConfigurationTreeCellRenderer.this.draggingNotFocusedBorder);
            } else {
                this.setBorder(PlotConfigurationTreeCellRenderer.this.nonFocusBorder);
            }
        }

        private void adaptRangeAxisCell(JTree tree, RangeAxisConfigTreeNode node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus, boolean dragging) {
            boolean foregroundSet;
            String i18nKey = "plotter.configuration_dialog.plot_dimension.range_axis";
            Font fontValue = PlotConfigurationTreeCellRenderer.this.TREE_FONT;
            if (fontValue == null) {
                fontValue = this.nameLabel.getFont();
            }
            fontValue = new Font(fontValue.getFamily(), 0, fontValue.getSize());
            this.nameLabel.setFont(fontValue);
            String icon = I18N.getMessageOrNull((ResourceBundle)I18N.getGUIBundle(), (String)("gui.label." + i18nKey + ".icon"), (Object[])new Object[0]);
            if (icon != null) {
                ImageIcon iicon = SwingTools.createIcon((String)("16/" + icon));
                this.nameLabel.setIcon(iicon);
            }
            RangeAxisConfig rangeAxis = node.getUserObject();
            DataTableColumn.ValueType type = rangeAxis.getValueType();
            Color foregroundColor = PlotConfigurationTreeCellRenderer.this.getValueTypeColor(type);
            String valueText = "";
            switch (type) {
                case DATE_TIME: {
                    valueText = I18N.getGUILabel((String)"plotter.configuration_dialog.plot_dimension.date_range_axis.label", (Object[])new Object[0]) + " ";
                    break;
                }
                case INVALID: {
                    valueText = I18N.getGUILabel((String)"plotter.configuration_dialog.plot_dimension.invalid_range_axis.label", (Object[])new Object[0]) + " ";
                    break;
                }
                case NOMINAL: {
                    valueText = I18N.getGUILabel((String)"plotter.configuration_dialog.plot_dimension.nominal_range_axis.label", (Object[])new Object[0]) + " ";
                    break;
                }
                case NUMERICAL: {
                    valueText = I18N.getGUILabel((String)"plotter.configuration_dialog.plot_dimension.numerical_range_axis.label", (Object[])new Object[0]) + " ";
                    break;
                }
                case UNKNOWN: {
                    valueText = I18N.getGUILabel((String)"plotter.configuration_dialog.plot_dimension.empty_range_axis.label", (Object[])new Object[0]) + " ";
                }
            }
            Icon errorLabelIcon = null;
            if (foregroundColor != null && foregroundColor.equals(TreeNodeColors.getWarningColor())) {
                errorLabelIcon = PlotConfigurationTreeCellRenderer.this.WARNING_ICON;
            }
            if (!rangeAxis.getWarnings().isEmpty()) {
                foregroundColor = TreeNodeColors.getWarningColor();
                errorLabelIcon = PlotConfigurationTreeCellRenderer.this.WARNING_ICON;
            }
            if (!rangeAxis.getErrors().isEmpty()) {
                foregroundColor = TreeNodeColors.getInvalidColor();
                valueText = I18N.getGUILabel((String)"plotter.configuration_dialog.plot_dimension.invalid_range_axis.label", (Object[])new Object[0]) + " ";
                errorLabelIcon = PlotConfigurationTreeCellRenderer.this.ERROR_ICON;
            }
            this.errorIconLabel.setIcon(errorLabelIcon);
            valueText = valueText + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)("gui.label." + i18nKey + ".label"), (Object[])new Object[0]) + ":";
            this.nameLabel.setText(valueText);
            String label = rangeAxis.getLabel();
            if (label == null) {
                label = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
            }
            this.attributeLabel.setText(label);
            this.attributeLabel.setVisible(true);
            boolean bl = foregroundSet = foregroundColor != null;
            if (foregroundSet) {
                this.nameLabel.setForeground(foregroundColor);
                this.attributeLabel.setForeground(foregroundColor);
            }
            this.adaptContainerStyle(tree, node, selected, expanded, leaf, row, hasFocus, dragging, !foregroundSet);
        }

        private void adaptDimensionCell(JTree tree, DimensionConfigTreeNode node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus, boolean dragging) {
            boolean foregroundSet;
            String i18nKey = null;
            switch (node.getDimension()) {
                case COLOR: {
                    i18nKey = "plotter.configuration_dialog.plot_dimension.color";
                    break;
                }
                case DOMAIN: {
                    i18nKey = "plotter.configuration_dialog.plot_dimension.domain";
                    break;
                }
                case SHAPE: {
                    i18nKey = "plotter.configuration_dialog.plot_dimension.shape";
                    break;
                }
                case SIZE: {
                    i18nKey = "plotter.configuration_dialog.plot_dimension.size";
                    break;
                }
            }
            Font fontValue = PlotConfigurationTreeCellRenderer.this.TREE_FONT;
            if (fontValue == null) {
                fontValue = this.nameLabel.getFont();
            }
            fontValue = new Font(fontValue.getFamily(), 0, fontValue.getSize());
            this.nameLabel.setFont(fontValue);
            String icon = I18N.getMessageOrNull((ResourceBundle)I18N.getGUIBundle(), (String)("gui.label." + i18nKey + ".icon"), (Object[])new Object[0]);
            if (icon != null) {
                ImageIcon iicon = SwingTools.createIcon((String)("16/" + icon));
                this.nameLabel.setIcon(iicon);
            }
            DimensionConfig.PlotDimension dimension = node.getDimension();
            String valueText = dimension.getName() + ": ";
            this.nameLabel.setText(valueText);
            DimensionConfig dimensionConfig = node.getUserObject();
            String emptyLabel = I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.plotter.configuration_dialog.empty_dimension.label", (Object[])new Object[0]);
            if (dimensionConfig != null) {
                valueText = dimensionConfig.getLabel();
                DataTableColumn dataTableColumn = dimensionConfig.getDataTableColumn();
                String name = dataTableColumn.getName();
                if (valueText == null) {
                    if (dimensionConfig.getDimension() == DimensionConfig.PlotDimension.DOMAIN && (name == null || name.isEmpty())) {
                        valueText = emptyLabel;
                    } else {
                        valueText = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
                        if (!dimensionConfig.isAutoNaming()) {
                            valueText = valueText + " [";
                            valueText = valueText + name;
                            valueText = valueText + "]";
                        }
                    }
                } else if (!dimensionConfig.isAutoNaming()) {
                    valueText = valueText + " [";
                    valueText = valueText + name;
                    valueText = valueText + "]";
                }
            } else {
                valueText = emptyLabel;
            }
            this.attributeLabel.setIcon(null);
            this.attributeLabel.setText(valueText);
            this.attributeLabel.setVisible(true);
            Color foregroundColor = null;
            Icon errorLabelIcon = null;
            if (dimensionConfig != null) {
                DataTableColumn.ValueType valueType = dimensionConfig.getValueType();
                if (valueType != DataTableColumn.ValueType.UNKNOWN || dimensionConfig.getDimension() != DimensionConfig.PlotDimension.DOMAIN) {
                    foregroundColor = PlotConfigurationTreeCellRenderer.this.getValueTypeColor(valueType);
                }
                PlotConfiguration plotConfig = (PlotConfiguration)((DefaultMutableTreeNode)tree.getModel().getRoot()).getUserObject();
                if (!dimensionConfig.getWarnings().isEmpty() || !plotConfig.isDimensionUsed(dimension)) {
                    foregroundColor = TreeNodeColors.getWarningColor();
                    errorLabelIcon = PlotConfigurationTreeCellRenderer.this.WARNING_ICON;
                }
                if (!dimensionConfig.getErrors().isEmpty() || foregroundColor != null && foregroundColor.equals(TreeNodeColors.getInvalidColor())) {
                    foregroundColor = TreeNodeColors.getInvalidColor();
                    errorLabelIcon = PlotConfigurationTreeCellRenderer.this.ERROR_ICON;
                }
            }
            this.errorIconLabel.setIcon(errorLabelIcon);
            boolean bl = foregroundSet = foregroundColor != null;
            if (foregroundSet) {
                this.nameLabel.setForeground(foregroundColor);
                this.attributeLabel.setForeground(foregroundColor);
            }
            this.adaptContainerStyle(tree, node, selected, expanded, leaf, row, hasFocus, dragging, !foregroundSet);
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 3, retDimension.height + 3);
            }
            return retDimension;
        }
    }
}

