/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.dialog;

import com.owc.gui.charting.configuration.AxisParallelLineConfiguration;
import com.owc.gui.charting.configuration.LineFormat;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.engine.jfreechart.JFreeChartPlotEngine;
import com.owc.gui.charting.gui.dialog.EditParallelLineDialog;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;

public class AddParallelLineDialog
extends JDialog {
    private JButton okButton;
    private JButton cancelButton;
    private JTextField xField;
    private JTextField yField;
    private double x = 1.0;
    private double y = 1.0;
    private JRadioButton horizontalLineRadiobutton;
    private JRadioButton verticalLineRadiobutton;
    private JComboBox<RangeAxisConfig> rangeAxisSelectionCombobox;
    private JButton modifyLineButton;
    private JFreeChartPlotEngine engine;
    private PlotConfiguration plotConfig;
    private Point mousePosition;
    private EditParallelLineDialog dialog;
    private AxisParallelLineConfiguration line;
    private static final long serialVersionUID = 1932257219370926682L;

    public AddParallelLineDialog() {
        super((Frame)ApplicationFrame.getApplicationFrame());
        this.setupGUI();
    }

    private void setupGUI() {
        JPanel mainPanel = new JPanel();
        this.setContentPane(mainPanel);
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 2, 5);
        this.horizontalLineRadiobutton = new JRadioButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.horizontal.label", (Object[])new Object[0]));
        this.horizontalLineRadiobutton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.horizontal.tip", (Object[])new Object[0]));
        this.horizontalLineRadiobutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddParallelLineDialog.this.setHorizontalLineSelected();
            }
        });
        this.horizontalLineRadiobutton.setSelected(true);
        this.add((Component)this.horizontalLineRadiobutton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        this.verticalLineRadiobutton = new JRadioButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.vertical.label", (Object[])new Object[0]));
        this.verticalLineRadiobutton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.vertical.tip", (Object[])new Object[0]));
        this.verticalLineRadiobutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddParallelLineDialog.this.setVerticalLineSelected();
            }
        });
        this.add((Component)this.verticalLineRadiobutton, gbc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.horizontalLineRadiobutton);
        group.add(this.verticalLineRadiobutton);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        this.rangeAxisSelectionCombobox = new JComboBox();
        this.rangeAxisSelectionCombobox.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.range_axis_combobox.tip", (Object[])new Object[0]));
        this.rangeAxisSelectionCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddParallelLineDialog.this.updateYFieldValue();
            }
        });
        this.add(this.rangeAxisSelectionCombobox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 2, 5);
        JLabel xLabel = new JLabel(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.width.label", (Object[])new Object[0]));
        this.add((Component)xLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.fill = 2;
        this.xField = new JTextField();
        this.xField.setText(String.valueOf(this.x));
        this.xField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return AddParallelLineDialog.this.verifyYInput(input);
            }
        });
        this.xField.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.width.tip", (Object[])new Object[0]));
        this.xField.setEnabled(false);
        this.add((Component)this.xField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 0;
        JLabel yLabel = new JLabel(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.height.label", (Object[])new Object[0]));
        this.add((Component)yLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 2;
        this.yField = new JTextField();
        this.yField.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.height.tip", (Object[])new Object[0]));
        this.yField.setText(String.valueOf(this.y));
        this.yField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return AddParallelLineDialog.this.verifyXInput(input);
            }
        });
        this.add((Component)this.yField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 5, 0, 5);
        this.modifyLineButton = new JButton();
        this.modifyLineButton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.modify_line.tip", (Object[])new Object[0]));
        this.modifyLineButton.setIcon(SwingTools.createIcon((String)("16/" + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.modify_line.icon", (Object[])new Object[0]))));
        this.modifyLineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddParallelLineDialog.this.modifyLine();
            }
        });
        this.add((Component)this.modifyLineButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(15, 5, 5, 5);
        this.add((Component)new JSeparator(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.okButton = new JButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.ok.label", (Object[])new Object[0]));
        this.okButton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.ok.tip", (Object[])new Object[0]));
        this.okButton.setIcon(SwingTools.createIcon((String)("24/" + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.ok.icon", (Object[])new Object[0]))));
        this.okButton.setMnemonic(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.ok.mne", (Object[])new Object[0]).toCharArray()[0]);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean successful = AddParallelLineDialog.this.addSpecifiedLine();
                if (!successful) {
                    return;
                }
                AddParallelLineDialog.this.dispose();
            }
        });
        this.okButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AddParallelLineDialog.this.okButton.doClick();
                }
            }
        });
        this.add((Component)this.okButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.fill = 0;
        gbc.anchor = 13;
        this.cancelButton = new JButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.cancel.label", (Object[])new Object[0]));
        this.cancelButton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.cancel.tip", (Object[])new Object[0]));
        this.cancelButton.setIcon(SwingTools.createIcon((String)("24/" + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.cancel.icon", (Object[])new Object[0]))));
        this.cancelButton.setMnemonic(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.cancel.mne", (Object[])new Object[0]).toCharArray()[0]);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddParallelLineDialog.this.dispose();
            }
        });
        this.add((Component)this.cancelButton, gbc);
        this.setMinimumSize(new Dimension(300, 250));
        this.setLocationRelativeTo(this.getOwner());
        this.setTitle(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.add_parallel_line.title.label", (Object[])new Object[0]));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                AddParallelLineDialog.this.okButton.requestFocusInWindow();
            }
        });
    }

    public void setMousePosition(Point mousePosition) {
        if (mousePosition == null) {
            throw new IllegalArgumentException("mousePosition must not be null!");
        }
        this.mousePosition = mousePosition;
    }

    public void setChartEngine(JFreeChartPlotEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("engine must not be null!");
        }
        this.engine = engine;
        this.setPlotConfiguration(engine.getPlotInstance().getMasterPlotConfiguration());
    }

    public void showDialog() {
        this.line = this.line == null ? this.createLine(1.0) : this.line.clone();
        if (this.horizontalLineRadiobutton.isSelected()) {
            this.line.setValue(Double.parseDouble(this.yField.getText()));
        } else {
            this.line.setValue(Double.parseDouble(this.xField.getText()));
        }
        this.setVisible(true);
    }

    private void setPlotConfiguration(PlotConfiguration plotConfig) {
        if (plotConfig == null) {
            throw new IllegalArgumentException("plotConfig must not be null!");
        }
        this.plotConfig = plotConfig;
        Vector<RangeAxisConfig> rangeConfigsVector = new Vector<RangeAxisConfig>();
        String selectedItem = String.valueOf(this.rangeAxisSelectionCombobox.getSelectedItem());
        for (RangeAxisConfig config : this.plotConfig.getRangeAxisConfigs()) {
            rangeConfigsVector.add(config);
        }
        this.rangeAxisSelectionCombobox.setModel(new DefaultComboBoxModel(rangeConfigsVector));
        if (selectedItem != null) {
            for (int i = 0; i < this.rangeAxisSelectionCombobox.getItemCount(); ++i) {
                if (!String.valueOf(this.rangeAxisSelectionCombobox.getItemAt(i)).equals(selectedItem)) continue;
                this.rangeAxisSelectionCombobox.setSelectedIndex(i);
                break;
            }
        }
        if (this.mousePosition != null) {
            Rectangle2D plotArea = this.engine.getChartPanel().getScreenDataArea();
            if (this.engine.getChartPanel().getChart().getPlot() instanceof XYPlot) {
                XYPlot plot = (XYPlot)this.engine.getChartPanel().getChart().getPlot();
                double chartX = plot.getDomainAxis().java2DToValue(this.mousePosition.getX(), plotArea, plot.getDomainAxisEdge());
                this.xField.setText(String.valueOf(chartX));
                for (int i = 0; i < plot.getRangeAxisCount(); ++i) {
                    ValueAxis config = plot.getRangeAxis(i);
                    if (config == null || config.getLabel() == null || !config.getLabel().equals(String.valueOf(this.rangeAxisSelectionCombobox.getSelectedItem()))) continue;
                    double chartY = config.java2DToValue(this.mousePosition.getY(), plotArea, plot.getRangeAxisEdge());
                    this.yField.setText(String.valueOf(chartY));
                }
            }
        }
    }

    private void setHorizontalLineSelected() {
        this.rangeAxisSelectionCombobox.setEnabled(true);
        this.xField.setEnabled(false);
        this.yField.setEnabled(true);
        this.okButton.requestFocusInWindow();
    }

    private void setVerticalLineSelected() {
        this.rangeAxisSelectionCombobox.setEnabled(false);
        this.xField.setEnabled(true);
        this.yField.setEnabled(false);
        this.okButton.requestFocusInWindow();
    }

    private void updateYFieldValue() {
        if (this.mousePosition != null) {
            Rectangle2D plotArea = this.engine.getChartPanel().getScreenDataArea();
            if (this.engine.getChartPanel().getChart().getPlot() instanceof XYPlot) {
                XYPlot plot = (XYPlot)this.engine.getChartPanel().getChart().getPlot();
                for (int i = 0; i < plot.getRangeAxisCount(); ++i) {
                    ValueAxis config = plot.getRangeAxis(i);
                    if (config == null || config.getLabel() == null || !config.getLabel().equals(String.valueOf(this.rangeAxisSelectionCombobox.getSelectedItem()))) continue;
                    double chartY = config.java2DToValue(this.mousePosition.getY(), plotArea, plot.getRangeAxisEdge());
                    this.yField.setText(String.valueOf(chartY));
                }
            }
        }
    }

    private boolean verifyYInput(JComponent input) {
        JTextField textField = (JTextField)input;
        String inputString = textField.getText();
        try {
            Double.parseDouble(inputString);
        }
        catch (NumberFormatException e) {
            textField.setForeground(Color.RED);
            return false;
        }
        textField.setForeground(Color.BLACK);
        return true;
    }

    private boolean verifyXInput(JComponent input) {
        JTextField textField = (JTextField)input;
        String inputString = textField.getText();
        try {
            Double.parseDouble(inputString);
        }
        catch (NumberFormatException e) {
            textField.setForeground(Color.RED);
            return false;
        }
        textField.setForeground(Color.BLACK);
        return true;
    }

    private boolean addSpecifiedLine() {
        if (this.horizontalLineRadiobutton.isSelected()) {
            Object selectedItem = this.rangeAxisSelectionCombobox.getSelectedItem();
            if (selectedItem != null && selectedItem instanceof RangeAxisConfig) {
                if (!this.yField.getInputVerifier().verify(this.yField)) {
                    this.yField.requestFocusInWindow();
                    return false;
                }
                RangeAxisConfig config = (RangeAxisConfig)selectedItem;
                if (this.line == null) {
                    this.line = this.createLine(Double.parseDouble(this.yField.getText()));
                }
                this.line.setValue(Double.parseDouble(this.yField.getText()));
                config.getCrossHairLines().addLine(this.line);
            }
        } else if (this.verticalLineRadiobutton.isSelected()) {
            if (!this.xField.getInputVerifier().verify(this.xField)) {
                this.xField.requestFocusInWindow();
                return false;
            }
            if (this.line == null) {
                this.line = this.createLine(Double.parseDouble(this.xField.getText()));
            }
            this.line.setValue(Double.parseDouble(this.xField.getText()));
            this.plotConfig.getDomainConfigManager().getCrosshairLines().addLine(this.line);
        }
        return true;
    }

    private void modifyLine() {
        if (this.line == null) {
            this.line = this.createLine(1.0);
        }
        if (this.dialog == null) {
            this.dialog = new EditParallelLineDialog();
        }
        if (this.horizontalLineRadiobutton.isSelected()) {
            if (!this.yField.getInputVerifier().verify(this.yField)) {
                this.yField.requestFocusInWindow();
                return;
            }
            this.line.setValue(Double.parseDouble(this.yField.getText()));
        } else {
            if (!this.xField.getInputVerifier().verify(this.xField)) {
                this.xField.requestFocusInWindow();
                return;
            }
            this.line.setValue(Double.parseDouble(this.xField.getText()));
        }
        this.dialog.setLine(this.line, false);
        this.dialog.showDialog();
    }

    private AxisParallelLineConfiguration createLine(double value) {
        AxisParallelLineConfiguration line = new AxisParallelLineConfiguration(value, false);
        line.getFormat().setStyle(LineFormat.LineStyle.SOLID);
        return line;
    }
}

