/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.dialog;

import com.owc.gui.charting.configuration.AxisParallelLineConfiguration;
import com.owc.gui.charting.configuration.LineFormat;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class EditParallelLineDialog
extends JDialog {
    private JButton okButton;
    private JButton cancelButton;
    private JTextField valueField;
    private JTextField widthField;
    private JButton lineColorButton;
    private JComboBox<LineFormat.LineStyle> lineStyleCombobox;
    private Color lineColor;
    private AxisParallelLineConfiguration line;
    private static final long serialVersionUID = 1932257219370926682L;

    public EditParallelLineDialog() {
        super((Frame)ApplicationFrame.getApplicationFrame());
        this.setupGUI();
    }

    private void setupGUI() {
        JPanel mainPanel = new JPanel();
        this.setContentPane(mainPanel);
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 2, 5);
        JLabel valueLabel = new JLabel(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.value.label", (Object[])new Object[0]));
        this.add((Component)valueLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.valueField = new JTextField();
        this.valueField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return EditParallelLineDialog.this.verifyValueInput(input);
            }
        });
        this.valueField.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.value.tip", (Object[])new Object[0]));
        this.add((Component)this.valueField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        JLabel colorLabel = new JLabel(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.color.label", (Object[])new Object[0]));
        this.add((Component)colorLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.lineColorButton = new JButton((Action)new ResourceAction(true, "edit_parallel_line.select_line_color", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                EditParallelLineDialog.this.createLineColorDialog();
            }
        });
        this.add((Component)this.lineColorButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        JLabel widthLabel = new JLabel(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.width.label", (Object[])new Object[0]));
        this.add((Component)widthLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.widthField = new JTextField();
        this.widthField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return EditParallelLineDialog.this.verifyWidthInput(input);
            }
        });
        this.widthField.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.width.tip", (Object[])new Object[0]));
        this.add((Component)this.widthField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        JLabel styleLabel = new JLabel(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.line_style.label", (Object[])new Object[0]));
        this.add((Component)styleLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.lineStyleCombobox = new JComboBox<LineFormat.LineStyle>(LineFormat.LineStyle.values());
        ((DefaultComboBoxModel)this.lineStyleCombobox.getModel()).removeElement((Object)LineFormat.LineStyle.NONE);
        this.lineStyleCombobox.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.line_style.tip", (Object[])new Object[0]));
        this.lineStyleCombobox.setSelectedItem((Object)LineFormat.LineStyle.SOLID);
        this.add(this.lineStyleCombobox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(15, 5, 5, 5);
        this.add((Component)new JSeparator(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.okButton = new JButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.ok.label", (Object[])new Object[0]));
        this.okButton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.ok.tip", (Object[])new Object[0]));
        this.okButton.setIcon(SwingTools.createIcon((String)("24/" + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.ok.icon", (Object[])new Object[0]))));
        this.okButton.setMnemonic(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.ok.mne", (Object[])new Object[0]).toCharArray()[0]);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean successful = EditParallelLineDialog.this.editLine();
                if (!successful) {
                    return;
                }
                EditParallelLineDialog.this.dispose();
            }
        });
        this.okButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EditParallelLineDialog.this.okButton.doClick();
                }
            }
        });
        this.add((Component)this.okButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.fill = 0;
        gbc.anchor = 13;
        this.cancelButton = new JButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.cancel.label", (Object[])new Object[0]));
        this.cancelButton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.cancel.tip", (Object[])new Object[0]));
        this.cancelButton.setIcon(SwingTools.createIcon((String)("24/" + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.cancel.icon", (Object[])new Object[0]))));
        this.cancelButton.setMnemonic(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.cancel.mne", (Object[])new Object[0]).toCharArray()[0]);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditParallelLineDialog.this.dispose();
            }
        });
        this.add((Component)this.cancelButton, gbc);
        this.setMinimumSize(new Dimension(275, 225));
        this.setLocationRelativeTo(this.getOwner());
        this.setTitle(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.edit_parallel_line.title.label", (Object[])new Object[0]));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                EditParallelLineDialog.this.cancelButton.requestFocusInWindow();
            }
        });
    }

    public void setLine(AxisParallelLineConfiguration line, boolean allowValueEdit) {
        if (line == null) {
            throw new IllegalArgumentException("line must not be null!");
        }
        if (!allowValueEdit) {
            this.valueField.setEnabled(false);
        }
        this.line = line;
        this.lineColor = line.getFormat().getColor();
        this.valueField.setText(String.valueOf(line.getValue()));
        this.widthField.setText(String.valueOf(line.getFormat().getWidth()));
        this.lineStyleCombobox.setSelectedItem((Object)line.getFormat().getStyle());
    }

    public void showDialog() {
        this.setVisible(true);
    }

    private boolean verifyValueInput(JComponent input) {
        JTextField textField = (JTextField)input;
        String inputString = textField.getText();
        try {
            Double.parseDouble(inputString);
        }
        catch (NumberFormatException e) {
            textField.setForeground(Color.RED);
            return false;
        }
        textField.setForeground(Color.BLACK);
        return true;
    }

    private boolean verifyWidthInput(JComponent input) {
        JTextField textField = (JTextField)input;
        String inputString = textField.getText();
        try {
            float width = Float.parseFloat(inputString);
            if ((double)width <= 0.0) {
                textField.setForeground(Color.RED);
                return false;
            }
        }
        catch (NumberFormatException e) {
            textField.setForeground(Color.RED);
            return false;
        }
        textField.setForeground(Color.BLACK);
        return true;
    }

    private void createLineColorDialog() {
        Color newLineColor;
        Color oldColor = this.line.getFormat().getColor();
        if (oldColor == null) {
            oldColor = Color.BLACK;
        }
        if ((newLineColor = JColorChooser.showDialog(null, I18N.getGUILabel((String)"edit_parallel_line.line_color_title.label", (Object[])new Object[0]), oldColor)) != null && !newLineColor.equals(oldColor)) {
            this.lineColor = newLineColor;
        }
    }

    private boolean editLine() {
        if (this.line != null) {
            LineFormat.LineStyle selectedLineStyle;
            if (!this.valueField.getInputVerifier().verify(this.valueField)) {
                this.valueField.requestFocusInWindow();
                return false;
            }
            if (!this.widthField.getInputVerifier().verify(this.widthField)) {
                this.widthField.requestFocusInWindow();
                return false;
            }
            this.line.setValue(Double.parseDouble(this.valueField.getText()));
            this.line.getFormat().setWidth(Float.parseFloat(this.widthField.getText()));
            if (this.lineColor != null) {
                this.line.getFormat().setColor(this.lineColor);
            }
            if ((selectedLineStyle = (LineFormat.LineStyle)((Object)this.lineStyleCombobox.getSelectedItem())) != null) {
                this.line.getFormat().setStyle(selectedLineStyle);
            }
        } else {
            return false;
        }
        return true;
    }
}

