/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.dialog;

import com.owc.gui.charting.configuration.AxisParallelLineConfiguration;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.engine.jfreechart.JFreeChartPlotEngine;
import com.owc.gui.charting.gui.dialog.AddParallelLineDialog;
import com.owc.gui.charting.gui.dialog.EditParallelLineDialog;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManageParallelLinesDialog
extends JDialog {
    private JButton okButton;
    private JButton cancelButton;
    private JRadioButton horizontalLineRadiobutton;
    private JRadioButton verticalLineRadiobutton;
    private JComboBox<RangeAxisConfig> rangeAxisSelectionCombobox;
    private JList<AxisParallelLineConfiguration> linesList;
    private JButton deleteSelectedLinesButton;
    private JButton modifySelectedLineButton;
    private JButton addNewLineButton;
    private JFreeChartPlotEngine engine;
    private PlotConfiguration plotConfig;
    private EditParallelLineDialog modifyLineDialog;
    private AddParallelLineDialog addLineDialog;
    private static final long serialVersionUID = 1932257219370926682L;

    public ManageParallelLinesDialog() {
        super((Frame)ApplicationFrame.getApplicationFrame());
        this.setupGUI();
    }

    private void setupGUI() {
        JPanel mainPanel = new JPanel();
        this.setContentPane(mainPanel);
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 2, 5);
        this.horizontalLineRadiobutton = new JRadioButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.horizontal.label", (Object[])new Object[0]));
        this.horizontalLineRadiobutton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.horizontal.tip", (Object[])new Object[0]));
        this.horizontalLineRadiobutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageParallelLinesDialog.this.setHorizontalLineSelected();
            }
        });
        this.horizontalLineRadiobutton.setSelected(true);
        this.add((Component)this.horizontalLineRadiobutton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        this.verticalLineRadiobutton = new JRadioButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.vertical.label", (Object[])new Object[0]));
        this.verticalLineRadiobutton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.vertical.tip", (Object[])new Object[0]));
        this.verticalLineRadiobutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageParallelLinesDialog.this.setVerticalLineSelected();
            }
        });
        this.add((Component)this.verticalLineRadiobutton, gbc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.horizontalLineRadiobutton);
        group.add(this.verticalLineRadiobutton);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        this.rangeAxisSelectionCombobox = new JComboBox();
        this.rangeAxisSelectionCombobox.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.range_axis_combobox.tip", (Object[])new Object[0]));
        this.rangeAxisSelectionCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageParallelLinesDialog.this.setHorizontalLineSelected();
            }
        });
        this.add(this.rangeAxisSelectionCombobox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        this.linesList = new JList();
        this.linesList.setSelectionMode(2);
        this.linesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ManageParallelLinesDialog.this.updateButtonStates();
            }
        });
        this.linesList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ManageParallelLinesDialog.this.deleteSelectedLines();
                }
            }
        });
        this.linesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ManageParallelLinesDialog.this.modifySelectedLine();
                }
            }
        });
        ExtendedJScrollPane listScrollPane = new ExtendedJScrollPane(this.linesList);
        this.add((Component)listScrollPane, gbc);
        JPanel listActionPanel = new JPanel();
        this.addNewLineButton = new JButton();
        this.addNewLineButton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.add_line.tip", (Object[])new Object[0]));
        this.addNewLineButton.setIcon(SwingTools.createIcon((String)("16/" + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.add_line.icon", (Object[])new Object[0]))));
        this.addNewLineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageParallelLinesDialog.this.addNewLine();
            }
        });
        listActionPanel.add(this.addNewLineButton);
        this.modifySelectedLineButton = new JButton();
        this.modifySelectedLineButton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.modify_line.tip", (Object[])new Object[0]));
        this.modifySelectedLineButton.setIcon(SwingTools.createIcon((String)("16/" + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.modify_line.icon", (Object[])new Object[0]))));
        this.modifySelectedLineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageParallelLinesDialog.this.modifySelectedLine();
            }
        });
        listActionPanel.add(this.modifySelectedLineButton);
        this.deleteSelectedLinesButton = new JButton();
        this.deleteSelectedLinesButton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.delete_lines.tip", (Object[])new Object[0]));
        this.deleteSelectedLinesButton.setIcon(SwingTools.createIcon((String)("16/" + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.delete_lines.icon", (Object[])new Object[0]))));
        this.deleteSelectedLinesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageParallelLinesDialog.this.deleteSelectedLines();
            }
        });
        listActionPanel.add(this.deleteSelectedLinesButton);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.add((Component)listActionPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(15, 5, 5, 5);
        this.add((Component)new JSeparator(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.okButton = new JButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.ok.label", (Object[])new Object[0]));
        this.okButton.setIcon(SwingTools.createIcon((String)("24/" + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.ok.icon", (Object[])new Object[0]))));
        this.okButton.setMnemonic(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.ok.mne", (Object[])new Object[0]).toCharArray()[0]);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageParallelLinesDialog.this.dispose();
            }
        });
        this.okButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ManageParallelLinesDialog.this.okButton.doClick();
                }
            }
        });
        this.add((Component)this.okButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.fill = 0;
        gbc.anchor = 13;
        this.cancelButton = new JButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.cancel.label", (Object[])new Object[0]));
        this.cancelButton.setIcon(SwingTools.createIcon((String)("24/" + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.cancel.icon", (Object[])new Object[0]))));
        this.cancelButton.setMnemonic(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.cancel.mne", (Object[])new Object[0]).toCharArray()[0]);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageParallelLinesDialog.this.dispose();
            }
        });
        this.add((Component)this.cancelButton, gbc);
        this.setMinimumSize(new Dimension(400, 300));
        this.setLocationRelativeTo(this.getOwner());
        this.setTitle(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_parallel_lines.title.label", (Object[])new Object[0]));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                ManageParallelLinesDialog.this.linesList.requestFocusInWindow();
            }
        });
    }

    public void setChartEngine(JFreeChartPlotEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("engine must not be null!");
        }
        this.engine = engine;
        this.setPlotConfiguration(engine.getPlotInstance().getMasterPlotConfiguration());
    }

    public void showDialog() {
        this.updateLineList();
        this.setVisible(true);
    }

    private void setPlotConfiguration(PlotConfiguration plotConfig) {
        if (plotConfig == null) {
            throw new IllegalArgumentException("plotConfig must not be null!");
        }
        this.plotConfig = plotConfig;
        Vector<RangeAxisConfig> rangeConfigsVector = new Vector<RangeAxisConfig>();
        for (RangeAxisConfig config : this.plotConfig.getRangeAxisConfigs()) {
            rangeConfigsVector.add(config);
        }
        this.rangeAxisSelectionCombobox.setModel(new DefaultComboBoxModel(rangeConfigsVector));
    }

    private void setHorizontalLineSelected() {
        this.rangeAxisSelectionCombobox.setEnabled(true);
        this.linesList.clearSelection();
        RangeAxisConfig selectedConfig = (RangeAxisConfig)this.rangeAxisSelectionCombobox.getSelectedItem();
        DefaultListModel<AxisParallelLineConfiguration> model = new DefaultListModel<AxisParallelLineConfiguration>();
        if (selectedConfig != null) {
            List<AxisParallelLineConfiguration> rangeAxisLines = selectedConfig.getCrossHairLines().getLines();
            for (int i = 0; i < rangeAxisLines.size(); ++i) {
                AxisParallelLineConfiguration line = rangeAxisLines.get(i);
                model.addElement(line);
            }
        }
        this.linesList.setModel(model);
    }

    private void setVerticalLineSelected() {
        this.rangeAxisSelectionCombobox.setEnabled(false);
        this.linesList.clearSelection();
        DefaultListModel<AxisParallelLineConfiguration> model = new DefaultListModel<AxisParallelLineConfiguration>();
        List<AxisParallelLineConfiguration> domainLines = this.engine.getPlotInstance().getMasterPlotConfiguration().getDomainConfigManager().getCrosshairLines().getLines();
        for (int i = 0; i < domainLines.size(); ++i) {
            AxisParallelLineConfiguration line = domainLines.get(i);
            model.addElement(line);
        }
        this.linesList.setModel(model);
    }

    private void deleteSelectedLines() {
        if (this.linesList.getSelectedIndex() == -1) {
            return;
        }
        for (AxisParallelLineConfiguration line : this.linesList.getSelectedValuesList()) {
            if (this.horizontalLineRadiobutton.isSelected()) {
                RangeAxisConfig config = (RangeAxisConfig)this.rangeAxisSelectionCombobox.getSelectedItem();
                config.getCrossHairLines().removeLine(line);
                continue;
            }
            this.engine.getPlotInstance().getMasterPlotConfiguration().getDomainConfigManager().getCrosshairLines().removeLine(line);
        }
        this.updateLineList();
    }

    private void modifySelectedLine() {
        if (this.linesList.getSelectedIndices().length > 1) {
            return;
        }
        AxisParallelLineConfiguration line = this.linesList.getSelectedValue();
        if (line != null) {
            if (this.modifyLineDialog == null) {
                this.modifyLineDialog = new EditParallelLineDialog();
            }
            this.modifyLineDialog.setLine(line, true);
            this.modifyLineDialog.showDialog();
        }
    }

    private void addNewLine() {
        if (this.addLineDialog == null) {
            this.addLineDialog = new AddParallelLineDialog();
        }
        this.addLineDialog.setChartEngine(this.engine);
        this.addLineDialog.showDialog();
        if (this.horizontalLineRadiobutton.isSelected()) {
            this.setHorizontalLineSelected();
        } else if (this.verticalLineRadiobutton.isSelected()) {
            this.setVerticalLineSelected();
        }
    }

    private void updateLineList() {
        if (this.horizontalLineRadiobutton.isSelected()) {
            this.setHorizontalLineSelected();
        } else {
            this.setVerticalLineSelected();
        }
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        int size = this.linesList.getSelectedValuesList().size();
        this.deleteSelectedLinesButton.setEnabled(size != 0);
        this.modifySelectedLineButton.setEnabled(size == 1);
    }
}

