/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.groupingpanel;

import com.owc.gui.charting.configuration.AbstractValueGrouping;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.ValueGrouping;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.AbstractConfigurationPanel;
import com.owc.gui.charting.listener.events.DimensionConfigChangeEvent;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.rapidminer.gui.tools.ResourceLabel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class AbstractGroupingCardPanel
extends AbstractConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private final DimensionConfig.PlotDimension dimension;
    private ResourceLabel categoricalLabel;
    private JCheckBox categoricalCheckBox;

    public AbstractGroupingCardPanel(PlotInstance plotInstance, DimensionConfig.PlotDimension dimension) {
        super(plotInstance);
        this.dimension = dimension;
        this.createComponents();
        this.registerAsPlotConfigurationListener();
        this.adaptGUI();
    }

    protected void createComponents() {
        this.categoricalLabel = new ResourceLabel("plotter.configuration_dialog.categorical", new Object[0]);
        this.categoricalCheckBox = new JCheckBox();
        this.categoricalLabel.setLabelFor((Component)this.categoricalCheckBox);
        this.categoricalCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractValueGrouping grouping;
                DimensionConfig dimensionConfig = AbstractGroupingCardPanel.this.getPlotConfiguration().getDimensionConfig(AbstractGroupingCardPanel.this.dimension);
                if (dimensionConfig != null && (grouping = (AbstractValueGrouping)dimensionConfig.getGrouping()) != null) {
                    grouping.setCategorical(AbstractGroupingCardPanel.this.categoricalCheckBox.isSelected());
                }
            }
        });
        this.addTwoComponentRow(this, (JComponent)this.categoricalLabel, this.categoricalCheckBox);
    }

    @Override
    protected void adaptGUI() {
        DimensionConfig dimensionConfig = this.getPlotConfiguration().getDimensionConfig(this.dimension);
        if (dimensionConfig != null) {
            boolean enableOptions = !dimensionConfig.getDataTableColumn().isNominal();
            boolean groupingEnabled = false;
            ValueGrouping grouping = dimensionConfig.getGrouping();
            if (grouping != null) {
                groupingEnabled = true;
                this.categoricalCheckBox.setSelected(grouping.isCategorical());
            }
            this.categoricalCheckBox.setEnabled(groupingEnabled && enableOptions);
            this.categoricalLabel.setEnabled(groupingEnabled && enableOptions);
            this.categoricalLabel.setVisible(enableOptions);
            this.categoricalCheckBox.setVisible(enableOptions);
        }
    }

    public DimensionConfig.PlotDimension getDimension() {
        return this.dimension;
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        DimensionConfigChangeEvent dimensionChange;
        if (change.getType() == PlotConfigurationChangeEvent.PlotConfigurationChangeType.DIMENSION_CONFIG_CHANGED && (dimensionChange = change.getDimensionChange()).getDimension() == this.getDimension() && (dimensionChange.getType() == DimensionConfigChangeEvent.DimensionConfigChangeType.GROUPING_CHANGED || dimensionChange.getType() == DimensionConfigChangeEvent.DimensionConfigChangeType.COLUMN)) {
            this.adaptGUI();
        }
        if (change.getType() == PlotConfigurationChangeEvent.PlotConfigurationChangeType.META_CHANGE) {
            this.processPlotConfigurationMetaChange(change);
        }
        return true;
    }
}

