/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.popup;

import com.owc.gui.charting.gui.popup.PopupComponentListener;
import com.owc.gui.charting.gui.popup.PopupPanel;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ResourceAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JDialog;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class PopupAction
extends ResourceAction
implements PopupComponentListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    private final PopupPanel popupComponent;
    private Component actionSource = null;
    private ContainerPopupDialog popup = null;
    private PopupPosition position = PopupPosition.VERTICAL;
    private static final int BORDER_OFFSET = 9;
    private Window containingWindow;
    private long hideTime = 0L;

    public PopupAction(boolean smallIcon, String i18nKey, Component component, Object ... i18nArgs) {
        super(smallIcon, i18nKey, i18nArgs);
        this.popupComponent = new PopupPanel(component);
        this.popupComponent.addListener(this);
    }

    public PopupAction(boolean smallIcon, String i18nKey, Component component, PopupPosition position, Object ... i18nArgs) {
        super(smallIcon, i18nKey, i18nArgs);
        this.position = position;
        this.popupComponent = new PopupPanel(component);
        this.popupComponent.addListener(this);
    }

    public PopupAction(String i18nKey, Component component, Object ... i18nArgs) {
        super(i18nKey, i18nArgs);
        this.popupComponent = new PopupPanel(component);
        this.popupComponent.addListener(this);
    }

    public PopupAction(String i18nKey, Component component, PopupPosition position, Object ... i18nArgs) {
        super(i18nKey, i18nArgs);
        this.position = position;
        this.popupComponent = new PopupPanel(component);
        this.popupComponent.addListener(this);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (System.currentTimeMillis() - this.hideTime > 150L) {
            if (this.hidePopup()) {
                return;
            }
            this.showPopup((Component)e.getSource());
        } else {
            Object source = e.getSource();
            if (source instanceof JToggleButton) {
                ((JToggleButton)e.getSource()).setSelected(false);
            }
        }
    }

    private Point calculatePosition(Component source) {
        int xSource = source.getLocationOnScreen().x;
        int ySource = source.getLocationOnScreen().y;
        Dimension popupSize = this.popupComponent.getSize();
        if (popupSize.width == 0) {
            popupSize = ((Component)this.popupComponent).getPreferredSize();
        }
        int xPopup = 0;
        int yPopup = 0;
        Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        int maxX = focusedWindow.getLocationOnScreen().x + focusedWindow.getWidth();
        int maxY = focusedWindow.getLocationOnScreen().y + focusedWindow.getHeight();
        switch (this.position) {
            case VERTICAL: {
                xPopup = xSource;
                if (xPopup + popupSize.width > maxX) {
                    xPopup = maxX - popupSize.width - 9;
                }
                yPopup = ySource + source.getHeight();
                if (xPopup >= focusedWindow.getLocationOnScreen().x && xPopup - focusedWindow.getLocationOnScreen().x + popupSize.width <= focusedWindow.getWidth()) break;
                xPopup = xSource;
                break;
            }
            case HORIZONTAL: {
                xPopup = xSource + source.getWidth();
                yPopup = ySource;
                if (yPopup + popupSize.height > maxY) {
                    yPopup = maxY - popupSize.height - 9;
                }
                if (yPopup >= focusedWindow.getLocationOnScreen().y && yPopup - focusedWindow.getLocationOnScreen().y + popupSize.height <= focusedWindow.getHeight()) break;
                yPopup = ySource;
            }
        }
        return new Point(xPopup, yPopup);
    }

    private void showPopup(Component source) {
        this.actionSource = source;
        this.actionSource.addComponentListener(this);
        if (this.actionSource instanceof JToggleButton) {
            JToggleButton toggleSource = (JToggleButton)this.actionSource;
            toggleSource.setSelected(true);
        }
        this.containingWindow = SwingUtilities.windowForComponent(this.actionSource);
        this.containingWindow.addComponentListener(this);
        Point position = this.calculatePosition(source);
        this.popupComponent.setLocation(position);
        this.popupComponent.setVisible(true);
        this.popup = new ContainerPopupDialog(this.containingWindow, this.popupComponent, position);
        this.popup.setVisible(true);
        this.popup.requestFocus();
        this.popupComponent.startTracking(this.containingWindow, this.actionSource);
    }

    private boolean hidePopup() {
        if (this.actionSource instanceof JToggleButton) {
            JToggleButton toggleSource = (JToggleButton)this.actionSource;
            toggleSource.setSelected(false);
        }
        if (this.containingWindow != null) {
            this.containingWindow.removeComponentListener(this);
            this.containingWindow = null;
        }
        if (this.actionSource != null) {
            this.actionSource.removeComponentListener(this);
            this.actionSource = null;
        }
        if (this.popup != null) {
            this.popupComponent.setVisible(false);
            this.popupComponent.stopTracking();
            this.popup.dispose();
            this.popup = null;
            this.hideTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public void focusLost() {
        this.hidePopup();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.hidePopup();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.hidePopup();
    }

    private class ContainerPopupDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public ContainerPopupDialog(Window owner, Component comp, Point point) {
            super(owner != null ? owner : RapidMinerGUI.getMainFrame());
            this.add(comp);
            this.setLocation(point);
            this.setUndecorated(true);
            this.pack();
        }
    }

    public static enum PopupPosition {
        HORIZONTAL,
        VERTICAL;

    }
}

